/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.algo.OptimisedBytesStoreHash;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonMappedBytes
extends MappedBytes {
    private final AbstractCloseable closeable = new AbstractCloseable(){

        @Override
        protected void performClose() throws IllegalStateException {
            CommonMappedBytes.this.performClose();
        }
    };
    protected final MappedFile mappedFile;
    private final boolean backingFileIsReadOnly;
    private final long capacity;
    protected long lastActualSize = 0L;
    private boolean initReleased;

    protected CommonMappedBytes(@NotNull MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected CommonMappedBytes(@NotNull MappedFile mappedFile, String name) throws IllegalStateException {
        super(name);
        assert (mappedFile != null);
        this.mappedFile = mappedFile;
        mappedFile.reserve(this);
        boolean bl = this.backingFileIsReadOnly = !mappedFile.file().canWrite();
        assert (!mappedFile.isClosed());
        this.clear();
        this.capacity = mappedFile.capacity();
    }

    @Override
    public void singleThreadedCheckReset() {
        super.singleThreadedCheckReset();
        this.closeable.singleThreadedCheckReset();
    }

    @Override
    @NotNull
    public CommonMappedBytes write(byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws IllegalStateException, BufferOverflowException {
        ObjectUtils.requireNonNull(byteArray);
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        this.throwExceptionIfClosed();
        this.write(this.writePosition(), byteArray, offset, length);
        this.uncheckedWritePosition(this.writePosition() + (long)Math.min(length, byteArray.length - offset));
        return this;
    }

    @Override
    @NotNull
    public CommonMappedBytes write(@NotNull RandomDataInput bytes) throws IllegalStateException, BufferOverflowException {
        ObjectUtils.requireNonNull(bytes);
        this.throwExceptionIfClosed();
        assert (bytes != this) : "you should not write to yourself !";
        long remaining = bytes.readRemaining();
        this.write(this.writePosition(), bytes);
        this.uncheckedWritePosition(this.writePosition() + remaining);
        return this;
    }

    @NotNull
    public CommonMappedBytes write(@NonNegative long offsetInRDO, @NotNull RandomDataInput bytes) throws BufferOverflowException, IllegalStateException {
        Longs.requireNonNegative(offsetInRDO);
        ObjectUtils.requireNonNull(bytes);
        this.throwExceptionIfClosed();
        try {
            this.write(offsetInRDO, bytes, bytes.readPosition(), bytes.readRemaining());
            return this;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NotNull
    public MappedFile mappedFile() {
        return this.mappedFile;
    }

    @Override
    public BytesStore<Bytes<Void>, Void> copy() throws IllegalStateException {
        return BytesUtil.copyOf(this);
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.capacity;
    }

    @Override
    public Bytes<Void> readLimitToCapacity() {
        this.uncheckedWritePosition(this.capacity);
        return this;
    }

    @Override
    public long realReadRemaining() {
        long limit = this.readLimit();
        if (limit > this.lastActualSize) {
            limit = Math.min(this.realCapacity(), limit);
        }
        return limit - this.readPosition();
    }

    @Override
    public long realWriteRemaining() {
        long limit = this.writeLimit();
        if (limit > this.lastActualSize) {
            limit = Math.min(this.realCapacity(), limit);
        }
        return limit - this.writePosition();
    }

    @Override
    @NonNegative
    public long realCapacity() {
        try {
            this.lastActualSize = this.mappedFile.actualSize();
            return this.lastActualSize;
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "Unable to obtain the real size for " + this.mappedFile.file(), (Throwable)e);
            this.lastActualSize = 0L;
            return this.lastActualSize;
        }
    }

    @Override
    @Nullable
    public String read8bit() throws IORuntimeException, BufferUnderflowException, IllegalStateException, ArithmeticException {
        return BytesInternal.read8bit(this);
    }

    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(this.writePosition(), Math.min(128L, bytesToSkip));
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @Override
    @NonNegative
    public long start() {
        return 0L;
    }

    @Override
    @NotNull
    public Bytes<Void> writePosition(@NonNegative long position) throws BufferOverflowException {
        if (position > this.writeLimit) {
            throw new BufferOverflowException();
        }
        if (position < 0L) {
            throw new BufferOverflowException();
        }
        if (position < this.readPosition) {
            this.readPosition = position;
        }
        this.uncheckedWritePosition(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> clear() throws IllegalStateException {
        long start;
        this.throwExceptionIfClosed();
        this.readPosition = start = 0L;
        this.uncheckedWritePosition(start);
        this.writeLimit = this.capacity;
        return this;
    }

    @Override
    protected void performRelease() {
        super.performRelease();
        this.mappedFile.release(this);
    }

    @Override
    @NotNull
    public Bytes<Void> write(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        Longs.requireNonNegative(offset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfClosed();
        if (bytes instanceof BytesStore) {
            this.write(bytes, offset, length);
        } else if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (length > 0L) {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> append8bit(@NotNull CharSequence text, @NonNegative int start, @NonNegative int end) throws IllegalArgumentException, BufferOverflowException, BufferUnderflowException, IndexOutOfBoundsException, IllegalStateException {
        ObjectUtils.requireNonNull(text);
        this.throwExceptionIfClosed();
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(text instanceof String) || pos + (long)((end - start) * 3) + 5L >= this.safeLimit()) {
            return (Bytes)super.append8bit(text, start, end);
        }
        return this.append8bit0((String)text, start, end - start);
    }

    @Override
    @NotNull
    public CommonMappedBytes write8bit(@NotNull CharSequence text, @NonNegative int start, @NonNegative int length) throws IllegalStateException, BufferUnderflowException, BufferOverflowException, ArithmeticException, IndexOutOfBoundsException {
        ObjectUtils.requireNonNull(text);
        this.throwExceptionIfClosed();
        ObjectUtils.requireNonNull(text);
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(text instanceof String) || pos + (long)length * 3L + 5L >= this.safeLimit()) {
            super.write8bit(text, start, length);
            return this;
        }
        this.writeStopBit(length);
        return this.append8bit0((String)text, start, length);
    }

    @NotNull
    private CommonMappedBytes append8bit0(@NotNull String s, @NonNegative int start, @NonNegative int length) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull(s);
        this.ensureCapacity(this.writePosition() + (long)length);
        long address = this.addressForWritePosition();
        Memory memory = ((MappedBytesStore)this.bytesStore()).memory;
        if (Jvm.isJava9Plus()) {
            int i;
            byte[] bytes = StringUtils.extractBytes(s);
            for (i = 0; i < length - 3; i += 4) {
                int c0 = bytes[i + start] & 0xFF;
                int c1 = bytes[i + start + 1] & 0xFF;
                int c2 = bytes[i + start + 2] & 0xFF;
                int c3 = bytes[i + start + 3] & 0xFF;
                if (OptimisedBytesStoreHash.IS_LITTLE_ENDIAN) {
                    memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
                } else {
                    memory.writeInt(address, c0 << 24 | c1 << 16 | c2 << 8 | c3);
                }
                address += 4L;
            }
            while (i < length) {
                byte c = bytes[i + start];
                memory.writeByte(address++, c);
                ++i;
            }
            this.writeSkip(length);
        } else {
            int i;
            char[] chars = StringUtils.extractChars(s);
            for (i = 0; i < length - 3; i += 4) {
                int c0 = chars[i + start] & 0xFF;
                int c1 = chars[i + start + 1] & 0xFF;
                int c2 = chars[i + start + 2] & 0xFF;
                int c3 = chars[i + start + 3] & 0xFF;
                if (OptimisedBytesStoreHash.IS_LITTLE_ENDIAN) {
                    memory.writeInt(address, c3 << 24 | c2 << 16 | c1 << 8 | c0);
                } else {
                    memory.writeInt(address, c0 << 24 | c1 << 16 | c2 << 8 | c3);
                }
                address += 4L;
            }
            while (i < length) {
                char c = chars[i + start];
                memory.writeByte(address++, (byte)c);
                ++i;
            }
            this.writeSkip(length);
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> appendUtf8(@NotNull CharSequence cs, @NonNegative int start, @NonNegative int length) throws BufferOverflowException, IllegalStateException, BufferUnderflowException, IndexOutOfBoundsException {
        ObjectUtils.requireNonNull(cs);
        this.throwExceptionIfClosed();
        long pos = this.writePosition();
        this.writeCheckOffset(pos, 0L);
        if (!(cs instanceof String) || pos + (long)length * 3L + 5L >= this.safeLimit()) {
            super.appendUtf8(cs, start, length);
            return this;
        }
        if (Jvm.isJava9Plus()) {
            char c;
            int i;
            String str;
            block9: {
                str = (String)cs;
                long address = this.addressForWrite(pos);
                Memory memory = OS.memory();
                for (i = 0; i < length; ++i) {
                    c = str.charAt(i + start);
                    if (c > '\u007f') {
                        this.writeSkip(i);
                        break block9;
                    }
                    memory.writeByte(address++, (byte)c);
                }
                this.writeSkip(length);
                return this;
            }
            while (i < length) {
                c = str.charAt(i + start);
                this.appendUtf8(c);
                ++i;
            }
        } else {
            char c;
            int i;
            char[] chars;
            block10: {
                chars = StringUtils.extractChars((String)cs);
                long address = this.addressForWrite(pos);
                Memory memory = OS.memory();
                for (i = 0; i < length; ++i) {
                    c = chars[i + start];
                    if (c > '\u007f') {
                        this.writeSkip(i);
                        break block10;
                    }
                    memory.writeByte(address++, (byte)c);
                }
                this.writeSkip(length);
                return this;
            }
            while (i < length) {
                c = chars[i + start];
                this.appendUtf8(c);
                ++i;
            }
        }
        return this;
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        super.release(id);
        this.initReleased |= id == INIT;
        if (this.refCount() <= 0) {
            this.closeable.close();
        }
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        super.releaseLast(id);
        this.initReleased |= id == INIT;
        this.closeable.close();
    }

    @Override
    public void close() {
        this.closeable.close();
    }

    void performClose() {
        if (!this.initReleased) {
            this.release(INIT);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public void warnAndCloseIfNotClosed() {
        this.closeable.warnAndCloseIfNotClosed();
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        this.closeable.throwExceptionIfClosed();
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(@Nullable CharSequence text) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (text instanceof String) {
            this.writeUtf8((String)text);
            return this;
        }
        if (text == null) {
            BytesInternal.writeStopBitNeg1(this);
        } else {
            long utfLength = AppendableUtil.findUtf8Length(text);
            this.writeStopBit(utfLength);
            BytesInternal.appendUtf8(this, text, 0, text.length());
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeUtf8(@Nullable String text) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (text == null) {
            BytesInternal.writeStopBitNeg1(this);
            return this;
        }
        try {
            if (Jvm.isJava9Plus()) {
                byte[] strBytes = StringUtils.extractBytes(text);
                byte coder = StringUtils.getStringCoder(text);
                long utfLength = AppendableUtil.findUtf8Length(strBytes, coder);
                this.writeStopBit(utfLength);
                this.appendUtf8(strBytes, 0, text.length(), coder);
            } else {
                char[] chars = StringUtils.extractChars(text);
                long utfLength = AppendableUtil.findUtf8Length(chars);
                this.writeStopBit(utfLength);
                this.appendUtf8(chars, 0, chars.length);
            }
            return this;
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long readStopBit() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        long offset = this.readOffsetPositionMoved(1L);
        byte l = this.bytesStore.readByte(offset);
        if (l >= 0) {
            return l;
        }
        return BytesInternal.readStopBit0(this, l);
    }

    @Override
    public char readStopBitChar() throws IORuntimeException, IllegalStateException, BufferUnderflowException {
        this.throwExceptionIfClosed();
        long offset = this.readOffsetPositionMoved(1L);
        byte l = this.bytesStore.readByte(offset);
        if (l >= 0) {
            return (char)l;
        }
        return (char)BytesInternal.readStopBit0(this, l);
    }

    @Override
    @NotNull
    public Bytes<Void> writeStopBit(long n) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.writeByte((byte)(n & 0x7FL));
            return this;
        }
        if (((n ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.writeByte((byte)(0x80L | n ^ 0xFFFFFFFFFFFFFFFFL));
            this.writeByte((byte)0);
            return this;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            this.writeByte((byte)(n & 0x7FL | 0x80L));
            this.writeByte((byte)(n >> 7));
            return this;
        }
        BytesInternal.writeStopBit0(this, n);
        return this;
    }

    @Override
    @NotNull
    public Bytes<Void> writeStopBit(char n) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if ((n & 0xFFFFFF80) == 0) {
            this.writeByte((byte)(n & 0x7F));
            return this;
        }
        if ((n & 0xFFFFC000) == 0) {
            this.writeByte((byte)(n & 0x7F | 0x80));
            this.writeByte((byte)(n >> 7));
            return this;
        }
        BytesInternal.writeStopBit0(this, (long)n);
        return this;
    }

    @Override
    public boolean isBackingFileReadOnly() {
        return this.backingFileIsReadOnly;
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    @Override
    @Deprecated
    public CommonMappedBytes disableThreadSafetyCheck(boolean disableThreadSafetyCheck) {
        this.singleThreadedCheckDisabled(disableThreadSafetyCheck);
        return this;
    }

    @Override
    public void singleThreadedCheckDisabled(boolean singleThreadedCheckDisabled) {
        super.singleThreadedCheckDisabled(singleThreadedCheckDisabled);
        this.closeable.singleThreadedCheckDisabled(singleThreadedCheckDisabled);
    }

    @Override
    @NotNull
    public String toString() {
        if (!TRACE) {
            return super.toString();
        }
        return this.getClass().getSimpleName() + "{\nrefCount=" + this.refCount() + ",\nmappedFile=" + this.mappedFile.file().getAbsolutePath() + ",\nmappedFileRefCount=" + this.mappedFile.refCount() + ",\nmappedFileIsClosed=" + this.mappedFile.isClosed() + ",\nmappedFileRafIsClosed=" + Jvm.getValue(this.mappedFile.raf(), "closed") + ",\nmappedFileRafChannelIsClosed=" + !this.mappedFile.raf().getChannel().isOpen() + ",\nisClosed=" + this.isClosed() + '}';
    }

    @Override
    public void chunkCount(long[] chunkCount) {
        this.mappedFile.chunkCount(chunkCount);
    }

    @Override
    public boolean readWrite() {
        return !this.mappedFile.readOnly();
    }
}

