/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.ReferenceCountedCache;
import org.junit.Assert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ReferenceCountedCacheTest
extends QueueTestCommon {
    public static final int MAX_THREADS_TO_RUN = 6;
    public static final int MIN_THREADS_TO_RUN = 3;
    public static final int NUM_RESOURCES = 50;
    private AtomicInteger createdCount;
    private AtomicInteger releasedCount;
    private ReferenceCountedCache<Integer, TestReferenceCounted, Reservation, RuntimeException> cache;

    ReferenceCountedCacheTest() {
    }

    @BeforeEach
    void setUp() {
        this.createdCount = new AtomicInteger(0);
        this.releasedCount = new AtomicInteger(0);
        this.cache = new ReferenceCountedCache(Reservation::new, id -> new TestReferenceCounted());
    }

    @AfterEach
    void closeCache() {
        Closeable.closeQuietly(this.cache);
    }

    @Test
    void shouldNeverGiveOutReleasedReferences() {
        ExecutorService executorService = Executors.newCachedThreadPool();
        int numThreads = Math.min(6, Math.max(3, Runtime.getRuntime().availableProcessors()));
        AtomicBoolean running = new AtomicBoolean(true);
        ArrayList executors = new ArrayList();
        for (int i = 0; i < numThreads; ++i) {
            executors.add(executorService.submit(new ReferenceGetter(50, this.cache, running)));
        }
        Jvm.pause((long)5000L);
        running.set(false);
        executors.forEach(f -> {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        Closeable.closeQuietly(this.cache);
        Jvm.startup().on(ReferenceCountedCache.class, "Created " + this.createdCount.get() + ", released " + this.releasedCount.get());
    }

    @Test
    void shouldReturnSameObjectWhileNotReleased() {
        Reservation reservation = (Reservation)this.cache.get((Object)1);
        Reservation otherReservation = (Reservation)this.cache.get((Object)1);
        Assertions.assertSame((Object)reservation.referenceCounted, (Object)otherReservation.referenceCounted);
        reservation.release();
        otherReservation.release();
    }

    @Test
    void shouldExpireObjectsWhenReferenceCountGoesToZero() {
        Reservation reservation = (Reservation)this.cache.get((Object)1);
        reservation.release();
        Jvm.pause((long)100L);
        Reservation otherReservation = (Reservation)this.cache.get((Object)1);
        Assertions.assertNotSame((Object)reservation.referenceCounted, (Object)otherReservation.referenceCounted);
        otherReservation.release();
    }

    private class TestReferenceCounted
    extends AbstractReferenceCounted
    implements ReferenceOwner,
    Closeable {
        public TestReferenceCounted() {
            ReferenceCountedCacheTest.this.createdCount.incrementAndGet();
        }

        protected void performRelease() throws IllegalStateException {
            ReferenceCountedCacheTest.this.releasedCount.incrementAndGet();
        }

        public void close() {
        }

        public boolean isClosed() {
            return false;
        }
    }

    private static class Reservation {
        private final ReferenceCounted referenceCounted;
        private final ReferenceOwner referenceOwner = ReferenceOwner.temporary((String)"reservation");

        public Reservation(ReferenceCounted referenceCounted) {
            this.referenceCounted = referenceCounted;
            referenceCounted.reserve(this.referenceOwner);
        }

        public void release() {
            this.referenceCounted.release(this.referenceOwner);
        }

        public void assertNotReleased() {
            int referenceCount = this.referenceCounted.refCount();
            Assert.assertTrue((String)("Expected reference count of at least 2, got " + referenceCount), (referenceCount > 1 ? 1 : 0) != 0);
        }
    }

    private static class ReferenceGetter
    implements Runnable,
    ReferenceOwner {
        private final int numResources;
        private final ReferenceCountedCache<Integer, TestReferenceCounted, Reservation, RuntimeException> cache;
        private final AtomicBoolean running;
        private final Random random;
        private final Reservation[] reservations;

        public ReferenceGetter(int numResources, ReferenceCountedCache<Integer, TestReferenceCounted, Reservation, RuntimeException> referenceId, AtomicBoolean running) {
            this.numResources = numResources;
            this.cache = referenceId;
            this.running = running;
            this.random = ThreadLocalRandom.current();
            this.reservations = new Reservation[numResources];
        }

        @Override
        public void run() {
            int reservationCount = 0;
            while (this.running.get()) {
                int nextResource = this.random.nextInt(this.numResources);
                if (this.reservations[nextResource] != null) {
                    this.reservations[nextResource].release();
                    this.reservations[nextResource] = null;
                    continue;
                }
                this.reservations[nextResource] = (Reservation)this.cache.get((Object)nextResource);
                this.reservations[nextResource].assertNotReleased();
                ++reservationCount;
            }
            for (int i = 0; i < this.reservations.length; ++i) {
                if (this.reservations[i] == null) continue;
                this.reservations[i].release();
            }
            Jvm.startup().on(ReferenceGetter.class, "Made " + reservationCount + " reservations");
        }
    }
}

