/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Random;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.UncheckedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TailerCloseInParallelTest
extends QueueTestCommon {
    static String file = OS.getTarget() + "/deleteme-" + Time.uniqueId();
    static final int size = 4096;
    static int s32;
    static long s64;
    static float f32;
    static double f64;
    static String s;
    static Random random;
    static volatile ChronicleQueue chronicle;
    static volatile ExcerptTailer tailer;

    @AfterClass
    public static void cleanup() {
        IOTools.deleteDirWithFiles((String)file, (int)3);
    }

    @Test
    public void runOnce() throws IOException {
        this.ignoreException("Reference tracing disabled");
        AbstractCloseable.disableCloseableTracing();
        AbstractReferenceCounted.disableReferenceTracing();
        Thread thread = new Thread(() -> {
            Jvm.pause((long)Math.min(random.nextInt(100), random.nextInt(100)));
            if (tailer != null && !tailer.isClosing()) {
                tailer.close();
            }
        });
        thread.start();
        for (int t = 0; t < random.nextInt(100); ++t) {
            try {
                TailerCloseInParallelTest.doPerfTest(file, bytes -> TailerCloseInParallelTest.writeMany(bytes, 4096), bytes -> TailerCloseInParallelTest.readMany(bytes, 4096), 1, t > 0);
                continue;
            }
            catch (ClosedIllegalStateException ex) {
                System.err.println("Caught expected: " + (Object)((Object)ex));
                break;
            }
        }
        if (chronicle != null && !chronicle.isClosing()) {
            chronicle.close();
        }
        Paths.get(file, new String[0]).toFile().delete();
    }

    static void doPerfTest(String file, TestWriter<Bytes<?>> writer, TestReader<Bytes<?>> reader, int count, boolean print) throws IOException {
        Histogram writeHdr = new Histogram(30, 7);
        Histogram readHdr = new Histogram(30, 7);
        chronicle = SingleChronicleQueueBuilder.single((String)file).blockSize(0x4000000).rollCycle((RollCycle)RollCycles.FIVE_MINUTELY).build();
        tailer = chronicle.createTailer();
        System.err.println("Length is " + tailer.toEnd().index());
        ExcerptAppender appender = chronicle.acquireAppender();
        UncheckedBytes bytes = new UncheckedBytes(BytesStore.empty().bytesForRead());
        for (int i = 0; i < count; ++i) {
            long start = System.nanoTime();
            try (DocumentContext dc = appender.writingDocument();){
                Bytes bytes0 = dc.wire().bytes();
                bytes0.ensureCapacity(4096L);
                bytes.setBytes(bytes0);
                bytes.readPosition(bytes.writePosition());
                writer.writeTo((Bytes<?>)bytes);
                bytes0.writePosition(bytes.writePosition());
            }
            long time = System.nanoTime() - start;
            writeHdr.sample((double)time);
        }
        ExcerptTailer tailer = chronicle.createTailer();
        for (int i = 0; i < count; ++i) {
            long start2 = System.nanoTime();
            try (DocumentContext dc = tailer.readingDocument();){
                Assert.assertTrue((boolean)dc.isPresent());
                Bytes bytes0 = dc.wire().bytes();
                bytes.setBytes(bytes0);
                reader.readFrom((Bytes<?>)bytes);
            }
            long time2 = System.nanoTime() - start2;
            readHdr.sample((double)time2);
        }
        System.err.println("!Length is " + tailer.toEnd().index());
        if (print) {
            System.out.println("Write latencies " + writeHdr.toMicrosFormat());
            System.out.println("Read latencies " + readHdr.toMicrosFormat());
        }
    }

    static void writeMany(Bytes<?> bytes, int size) {
        for (int i = 0; i < size; i += 32) {
            bytes.writeInt(i);
            bytes.writeFloat((float)i);
            bytes.writeLong((long)i);
            bytes.writeDouble((double)i);
            bytes.writeUtf8("Hello!!");
        }
    }

    static void readMany(Bytes<?> bytes, int size) {
        for (int i = 0; i < size; i += 32) {
            s32 = bytes.readInt();
            f32 = bytes.readFloat();
            s64 = bytes.readLong();
            f64 = bytes.readDouble();
            s = bytes.readUtf8();
            Assert.assertEquals((Object)"Hello!!", (Object)s);
        }
    }

    static {
        random = new Random();
    }

    static interface TestReader<T> {
        public void readFrom(T var1);
    }

    static interface TestWriter<T> {
        public void writeTo(T var1);
    }
}

