/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RollCyclesDeprecationChecksTest
extends QueueTestCommon {
    @Test
    public void shouldWarnWhenDeprecatedRollCycleIsInUse() {
        this.expectException("You've configured your queue to use a deprecated RollCycle (net.openhft.chronicle.queue.RollCycles.HOURLY) please consider switching to net.openhft.chronicle.queue.rollcycles.LegacyRollCycles.HOURLY, as the RollCycle constant you've nominated will be removed in a future release!");
        RollCycles.warnIfDeprecated((RollCycle)RollCycles.HOURLY);
    }

    @Test
    public void shouldNotWarnWhenNonDeprecatedRollCycleIsInUse() {
        RollCycles.warnIfDeprecated((RollCycle)RollCycles.FAST_HOURLY);
    }

    @Test
    public void shouldNotWarnWhenCustomRollCycleIsInUse() {
        RollCycles.warnIfDeprecated((RollCycle)new CustomRollCycle());
    }

    @Test
    public void shouldIndicateIfARollCycleIsDeprecated() {
        Assert.assertTrue((boolean)RollCycles.isDeprecated((RollCycle)RollCycles.HOURLY));
        Assert.assertFalse((boolean)RollCycles.isDeprecated((RollCycle)RollCycles.FAST_HOURLY));
        Assert.assertFalse((boolean)RollCycles.isDeprecated((RollCycle)new CustomRollCycle()));
    }

    @Test
    public void deprecationStatusIsCorrect() throws IllegalAccessException {
        HashSet<RollCycles> allRollCycles = new HashSet<RollCycles>(Arrays.asList(RollCycles.values()));
        HashSet<RollCycles> checkedRollCycles = new HashSet<RollCycles>();
        for (Field field : RollCycles.class.getFields()) {
            if (!field.isEnumConstant()) continue;
            RollCycles rollCycle = (RollCycles)field.get(null);
            Assert.assertEquals((Object)(field.getAnnotation(Deprecated.class) != null ? 1 : 0), (Object)RollCycles.isDeprecated((RollCycle)rollCycle));
            checkedRollCycles.add(rollCycle);
        }
        Assert.assertEquals(allRollCycles, checkedRollCycles);
    }

    private static class CustomRollCycle
    implements RollCycle {
        private CustomRollCycle() {
        }

        @NotNull
        public String format() {
            return "oooahhh";
        }

        public int lengthInMillis() {
            return 0;
        }

        public int defaultIndexCount() {
            return 0;
        }

        public int defaultIndexSpacing() {
            return 0;
        }

        public long toIndex(int cycle, long sequenceNumber) {
            return 0L;
        }

        public long toSequenceNumber(long index) {
            return 0L;
        }

        public int toCycle(long index) {
            return 0;
        }

        public long maxMessagesPerCycle() {
            return 0L;
        }
    }
}

