/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;
import net.openhft.chronicle.wire.QueryWire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChronicleChannelSupplier;
import net.openhft.chronicle.wire.channel.ChronicleGatewayMain;
import net.openhft.chronicle.wire.channel.SystemContext;
import net.openhft.chronicle.wire.channel.impl.SocketRegistry;
import net.openhft.chronicle.wire.channel.impl.internal.Handler;

public class ChronicleContext
extends SimpleCloseable {
    private final Set<Closeable> closeableSet = Collections.synchronizedSet(Collections.newSetFromMap(new WeakIdentityHashMap()));
    private final String url;
    private String name;
    private transient URL _url;
    private transient SocketRegistry socketRegistry;
    private boolean buffered;
    private boolean useAffinity;
    private ChronicleGatewayMain gateway;
    private SystemContext systemContext;
    private boolean privateSocketRegistry;

    protected ChronicleContext(String url) {
        this(url, null);
    }

    protected ChronicleContext(String url, SocketRegistry socketRegistry) {
        this.url = url;
        this.socketRegistry = socketRegistry;
        this.init();
    }

    public static ChronicleContext newContext(String url) {
        return new ChronicleContext(url);
    }

    public static URL urlFor(String spec) throws IORuntimeException {
        try {
            if (spec.startsWith("internal:")) {
                return new URL(null, spec, new Handler());
            }
            if (spec.startsWith("tcp:")) {
                return new URL(null, spec, new net.openhft.chronicle.wire.channel.impl.tcp.Handler());
            }
            return new URL(spec);
        }
        catch (MalformedURLException e) {
            throw new IORuntimeException(e);
        }
    }

    public AffinityLock affinityLock() {
        return this.useAffinity() ? AffinityLock.acquireLock() : AffinityLock.acquireLock((String)null);
    }

    public boolean useAffinity() {
        return this.useAffinity;
    }

    public ChronicleContext useAffinity(boolean useAffinity) {
        this.useAffinity = useAffinity;
        return this;
    }

    protected void init() {
        if (this.socketRegistry == null) {
            this.socketRegistry = new SocketRegistry();
            this.privateSocketRegistry = true;
        }
    }

    public ChronicleChannelSupplier newChannelSupplier(ChannelHandler handler) throws InvalidMarshallableException {
        this.startServerIfNeeded();
        ChronicleChannelSupplier connectionSupplier = new ChronicleChannelSupplier(this, handler);
        String hostname = this.url().getHost();
        int port = this.gateway == null ? this.url().getPort() : this.gateway.port();
        String query = this.url().getQuery();
        String connectionId = null;
        if (query != null) {
            QueryWire wire = new QueryWire(Bytes.from(query));
            connectionId = wire.read("sessionName").text();
        }
        ((ChronicleChannelSupplier)((ChronicleChannelSupplier)((ChronicleChannelSupplier)connectionSupplier.protocol(this.url().getProtocol()).hostname(hostname == null || hostname.isEmpty() ? "localhost" : hostname)).port(port)).connectionId(connectionId).buffered(this.buffered())).initiator(true);
        return connectionSupplier;
    }

    private void startServerIfNeeded() throws InvalidMarshallableException {
        if (this.url().getProtocol().equals("tcp") && "".equals(this.url().getHost())) {
            this.startNewGateway();
        }
    }

    public synchronized void startNewGateway() throws InvalidMarshallableException {
        if (this.gateway != null) {
            return;
        }
        this.gateway = new ChronicleGatewayMain(this.url, this.socketRegistry, this.systemContext());
        this.gateway.name(this.name()).buffered(this.buffered()).useAffinity(this.useAffinity());
        try {
            this.addCloseable(this.gateway);
            this.gateway.start();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public void addCloseable(Closeable closeable) {
        this.closeableSet.add(closeable);
    }

    @Override
    protected void performClose() {
        Closeable.closeQuietly(this.closeableSet);
        this.closeableSet.clear();
        if (this.privateSocketRegistry) {
            this.socketRegistry.close();
        }
    }

    public URL url() {
        if (this._url == null) {
            this._url = ChronicleContext.urlFor(this.url);
        }
        return this._url;
    }

    public boolean buffered() {
        return this.buffered;
    }

    public ChronicleContext buffered(boolean buffered) {
        this.buffered = buffered;
        return this;
    }

    public SocketRegistry socketRegistry() {
        return this.socketRegistry;
    }

    public void systemContext(SystemContext systemContext) throws InvalidMarshallableException {
        this.systemContext = (SystemContext)systemContext.deepCopy();
    }

    public SystemContext systemContext() throws InvalidMarshallableException {
        return this.systemContext == null ? (SystemContext)SystemContext.INSTANCE.deepCopy() : this.systemContext;
    }

    public ChronicleContext name(String name) {
        this.name = name;
        return this;
    }

    public String name() {
        return this.name;
    }

    public File toFile(String name) {
        if (this.name() == null) {
            return new File(name);
        }
        return new File(this.name(), name);
    }

    public String toString() {
        return WireType.YAML.asString(this);
    }

    static {
        Handler.init();
    }
}

