/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.MethodWriterBuilder;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.StopCharTesters;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.ref.TextBooleanReference;
import net.openhft.chronicle.bytes.ref.TextIntArrayReference;
import net.openhft.chronicle.bytes.ref.TextIntReference;
import net.openhft.chronicle.bytes.ref.TextLongArrayReference;
import net.openhft.chronicle.bytes.ref.TextLongReference;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.TextReadDocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.TextWriteDocumentContext;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaMethodReaderBuilder;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.YamlKeys;
import net.openhft.chronicle.wire.YamlToken;
import net.openhft.chronicle.wire.YamlTokeniser;
import net.openhft.chronicle.wire.YamlWireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YamlWire
extends YamlWireOut<YamlWire> {
    static final String SEQ_MAP = "!seqmap";
    static final String BINARY_TAG = "!binary";
    static final String DATA_TAG = "!data";
    private final TextValueIn valueIn = this.createValueIn();
    private final YamlTokeniser yt;
    private final Map<String, Object> anchorValues = new HashMap<String, Object>();
    private DefaultValueIn defaultValueIn;
    private WriteDocumentContext writeContext;
    private ReadDocumentContext readContext;

    public YamlWire(@NotNull Bytes<?> bytes, boolean use8bit) {
        super((Bytes)bytes, use8bit);
        this.yt = new YamlTokeniser(bytes);
        this.defaultValueIn = new DefaultValueIn(this);
    }

    public YamlWire(@NotNull Bytes<?> bytes) {
        this(bytes, false);
    }

    @NotNull
    public static YamlWire fromFile(String name) throws IOException {
        return new YamlWire(BytesUtil.readFile(name), true);
    }

    @NotNull
    public static YamlWire from(@NotNull String text) {
        return new YamlWire(Bytes.from(text));
    }

    public static String asText(@NotNull Wire wire) throws InvalidMarshallableException {
        long pos = wire.bytes().readPosition();
        @NotNull Wire tw = Wire.newYamlWireOnHeap();
        wire.copyTo(tw);
        wire.bytes().readPosition(pos);
        return tw.toString();
    }

    private static <ACS extends Appendable & CharSequence> void unescape(@NotNull ACS sb, char blockQuote) {
        int end = 0;
        int length = ((CharSequence)sb).length();
        boolean skip = false;
        for (int i = 0; i < length; ++i) {
            char ch2;
            if (skip) {
                skip = false;
                continue;
            }
            char ch = ((CharSequence)sb).charAt(i);
            if (blockQuote == '\"' && ch == '\\' && i < length - 1) {
                char ch3 = ((CharSequence)sb).charAt(++i);
                switch (ch3) {
                    case '0': {
                        ch = '\u0000';
                        break;
                    }
                    case 'a': {
                        ch = '\u0007';
                        break;
                    }
                    case 'b': {
                        ch = '\b';
                        break;
                    }
                    case 't': {
                        ch = '\t';
                        break;
                    }
                    case 'n': {
                        ch = '\n';
                        break;
                    }
                    case 'v': {
                        ch = '\u000b';
                        break;
                    }
                    case 'f': {
                        ch = '\f';
                        break;
                    }
                    case 'r': {
                        ch = '\r';
                        break;
                    }
                    case 'e': {
                        ch = '\u001b';
                        break;
                    }
                    case 'N': {
                        ch = '\u0085';
                        break;
                    }
                    case '_': {
                        ch = '\u00a0';
                        break;
                    }
                    case 'L': {
                        ch = '\u2028';
                        break;
                    }
                    case 'P': {
                        ch = '\u2029';
                        break;
                    }
                    case 'x': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    case 'u': {
                        ch = (char)(Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 4096 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 256 + Character.getNumericValue(((CharSequence)sb).charAt(++i)) * 16 + Character.getNumericValue(((CharSequence)sb).charAt(++i)));
                        break;
                    }
                    default: {
                        ch = ch3;
                    }
                }
            }
            if (blockQuote == '\'' && ch == '\'' && i < length - 1 && (ch2 = ((CharSequence)sb).charAt(i + 1)) == ch) {
                skip = true;
            }
            AppendableUtil.setCharAt(sb, end++, ch);
        }
        if (length != ((CharSequence)sb).length()) {
            throw new IllegalStateException("Length changed from " + length + " to " + ((CharSequence)sb).length() + " for " + sb);
        }
        AppendableUtil.setLength(sb, end);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public boolean hintReadInputOrder() {
        return true;
    }

    @Override
    @NotNull
    public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.YAML, () -> this.newTextMethodWriterInvocationHandler(tClass));
        for (Class aClass : additional) {
            builder.addInterface(aClass);
        }
        builder.marshallableOut(this);
        return builder.build();
    }

    @NotNull
    TextMethodWriterInvocationHandler newTextMethodWriterInvocationHandler(Class ... interfaces) {
        for (Class anInterface : interfaces) {
            Comment c = anInterface.getAnnotation(Comment.class);
            if (c == null) continue;
            this.writeComment(c.value());
        }
        return new TextMethodWriterInvocationHandler(interfaces[0], this);
    }

    @Override
    @NotNull
    public <T> MethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder<T> builder = new VanillaMethodWriterBuilder<T>(tClass, WireType.YAML, () -> this.newTextMethodWriterInvocationHandler(tClass));
        builder.marshallableOut(this);
        return builder;
    }

    @Override
    @NotNull
    public VanillaMethodReaderBuilder methodReaderBuilder() {
        return super.methodReaderBuilder().wireType(WireType.YAML);
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        if (this.writeContext == null) {
            this.useBinaryDocuments();
        }
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (this.writeContext != null && this.writeContext.isOpen()) {
            return this.writeContext;
        }
        return this.writingDocument(metaData);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.initReadContext();
        return this.readContext;
    }

    protected void initReadContext() {
        if (this.readContext == null) {
            this.useBinaryDocuments();
        }
        this.readContext.start();
    }

    @NotNull
    public YamlWire useBinaryDocuments() {
        this.readContext = new BinaryReadDocumentContext(this, false);
        this.writeContext = new BinaryWriteDocumentContext(this);
        return this;
    }

    @NotNull
    public YamlWire useTextDocuments() {
        this.readContext = new TextReadDocumentContext(this);
        this.writeContext = new TextWriteDocumentContext(this);
        return this;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        long readPosition = this.bytes().readPosition();
        long readLimit = this.bytes().readLimit();
        this.bytes().readPosition(readLocation);
        this.initReadContext();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @NotNull
    protected TextValueIn createValueIn() {
        return new TextValueIn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.bytes.readRemaining() > 0x100000L) {
            long l = this.bytes.readLimit();
            try {
                this.bytes.readLimit(this.bytes.readPosition() + 0x100000L);
                String string = this.bytes + "..";
                return string;
            }
            finally {
                this.bytes.readLimit(l);
            }
        }
        return this.bytes.toString();
    }

    @Override
    public void copyTo(@NotNull WireOut wire) throws InvalidMarshallableException {
        if (wire instanceof TextWire || wire instanceof YamlWire) {
            Bytes<?> bytes0 = this.bytes();
            wire.bytes().write(this.bytes, this.yt.blockStart(), bytes0.readLimit() - this.yt.blockStart);
            this.bytes.readPosition(this.bytes.readLimit());
        } else {
            while (!this.isEmpty()) {
                this.copyOne(wire, true);
                this.yt.next();
            }
        }
    }

    private void copyOne(WireOut wire, boolean nested) throws InvalidMarshallableException {
        switch (this.yt.current()) {
            case NONE: {
                break;
            }
            case COMMENT: {
                wire.writeComment(this.yt.text());
                break;
            }
            case TAG: {
                wire.getValueOut().typePrefix(this.yt.text());
                this.yt.next();
                this.copyOne(wire, true);
                this.yt.next();
                break;
            }
            case DIRECTIVE: {
                break;
            }
            case DOCUMENT_END: {
                break;
            }
            case DIRECTIVES_END: {
                this.yt.next();
                while (!this.isEmpty()) {
                    this.copyOne(wire, false);
                    this.yt.next();
                }
                break;
            }
            case MAPPING_KEY: {
                this.copyMappingKey(wire, nested);
                break;
            }
            case MAPPING_END: {
                return;
            }
            case MAPPING_START: {
                if (!nested) break;
                this.yt.next();
                wire.getValueOut().marshallable(w -> {
                    while (this.yt.current() == YamlToken.MAPPING_KEY) {
                        this.copyMappingKey(wire, true);
                        this.yt.next();
                    }
                });
                break;
            }
            case SEQUENCE_END: {
                break;
            }
            case SEQUENCE_ENTRY: {
                break;
            }
            case SEQUENCE_START: {
                this.yt.next();
                YamlWire yw = this;
                wire.getValueOut().sequence(w -> {
                    while (this.yt.current() != YamlToken.SEQUENCE_END) {
                        yw.copyOne(w.wireOut(), true);
                        yw.yt.next();
                    }
                });
                break;
            }
            case TEXT: {
                wire.getValueOut().text(this.yt.text());
                break;
            }
            case LITERAL: {
                wire.getValueOut().text(this.yt.text());
                break;
            }
            case ANCHOR: {
                break;
            }
            case ALIAS: {
                break;
            }
            case RESERVED: {
                break;
            }
            case STREAM_END: {
                break;
            }
        }
    }

    private void copyMappingKey(WireOut wire, boolean nested) throws InvalidMarshallableException {
        this.yt.next();
        if (this.yt.current() == YamlToken.MAPPING_KEY) {
            this.yt.next();
        }
        if (this.yt.current() == YamlToken.TEXT) {
            if (nested) {
                wire.write(this.yt.text());
            } else {
                wire.writeEvent(String.class, this.yt.text());
            }
        } else {
            throw new UnsupportedOperationException("Unable to copy key " + this.yt);
        }
        this.yt.next();
        this.copyOne(wire, true);
    }

    @Override
    public long readEventNumber() {
        StringBuilder stringBuilder = this.acquireStringBuilder();
        this.readField(stringBuilder);
        try {
            return StringUtils.parseInt(stringBuilder, 10);
        }
        catch (NumberFormatException ignored) {
            return Long.MIN_VALUE;
        }
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder());
        switch (this.yt.current()) {
            case NONE: 
            case MAPPING_END: {
                return this.defaultValueIn;
            }
        }
        return this.valueIn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected StringBuilder readField(@NotNull StringBuilder sb) {
        this.startEventIfTop();
        if (this.yt.current() == YamlToken.MAPPING_KEY) {
            this.yt.next();
            if (this.yt.current() != YamlToken.TEXT) throw new IllegalStateException(this.yt.toString());
            String text = this.yt.text();
            sb.setLength(0);
            sb.append(text);
            YamlWire.unescape(sb, this.yt.blockQuote());
            this.yt.next();
            return sb;
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) throws InvalidMarshallableException {
        this.startEventIfTop();
        switch (this.yt.current()) {
            case MAPPING_KEY: {
                YamlToken next = this.yt.next();
                if (next == YamlToken.MAPPING_KEY) {
                    return this.readEvent(expectedClass);
                }
                return this.valueIn.object(expectedClass);
            }
            case NONE: {
                return null;
            }
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    @Override
    public boolean isNotEmptyAfterPadding() {
        this.consumePadding();
        switch (this.yt.current()) {
            case NONE: 
            case DOCUMENT_END: 
            case MAPPING_END: 
            case SEQUENCE_END: {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private <K> K toExpected(Class<K> expectedClass, StringBuilder sb) {
        return ObjectUtils.convertTo(expectedClass, WireInternal.INTERNER.intern(sb));
    }

    @Override
    public void consumePadding() {
        block4: while (true) {
            switch (this.yt.current()) {
                case COMMENT: {
                    this.commentListener.accept(this.yt.text());
                }
                case DIRECTIVE: 
                case DIRECTIVES_END: {
                    this.yt.next();
                    continue block4;
                }
            }
            break;
        }
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        return "todo";
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.read(key.name().toString());
    }

    @Override
    @NotNull
    public ValueIn read(String keyName) {
        this.startEventIfTop();
        YamlKeys keys = this.yt.keys();
        int count = keys.count();
        if (count > 0) {
            long pos = this.yt.lastKeyPosition();
            long[] offsets = keys.offsets();
            int contextSize = this.yt.contextSize();
            for (int i = 0; i < count; ++i) {
                this.yt.revertToContext(contextSize);
                YamlToken next = this.yt.rereadAndNext(offsets[i]);
                assert (next == YamlToken.MAPPING_KEY);
                if (!this.checkForMatch(keyName)) continue;
                keys.removeIndex(i);
                return this.valueIn;
            }
            this.yt.revertToContext(contextSize);
            this.bytes.readPosition(pos);
            this.yt.next();
        }
        int minIndent = this.yt.topContext().indent;
        while (this.yt.current() == YamlToken.MAPPING_KEY) {
            long lastKeyPosition = this.yt.lastKeyPosition();
            if (this.checkForMatch(keyName)) {
                return this.valueIn;
            }
            keys.push(lastKeyPosition);
            this.valueIn.consumeAny(minIndent);
        }
        return this.defaultValueIn;
    }

    public String dumpContext() {
        ValidatableUtil.startValidateDisabled();
        try {
            Wire yw = Wire.newYamlWireOnHeap();
            yw.getValueOut().list(this.yt.contexts, YamlTokeniser.YTContext.class);
            String string = yw.toString();
            return string;
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
    }

    private boolean checkForMatch(@NotNull String keyName) {
        YamlToken next = this.yt.next();
        if (next != YamlToken.TEXT) {
            throw new IllegalStateException(next.toString());
        }
        this.sb.setLength(0);
        this.sb.append(this.yt.text());
        YamlWire.unescape(this.sb, this.yt.blockQuote());
        this.yt.next();
        return this.sb.length() == 0 || StringUtils.isEqual(this.sb, (CharSequence)keyName);
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        this.startEventIfTop();
        this.readField(name);
        return this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        this.sb.setLength(0);
        if (this.yt.current() == YamlToken.COMMENT) {
            YamlToken next = this.yt.next();
            this.sb.append(this.yt.text());
        }
        return this;
    }

    @Override
    public void clear() {
        this.reset();
    }

    protected void consumeDocumentStart() {
        if (this.bytes.readRemaining() > 4L) {
            String word;
            long pos = this.bytes.readPosition();
            if (this.bytes.readByte(pos) == 45 && this.bytes.readByte(pos + 1L) == 45 && this.bytes.readByte(pos + 2L) == 45) {
                this.bytes.readSkip(3L);
            }
            pos = this.bytes.readPosition();
            switch (word = this.bytes.parseUtf8(StopCharTesters.SPACE_STOP)) {
                case "!!data": 
                case "!!data-not-ready": 
                case "!!meta-data": 
                case "!!meta-data-not-ready": {
                    break;
                }
                default: {
                    this.bytes.readPosition(pos);
                }
            }
        }
        if (this.yt.current() == YamlToken.NONE) {
            this.yt.next();
        }
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new TextLongReference();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        return new TextBooleanReference();
    }

    @Override
    public boolean useSelfDescribingMessage(@NotNull CommonMarshallable object) {
        return true;
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new TextIntReference();
    }

    @Override
    @NotNull
    public LongArrayValues newLongArrayReference() {
        return new TextLongArrayReference();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        return new TextIntArrayReference();
    }

    @NotNull
    private Map readMap(Class valueType) {
        LinkedHashMap map = new LinkedHashMap();
        if (this.yt.current() == YamlToken.MAPPING_START) {
            while (this.yt.next() == YamlToken.MAPPING_KEY) {
                if (this.yt.next() == YamlToken.TEXT) {
                    String key = this.yt.text();
                    if (this.yt.next() != YamlToken.TEXT) {
                        throw new UnsupportedOperationException(this.yt.toString());
                    }
                    Object o = ObjectUtils.convertTo(valueType, this.yt.text());
                    map.put(key, o);
                    continue;
                }
                throw new UnsupportedOperationException(this.yt.toString());
            }
        } else {
            throw new UnsupportedOperationException(this.yt.toString());
        }
        return map;
    }

    @Override
    public void startEvent() {
        this.consumePadding();
        switch (this.yt.current()) {
            case MAPPING_START: {
                this.yt.next(Integer.MAX_VALUE);
                return;
            }
            case NONE: {
                return;
            }
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    void startEventIfTop() {
        this.consumePadding();
        if (this.yt.contextSize() == 3 && this.yt.current() == YamlToken.MAPPING_START) {
            this.yt.next();
        }
    }

    @Override
    public boolean isEndEvent() {
        this.consumePadding();
        YamlToken current = this.yt.current();
        return current == YamlToken.MAPPING_END || current == YamlToken.NONE;
    }

    @Override
    public void endEvent() {
        int minIndent = this.yt.topContext().indent;
        switch (this.yt.current()) {
            case NONE: 
            case DOCUMENT_END: 
            case MAPPING_END: {
                break;
            }
            default: {
                this.valueIn.consumeAny(minIndent);
            }
        }
        if (this.yt.current() == YamlToken.NONE) {
            this.yt.next(Integer.MIN_VALUE);
        } else {
            while (this.yt.current() == YamlToken.MAPPING_KEY) {
                this.yt.next();
                this.valueIn.consumeAny(minIndent);
            }
        }
        if (this.yt.current() == YamlToken.MAPPING_END || this.yt.current() == YamlToken.DOCUMENT_END || this.yt.current() == YamlToken.NONE) {
            this.yt.next(Integer.MIN_VALUE);
            return;
        }
        throw new UnsupportedOperationException(this.yt.toString());
    }

    @Override
    public void reset() {
        if (this.readContext != null) {
            this.readContext.reset();
        }
        if (this.writeContext != null) {
            this.writeContext.reset();
        }
        this.bytes.clear();
        this.sb.setLength(0);
        this.yt.reset();
        this.valueIn.resetState();
        this.valueOut.resetState();
        this.anchorValues.clear();
    }

    @Override
    public boolean hasMetaDataPrefix() {
        if (this.yt.current() == YamlToken.TAG && this.yt.isText("!meta-data")) {
            this.yt.next();
            return true;
        }
        return false;
    }

    @Override
    public boolean readDocument(@Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) throws InvalidMarshallableException {
        this.valueIn.resetState();
        return super.readDocument(metaDataConsumer, dataConsumer);
    }

    @Override
    public boolean readDocument(long position, @Nullable ReadMarshallable metaDataConsumer, @Nullable ReadMarshallable dataConsumer) throws InvalidMarshallableException {
        this.valueIn.resetState();
        return super.readDocument(position, metaDataConsumer, dataConsumer);
    }

    @Override
    public boolean writingIsComplete() {
        return !this.writeContext.isNotComplete();
    }

    class TextValueIn
    implements ValueIn {
        TextValueIn() {
        }

        @Override
        public ClassLookup classLookup() {
            return YamlWire.this.classLookup();
        }

        @Override
        public void resetState() {
            YamlWire.this.yt.reset();
            YamlWire.this.anchorValues.clear();
        }

        @Override
        @Nullable
        public String text() {
            @Nullable StringBuilder cs = this.textTo0(YamlWire.this.acquireStringBuilder());
            return cs == null ? null : WireInternal.INTERNER.intern(cs);
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            sb.setLength(0);
            @Nullable StringBuilder cs = this.textTo0(sb);
            if (cs == null) {
                return null;
            }
            if (cs != sb) {
                sb.setLength(0);
                sb.append((CharSequence)cs);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> bytes) {
            bytes.clear();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            bytes.clear();
            bytes.append(YamlWire.this.yt.text());
            YamlWire.this.yt.next();
            return bytes;
        }

        @Override
        public BracketType getBracketType() {
            switch (YamlWire.this.yt.current()) {
                default: {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                case COMMENT: 
                case TAG: 
                case DIRECTIVES_END: {
                    YamlWire.this.yt.next();
                    return this.getBracketType();
                }
                case MAPPING_START: {
                    return BracketType.MAP;
                }
                case SEQUENCE_START: {
                    return BracketType.SEQ;
                }
                case NONE: 
                case MAPPING_KEY: 
                case SEQUENCE_ENTRY: 
                case TEXT: 
                case LITERAL: 
                case STREAM_START: 
            }
            return BracketType.NONE;
        }

        @Nullable
        Bytes<?> textTo0(@NotNull Bytes<?> a) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            a.append(YamlWire.this.yt.text());
            return a;
        }

        @Nullable
        StringBuilder textTo0(@NotNull StringBuilder a) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            if (YamlWire.this.yt.current() == YamlToken.TEXT || YamlWire.this.yt.current() == YamlToken.LITERAL) {
                a.append(YamlWire.this.yt.text());
                if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                    YamlWire.unescape(a, YamlWire.this.yt.blockQuote());
                }
                YamlWire.this.yt.next();
            } else if (YamlWire.this.yt.current() == YamlToken.TAG) {
                if (YamlWire.this.yt.isText("!null")) {
                    YamlWire.this.yt.next();
                    YamlWire.this.yt.next();
                    return null;
                }
                if (YamlWire.this.yt.isText(YamlWire.BINARY_TAG)) {
                    byte[] arr;
                    YamlWire.this.yt.next();
                    for (byte b : arr = (byte[])this.decodeBinary(byte[].class)) {
                        a.append((char)b);
                    }
                    return a;
                }
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return a;
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, BooleanConsumer consumer) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes) {
            toBytes.clear();
            return this.bytes((BytesIn<?> b) -> {
                Bytes cfr_ignored_0 = (Bytes)toBytes.write((BytesStore)((Object)b));
            });
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            return this.bytes((BytesIn<?> bytes) -> {
                long capacity = bytes.readRemaining();
                VanillaBytes<Void> bytes2 = Bytes.allocateDirect(capacity);
                bytes2.write((BytesStore)((Object)bytes));
                toBytes.set(bytes2.addressForRead(bytes2.start()), capacity);
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            YamlWire.this.consumePadding();
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                YamlWire.this.bytes.readSkip(1L);
                YamlWire.this.yt.text(sb);
                YamlWire.this.yt.next();
                if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
                @Nullable byte[] uncompressed = Compression.uncompress((CharSequence)sb, YamlWire.this.yt, t -> {
                    @NotNull StringBuilder sb2 = YamlWire.this.acquireStringBuilder();
                    t.text(sb2);
                    return Base64.getDecoder().decode(sb2.toString());
                });
                if (uncompressed != null) {
                    Bytes<byte[]> bytes = Bytes.wrapForRead(uncompressed);
                    try {
                        bytesConsumer.readMarshallable(bytes);
                        return YamlWire.this;
                    }
                    finally {
                        bytes.releaseLast();
                    }
                } else {
                    if (!StringUtils.isEqual(sb, (CharSequence)"!null")) throw new IORuntimeException("Unsupported type=" + sb);
                    bytesConsumer.readMarshallable(null);
                    YamlWire.this.yt.next();
                }
                return YamlWire.this;
            }
            this.textTo(sb);
            Bytes<byte[]> bytes = Bytes.wrapForRead(sb.toString().getBytes(StandardCharsets.ISO_8859_1));
            try {
                bytesConsumer.readMarshallable(bytes);
                return YamlWire.this;
            }
            finally {
                bytes.releaseLast();
            }
        }

        @Override
        public byte @Nullable [] bytes(byte[] using) {
            return (byte[])this.objectWithInferredType(using, SerializationStrategies.ANY_OBJECT, byte[].class);
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return YamlWire.this;
        }

        @Override
        public long readLength() {
            return this.readLengthMarshallable();
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
            return YamlWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected long readLengthMarshallable() {
            long start = YamlWire.this.bytes.readPosition();
            try {
                this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
                long l = YamlWire.this.bytes.readPosition() - start;
                return l;
            }
            finally {
                YamlWire.this.bytes.readPosition(start);
            }
        }

        protected void consumeAny(int minIndent) {
            YamlWire.this.consumePadding();
            int indent2 = Math.max(((YamlWire)YamlWire.this).yt.topContext().indent, minIndent);
            switch (YamlWire.this.yt.current()) {
                case TAG: 
                case SEQUENCE_ENTRY: {
                    YamlWire.this.yt.next(minIndent);
                    this.consumeAny(minIndent);
                    break;
                }
                case MAPPING_START: {
                    this.consumeMap(indent2);
                    break;
                }
                case SEQUENCE_START: {
                    this.consumeSeq(indent2);
                    break;
                }
                case MAPPING_KEY: {
                    YamlWire.this.yt.next(minIndent);
                    this.consumeAny(minIndent);
                    if (YamlWire.this.yt.current() == YamlToken.MAPPING_KEY || YamlWire.this.yt.current() == YamlToken.MAPPING_END) break;
                    this.consumeAny(minIndent);
                    break;
                }
                case SEQUENCE_END: {
                    YamlWire.this.yt.next(minIndent);
                    break;
                }
                case TEXT: {
                    YamlWire.this.yt.next(minIndent);
                    break;
                }
                case NONE: 
                case DOCUMENT_END: 
                case MAPPING_END: 
                case STREAM_START: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(YamlWire.this.yt.toString());
                }
            }
        }

        private void consumeSeq(int minIndent) {
            assert (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START);
            YamlWire.this.yt.next(minIndent);
            block4: while (true) {
                switch (YamlWire.this.yt.current()) {
                    case SEQUENCE_ENTRY: {
                        YamlWire.this.yt.next(minIndent);
                        this.consumeAny(minIndent);
                        continue block4;
                    }
                    case SEQUENCE_END: {
                        YamlWire.this.yt.next(minIndent);
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException(YamlWire.this.yt.toString());
        }

        private void consumeMap(int minIndent) {
            YamlWire.this.yt.next(minIndent);
            while (YamlWire.this.yt.current() == YamlToken.MAPPING_KEY) {
                YamlWire.this.yt.next(minIndent);
                this.consumeAny(minIndent);
                this.consumeAny(minIndent);
            }
            if (YamlWire.this.yt.current() == YamlToken.NONE) {
                YamlWire.this.yt.next(Integer.MIN_VALUE);
            }
            if (YamlWire.this.yt.current() == YamlToken.MAPPING_END) {
                YamlWire.this.yt.next(minIndent);
            }
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                tFlag.accept(t, null);
                return YamlWire.this;
            }
            Boolean flag = stringBuilder.length() == 0 ? null : Boolean.valueOf(StringUtils.isEqual(stringBuilder, (CharSequence)"true"));
            tFlag.accept(t, flag);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            YamlWire.this.consumePadding();
            tb.accept(t, (byte)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (short)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            YamlWire.this.consumePadding();
            ti.accept(t, (int)this.getALong());
            return YamlWire.this;
        }

        long getALong() {
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                long l = YamlWire.this.yt.parseLong();
                YamlWire.this.yt.next();
                return l;
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            YamlWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            YamlWire.this.consumePadding();
            tl.accept(t, this.getALong());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            YamlWire.this.consumePadding();
            tf.accept(t, (float)this.getADouble());
            return YamlWire.this;
        }

        public double getADouble() {
            if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                double v = YamlWire.this.yt.parseDouble();
                YamlWire.this.yt.next();
                return v;
            }
            throw new UnsupportedOperationException("yt:" + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            YamlWire.this.consumePadding();
            td.accept(t, this.getADouble());
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            setLocalTime.accept(t, LocalTime.parse(WireInternal.INTERNER.intern(stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tZonedDateTime.accept(t, ZonedDateTime.parse(WireInternal.INTERNER.intern(stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tLocalDate.accept(t, LocalDate.parse(WireInternal.INTERNER.intern(stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            this.textTo(stringBuilder);
            tuuid.accept(t, UUID.fromString(WireInternal.INTERNER.intern(stringBuilder)));
            return YamlWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            YamlWire.this.consumePadding();
            if (!(values instanceof TextLongArrayReference)) {
                values = new TextLongArrayReference();
            }
            @NotNull Byteable b = (Byteable)((Object)values);
            long length = TextLongArrayReference.peakLength(YamlWire.this.bytes, YamlWire.this.bytes.readPosition());
            b.bytesStore(YamlWire.this.bytes, YamlWire.this.bytes.readPosition(), length);
            YamlWire.this.bytes.readSkip(length);
            setter.accept(t, values);
            return YamlWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public WireIn bool(@NotNull BooleanValue value) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof TextLongReference)) {
                value = new TextLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            YamlWire.this.consumePadding();
            if (this.isNull()) {
                return false;
            }
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START) {
                int minIndent = ((YamlWire)YamlWire.this).yt.secondTopContext().indent;
                YamlWire.this.yt.next(Integer.MAX_VALUE);
                tReader.accept(t, YamlWire.this.valueIn);
                if (YamlWire.this.yt.current() == YamlToken.NONE) {
                    YamlWire.this.yt.next(minIndent);
                }
                if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_END) {
                    YamlWire.this.yt.next(minIndent);
                }
            } else if (YamlWire.this.yt.current() == YamlToken.TEXT) {
                tReader.accept(t, YamlWire.this.valueIn);
            } else {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return true;
        }

        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader reader0) throws InvalidMarshallableException {
            return this.sequence(list, buffer, bufferAdd);
        }

        @Override
        public <T> boolean sequence(@NotNull List<T> list, @NotNull List<T> buffer, @NotNull Supplier<T> bufferAdd) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            if (this.isNull()) {
                return false;
            }
            list.clear();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START) {
                int minIndent = ((YamlWire)YamlWire.this).yt.secondTopContext().indent;
                YamlWire.this.yt.next(Integer.MAX_VALUE);
                while (this.hasNextSequenceItem()) {
                    if (buffer.size() <= list.size()) {
                        buffer.add(bufferAdd.get());
                    }
                    T using = buffer.get(list.size());
                    list.add(YamlWire.this.valueIn.object(using, using.getClass()));
                }
                if (YamlWire.this.yt.current() == YamlToken.NONE) {
                    YamlWire.this.yt.next(minIndent);
                }
                if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_END) {
                    YamlWire.this.yt.next(minIndent);
                }
            } else {
                throw new UnsupportedOperationException(YamlWire.this.yt.toString());
            }
            return true;
        }

        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            assert (YamlWire.this.yt.current() == YamlToken.SEQUENCE_START);
            YamlWire.this.yt.next(Integer.MIN_VALUE);
            block4: while (true) {
                switch (YamlWire.this.yt.current()) {
                    case SEQUENCE_ENTRY: {
                        YamlWire.this.yt.next(Integer.MIN_VALUE);
                        tReader.accept(t, kls, YamlWire.this.valueIn);
                        continue block4;
                    }
                    case SEQUENCE_END: {
                        YamlWire.this.yt.next(Integer.MIN_VALUE);
                        return YamlWire.this;
                    }
                }
                break;
            }
            throw new IllegalStateException(YamlWire.this.yt.toString());
        }

        @Override
        public boolean hasNext() {
            if (YamlWire.this.yt.current() == YamlToken.DOCUMENT_END) {
                YamlWire.this.yt.next(Integer.MIN_VALUE);
            }
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case NONE: 
                case DOCUMENT_END: 
                case MAPPING_END: 
                case SEQUENCE_END: 
                case STREAM_END: {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean hasNextSequenceItem() {
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case SEQUENCE_ENTRY: 
                case SEQUENCE_START: 
                case TEXT: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                ts.accept(t, YamlWire.this.yt.text());
                YamlWire.this.yt.next();
            } else {
                ts.accept(t, "java.lang.Object");
            }
            return this;
        }

        @Override
        public Class typePrefix() {
            if (YamlWire.this.yt.current() != YamlToken.TAG) {
                return null;
            }
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            YamlWire.this.yt.text(stringBuilder);
            if (YamlWire.BINARY_TAG.contentEquals(stringBuilder) || YamlWire.DATA_TAG.contains(stringBuilder)) {
                return null;
            }
            try {
                YamlWire.this.yt.next();
                return this.classLookup().forName(stringBuilder);
            }
            catch (ClassNotFoundRuntimeException e) {
                Jvm.warn().on(this.getClass(), "Unable to find " + stringBuilder + " " + e);
                return null;
            }
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    Class type = this.typePrefix();
                    return type;
                }
            }
            return null;
        }

        @Override
        public boolean isTyped() {
            YamlWire.this.consumePadding();
            int code = YamlWire.this.bytes.peekUnsignedByte();
            return code == 33;
        }

        @NotNull
        String stringForCode(int code) {
            return code < 0 ? "Unexpected end of input" : "'" + (char)code + "'";
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) throws IORuntimeException, BufferUnderflowException {
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG && YamlWire.this.yt.text().equals("type") && YamlWire.this.yt.next() == YamlToken.TEXT) {
                Class<?> aClass = this.classLookup().forName(YamlWire.this.yt.text());
                YamlWire.this.yt.next();
                return aClass;
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException, InvalidMarshallableException {
            if (this.isNull()) {
                this.consumeAny(((YamlWire)YamlWire.this).yt.topContext().indent);
                return null;
            }
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
                YamlWire.this.consumePadding();
            }
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    Class clazz = this.typePrefix();
                    if (clazz != object.getClass()) {
                        object = ObjectUtils.newInstance(clazz);
                    }
                    return this.marshallable(object, strategy);
                }
                case SEQUENCE_START: {
                    Jvm.warn().on(this.getClass(), "Expected a {} but was blank for type " + object.getClass());
                    this.consumeAny(((YamlWire)YamlWire.this).yt.secondTopContext().indent);
                    return object;
                }
                case MAPPING_START: {
                    this.wireIn().startEvent();
                    object = strategy.readUsing(null, object, this, BracketType.MAP);
                    try {
                        this.wireIn().endEvent();
                    }
                    catch (UnsupportedOperationException uoe) {
                        throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (Object)((Object)YamlWire.this.yt.current()) + "', bytes=" + Bytes.toString(YamlWire.this.bytes, 1024L));
                    }
                    return object;
                }
            }
            throw new UnsupportedOperationException(YamlWire.this.yt.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Demarshallable demarshallable(@NotNull Class clazz) {
            Object object;
            YamlWire.this.consumePadding();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    YamlWire.this.yt.next();
                    break;
                }
                case MAPPING_START: {
                    break;
                }
                default: {
                    throw new IORuntimeException("Unsupported type " + (Object)((Object)YamlWire.this.yt.current()));
                }
            }
            long len = this.readLengthMarshallable();
            long limit = YamlWire.this.bytes.readLimit();
            long position = YamlWire.this.bytes.readPosition();
            long newLimit = position - 1L + len;
            try {
                YamlWire.this.bytes.readLimit(newLimit);
                YamlWire.this.bytes.readSkip(1L);
                YamlWire.this.consumePadding();
                object = Demarshallable.newInstance(clazz, YamlWire.this);
            }
            finally {
                YamlWire.this.bytes.readLimit(limit);
                YamlWire.this.bytes.readPosition(newLimit);
            }
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() != YamlToken.MAPPING_END) {
                throw new IORuntimeException("Unterminated { while reading marshallable " + object + ",code='" + (Object)((Object)YamlWire.this.yt.current()) + "', bytes=" + Bytes.toString(YamlWire.this.bytes, 1024L));
            }
            YamlWire.this.yt.next();
            return object;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() throws InvalidMarshallableException {
            return (T)this.objectWithInferredType(null, SerializationStrategies.ANY_NESTED, null);
        }

        @Nullable
        private <K, V> Map<K, V> map(@NotNull Class<K> kClass, @NotNull Class<V> vClass, @Nullable Map<K, V> usingMap) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            if (usingMap == null) {
                usingMap = new LinkedHashMap();
            } else {
                usingMap.clear();
            }
            @NotNull StringBuilder sb = YamlWire.this.acquireStringBuilder();
            switch (YamlWire.this.yt.current()) {
                case TAG: {
                    return this.typedMap(kClass, vClass, usingMap, sb);
                }
                case MAPPING_START: {
                    return this.marshallableAsMap(kClass, vClass, usingMap);
                }
                case SEQUENCE_START: {
                    return YamlWire.this.readAllAsMap(kClass, vClass, usingMap);
                }
            }
            throw new IORuntimeException("Unexpected code " + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Nullable
        private <K, V> Map<K, V> typedMap(@NotNull Class<K> kClazz, @NotNull Class<V> vClass, @NotNull Map<K, V> usingMap, @NotNull StringBuilder sb) throws InvalidMarshallableException {
            YamlWire.this.yt.text(sb);
            YamlWire.this.yt.next();
            if ("!null".contentEquals(sb)) {
                this.text();
                return null;
            }
            if (YamlWire.SEQ_MAP.contentEquals(sb)) {
                YamlWire.this.consumePadding();
                if (YamlWire.this.yt.current() != YamlToken.SEQUENCE_START) {
                    throw new IORuntimeException("Unsupported start of sequence : " + (Object)((Object)YamlWire.this.yt.current()));
                }
                do {
                    this.marshallable((WireIn r) -> {
                        @Nullable E k = r.read(() -> "key").object(kClazz);
                        @Nullable E v = r.read(() -> "value").object(vClass);
                        usingMap.put(k, v);
                    });
                } while (this.hasNextSequenceItem());
                return usingMap;
            }
            throw new IORuntimeException("Unsupported type :" + sb);
        }

        @Override
        public boolean bool() {
            YamlWire.this.consumePadding();
            StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
            if (this.textTo(stringBuilder) == null) {
                throw new NullPointerException("value is null");
            }
            if (ObjectUtils.isTrue(stringBuilder)) {
                return true;
            }
            if (ObjectUtils.isFalse(stringBuilder)) {
                return false;
            }
            Jvm.debug().on(this.getClass(), "Unable to parse '" + stringBuilder + "' as a boolean flag, assuming false");
            return false;
        }

        @Override
        public byte int8() {
            long l = this.int64();
            if (l > 127L || l < -128L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Byte.MAX_VALUE/MIN_VALUE");
            }
            return (byte)l;
        }

        @Override
        public short int16() {
            long l = this.int64();
            if (l > 32767L || l < -32768L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Short.MAX_VALUE/MIN_VALUE");
            }
            return (short)l;
        }

        @Override
        public int int32() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/MIN_VALUE");
            }
            return (int)l;
        }

        @Override
        public int uint16() {
            long l = this.int64();
            if (l > Integer.MAX_VALUE || l < 0L) {
                throw new IllegalStateException("value=" + l + ", is greater or less than Integer.MAX_VALUE/ZERO");
            }
            return (int)l;
        }

        @Override
        public long int64() {
            YamlWire.this.consumePadding();
            YamlWire.this.valueIn.skipType();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                Jvm.warn().on(this.getClass(), "Unable to read " + YamlWire.this.valueIn.objectBestEffort() + " as a long.");
                return 0L;
            }
            return this.getALong();
        }

        @Override
        public double float64() {
            YamlWire.this.consumePadding();
            YamlWire.this.valueIn.skipType();
            if (YamlWire.this.yt.current() != YamlToken.TEXT) {
                Jvm.warn().on(this.getClass(), "Unable to read " + YamlWire.this.valueIn.objectBestEffort() + " as a long.");
                return 0.0;
            }
            return this.getADouble();
        }

        void skipType() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                YamlWire.this.yt.next();
                YamlWire.this.consumePadding();
            }
        }

        @Override
        public float float32() {
            double d = this.float64();
            if ((double)((float)d) != d) {
                throw new IllegalStateException("value=" + d + " can not be represented as a float");
            }
            return (float)d;
        }

        @Override
        public boolean isNull() {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.TAG && YamlWire.this.yt.isText("!null")) {
                this.consumeAny(0);
                return true;
            }
            return false;
        }

        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class type) throws InvalidMarshallableException {
            YamlWire.this.consumePadding();
            if (YamlWire.this.yt.current() == YamlToken.SEQUENCE_ENTRY) {
                YamlWire.this.yt.next();
            }
            @Nullable Object o = this.objectWithInferredType0(using, strategy, type);
            YamlWire.this.consumePadding();
            return o;
        }

        @Nullable
        Object objectWithInferredType0(Object using, @NotNull SerializationStrategy strategy, Class type) throws InvalidMarshallableException {
            boolean bestEffort;
            boolean bl = bestEffort = type != null;
            if (YamlWire.this.yt.current() == YamlToken.TAG) {
                Class aClass = this.typePrefix();
                if (type == null || type == Object.class || type.isInterface()) {
                    type = aClass;
                }
            }
            switch (YamlWire.this.yt.current()) {
                case MAPPING_START: {
                    if (type != null) {
                        if (type == SortedMap.class && !(using instanceof SortedMap)) {
                            using = new TreeMap();
                        }
                        if (type == Object.class || Map.class.isAssignableFrom(type) || using instanceof Map) {
                            return this.map(Object.class, Object.class, using);
                        }
                    }
                    return YamlWire.this.valueIn.object(using, type, bestEffort);
                }
                case SEQUENCE_START: {
                    return this.readSequence(type);
                }
                case TEXT: 
                case LITERAL: {
                    TreeMap o = YamlWire.this.valueIn.readNumberOrText();
                    return ObjectUtils.convertTo(type, o);
                }
                case ANCHOR: {
                    String alias = YamlWire.this.yt.text();
                    YamlWire.this.yt.next();
                    TreeMap o = YamlWire.this.valueIn.object(using, type);
                    YamlWire.this.anchorValues.put(alias, o);
                    return o;
                }
                case ALIAS: {
                    String alias = YamlWire.this.yt.text();
                    TreeMap o = YamlWire.this.anchorValues.get(YamlWire.this.yt.text());
                    if (o == null) {
                        throw new IllegalStateException("Unknown alias " + alias + " with no corresponding anchor");
                    }
                    YamlWire.this.yt.next();
                    return o;
                }
                case NONE: {
                    return null;
                }
                case TAG: {
                    StringBuilder stringBuilder = YamlWire.this.acquireStringBuilder();
                    YamlWire.this.yt.text(stringBuilder);
                    if (!YamlWire.BINARY_TAG.contentEquals(stringBuilder)) break;
                    YamlWire.this.yt.next();
                    return this.decodeBinary(type);
                }
            }
            throw new UnsupportedOperationException("Cannot determine what to do with " + (Object)((Object)YamlWire.this.yt.current()));
        }

        @Nullable
        protected Object readNumberOrText() {
            char bq = YamlWire.this.yt.blockQuote();
            @Nullable String s = this.text();
            if (YamlWire.this.yt.current() == YamlToken.LITERAL) {
                return s;
            }
            if (s == null || bq != '\u0000' || s.length() < 1 || s.length() > 40 || "0123456789.+-".indexOf(s.charAt(0)) < 0) {
                return s;
            }
            String ss = s;
            if (s.indexOf(95) >= 0) {
                ss = ss.replace("_", "");
            }
            if (s.startsWith("0o")) {
                ss = "0" + s.substring(2);
            }
            try {
                return Long.decode(ss);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.parseDouble(ss);
                }
                catch (NumberFormatException numberFormatException2) {
                    try {
                        if (s.length() == 7 && s.charAt(1) == ':') {
                            return LocalTime.parse('0' + s);
                        }
                        if (s.length() == 8 && s.charAt(2) == ':') {
                            return LocalTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() == 10) {
                            return LocalDate.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    try {
                        if (s.length() >= 22) {
                            return ZonedDateTime.parse(s);
                        }
                    }
                    catch (DateTimeParseException dateTimeParseException) {
                        // empty catch block
                    }
                    return s;
                }
            }
        }

        @NotNull
        private Object readSequence(Class clazz) {
            @NotNull TreeSet<E> coll = clazz == SortedSet.class ? new TreeSet() : (clazz == Set.class ? new LinkedHashSet() : new ArrayList());
            @Nullable Class<?> componentType = clazz != null && clazz.isArray() && clazz.getComponentType().isPrimitive() ? clazz.getComponentType() : null;
            this.readCollection(componentType, coll);
            if (clazz != null && clazz.isArray()) {
                Object o = Array.newInstance(clazz.getComponentType(), coll.size());
                if (clazz.getComponentType().isPrimitive()) {
                    Iterator iter = coll.iterator();
                    for (int i = 0; i < coll.size(); ++i) {
                        Array.set(o, i, iter.next());
                    }
                    return o;
                }
                return coll.toArray((Object[])o);
            }
            return coll;
        }

        private void readCollection(@Nullable Class clazz, @NotNull Collection list) {
            this.sequence(list, (T l, ValueIn v) -> {
                while (v.hasNextSequenceItem()) {
                    l.add(v.object(clazz));
                }
            });
        }

        private Object decodeBinary(Class type) throws InvalidMarshallableException {
            Object o = this.objectWithInferredType(null, SerializationStrategies.ANY_SCALAR, String.class);
            byte[] decoded = Base64.getDecoder().decode(o == null ? "" : o.toString().replaceAll("\\s", ""));
            if (type == null || BytesStore.class.isAssignableFrom(type)) {
                return BytesStore.wrap(decoded);
            }
            if (type.isArray() && type.getComponentType().equals(Byte.TYPE)) {
                return decoded;
            }
            try {
                Method valueOf = type.getDeclaredMethod("valueOf", byte[].class);
                Jvm.setAccessible(valueOf);
                return valueOf.invoke(null, new Object[]{decoded});
            }
            catch (NoSuchMethodException valueOf) {
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
            throw new UnsupportedOperationException("Cannot determine how to deserialize " + type + " from binary data");
        }

        public String toString() {
            return YamlWire.this.toString();
        }
    }
}

