/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Byteable;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.CommonMarshallable;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.ref.BinaryBooleanReference;
import net.openhft.chronicle.bytes.ref.BinaryIntArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryIntReference;
import net.openhft.chronicle.bytes.ref.BinaryLongArrayReference;
import net.openhft.chronicle.bytes.ref.BinaryLongReference;
import net.openhft.chronicle.bytes.ref.BinaryTwoLongReference;
import net.openhft.chronicle.bytes.util.BinaryLengthLength;
import net.openhft.chronicle.bytes.util.Bit8StringInterner;
import net.openhft.chronicle.bytes.util.Compression;
import net.openhft.chronicle.bytes.util.UTF8StringInterner;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ValidatableUtil;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.util.BooleanConsumer;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.ObjBooleanConsumer;
import net.openhft.chronicle.core.util.ObjByteConsumer;
import net.openhft.chronicle.core.util.ObjFloatConsumer;
import net.openhft.chronicle.core.util.ObjShortConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.BooleanValue;
import net.openhft.chronicle.core.values.IntArrayValues;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.core.values.TwoLongValue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWireCode;
import net.openhft.chronicle.wire.BinaryWriteDocumentContext;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.DefaultValueIn;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TriConsumer;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueInStack;
import net.openhft.chronicle.wire.ValueInState;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryWire
extends AbstractWire
implements Wire {
    static final StringBuilderPool SBP = new StringBuilderPool();
    private static final boolean SUPPORT_DELTA = BinaryWire.supportDelta();
    private static final UTF8StringInterner UTF8 = new UTF8StringInterner(4096);
    private static final Bit8StringInterner BIT8 = new Bit8StringInterner(1024);
    private static final ClassValue<Boolean> USES_SELF_DESCRIBING = ClassLocal.withInitial(k -> {
        Object m = ObjectUtils.newInstance(k);
        if (m instanceof Marshallable) {
            return ((Marshallable)m).usesSelfDescribingMessage();
        }
        return true;
    });
    private final FixedBinaryValueOut fixedValueOut = new FixedBinaryValueOut();
    @NotNull
    private final FixedBinaryValueOut valueOut;
    @NotNull
    private final BinaryValueIn valueIn;
    private final boolean numericFields;
    private final boolean fieldLess;
    private final int compressedSize;
    private final WriteDocumentContext writeContext = new BinaryWriteDocumentContext(this);
    @NotNull
    private final BinaryReadDocumentContext readContext;
    private final boolean supportDelta;
    private final StringBuilder stringBuilder = new StringBuilder();
    private DefaultValueIn defaultValueIn;
    private String compression;
    private Boolean overrideSelfDescribing = null;

    public BinaryWire(@NotNull Bytes<?> bytes) {
        this(bytes, false, false, false, Integer.MAX_VALUE, "binary", SUPPORT_DELTA);
    }

    public BinaryWire(@NotNull Bytes<?> bytes, boolean fixed, boolean numericFields, boolean fieldLess, int compressedSize, String compression, boolean supportDelta) {
        super(bytes, false);
        this.numericFields = numericFields;
        this.fieldLess = fieldLess;
        this.compressedSize = compressedSize;
        this.valueOut = this.getFixedBinaryValueOut(fixed);
        this.compression = compression;
        this.valueIn = supportDelta ? new DeltaValueIn() : new BinaryValueIn();
        this.readContext = new BinaryReadDocumentContext(this, supportDelta);
        this.supportDelta = supportDelta;
    }

    private static boolean supportDelta() {
        String supportDeltaStr = System.getProperty("deltaWire.enable");
        if (supportDeltaStr != null) {
            if (ObjectUtils.isTrue(supportDeltaStr)) {
                return true;
            }
            if (ObjectUtils.isFalse(supportDeltaStr)) {
                return false;
            }
        }
        try {
            Class.forName("software.chronicle.wire.DeltaWire");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @NotNull
    public static BinaryWire binaryOnly(@NotNull Bytes<?> bytes) {
        return new BinaryWire(bytes, false, false, false, Integer.MAX_VALUE, "binary", false);
    }

    static boolean textable(@NotNull BytesStore bytes) {
        for (long pos = bytes.readPosition(); pos < bytes.readLimit(); ++pos) {
            if (bytes.readByte(pos) < 127) continue;
            return false;
        }
        return true;
    }

    static boolean isDigit(char c) {
        return (c = (char)(c - 48)) <= '\t';
    }

    @Override
    public void reset() {
        this.writeContext.reset();
        this.readContext.reset();
        this.valueIn.resetState();
        this.valueOut.resetState();
        this.bytes.clear();
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public Boolean getOverrideSelfDescribing() {
        return this.overrideSelfDescribing;
    }

    public BinaryWire setOverrideSelfDescribing(Boolean overrideSelfDescribing) {
        this.overrideSelfDescribing = overrideSelfDescribing;
        return this;
    }

    @NotNull
    StringBuilder acquireStringBuilder() {
        this.stringBuilder.setLength(0);
        return this.stringBuilder;
    }

    @NotNull
    protected FixedBinaryValueOut getFixedBinaryValueOut(boolean fixed) {
        return fixed ? this.fixedValueOut : new BinaryValueOut();
    }

    @NotNull
    protected BinaryValueIn getBinaryValueIn() {
        return new DeltaValueIn();
    }

    @Override
    public void clear() {
        this.bytes.clear();
        this.valueIn.resetState();
        this.valueOut.resetState();
    }

    public boolean fieldLess() {
        return this.fieldLess;
    }

    @Override
    @NotNull
    public DocumentContext writingDocument(boolean metaData) {
        this.writeContext.start(metaData);
        return this.writeContext;
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean metaData) {
        if (this.writeContext.isOpen() && this.writeContext.chainedElement()) {
            return this.writeContext;
        }
        return this.writingDocument(metaData);
    }

    @Override
    @NotNull
    public DocumentContext readingDocument() {
        this.readContext.start();
        return this.readContext;
    }

    @Override
    @NotNull
    public DocumentContext readingDocument(long readLocation) {
        @NotNull Bytes<?> bytes = this.bytes();
        long readPosition = bytes.readPosition();
        long readLimit = bytes.readLimit();
        bytes.readPositionUnlimited(readLocation);
        this.readContext.start();
        this.readContext.closeReadLimit(readLimit);
        this.readContext.closeReadPosition(readPosition);
        return this.readContext;
    }

    @Override
    @NotNull
    public String readingPeekYaml() {
        long start = this.readContext.start;
        if (start == -1L) {
            return "";
        }
        return Wires.fromSizePrefixedBlobs(this.bytes, start, this.usePadding());
    }

    @Override
    public void copyTo(@NotNull WireOut wire) throws InvalidMarshallableException {
        if (wire.getClass() == this.getClass()) {
            Bytes<?> bytes2 = wire.bytes();
            if (bytes2.retainedHexDumpDescription()) {
                bytes2.writeHexDumpDescription("passed-through");
            }
            bytes2.write(this.bytes);
            this.bytes.readPosition(this.bytes.readLimit());
            return;
        }
        while (this.bytes.readRemaining() > 0L) {
            this.copyOne(wire);
        }
    }

    public void copyOne(@NotNull WireOut wire) throws InvalidMarshallableException {
        int peekCode = this.peekCode();
        block2 : switch (peekCode >> 4) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().uint8checked(peekCode);
                break;
            }
            case 8: {
                switch (peekCode) {
                    case 143: {
                        this.bytes.uncheckedReadSkipOne();
                        break block2;
                    }
                    case 142: {
                        this.bytes.uncheckedReadSkipOne();
                        this.bytes.readSkip(this.bytes.readUnsignedInt());
                        break block2;
                    }
                    case 128: {
                        this.bytes.uncheckedReadSkipOne();
                        int len = this.bytes.readUnsignedByte();
                        this.readWithLength(wire, len);
                        break block2;
                    }
                    case 129: {
                        this.bytes.uncheckedReadSkipOne();
                        int len = this.bytes.readUnsignedShort();
                        this.readWithLength(wire, len);
                        break block2;
                    }
                    case 130: {
                        this.bytes.uncheckedReadSkipOne();
                        int len = this.bytes.readInt();
                        this.readWithLength(wire, len);
                        break block2;
                    }
                    case 138: {
                        this.bytes.uncheckedReadSkipOne();
                        if (BinaryWire.textable(this.bytes)) {
                            wire.getValueOut().text(this.bytes);
                        } else {
                            wire.getValueOut().bytes(this.bytes);
                        }
                        this.bytes.readPositionRemaining(this.bytes.readLimit(), 0L);
                        break block2;
                    }
                    case 141: {
                        this.bytes.uncheckedReadSkipOne();
                        long len2 = this.bytes.readLong();
                        long used = this.bytes.readLong();
                        if (len2 == used && len2 <= 2L) {
                            wire.getValueOut().sequence(o -> {
                                for (long i = 0L; i < len2; ++i) {
                                    long v = this.bytes.readLong();
                                    o.int64(v);
                                }
                            });
                            break block2;
                        }
                        wire.getValueOut().sequence(o -> {
                            wire.writeComment("length: " + len2 + ", used: " + used);
                            for (long i = 0L; i < len2; ++i) {
                                long v = this.bytes.readLong();
                                if (i == used) {
                                    o.swapLeaf(true);
                                }
                                o.int64(v);
                            }
                            o.swapLeaf(false);
                        });
                        break block2;
                    }
                    case 135: {
                        this.bytes.uncheckedReadSkipOne();
                        @NotNull StringBuilder sb = this.acquireStringBuilder();
                        this.readFieldAnchor(sb);
                        wire.write(sb);
                        break block2;
                    }
                    case 136: 
                    case 137: {
                        @Nullable Object o2 = this.valueIn.object();
                        wire.getValueOut().object(o2);
                        break block2;
                    }
                }
                this.unknownCode(wire);
                break;
            }
            case 9: {
                this.bytes.uncheckedReadSkipOne();
                try {
                    Double d = this.readFloat0(peekCode);
                    wire.getValueOut().object(d);
                }
                catch (Exception e) {
                    this.unknownCode(wire);
                }
                break;
            }
            case 10: {
                this.bytes.uncheckedReadSkipOne();
                try {
                    if (peekCode == 175) {
                        wire.getValueOut().int64_0x(this.bytes.readLong());
                        break;
                    }
                    Number l = this.readInt0object(peekCode);
                    if (l instanceof Integer) {
                        wire.getValueOut().int32(l.intValue());
                        break;
                    }
                    wire.getValueOut().object(l);
                }
                catch (Exception e) {
                    this.unknownCode(wire);
                }
                break;
            }
            case 11: {
                this.copySpecial(wire, peekCode);
                break;
            }
            case 12: 
            case 13: {
                StringBuilder fsb = this.readField(peekCode, AnyCodeMatch.ANY_CODE_MATCH.name(), AnyCodeMatch.ANY_CODE_MATCH.code(), this.acquireStringBuilder(), false);
                wire.write(fsb);
                break;
            }
            case 14: 
            case 15: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = this.readText(peekCode, this.acquireStringBuilder());
                wire.getValueOut().text(sb);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readWithLength(@NotNull WireOut wire, int len) throws InvalidMarshallableException {
        long lim = this.bytes.readLimit();
        try {
            this.bytes.readLimit(this.bytes.readPosition() + (long)len);
            @NotNull ValueOut wireValueOut = wire.getValueOut();
            switch (this.getBracketTypeNext()) {
                case MAP: {
                    wireValueOut.marshallable(this::copyTo);
                    return;
                }
                case SEQ: {
                    wireValueOut.sequence(v -> this.copyTo(v.wireOut()));
                    return;
                }
                case NONE: {
                    BytesStore bytes;
                    Object object = this.getValueIn().object();
                    if (object instanceof BytesStore && BinaryWire.textable(bytes = (BytesStore)object)) {
                        wireValueOut.text(bytes);
                        bytes.releaseLast();
                        return;
                    }
                    wireValueOut.object(object);
                    return;
                }
            }
            return;
        }
        finally {
            this.bytes.readLimit(lim);
        }
    }

    private void unknownCode(@NotNull WireOut wire) {
        wire.writeComment("# " + BinaryWireCode.stringForCode(this.bytes.readUnsignedByte()));
    }

    @NotNull
    private BracketType getBracketTypeNext() {
        int peekCode = this.peekCode();
        return this.getBracketTypeFor(peekCode);
    }

    @NotNull
    BracketType getBracketTypeFor(int peekCode) {
        if (peekCode >= 192 && peekCode <= 223) {
            return BracketType.MAP;
        }
        switch (peekCode) {
            case 183: 
            case 185: 
            case 186: 
            case 189: {
                return BracketType.MAP;
            }
            case 138: 
            case 141: {
                return BracketType.NONE;
            }
        }
        return BracketType.SEQ;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull String fieldName) {
        return this.read(fieldName, fieldName.hashCode(), null, Function.identity());
    }

    @Override
    @NotNull
    public ValueIn read() {
        this.readField(this.acquireStringBuilder(), null, AnyCodeMatch.ANY_CODE_MATCH.code());
        return this.bytes.readRemaining() <= 0L ? this.acquireDefaultValueIn() : this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull WireKey key) {
        return this.read(key.name(), key.code(), key, WireKey::defaultValue);
    }

    private <T> ValueIn read(CharSequence keyName, int keyCode, T defaultSource, @NotNull Function<T, Object> defaultLookup) {
        ValueInState curr = this.valueIn.curr();
        @NotNull StringBuilder sb = this.acquireStringBuilder();
        if (curr.savedPosition() > 0L) {
            this.bytes.readPosition(curr.savedPosition() - 1L);
            curr.savedPosition(0L);
        }
        while (this.bytes.readRemaining() > 0L) {
            long position = this.bytes.readPosition();
            this.readField(sb, keyName, keyCode);
            if (sb.length() == 0 || StringUtils.isEqual(sb, keyName)) {
                return this.valueIn;
            }
            curr.addUnexpected(position);
            ValidatableUtil.startValidateDisabled();
            try {
                this.valueIn.consumeNext();
            }
            catch (InvalidMarshallableException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                ValidatableUtil.endValidateDisabled();
            }
            this.consumePadding();
        }
        return this.read2(keyName, keyCode, defaultSource, defaultLookup, curr, sb, keyName);
    }

    protected <T> ValueIn read2(CharSequence keyName, int keyCode, T defaultSource, @NotNull Function<T, Object> defaultLookup, @NotNull ValueInState curr, @NotNull StringBuilder sb, CharSequence name) {
        long position2 = this.bytes.readLimit();
        for (int i = 0; i < curr.unexpectedSize(); ++i) {
            this.bytes.readPosition(curr.unexpected(i));
            this.readField(sb, keyName, keyCode);
            if (sb.length() != 0 && !StringUtils.isEqual(sb, name)) continue;
            curr.removeUnexpected(i);
            curr.savedPosition(position2 + 1L);
            return this.valueIn;
        }
        this.bytes.readPosition(position2);
        this.acquireDefaultValueIn();
        this.defaultValueIn.defaultValue = defaultLookup.apply(defaultSource);
        return this.defaultValueIn;
    }

    private DefaultValueIn acquireDefaultValueIn() {
        if (this.defaultValueIn == null) {
            this.defaultValueIn = new DefaultValueIn(this);
        }
        this.defaultValueIn.defaultValue = null;
        return this.defaultValueIn;
    }

    @Override
    public long readEventNumber() {
        int peekCode = this.peekCodeAfterPadding();
        if (peekCode == 186) {
            this.bytes.uncheckedReadSkipOne();
            int peekCode2 = this.bytes.peekUnsignedByte();
            if (0 <= peekCode2 && peekCode2 < 128) {
                this.bytes.uncheckedReadSkipOne();
                return peekCode2;
            }
            return this.bytes.readStopBit();
        }
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    public ValueIn readEventName(@NotNull StringBuilder name) {
        return this.readField(name, null, AnyCodeMatch.ANY_CODE_MATCH.code()) == null ? this.acquireDefaultValueIn() : this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn read(@NotNull StringBuilder name) {
        return this.readField(name, null, AnyCodeMatch.ANY_CODE_MATCH.code()) == null ? this.acquireDefaultValueIn() : this.valueIn;
    }

    @Override
    @NotNull
    public ValueIn getValueIn() {
        return this.valueIn;
    }

    @Override
    @NotNull
    public Wire readComment(@NotNull StringBuilder s) {
        if (this.peekCode() == 190) {
            this.bytes.uncheckedReadSkipOne();
            this.bytes.readUtf8(s);
        } else {
            s.setLength(0);
        }
        return this;
    }

    @Nullable
    private StringBuilder readField(@NotNull StringBuilder name, CharSequence keyName, int keyCode) {
        int peekCode = this.peekCodeAfterPadding();
        return this.readField(peekCode, keyName, keyCode, name, true);
    }

    private int peekCodeAfterPadding() {
        int peekCode = this.peekCode();
        if (peekCode == 143 || peekCode == 142 || peekCode == 190) {
            this.consumePadding();
            peekCode = this.peekCode();
        }
        return peekCode;
    }

    @Override
    @Nullable
    public <K> K readEvent(@NotNull Class<K> expectedClass) throws InvalidMarshallableException {
        int peekCode = this.peekCodeAfterPadding();
        switch (peekCode >> 4) {
            case -1: {
                return null;
            }
            case 8: 
            case 11: {
                return this.readSpecialField(peekCode, expectedClass);
            }
            case 12: 
            case 13: {
                return this.readSmallField(peekCode, expectedClass);
            }
        }
        return null;
    }

    @NotNull
    private <K> K readSmallField(int peekCode, Class<K> expectedClass) {
        this.bytes.uncheckedReadSkipOne();
        int length = peekCode & 0x1F;
        String s = (String)BIT8.intern(this.bytes, length);
        this.bytes.readSkip(length);
        if (expectedClass == String.class) {
            return (K)WireInternal.INTERNER.intern(s);
        }
        return ObjectUtils.convertTo(expectedClass, s);
    }

    @Nullable
    private <K> K readSpecialField(int peekCode, @NotNull Class<K> expectedClass) throws InvalidMarshallableException {
        switch (peekCode) {
            case 186: {
                this.bytes.uncheckedReadSkipOne();
                long fieldId = this.bytes.readStopBit();
                return ObjectUtils.convertTo(expectedClass, fieldId);
            }
            case 183: 
            case 185: {
                this.bytes.uncheckedReadSkipOne();
                @Nullable StringBuilder sb = this.read8bit();
                return ObjectUtils.convertTo(expectedClass, WireInternal.INTERNER.intern(sb));
            }
            case 135: {
                this.bytes.uncheckedReadSkipOne();
                StringBuilder sb = SBP.acquireStringBuilder();
                this.readFieldAnchor(sb);
                return ObjectUtils.convertTo(expectedClass, sb);
            }
            case 189: {
                this.bytes.uncheckedReadSkipOne();
                return this.valueIn.object(expectedClass);
            }
        }
        return null;
    }

    @Nullable
    StringBuilder read8bit() {
        @NotNull StringBuilder sb = this.acquireStringBuilder();
        return this.bytes.read8bit(sb) ? sb : null;
    }

    @Override
    public void consumePadding() {
        block5: while (true) {
            int code = this.peekCode();
            switch (code) {
                case 143: {
                    this.bytes.uncheckedReadSkipOne();
                    continue block5;
                }
                case 142: {
                    this.bytes.uncheckedReadSkipOne();
                    this.bytes.readSkip(this.bytes.readUnsignedInt());
                    continue block5;
                }
                case 190: {
                    this.bytes.uncheckedReadSkipOne();
                    this.commentListener.accept(this.readUtf8());
                    continue block5;
                }
            }
            break;
        }
    }

    protected int peekCode() {
        return this.bytes.peekUnsignedByte();
    }

    private StringBuilder readField(int peekCode, CharSequence keyName, int keyCode, @NotNull StringBuilder sb, boolean missingOk) {
        sb.setLength(0);
        switch (peekCode >> 4) {
            case -1: {
                break;
            }
            case 8: 
            case 11: {
                return this.readSpecialField(peekCode, keyName, keyCode, sb);
            }
            case 12: 
            case 13: {
                return this.readSmallField(peekCode, sb);
            }
            default: {
                if (missingOk) break;
                throw new UnsupportedOperationException("Unknown code " + BinaryWireCode.stringForCode(peekCode));
            }
        }
        if (this.fieldLess) {
            return sb;
        }
        return null;
    }

    @NotNull
    private StringBuilder readSmallField(int peekCode, @NotNull StringBuilder sb) {
        this.bytes.uncheckedReadSkipOne();
        if (this.bytes.isDirectMemory() && this.bytes.bytesStore() instanceof NativeBytesStore) {
            AppendableUtil.parse8bit_SB1(this.bytes, sb, peekCode & 0x1F);
        } else {
            try {
                AppendableUtil.parse8bit(this.bytes, sb, peekCode & 0x1F);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        return sb;
    }

    @Nullable
    private StringBuilder readSpecialField(int peekCode, CharSequence keyName, int keyCode, @NotNull StringBuilder sb) {
        switch (peekCode) {
            case 186: {
                this.bytes.uncheckedReadSkipOne();
                long fieldId = this.bytes.readStopBit();
                return this.readFieldNumber(keyName, keyCode, sb, fieldId);
            }
            case 183: 
            case 185: {
                this.bytes.uncheckedReadSkipOne();
                this.bytes.read8bit(sb);
                return sb;
            }
            case 135: {
                this.bytes.uncheckedReadSkipOne();
                return this.readFieldAnchor(sb);
            }
            case 189: {
                this.valueIn.text(sb);
                return sb;
            }
        }
        return null;
    }

    @NotNull
    protected StringBuilder readFieldAnchor(@NotNull StringBuilder sb) {
        if (this.valueIn instanceof DeltaValueIn) {
            @NotNull DeltaValueIn in = (DeltaValueIn)this.valueIn;
            int ref = Maths.toUInt31(this.bytes.readStopBit());
            if (ref >= in.inField.length) {
                in.inField = Arrays.copyOf(in.inField, in.inField.length * 2);
            }
            this.bytes.readUtf8(sb);
            in.inField[ref] = sb.toString();
            return sb;
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected StringBuilder readFieldNumber(CharSequence keyName, int keyCode, @NotNull StringBuilder sb, long fieldId) {
        if (this.valueIn instanceof DeltaValueIn) {
            String s;
            @NotNull DeltaValueIn in = (DeltaValueIn)this.valueIn;
            if (fieldId >= 0L && fieldId < (long)in.inField.length && (s = in.inField[(int)fieldId]) != null) {
                return sb.append(s);
            }
        }
        if (keyCode == AnyCodeMatch.ANY_CODE_MATCH.code()) {
            sb.append(fieldId);
            return sb;
        }
        if (fieldId != (long)keyCode) {
            return sb;
        }
        sb.append(keyName);
        return sb;
    }

    @NotNull
    <T extends Appendable & CharSequence> T getStringBuilder(int code, @NotNull T sb) {
        this.bytes.parseUtf8(sb, true, code & 0x1F);
        return sb;
    }

    private void copySpecial(@NotNull WireOut wire, int peekCode) throws InvalidMarshallableException {
        switch (peekCode) {
            case 190: {
                this.bytes.uncheckedReadSkipOne();
                @Nullable StringBuilder sb = this.readUtf8();
                wire.writeComment(sb);
                break;
            }
            case 178: {
                wire.getValueOut().time(this.getValueIn().time());
                break;
            }
            case 179: {
                wire.getValueOut().date(this.getValueIn().date());
                break;
            }
            case 180: {
                wire.getValueOut().dateTime(this.getValueIn().dateTime());
                break;
            }
            case 181: {
                wire.getValueOut().zonedDateTime(this.getValueIn().zonedDateTime());
                break;
            }
            case 182: {
                long readPosition = this.bytes.readPosition();
                this.bytes.uncheckedReadSkipOne();
                @Nullable StringBuilder sb = this.readUtf8();
                if (StringUtils.isEqual("gzip", (CharSequence)sb) || StringUtils.isEqual("lzw", (CharSequence)sb)) {
                    this.bytes.readPosition(readPosition);
                    wire.writeComment(sb);
                    wire.getValueOut().text(this.valueIn.text());
                    break;
                }
                wire.getValueOut().typePrefix(sb);
                try {
                    Class<?> aClass = this.classLookup.forName(sb);
                    if (aClass == byte[].class) {
                        wire.getValueOut().text(BytesStore.wrap(this.valueIn.bytes()));
                        break;
                    }
                    if (aClass.isEnum()) {
                        wire.getValueOut().object(aClass, this.valueIn.object(aClass));
                        break;
                    }
                    if (this.usesSelfDescribing(aClass) || aClass.isInterface()) break;
                    Marshallable m = (Marshallable)ObjectUtils.newInstance(aClass);
                    this.valueIn.marshallable(m);
                    wire.getValueOut().marshallable(m);
                }
                catch (Exception e) {
                    Jvm.warn().on(this.getClass(), "Unable to copy " + sb + " safely will try anyway " + e);
                }
                break;
            }
            case 188: {
                this.bytes.uncheckedReadSkipOne();
                @Nullable StringBuilder sb = this.readUtf8();
                wire.getValueOut().typeLiteral(sb);
                break;
            }
            case 183: 
            case 185: {
                StringBuilder fsb = this.readField(peekCode, null, AnyCodeMatch.ANY_CODE_MATCH.code(), this.acquireStringBuilder(), true);
                wire.write(fsb);
                break;
            }
            case 189: {
                this.bytes.uncheckedReadSkipOne();
                wire.writeStartEvent();
                boolean wasLeaf = wire.getValueOut().swapLeaf(true);
                if (this.peekCode() == 182) {
                    this.copyOne(wire);
                }
                this.copyOne(wire);
                wire.getValueOut().swapLeaf(wasLeaf);
                wire.writeEndEvent();
                break;
            }
            case 184: {
                this.bytes.uncheckedReadSkipOne();
                @Nullable StringBuilder sb1 = this.readUtf8();
                wire.getValueOut().text(sb1);
                break;
            }
            case 186: {
                this.bytes.uncheckedReadSkipOne();
                final long code2 = this.bytes.readStopBit();
                if (this.valueIn instanceof DeltaValueIn) {
                    String name;
                    @NotNull DeltaValueIn din = (DeltaValueIn)this.valueIn;
                    if (code2 >= 0L && code2 < (long)din.inField.length && (name = din.inField[(int)code2]) != null) {
                        wire.write(name);
                        break;
                    }
                }
                wire.write(new WireKey(){

                    @Override
                    @NotNull
                    public String name() {
                        return Long.toString(code2);
                    }

                    @Override
                    public int code() {
                        return (int)code2;
                    }
                });
                break;
            }
            case 187: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().bool(null);
                break;
            }
            case 176: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().bool(false);
                break;
            }
            case 177: {
                this.bytes.uncheckedReadSkipOne();
                wire.getValueOut().bool(true);
                break;
            }
            default: {
                this.unknownCode(wire);
            }
        }
    }

    private boolean usesSelfDescribing(Class aClass) {
        Boolean selfDesc = this.overrideSelfDescribing == null ? USES_SELF_DESCRIBING.get(aClass) : this.overrideSelfDescribing;
        return Boolean.TRUE.equals(selfDesc);
    }

    long readInt(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 11: {
                switch (code) {
                    case 176: {
                        return 0L;
                    }
                    case 177: {
                        return 1L;
                    }
                }
                break;
            }
            case 9: {
                double d = this.readFloat0(code);
                return (long)d;
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    double readFloat0(int code) {
        if ((code & 0x80) == 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return this.bytes.readFloat();
            }
            case 146: {
                return (double)this.bytes.readStopBit() / 100.0;
            }
            case 148: {
                return (double)this.bytes.readStopBit() / 10000.0;
            }
            case 150: {
                return (double)this.bytes.readStopBit() / 1000000.0;
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private Number readFloat0bject(int code) {
        if (code < 128 && code >= 0) {
            return code;
        }
        switch (code) {
            case 144: {
                return Float.valueOf(this.bytes.readFloat());
            }
            case 146: {
                return (double)this.bytes.readStopBit() / 100.0;
            }
            case 148: {
                return (double)this.bytes.readStopBit() / 10000.0;
            }
            case 150: {
                return (double)this.bytes.readStopBit() / 1000000.0;
            }
            case 145: {
                return this.bytes.readDouble();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    long readInt0(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: 
            case 168: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: 
            case 169: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: 
            case 175: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    Number readInt0object(int code) {
        if (this.isSmallInt(code)) {
            return code;
        }
        switch (code) {
            case 164: {
                return this.bytes.readByte();
            }
            case 161: 
            case 168: {
                return this.bytes.readUnsignedByte();
            }
            case 165: {
                return this.bytes.readShort();
            }
            case 162: 
            case 169: {
                return this.bytes.readUnsignedShort();
            }
            case 166: {
                return this.bytes.readInt();
            }
            case 163: {
                return this.bytes.readUnsignedInt();
            }
            case 167: 
            case 175: {
                return this.bytes.readLong();
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    private boolean isSmallInt(int code) {
        return (code & 0x80) == 0;
    }

    double readFloat(int code) {
        if (code < 128) {
            return code;
        }
        switch (code >> 4) {
            case 9: {
                return this.readFloat0(code);
            }
            case 10: {
                return this.readInt0(code);
            }
        }
        throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
    }

    @Override
    @NotNull
    public ValueOut write() {
        if (!this.fieldLess) {
            this.writeField("");
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull WireKey key) {
        return this.writeEventName(key.name());
    }

    @Override
    @NotNull
    public ValueOut writeEventName(@NotNull CharSequence name) {
        if (this.bytes.retainedHexDumpDescription()) {
            this.bytes.writeHexDumpDescription(name + ": (event)");
        }
        this.writeCode(185).write8bit(name);
        return this.valueOut;
    }

    @Override
    public ValueOut writeEventId(int methodId) {
        this.writeCode(186).writeStopBit(methodId);
        return this.valueOut;
    }

    @Override
    public ValueOut writeEventId(String name, int methodId) {
        if (this.bytes.retainedHexDumpDescription()) {
            this.writeEventIdDescription(name, methodId);
        }
        this.writeCode(186).writeStopBit(methodId);
        return this.valueOut;
    }

    private void writeEventIdDescription(String name, int methodId) {
        StringBuilder sb = SBP.acquireStringBuilder();
        sb.append(name).append(" (");
        if (32 < methodId && methodId <= 126) {
            sb.append('\'').append((char)methodId).append('\'');
        } else {
            sb.append(methodId);
        }
        sb.append(')');
        this.bytes.writeHexDumpDescription(sb);
    }

    @Override
    public void writeStartEvent() {
        this.writeCode(189);
    }

    @Override
    public void writeEndEvent() {
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull WireKey key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(key.code());
            } else {
                this.writeField(key.name());
            }
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut write(@NotNull CharSequence key) {
        if (!this.fieldLess) {
            if (this.numericFields) {
                this.writeField(WireKey.toCode(key));
            } else {
                this.writeField(key);
            }
        }
        return this.valueOut;
    }

    @Override
    @NotNull
    public ValueOut getValueOut() {
        return this.valueOut;
    }

    @Override
    @NotNull
    public Wire writeComment(CharSequence s) {
        this.writeCode(190);
        this.bytes.writeUtf8(s);
        return this;
    }

    @Override
    @NotNull
    public WireOut addPadding(int paddingToAdd) {
        if (paddingToAdd < 0) {
            throw new IllegalStateException("Cannot add " + paddingToAdd + " bytes of padding");
        }
        if (paddingToAdd >= 5) {
            ((Bytes)this.writeCode(142).writeUnsignedInt((long)paddingToAdd - 5L)).writeSkip((long)paddingToAdd - 5L);
        } else {
            for (int i = 0; i < paddingToAdd; ++i) {
                this.writeCode(143);
            }
        }
        return this;
    }

    private void writeField(@NotNull CharSequence name) {
        int len;
        if (this.bytes.retainedHexDumpDescription()) {
            this.bytes.writeHexDumpDescription(name + ":");
        }
        if ((len = name.length()) < 32) {
            this.writeField0(name, len);
        } else {
            this.writeCode(183).write8bit(name);
        }
    }

    private void writeField0(@NotNull CharSequence name, int len) {
        if (len > 0 && BinaryWire.isDigit(name.charAt(0))) {
            try {
                this.writeField(StringUtils.parseInt(name, 10));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.bytes.writeByte((byte)(192 + len));
        this.bytes.append8bit(name);
    }

    private void writeField(int code) {
        if (this.bytes.retainedHexDumpDescription()) {
            this.bytes.writeHexDumpDescription(Integer.toString(code));
        }
        this.writeCode(186);
        this.bytes.writeStopBit(code);
    }

    protected Bytes<?> writeCode(int code) {
        return (Bytes)this.bytes.writeByte((byte)code);
    }

    @Nullable
    <T extends Appendable & CharSequence> T readText(int code, @NotNull T sb) {
        if (code <= 127) {
            AppendableUtil.append(sb, code);
            return sb;
        }
        switch (code >> 4) {
            case 8: {
                switch (code) {
                    case 128: 
                    case 129: 
                    case 130: {
                        if (sb instanceof StringBuilder) {
                            this.bytes.uncheckedReadSkipBackOne();
                            this.valueIn.bytesStore((StringBuilder)sb);
                        } else if (sb instanceof Bytes) {
                            this.bytes.uncheckedReadSkipBackOne();
                            this.valueIn.bytesStore((Bytes)sb);
                        } else {
                            throw new IllegalArgumentException("Expected a StringBuilder or Bytes");
                        }
                        return sb;
                    }
                    case 143: {
                        return this.readText(this.bytes.readUnsignedByte(), sb);
                    }
                    case 142: {
                        this.bytes.readSkip(this.bytes.readUnsignedInt());
                        return this.readText(this.bytes.readUnsignedByte(), sb);
                    }
                }
                throw this.unknownCode(code);
            }
            case 11: {
                switch (code) {
                    case 187: {
                        AppendableUtil.append(sb, "null");
                        return sb;
                    }
                    case 177: {
                        AppendableUtil.append(sb, "true");
                        return sb;
                    }
                    case 176: {
                        AppendableUtil.append(sb, "false");
                        return sb;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 184: 
                    case 188: {
                        if (this.bytes.readUtf8(sb)) {
                            return sb;
                        }
                        return null;
                    }
                    case 189: {
                        this.valueIn.text((StringBuilder)sb);
                        return sb;
                    }
                }
                throw this.unknownCode(code);
            }
            case 9: {
                AppendableUtil.append(sb, this.readFloat(code));
                return sb;
            }
            case 10: {
                AppendableUtil.append(sb, this.readInt(code));
                return sb;
            }
            case 14: 
            case 15: {
                return this.getStringBuilder(code, sb);
            }
            case 12: 
            case 13: {
                this.readField(SBP.acquireStringBuilder(), "", code);
                AppendableUtil.setLength(sb, 0);
                return this.readText(this.peekCode(), sb);
            }
        }
        throw this.unknownCode(code);
    }

    @NotNull
    private UnsupportedOperationException unknownCode(int code) {
        return new UnsupportedOperationException("code=0x" + String.format("%02X ", code).trim());
    }

    int readCode() {
        return this.bytes.uncheckedReadUnsignedByte();
    }

    @NotNull
    public String toString() {
        return this.bytes.toDebugString();
    }

    @Override
    @NotNull
    public LongValue newLongReference() {
        return new BinaryLongReference();
    }

    @Override
    @NotNull
    public BooleanValue newBooleanReference() {
        return new BinaryBooleanReference();
    }

    @Override
    @NotNull
    public TwoLongValue newTwoLongReference() {
        return new BinaryTwoLongReference();
    }

    @Override
    @NotNull
    public IntValue newIntReference() {
        return new BinaryIntReference();
    }

    @Override
    @NotNull
    public BinaryLongArrayReference newLongArrayReference() {
        return new BinaryLongArrayReference();
    }

    @Override
    @NotNull
    public IntArrayValues newIntArrayReference() {
        return new BinaryIntArrayReference();
    }

    @Nullable
    StringBuilder readUtf8() {
        @NotNull StringBuilder sb = this.acquireStringBuilder();
        return this.bytes.readUtf8(sb) ? sb : null;
    }

    @Override
    public boolean useSelfDescribingMessage(@NotNull CommonMarshallable object) {
        return this.overrideSelfDescribing == null ? object.usesSelfDescribingMessage() : this.overrideSelfDescribing.booleanValue();
    }

    @Override
    public boolean writingIsComplete() {
        return !this.writeContext.isNotComplete();
    }

    class DeltaValueIn
    extends BinaryValueIn {
        @NotNull
        Marshallable[] inObjects;
        @NotNull
        String[] inField;

        DeltaValueIn() {
            this.inObjects = new Marshallable[128];
            this.inField = new String[128];
        }

        @Override
        @NotNull
        protected <T> T anchor() throws InvalidMarshallableException {
            long ref = BinaryWire.this.bytes.readStopBit();
            if (ref >= (long)this.inObjects.length) {
                this.inObjects = Arrays.copyOf(this.inObjects, this.inObjects.length * 2);
            }
            @NotNull T t = super.typedMarshallable0();
            this.inObjects[Maths.toUInt31((long)ref)] = (Marshallable)t;
            return t;
        }

        @Override
        @NotNull
        protected <T> T updateAlias() throws InvalidMarshallableException {
            int ref = Maths.toUInt31(BinaryWire.this.bytes.readStopBit());
            Marshallable previous = this.inObjects[ref];
            if (previous == null) {
                throw new IllegalStateException("Unknown ref: " + ref);
            }
            super.marshallable(previous, false);
            return (T)previous;
        }

        @Override
        public int int32(int previous) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 168: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFFFF00 | BinaryWire.this.bytes.readUnsignedByte();
                }
                case 169: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFF0000 | BinaryWire.this.bytes.readUnsignedShort();
                }
            }
            return super.int32();
        }

        @Override
        public long int64(long previous) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 168: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFFFFFFFFFFFF00L | (long)BinaryWire.this.bytes.readUnsignedByte();
                }
                case 169: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return previous & 0xFFFFFFFFFFFF0000L | (long)BinaryWire.this.bytes.readUnsignedShort();
                }
            }
            return super.int64();
        }

        @Override
        public float float32(float previous) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 155: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    int i = BinaryWire.this.bytes.readUnsignedByte();
                    int fi = Math.round(previous * 100.0f);
                    fi = fi & 0xFFFFFF00 | i;
                    return (float)fi / 100.0f;
                }
            }
            return super.float32();
        }

        @Override
        public double float64(double previous) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 154: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    int i = BinaryWire.this.bytes.readUnsignedByte();
                    long fi = Math.round(previous);
                    fi = fi & 0xFFFFFFFFFFFFFF00L | (long)i;
                    return fi;
                }
                case 155: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    int i = BinaryWire.this.bytes.readUnsignedByte();
                    long fi = Math.round(previous * 100.0);
                    fi = fi & 0xFFFFFFFFFFFFFF00L | (long)i;
                    return (double)fi / 100.0;
                }
                case 156: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    int i = BinaryWire.this.bytes.readUnsignedByte();
                    long fi = Math.round(previous * 10000.0);
                    fi = fi & 0xFFFFFFFFFFFFFF00L | (long)i;
                    return (double)fi / 10000.0;
                }
            }
            return super.float64();
        }
    }

    protected class BinaryValueIn
    implements ValueIn {
        final ValueInStack stack = new ValueInStack();
        final ValueIn.Reader reader0field = this::reader0;

        protected BinaryValueIn() {
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public long readLong(LongConverter longConverter) {
            return this.readLong();
        }

        @Override
        public void resetState() {
            this.stack.reset();
        }

        public void pushState() {
            this.stack.push();
        }

        public void popState() {
            this.stack.pop();
        }

        public ValueInState curr() {
            return this.stack.curr();
        }

        @Override
        @NotNull
        public BracketType getBracketType() {
            BinaryWire.this.consumePadding();
            switch (BinaryWire.this.peekCode()) {
                case 128: {
                    return BinaryWire.this.getBracketTypeFor(BinaryWire.this.bytes.readUnsignedByte(BinaryWire.this.bytes.readPosition() + 1L + 1L));
                }
                case 129: {
                    return BinaryWire.this.getBracketTypeFor(BinaryWire.this.bytes.readUnsignedByte(BinaryWire.this.bytes.readPosition() + 2L + 1L));
                }
                case 130: {
                    return BinaryWire.this.getBracketTypeFor(BinaryWire.this.bytes.readUnsignedByte(BinaryWire.this.bytes.readPosition() + 4L + 1L));
                }
                case 187: {
                    return BracketType.NONE;
                }
            }
            return BracketType.NONE;
        }

        @NotNull
        WireIn text(@NotNull Consumer<String> s) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    s.accept(null);
                    break;
                }
                case 184: {
                    s.accept(BinaryWire.this.bytes.readUtf8());
                    break;
                }
                default: {
                    if (code >= 224 && code <= 255) {
                        @NotNull StringBuilder sb = BinaryWire.this.acquireStringBuilder();
                        BinaryWire.this.bytes.parseUtf8((Appendable)sb, code & 0x1F);
                        s.accept(WireInternal.INTERNER.intern(sb));
                        break;
                    }
                    this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        private boolean isText(int code) {
            return code == 184 || code >= 224 && code <= 255;
        }

        @Override
        @Nullable
        public StringBuilder textTo(@NotNull StringBuilder sb) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                sb.setLength(0);
                return null;
            }
            @Nullable StringBuilder text = BinaryWire.this.readText(code, sb);
            if (text == null) {
                this.cantRead(code);
            }
            return sb;
        }

        @Override
        @Nullable
        public Bytes<?> textTo(@NotNull Bytes<?> bytes) {
            boolean wasNull;
            int code = BinaryWire.this.readCode();
            boolean bl = wasNull = code == 187;
            if (wasNull) {
                bytes.readPosition(0L);
                return null;
            }
            @Nullable Bytes<?> text = BinaryWire.this.readText(code, bytes);
            if (text == null) {
                this.cantRead(code);
            }
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public String text() {
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    return null;
                }
                case 184: {
                    long len0 = BinaryWire.this.bytes.readStopBit();
                    if (len0 == -1L) {
                        return null;
                    }
                    int len = Maths.toUInt31(len0);
                    long limit = BinaryWire.this.bytes.readLimit();
                    long end = BinaryWire.this.bytes.readPosition() + (long)len;
                    try {
                        BinaryWire.this.bytes.readLimit(end);
                        String string = (String)UTF8.intern(BinaryWire.this.bytes);
                        return string;
                    }
                    finally {
                        BinaryWire.this.bytes.readLimit(limit);
                        BinaryWire.this.bytes.readPosition(end);
                    }
                }
                case 182: {
                    byte[] bytes;
                    @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                    if (sb != null && (bytes = Compression.uncompress((CharSequence)sb, this, ValueIn::bytes)) != null) {
                        return new String(bytes, StandardCharsets.UTF_8);
                    }
                    @Nullable StringBuilder text = BinaryWire.this.readText(code, BinaryWire.this.acquireStringBuilder());
                    return WireInternal.INTERNER.intern(text);
                }
            }
            StringBuilder sb = BinaryWire.this.acquireStringBuilder();
            @Nullable StringBuilder text = (code & 0xE0) == 224 ? BinaryWire.this.getStringBuilder(code, sb) : BinaryWire.this.readText(code, sb);
            return text == null ? null : WireInternal.INTERNER.intern(text);
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes) {
            return this.bytes(toBytes, true);
        }

        @Override
        @NotNull
        public WireIn bytes(@NotNull BytesOut<?> toBytes, boolean clearBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (clearBytes) {
                toBytes.clear();
            }
            if (code == 187) {
                return BinaryWire.this;
            }
            if (code == 182) {
                @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                assert (sb != null);
                long length2 = this.readLength();
                int code2 = BinaryWire.this.readCode();
                if (code2 != 138) {
                    this.cantRead(code);
                }
                BinaryWire.this.bytes.readWithLength0(length2 - 1L, (b, sb1, toBytes1) -> Compression.uncompress(sb1, b, toBytes1), sb, toBytes);
                return this.wireIn();
            }
            if (code == 138) {
                BinaryWire.this.bytes.readWithLength(length - 1L, toBytes);
            } else {
                BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                this.textTo((Bytes)toBytes);
            }
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesLiteral(@NotNull BytesOut<?> toBytes) {
            long length = this.readLength();
            toBytes.clear();
            toBytes.write(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @NotNull
        public BytesStore bytesLiteral() {
            int length = Maths.toUInt31(this.readLength());
            @NotNull BytesStore<?, byte[]> toBytes = BytesStore.wrap(new byte[length]);
            toBytes.write(0L, BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), (long)length);
            BinaryWire.this.bytes.readSkip(length);
            return toBytes;
        }

        @Override
        @Nullable
        public WireIn bytesSet(@NotNull PointerBytesStore toBytes) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                return BinaryWire.this;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            long startAddr = BinaryWire.this.bytes.addressForRead(BinaryWire.this.bytes.readPosition());
            toBytes.set(startAddr, length - 1L);
            BinaryWire.this.bytes.readSkip(length - 1L);
            return this.wireIn();
        }

        @Override
        @NotNull
        public WireIn bytesMatch(@NotNull BytesStore compareBytes, @NotNull BooleanConsumer consumer) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (compareBytes.readRemaining() == --length) {
                consumer.accept(BinaryWire.this.bytes.equalBytes(compareBytes, length));
            } else {
                consumer.accept(false);
            }
            BinaryWire.this.bytes.readSkip(length);
            return this.wireIn();
        }

        @Override
        @Nullable
        public BytesStore bytesStore() {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 138: 
                case 141: {
                    BytesStore<?, Void> toBytes = BytesStore.lazyNativeBytesStoreWithFixedCapacity(length);
                    toBytes.write(0L, BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                    BinaryWire.this.bytes.readSkip(length);
                    return toBytes;
                }
                case 182: {
                    @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                    @Nullable byte[] bytes = Compression.uncompress((CharSequence)sb, this, ValueIn::bytes);
                    if (bytes != null) {
                        return BytesStore.wrap(bytes);
                    }
                    throw new UnsupportedOperationException("Unsupported type " + sb);
                }
                case 187: {
                    return null;
                }
            }
            this.cantRead(code);
            throw new AssertionError();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bytesStore(@NotNull StringBuilder sb) {
            sb.setLength(0);
            BinaryWire.this.consumePadding();
            long pos = BinaryWire.this.bytes.readPosition();
            long length = this.readLength();
            if (length < 0L) {
                throw this.cantRead(BinaryWire.this.peekCode());
            }
            if (length > BinaryWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            int code = BinaryWire.this.readCode();
            if (code == 138) {
                for (long i = 1L; i < length; ++i) {
                    sb.append((char)BinaryWire.this.bytes.readUnsignedByte());
                }
            } else {
                BinaryWire.this.bytes.readPosition(pos);
                long limit = BinaryWire.this.bytes.readLimit();
                BinaryWire.this.bytes.readLimit(pos + 4L + length);
                try {
                    sb.append(Wires.fromSizePrefixedBlobs(BinaryWire.this.bytes));
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit);
                }
            }
        }

        public void bytesStore(@NotNull Bytes<?> toBytes) {
            toBytes.clear();
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                return;
            }
            if (code != 138) {
                this.cantRead(code);
            }
            if (length > BinaryWire.this.bytes.readRemaining()) {
                throw new IllegalStateException("Length of Bytes " + length + " > " + BinaryWire.this.bytes.readRemaining());
            }
            toBytes.ensureCapacity(toBytes.writePosition() + length);
            toBytes.write(0L, BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            toBytes.readLimit(length);
            BinaryWire.this.bytes.readSkip(length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public WireIn bytes(@NotNull ReadBytesMarshallable bytesConsumer) {
            long length = this.readLength() - 1L;
            int code = BinaryWire.this.readCode();
            if (code != 138) {
                this.cantRead(code);
            }
            if (length > BinaryWire.this.bytes.readRemaining()) {
                throw new BufferUnderflowException();
            }
            long limit0 = BinaryWire.this.bytes.readLimit();
            long limit = BinaryWire.this.bytes.readPosition() + length;
            try {
                BinaryWire.this.bytes.readLimit(limit);
                bytesConsumer.readMarshallable(BinaryWire.this.bytes);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit0);
                BinaryWire.this.bytes.readPosition(limit);
            }
            return this.wireIn();
        }

        @Override
        @Nullable
        public byte[] bytes(byte[] using) {
            long length = this.readLength();
            int code = BinaryWire.this.readCode();
            if (code == 187) {
                return null;
            }
            if (code == 182) {
                @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                assert ("byte[]".contentEquals(sb));
                length = this.readLength();
                code = BinaryWire.this.readCode();
            }
            if (code != 138) {
                this.cantRead(code);
            }
            @NotNull byte[] bytes2 = using != null && (long)using.length == length ? using : new byte[Maths.toUInt31(--length)];
            BinaryWire.this.bytes.readWithLength(length, b -> b.read(bytes2));
            return bytes2;
        }

        @Override
        @NotNull
        public WireIn wireIn() {
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long readLength() {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                return 1L;
            }
            switch (code) {
                case 128: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return BinaryWire.this.bytes.uncheckedReadUnsignedByte();
                }
                case 129: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return BinaryWire.this.bytes.readUnsignedShort();
                }
                case 130: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return BinaryWire.this.bytes.readUnsignedInt();
                }
                case 182: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    long len = BinaryWire.this.bytes.readStopBit();
                    BinaryWire.this.bytes.readSkip(len);
                    return this.readLength();
                }
                case 176: 
                case 177: 
                case 187: {
                    return 1L;
                }
                case 154: 
                case 155: 
                case 156: 
                case 161: 
                case 164: {
                    return 2L;
                }
                case 162: 
                case 165: {
                    return 3L;
                }
                case 144: 
                case 163: 
                case 166: {
                    return 5L;
                }
                case 145: 
                case 167: {
                    return 9L;
                }
                case 142: 
                case 143: 
                case 190: {
                    BinaryWire.this.consumePadding();
                    return this.readLength();
                }
                case 146: 
                case 148: 
                case 150: {
                    long pos = BinaryWire.this.bytes.readPosition() + 1L;
                    while (pos < BinaryWire.this.bytes.readLimit() && BinaryWire.this.bytes.readUnsignedByte(pos++) >= 128) {
                    }
                    return pos - BinaryWire.this.bytes.readPosition();
                }
                case 160: {
                    return 17L;
                }
                case 175: {
                    return 9L;
                }
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 184: 
                case 188: {
                    long pos0 = BinaryWire.this.bytes.readPosition();
                    try {
                        BinaryWire.this.bytes.uncheckedReadSkipOne();
                        long len2 = BinaryWire.this.bytes.readStopBit();
                        long l = BinaryWire.this.bytes.readPosition() - pos0 + len2;
                        return l;
                    }
                    finally {
                        BinaryWire.this.bytes.readPosition(pos0);
                    }
                }
                case 141: {
                    long capacity = BinaryWire.this.bytes.readLong(BinaryWire.this.bytes.readPosition() + 1L);
                    return 17L + capacity * 8L;
                }
                case -1: {
                    return 0L;
                }
            }
            if (code >= 224) {
                return (long)code + -223L;
            }
            return -1L;
        }

        @Override
        @NotNull
        public WireIn skipValue() {
            long length = this.readLength();
            if (length < 0L) {
                this.objectBestEffort();
            } else {
                BinaryWire.this.bytes.readSkip(length);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn bool(T t, @NotNull ObjBooleanConsumer<T> tFlag) {
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 187: {
                    tFlag.accept(t, null);
                    break;
                }
                case 176: {
                    tFlag.accept(t, false);
                    break;
                }
                case 177: {
                    tFlag.accept(t, true);
                    break;
                }
                case 142: 
                case 143: 
                case 190: {
                    BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                    BinaryWire.this.consumePadding();
                    this.bool(t, tFlag);
                    break;
                }
                default: {
                    throw this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int8(@NotNull T t, @NotNull ObjByteConsumer<T> tb) {
            int code = BinaryWire.this.bytes.readUnsignedByte();
            if (code < 128) {
                tb.accept(t, (byte)code);
                return BinaryWire.this;
            }
            this.int8b(t, tb, code);
            return BinaryWire.this;
        }

        private <T> void int8b(@NotNull T t, @NotNull ObjByteConsumer<T> tb, int code) {
            switch (code) {
                case 142: 
                case 143: 
                case 190: {
                    BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                    BinaryWire.this.consumePadding();
                    code = BinaryWire.this.bytes.readUnsignedByte();
                }
            }
            if (this.isText(code)) {
                tb.accept(t, Byte.parseByte(this.text()));
            } else {
                tb.accept(t, (byte)BinaryWire.this.readInt(code));
            }
        }

        @Override
        @NotNull
        public <T> WireIn uint8(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Short.parseShort(this.text()));
            } else {
                ti.accept(t, (short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int16(@NotNull T t, @NotNull ObjShortConsumer<T> ti) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Short.parseShort(this.text()));
            } else {
                ti.accept(t, (short)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint16(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Integer.parseInt(this.text()));
            } else {
                ti.accept(t, (int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int32(@NotNull T t, @NotNull ObjIntConsumer<T> ti) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                ti.accept(t, Integer.parseInt(this.text()));
            } else {
                ti.accept(t, (int)BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn uint32(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tl.accept(t, Long.parseLong(this.text()));
            } else {
                tl.accept(t, BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@NotNull T t, @NotNull ObjLongConsumer<T> tl) {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tl.accept(t, Long.parseLong(this.text()));
            } else {
                tl.accept(t, BinaryWire.this.readInt(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float32(@NotNull T t, @NotNull ObjFloatConsumer<T> tf) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                tf.accept(t, Float.parseFloat(this.text()));
            } else {
                tf.accept(t, (float)BinaryWire.this.readFloat(code));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn float64(@NotNull T t, @NotNull ObjDoubleConsumer<T> td) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            td.accept(t, BinaryWire.this.readFloat(code));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn time(@NotNull T t, @NotNull BiConsumer<T, LocalTime> setLocalTime) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 178) {
                setLocalTime.accept(t, this.readLocalTime());
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        private LocalTime readLocalTime() {
            @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
            return LocalTime.parse(sb);
        }

        @Override
        @NotNull
        public <T> WireIn zonedDateTime(@NotNull T t, @NotNull BiConsumer<T, ZonedDateTime> tZonedDateTime) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 181) {
                @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                tZonedDateTime.accept(t, ZonedDateTime.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn date(@NotNull T t, @NotNull BiConsumer<T, LocalDate> tLocalDate) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 179) {
                @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                tLocalDate.accept(t, LocalDate.parse(sb));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        public boolean hasNext() {
            return BinaryWire.this.bytes.readRemaining() > 0L;
        }

        @Override
        public boolean hasNextSequenceItem() {
            return this.hasNext();
        }

        @Override
        @NotNull
        public UUID uuid() {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                return new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong());
            }
            throw this.cantRead(code);
        }

        @Override
        @NotNull
        public <T> WireIn uuid(@NotNull T t, @NotNull BiConsumer<T, UUID> tuuid) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 160) {
                tuuid.accept(t, new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong()));
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64array(@Nullable LongArrayValues values, T t, @NotNull BiConsumer<T, LongArrayValues> setter) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 141) {
                if (!(values instanceof BinaryLongArrayReference) || values.isClosing()) {
                    values = new BinaryLongArrayReference();
                }
                @Nullable Byteable b = (Byteable)((Object)values);
                long length = BinaryLongArrayReference.peakLength(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition());
                b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                BinaryWire.this.bytes.readSkip(length);
                setter.accept(t, values);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int128(@NotNull TwoLongValue value) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code == 141) {
                @Nullable Byteable b = (Byteable)((Object)value);
                long length = BinaryLongArrayReference.peakLength(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition());
                b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition() + 8L + 8L, length - 16L);
                BinaryWire.this.bytes.readSkip(length);
            } else {
                this.cantRead(code);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int64(@NotNull LongValue value) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 167 && code != 0) {
                this.cantRead(code);
            }
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireIn int32(@NotNull IntValue value) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 166) {
                this.cantRead(code);
            }
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        @Override
        public WireIn bool(@NotNull BooleanValue value) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 177 && code != 176) {
                this.cantRead(code);
            }
            BinaryWire.this.bytes.readSkip(-1L);
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireIn int64(@Nullable LongValue value, T t, @NotNull BiConsumer<T, LongValue> setter) {
            if (!(value instanceof BinaryLongReference)) {
                value = new BinaryLongReference();
                setter.accept(t, value);
            }
            return this.int64(value);
        }

        @Override
        @NotNull
        public <T> WireIn int32(@Nullable IntValue value, T t, @NotNull BiConsumer<T, IntValue> setter) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            if (code != 166) {
                this.cantRead(code);
            }
            if (!(value instanceof Byteable) || ((Byteable)((Object)value)).maxSize() != 4L) {
                value = new BinaryIntReference();
                setter.accept(t, value);
            }
            @NotNull Byteable b = (Byteable)((Object)value);
            long length = b.maxSize();
            b.bytesStore(BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
            BinaryWire.this.bytes.readSkip(length);
            return BinaryWire.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> boolean sequence(@NotNull T t, @NotNull BiConsumer<T, ValueIn> tReader) {
            if (this.isNull()) {
                return false;
            }
            long length = this.readLength();
            if (length < 0L) {
                throw this.cantRead(BinaryWire.this.peekCode());
            }
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                tReader.accept(t, this);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return true;
        }

        @Override
        public <T> boolean sequence(@NotNull List<T> list, @NotNull List<T> buffer, @NotNull Supplier<T> bufferAdd) throws InvalidMarshallableException {
            list.clear();
            return this.sequence(list, buffer, bufferAdd, this.reader0field);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> boolean sequence(List<T> list, @NotNull List<T> buffer, Supplier<T> bufferAdd, ValueIn.Reader tReader) throws InvalidMarshallableException {
            if (this.isNull()) {
                return false;
            }
            long length = this.readLength();
            if (length < 0L) {
                throw this.cantRead(BinaryWire.this.peekCode());
            }
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                tReader.accept(this, list, buffer, bufferAdd);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public <T, K> WireIn sequence(@NotNull T t, K kls, @NotNull TriConsumer<T, K, ValueIn> tReader) throws InvalidMarshallableException {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long length = this.readLengthPrefixed(code);
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                tReader.accept(t, kls, this);
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
            return BinaryWire.this;
        }

        private long readLengthPrefixed(int code) {
            long length;
            switch (code) {
                case 128: {
                    length = BinaryWire.this.bytes.readUnsignedByte();
                    break;
                }
                case 129: {
                    length = BinaryWire.this.bytes.readUnsignedShort();
                    break;
                }
                case 130: {
                    length = BinaryWire.this.bytes.readUnsignedInt();
                    break;
                }
                default: {
                    throw this.cantRead(code);
                }
            }
            return length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> int sequenceWithLength(@NotNull T t, @NotNull ToIntBiFunction<ValueIn, T> tReader) {
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long length = this.readLengthPrefixed(code);
            long limit = BinaryWire.this.bytes.readLimit();
            long limit2 = BinaryWire.this.bytes.readPosition() + length;
            BinaryWire.this.bytes.readLimit(limit2);
            try {
                int n = tReader.applyAsInt(this, (ValueIn)t);
                return n;
            }
            finally {
                BinaryWire.this.bytes.readLimit(limit);
                BinaryWire.this.bytes.readPosition(limit2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T applyToMarshallable(@NotNull Function<WireIn, T> marshallableReader) {
            BinaryWire.this.consumePadding();
            this.pushState();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                T t = marshallableReader.apply(BinaryWire.this);
                return t;
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            }
            T t = marshallableReader.apply(BinaryWire.this);
            return t;
            finally {
                this.popState();
            }
        }

        @Override
        public boolean isTyped() {
            int code = BinaryWire.this.peekCode();
            return code == 182;
        }

        @Override
        @Nullable
        public <T> T typedMarshallable() throws IORuntimeException, InvalidMarshallableException {
            this.pushState();
            try {
                int code = BinaryWire.this.readCode();
                switch (code) {
                    case 182: {
                        T t = this.typedMarshallable0();
                        return t;
                    }
                    case 187: {
                        T t = null;
                        return t;
                    }
                    case 136: {
                        T t = this.anchor();
                        return t;
                    }
                    case 137: {
                        T t = this.updateAlias();
                        return t;
                    }
                }
                this.cantRead(code);
                T t = null;
                return t;
            }
            finally {
                this.popState();
            }
        }

        @Nullable
        protected <T> T typedMarshallable0() throws InvalidMarshallableException {
            @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
            if (sb == null) {
                return null;
            }
            Class<?> clazz = this.classLookup().forName(sb);
            if (Demarshallable.class.isAssignableFrom(clazz)) {
                return (T)this.demarshallable(clazz);
            }
            if (!Marshallable.class.isAssignableFrom(clazz) && !Demarshallable.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException("its not possible to Marshallable and object that is not of type Marshallable, type=" + sb);
            }
            ReadMarshallable m = (ReadMarshallable)ObjectUtils.newInstance(clazz);
            this.marshallable(m, true);
            return ReadResolvable.readResolve(m);
        }

        @NotNull
        protected <T> T updateAlias() throws InvalidMarshallableException {
            throw new UnsupportedOperationException("Used by DeltaWire");
        }

        @NotNull
        protected <T> T anchor() throws InvalidMarshallableException {
            throw new UnsupportedOperationException("Used by DeltaWire");
        }

        @Override
        @Nullable
        public <T> T typedMarshallable(@NotNull Function<Class, ReadMarshallable> marshallableFunction) throws IORuntimeException, InvalidMarshallableException {
            int code = BinaryWire.this.peekCode();
            if (code != 182) {
                return this.typedMarshallable();
            }
            @Nullable Class aClass = this.typePrefix();
            if (ReadMarshallable.class.isAssignableFrom(aClass)) {
                ReadMarshallable marshallable = marshallableFunction.apply(aClass);
                this.marshallable(marshallable);
                return (T)marshallable;
            }
            return this.object(null, aClass);
        }

        @Override
        public Class typePrefix() {
            int code = BinaryWire.this.peekCode();
            if (code != 182) {
                return null;
            }
            BinaryWire.this.bytes.uncheckedReadSkipOne();
            @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
            try {
                return this.classLookup().forName(sb);
            }
            catch (ClassNotFoundRuntimeException e) {
                Jvm.warn().on(BinaryWire.this.getClass(), "Unable to find class " + sb);
                return null;
            }
        }

        @Override
        public Object typePrefixOrObject(Class tClass) {
            int code = BinaryWire.this.peekCode();
            if (code != 182) {
                return null;
            }
            BinaryWire.this.bytes.uncheckedReadSkipOne();
            @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
            try {
                return sb == null ? null : this.classLookup().forName(sb);
            }
            catch (ClassNotFoundRuntimeException e) {
                if (Wires.dtoInterface(tClass) && Wires.GENERATE_TUPLES) {
                    return Wires.tupleFor(tClass, sb.toString());
                }
                Jvm.warn().on(this.getClass(), "Unknown class (" + sb + "), perhaps you need to define an alias", (Throwable)e);
                return null;
            }
        }

        @Override
        @NotNull
        public <T> ValueIn typePrefix(T t, @NotNull BiConsumer<T, CharSequence> ts) {
            @NotNull StringBuilder sb = BinaryWire.this.acquireStringBuilder();
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 182: {
                    BinaryWire.this.bytes.readUtf8(sb);
                    break;
                }
                case 187: {
                    sb.setLength(0);
                    sb.append("!null");
                    break;
                }
                default: {
                    this.cantRead(code);
                }
            }
            ts.accept(t, sb);
            return this;
        }

        @Override
        @NotNull
        public <T> WireIn typeLiteralAsText(T t, @NotNull BiConsumer<T, CharSequence> classNameConsumer) {
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 188: {
                    StringBuilder sb = BinaryWire.this.readUtf8();
                    classNameConsumer.accept(t, sb);
                    break;
                }
                case 187: {
                    classNameConsumer.accept(t, null);
                    break;
                }
                default: {
                    this.cantRead(code);
                }
            }
            return BinaryWire.this;
        }

        @Override
        public ClassLookup classLookup() {
            return BinaryWire.this.classLookup();
        }

        @Override
        public Type typeLiteral(BiFunction<CharSequence, ClassNotFoundException, Type> unresolvedHandler) {
            int code = BinaryWire.this.readCode();
            switch (code) {
                case 188: {
                    StringBuilder sb = BinaryWire.this.readUtf8();
                    try {
                        return this.classLookup().forName(sb);
                    }
                    catch (ClassNotFoundRuntimeException e) {
                        return unresolvedHandler.apply(sb, e.getCause());
                    }
                }
                case 187: {
                    return null;
                }
            }
            throw this.cantRead(code);
        }

        @Override
        public boolean marshallable(@NotNull ReadMarshallable object) throws BufferUnderflowException, IORuntimeException, InvalidMarshallableException {
            return this.marshallable(object, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean marshallable(@NotNull ReadMarshallable object, boolean overwrite) throws BufferUnderflowException, IORuntimeException, InvalidMarshallableException {
            BinaryWire.this.consumePadding();
            if (this.isNull()) {
                return false;
            }
            this.pushState();
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    if (BinaryWire.this.useSelfDescribingMessage(object)) {
                        if (overwrite) {
                            object.readMarshallable(BinaryWire.this);
                        }
                        Wires.readMarshallable(object, BinaryWire.this, false);
                    }
                    ((ReadBytesMarshallable)((Object)object)).readMarshallable(BinaryWire.this.bytes);
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                    this.popState();
                }
            } else {
                throw new IORuntimeException("Length unknown");
            }
            return true;
        }

        @Override
        public boolean isNull() {
            BinaryWire.this.consumePadding();
            if (BinaryWire.this.peekCode() == 187) {
                BinaryWire.this.bytes.uncheckedReadSkipOne();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public Object marshallable(@NotNull Object object, @NotNull SerializationStrategy strategy) throws BufferUnderflowException, IORuntimeException, InvalidMarshallableException {
            Object o;
            if (this.isNull()) {
                return null;
            }
            this.pushState();
            BinaryWire.this.consumePadding();
            if (BinaryWire.this.supportDelta && (o = this.readMarshallableAnchor(object)) != null) {
                return o;
            }
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    strategy.readUsing(null, object, this, BracketType.MAP);
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                    this.popState();
                }
            } else {
                throw new IORuntimeException("Length unknown " + length);
            }
            return object;
        }

        @Nullable
        private Object readMarshallableAnchor(@NotNull Object object) throws InvalidMarshallableException {
            int code = BinaryWire.this.peekCode();
            switch (code) {
                case 136: 
                case 137: {
                    Object o;
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    Object t = o = code == 136 ? this.anchor() : this.updateAlias();
                    if (object == null || o.getClass() != object.getClass()) {
                        return o instanceof Marshallable ? Wires.deepCopy((Marshallable)o) : o;
                    }
                    Wires.copyTo(o, object);
                    return object;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public Demarshallable demarshallable(@NotNull Class clazz) throws BufferUnderflowException, IORuntimeException {
            if (this.isNull()) {
                return null;
            }
            long length = this.readLength();
            if (length >= 0L) {
                long limit = BinaryWire.this.bytes.readLimit();
                long limit2 = BinaryWire.this.bytes.readPosition() + length;
                BinaryWire.this.bytes.readLimit(limit2);
                try {
                    Object t = Demarshallable.newInstance(clazz, this.wireIn());
                    return t;
                }
                finally {
                    BinaryWire.this.bytes.readLimit(limit);
                    BinaryWire.this.bytes.readPosition(limit2);
                }
            }
            return Demarshallable.newInstance(clazz, this.wireIn());
        }

        private long readTextAsLong(long otherwise) throws IORuntimeException, BufferUnderflowException {
            String text;
            BinaryWire.this.bytes.uncheckedReadSkipBackOne();
            try {
                text = this.text();
            }
            catch (Exception e) {
                return otherwise;
            }
            if (text == null || text.length() == 0) {
                return otherwise;
            }
            try {
                return Long.parseLong(text);
            }
            catch (NumberFormatException e) {
                return Math.round(Double.parseDouble(text));
            }
        }

        private double readTextAsDouble() throws IORuntimeException, BufferUnderflowException {
            String text;
            BinaryWire.this.bytes.uncheckedReadSkipBackOne();
            try {
                text = this.text();
            }
            catch (BufferUnderflowException e) {
                return Double.NaN;
            }
            if (text == null || text.length() == 0) {
                return Double.NaN;
            }
            return Double.parseDouble(text);
        }

        @Override
        public boolean bool() throws IORuntimeException {
            int code = BinaryWire.this.readCode();
            if (this.isText(code)) {
                return Boolean.valueOf(this.text());
            }
            switch (code) {
                case 177: {
                    return true;
                }
                case 176: {
                    return false;
                }
                case 142: 
                case 143: 
                case 190: {
                    BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                    BinaryWire.this.consumePadding();
                    return this.bool();
                }
            }
            throw new IORuntimeException(BinaryWireCode.stringForCode(code));
        }

        @Override
        public byte int8() {
            int code = BinaryWire.this.readCode();
            if (code < 128) {
                return (byte)code;
            }
            return this.int8b(code);
        }

        private byte int8b(int code) {
            long value;
            switch (code) {
                case 142: 
                case 143: 
                case 190: {
                    BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                    BinaryWire.this.consumePadding();
                    code = BinaryWire.this.readCode();
                }
            }
            long l = value = this.isText(code) ? this.readTextAsLong(-128L) : BinaryWire.this.readInt0(code);
            if (value > 127L || value < -128L) {
                throw new IllegalStateException();
            }
            return (byte)value;
        }

        @Override
        public short int16() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong(-32768L) : BinaryWire.this.readInt0(code);
            if (value > 32767L || value < -32768L) {
                throw new IllegalStateException();
            }
            return (short)value;
        }

        @Override
        public int uint16() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong(0L) : BinaryWire.this.readInt0(code);
            if (value > 0x100000000L || value < 0L) {
                throw new IllegalStateException("value " + value + " cannot be cast to an unsigned 16-bit int without loss of information");
            }
            return (int)value;
        }

        @Override
        public float float32() {
            double value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            switch (code >> 16) {
                case 10: {
                    value = BinaryWire.this.readInt0(code);
                    break;
                }
                case 9: {
                    value = BinaryWire.this.readFloat0(code);
                    break;
                }
                default: {
                    value = this.readTextAsDouble();
                }
            }
            return (float)value;
        }

        @Override
        public int int32() {
            long value;
            BinaryWire.this.consumePadding();
            int code = BinaryWire.this.readCode();
            long l = value = this.isText(code) ? this.readTextAsLong(Integer.MIN_VALUE) : BinaryWire.this.readInt0(code);
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalStateException("value " + value + " cannot be cast to int without loss of information");
            }
            return (int)value;
        }

        @Override
        public long int64() {
            int code = BinaryWire.this.readCode();
            if (code == 143 || code == 142 || code == 190) {
                BinaryWire.this.bytes.uncheckedReadSkipBackOne();
                BinaryWire.this.consumePadding();
                code = BinaryWire.this.readCode();
            }
            if ((code & 0x80) == 0) {
                return code;
            }
            switch (code >> 4) {
                case 9: {
                    return (long)BinaryWire.this.readFloat0(code);
                }
                case 10: {
                    return BinaryWire.this.readInt0(code);
                }
            }
            return this.readTextAsLong(Long.MIN_VALUE);
        }

        @Override
        public double float64() {
            int code = BinaryWire.this.readCode();
            if (code >> 4 == 9) {
                return BinaryWire.this.readFloat0(code);
            }
            return this.isText(code) ? this.readTextAsDouble() : (double)BinaryWire.this.readInt0(code);
        }

        @NotNull
        private RuntimeException cantRead(int code) {
            throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object objectWithInferredType(Object using, @NotNull SerializationStrategy strategy, Class type) throws InvalidMarshallableException {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                BinaryWire.this.bytes.uncheckedReadSkipOne();
                return code;
            }
            switch (code >> 4) {
                case 8: {
                    switch (code) {
                        case 128: 
                        case 129: 
                        case 130: {
                            if (using instanceof StringBuilder) {
                                this.bytesStore((StringBuilder)using);
                                return using;
                            }
                            if (using instanceof Bytes) {
                                this.bytesStore((Bytes)using);
                                return using;
                            }
                            long pos = BinaryWire.this.bytes.readPosition();
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            int len = this.readLength(code);
                            code = BinaryWire.this.peekCode();
                            if (code == 138) {
                                BinaryWire.this.bytes.readPosition(pos);
                                return this.bytesStore();
                            }
                            long lim = BinaryWire.this.bytes.readLimit();
                            try {
                                BinaryWire.this.bytes.readLimit(BinaryWire.this.bytes.readPosition() + (long)len);
                                Object using1 = using;
                                if (using1 == null && type != null) {
                                    using1 = strategy.newInstanceOrNull(type);
                                }
                                if (this.isEvent(code)) {
                                    Object object = (strategy == SerializationStrategies.ANY_OBJECT ? SerializationStrategies.MAP : strategy).readUsing(type, using1, this, BracketType.MAP);
                                    return object;
                                }
                                Object object = (strategy == SerializationStrategies.ANY_OBJECT ? SerializationStrategies.LIST : strategy).readUsing(type, using1, this, BracketType.SEQ);
                                return object;
                            }
                            finally {
                                BinaryWire.this.bytes.readLimit(lim);
                            }
                        }
                        case 138: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            long length = BinaryWire.this.bytes.readRemaining();
                            if (length == 0L) {
                                return BytesStore.empty();
                            }
                            @NotNull BytesStore<?, Void> toBytes = BytesStore.lazyNativeBytesStoreWithFixedCapacity(length);
                            toBytes.write(0L, BinaryWire.this.bytes, BinaryWire.this.bytes.readPosition(), length);
                            BinaryWire.this.bytes.readSkip(length);
                            return toBytes;
                        }
                        case 136: 
                        case 137: {
                            return this.typedMarshallable();
                        }
                    }
                    break;
                }
                case 11: {
                    switch (code) {
                        case 176: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return Boolean.FALSE;
                        }
                        case 177: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return Boolean.TRUE;
                        }
                        case 187: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return null;
                        }
                        case 184: {
                            return this.text();
                        }
                        case 182: {
                            BinaryWire.this.readCode();
                            @Nullable StringBuilder sb = BinaryWire.this.readUtf8();
                            Class<?> clazz2 = this.classLookup().forName(sb);
                            return this.object(null, clazz2);
                        }
                        case 189: {
                            if (using == null) {
                                strategy = SerializationStrategies.MAP;
                                using = strategy.newInstanceOrNull(null);
                            }
                            strategy.readUsing(type, using, BinaryWire.this.valueIn, BracketType.MAP);
                            return ObjectUtils.convertTo(type, using);
                        }
                        case 178: {
                            return this.time();
                        }
                        case 179: {
                            return this.date();
                        }
                        case 180: {
                            return this.dateTime();
                        }
                        case 181: {
                            return this.zonedDateTime();
                        }
                        case 188: {
                            return this.typeLiteral();
                        }
                    }
                    break;
                }
                case 9: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    return BinaryWire.this.readFloat0bject(code);
                }
                case 10: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    if (code == 160) {
                        return new UUID(BinaryWire.this.bytes.readLong(), BinaryWire.this.bytes.readLong());
                    }
                    return BinaryWire.this.readInt0object(code);
                }
            }
            return this.text();
        }

        private int readLength(int code) {
            int len;
            switch (code) {
                case 128: {
                    len = BinaryWire.this.bytes.readUnsignedByte();
                    break;
                }
                case 129: {
                    len = BinaryWire.this.bytes.readUnsignedShort();
                    break;
                }
                case 130: {
                    len = BinaryWire.this.bytes.readInt();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return len;
        }

        private boolean isEvent(int code) {
            return code == 185 || 192 <= code && code <= 223;
        }

        void consumeNext() throws InvalidMarshallableException {
            int code = BinaryWire.this.peekCode();
            if ((code & 0x80) == 0) {
                BinaryWire.this.bytes.uncheckedReadSkipOne();
                return;
            }
            switch (code >> 4) {
                case 8: {
                    switch (code) {
                        case 128: {
                            BinaryWire.this.bytes.readSkip(1L);
                            BinaryWire.this.bytes.readSkip(BinaryWire.this.bytes.readUnsignedByte());
                            return;
                        }
                        case 129: {
                            BinaryWire.this.bytes.readSkip(1L);
                            BinaryWire.this.bytes.readSkip(BinaryWire.this.bytes.readUnsignedShort());
                            return;
                        }
                        case 130: {
                            BinaryWire.this.bytes.readSkip(1L);
                            BinaryWire.this.bytes.readSkip(BinaryWire.this.bytes.readUnsignedInt());
                            return;
                        }
                        case 136: 
                        case 137: {
                            BinaryWire.this.valueIn.objectBestEffort();
                            return;
                        }
                        case 135: {
                            BinaryWire.this.bytes.readSkip(1L);
                            BinaryWire.this.readFieldAnchor(BinaryWire.this.acquireStringBuilder());
                            return;
                        }
                    }
                    Jvm.warn().on(this.getClass(), "reading control code as text");
                    break;
                }
                case 11: {
                    switch (code) {
                        case 176: 
                        case 177: 
                        case 187: {
                            BinaryWire.this.bytes.uncheckedReadSkipOne();
                            return;
                        }
                        case 184: {
                            this.text();
                            return;
                        }
                        case 182: {
                            BinaryWire.this.readCode();
                            BinaryWire.this.readUtf8();
                            this.consumeNext();
                            return;
                        }
                    }
                    break;
                }
                case 9: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    if (code < 128 && code >= 0) {
                        return;
                    }
                    switch (code) {
                        case 144: {
                            BinaryWire.this.bytes.readFloat();
                            return;
                        }
                        case 146: {
                            BinaryWire.this.bytes.readStopBit();
                            return;
                        }
                        case 148: {
                            BinaryWire.this.bytes.readStopBit();
                            return;
                        }
                        case 150: {
                            BinaryWire.this.bytes.readStopBit();
                            return;
                        }
                        case 145: {
                            BinaryWire.this.bytes.readDouble();
                            return;
                        }
                        case 154: 
                        case 155: 
                        case 156: {
                            BinaryWire.this.bytes.readUnsignedByte();
                            return;
                        }
                    }
                    throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
                }
                case 10: {
                    BinaryWire.this.bytes.uncheckedReadSkipOne();
                    if (BinaryWire.this.isSmallInt(code)) {
                        return;
                    }
                    switch (code) {
                        case 164: {
                            BinaryWire.this.bytes.readByte();
                            return;
                        }
                        case 161: 
                        case 168: {
                            BinaryWire.this.bytes.readUnsignedByte();
                            return;
                        }
                        case 165: {
                            BinaryWire.this.bytes.readShort();
                            return;
                        }
                        case 162: 
                        case 169: {
                            BinaryWire.this.bytes.readUnsignedShort();
                            return;
                        }
                        case 166: {
                            BinaryWire.this.bytes.readInt();
                            return;
                        }
                        case 163: {
                            BinaryWire.this.bytes.readUnsignedInt();
                            return;
                        }
                        case 167: 
                        case 175: {
                            BinaryWire.this.bytes.readLong();
                            return;
                        }
                    }
                    throw new UnsupportedOperationException(BinaryWireCode.stringForCode(code));
                }
            }
            this.text();
        }
    }

    protected class BinaryValueOut
    extends FixedBinaryValueOut {
        protected BinaryValueOut() {
        }

        @Override
        public boolean isBinary() {
            return true;
        }

        @Override
        public WireOut writeInt(IntConverter intConverter, int i) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(intConverter.asString(i));
            }
            return this.writeInt(i);
        }

        @Override
        public WireOut writeLong(LongConverter longConverter, long l) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(longConverter.asString(l));
            }
            return this.writeLong(l);
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            this.writeNumber(i8);
            return BinaryWire.this;
        }

        void writeNumber(long l) {
            switch (Long.numberOfLeadingZeros(l)) {
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    super.uint8checked((short)l);
                    return;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    super.fixedInt16((short)l);
                    return;
                }
                case 48: {
                    super.uint16checked((int)l);
                    return;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    super.fixedInt32((int)l);
                    return;
                }
                case 32: {
                    super.uint32checked(l);
                    return;
                }
                case 0: {
                    if (l >= -128L) {
                        super.int8((byte)l);
                        return;
                    }
                    if (l >= -32768L) {
                        super.int16((short)l);
                        return;
                    }
                    if (l < Integer.MIN_VALUE) break;
                    super.int32((int)l);
                    return;
                }
            }
            if ((long)((float)l) == l) {
                super.float32(l);
                return;
            }
            super.int64(l);
        }

        void writeNumber(int l) {
            switch (Integer.numberOfLeadingZeros(l) + 32) {
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    super.uint8checked((short)l);
                    return;
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    super.fixedInt16((short)l);
                    return;
                }
                case 48: {
                    super.uint16checked(l);
                    return;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: {
                    super.fixedInt32(l);
                    return;
                }
                case 32: {
                    if (l >= -128) {
                        super.int8((byte)l);
                    } else if (l >= Short.MIN_VALUE) {
                        super.int16((short)l);
                    } else {
                        super.int32(l);
                    }
                    return;
                }
            }
            assert (false);
        }

        void writeNumber(float l) {
            boolean canOnlyBeRepresentedAsFloatingPoint;
            boolean bl = canOnlyBeRepresentedAsFloatingPoint = (float)((long)l) != l;
            if (canOnlyBeRepresentedAsFloatingPoint) {
                this.writeAsFloat(l);
            } else {
                this.writeAsIntOrFloat(l);
            }
        }

        void writeNumber(double l) {
            boolean canOnlyBeRepresentedAsFloatingPoint;
            boolean bl = canOnlyBeRepresentedAsFloatingPoint = (double)((long)l) != l;
            if (canOnlyBeRepresentedAsFloatingPoint) {
                this.writeAsFloat(l);
            } else {
                this.writeAsIntOrFloat(l);
            }
        }

        private void writeAsIntOrFloat(float l) {
            if (l >= 0.0f) {
                this.writeAsPositive(l);
            } else if (l >= -128.0f) {
                super.int8((byte)l);
            } else if (l >= -32768.0f) {
                super.int16((short)l);
            } else {
                super.float32(l);
            }
        }

        private void writeAsIntOrFloat(double l) {
            if (l >= 0.0) {
                this.writeAsPositive(l);
            } else if (l >= -128.0) {
                super.int8((byte)l);
            } else if (l >= -32768.0) {
                super.int16((short)l);
            } else if ((double)((float)l) == l) {
                super.float32((float)l);
            } else if (l >= -2.147483648E9) {
                super.int32((int)l);
            } else {
                super.float64(l);
            }
        }

        private void writeAsPositive(double l) {
            if (l <= 255.0) {
                super.uint8checked((short)l);
            } else if (l <= 65535.0) {
                super.uint16checked((int)l);
            } else if ((double)((float)l) == l) {
                super.float32((float)l);
            } else if (l <= 4.294967295E9) {
                super.uint32checked((long)l);
            } else {
                super.float64(l);
            }
        }

        private void writeAsFloat(float l) {
            long l6 = Math.round((double)l * 1000000.0);
            if ((float)l6 / 1000000.0f == l && l6 > -16384L && l6 < 0x200000L && this.writeAsFixedPoint(l, l6)) {
                return;
            }
            super.float32(l);
        }

        private void writeAsFloat(double l) {
            long l6 = Math.round(l * 1000000.0);
            if ((double)l6 / 1000000.0 == l && l6 > -34359738368L && l6 < 0x40000000000L && this.writeAsFixedPoint(l, l6)) {
                return;
            }
            if ((double)((float)l) == l || Double.isNaN(l)) {
                super.float32((float)l);
                return;
            }
            super.float64(l);
        }

        private boolean writeAsFixedPoint(float l, long l6) {
            long i2 = l6 / 10000L;
            if ((float)i2 / 100.0f == l) {
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(i2 + "/1e2");
                }
                BinaryWire.this.writeCode(146).writeStopBit(i2);
                return true;
            }
            long i4 = l6 / 100L;
            if ((float)i4 / 10000.0f == l) {
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(i4 + "/1e4");
                }
                BinaryWire.this.writeCode(148).writeStopBit(i4);
                return true;
            }
            if ((float)l6 / 1000000.0f == l) {
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(l6 + "/1e6");
                }
                BinaryWire.this.writeCode(150).writeStopBit(l6);
                return true;
            }
            return false;
        }

        private boolean writeAsFixedPoint(double l, long l6) {
            long i2 = l6 / 10000L;
            if ((double)i2 / 100.0 == l) {
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(i2 + "/1e2");
                }
                BinaryWire.this.writeCode(146).writeStopBit(i2);
                return true;
            }
            long i4 = l6 / 100L;
            if ((double)i4 / 10000.0 == l) {
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(i4 + "/1e4");
                }
                BinaryWire.this.writeCode(148).writeStopBit(i4);
                return true;
            }
            if ((double)l6 / 1000000.0 == l) {
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(l6 + "/1e6");
                }
                BinaryWire.this.writeCode(150).writeStopBit(l6);
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            this.writeNumber(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            this.writeNumber(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            this.writeNumber(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            this.writeNumber(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            this.writeNumber(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            this.writeNumber(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            this.writeNumber(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            this.writeNumber(d);
            return BinaryWire.this;
        }
    }

    protected class FixedBinaryValueOut
    implements ValueOut {
        protected FixedBinaryValueOut() {
        }

        @Override
        @NotNull
        public WireOut bool(@Nullable Boolean flag) {
            BinaryWire.this.bytes.writeUnsignedByte(flag == null ? 187 : (flag != false ? 177 : 176));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut nu11() {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("null");
            }
            BinaryWire.this.writeCode(187);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable CharSequence s) {
            if (s == null) {
                this.nu11();
            } else {
                long utflen;
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(s);
                }
                if ((utflen = AppendableUtil.findUtf8Length(s)) < 32L) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte((int)(224L + utflen))).appendUtf8(s);
                } else {
                    BinaryWire.this.writeCode(184);
                    BinaryWire.this.bytes.writeUtf8(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable String s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                char ch;
                int len;
                if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                    BinaryWire.this.bytes.writeHexDumpDescription(s);
                }
                if ((len = s.length()) < 32) {
                    len = (int)AppendableUtil.findUtf8Length(s);
                }
                if (len == 0) {
                    BinaryWire.this.bytes.writeUnsignedByte(224);
                } else if (len == 1 && (ch = s.charAt(0)) < '\u0080') {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(225)).writeUnsignedByte(ch);
                } else if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8(s);
                } else {
                    BinaryWire.this.writeCode(184);
                    BinaryWire.this.bytes.writeUtf8(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut text(@Nullable BytesStore s) {
            if (s == null) {
                BinaryWire.this.writeCode(187);
            } else {
                int len = s.length();
                if (len < 32) {
                    ((Bytes)BinaryWire.this.bytes.writeUnsignedByte(224 + len)).appendUtf8(s);
                } else {
                    BinaryWire.this.writeCode(184).writeUtf8(s);
                }
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return this.nu11();
            }
            long remaining = fromBytes.readRemaining();
            if (remaining >= (long)this.compressedSize()) {
                this.compress(BinaryWire.this.compression, fromBytes.bytesForRead());
            } else {
                this.bytes0(fromBytes, remaining);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytesLiteral(@Nullable BytesStore fromBytes) {
            if (fromBytes == null) {
                return this.nu11();
            }
            long remaining = fromBytes.readRemaining();
            this.writeLength(Maths.toInt32(remaining));
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        public int compressedSize() {
            return BinaryWire.this.compressedSize;
        }

        public void bytes0(@NotNull BytesStore fromBytes, long remaining) {
            this.writeLength(Maths.toInt32(remaining + 1L));
            BinaryWire.this.writeCode(138);
            if (remaining > 0L) {
                BinaryWire.this.bytes.write(fromBytes);
            }
        }

        @Override
        @NotNull
        public WireOut rawBytes(@NotNull byte[] value) {
            this.typePrefix(byte[].class);
            this.writeLength(Maths.toInt32((long)value.length + 1L));
            BinaryWire.this.writeCode(138);
            if (value.length > 0) {
                BinaryWire.this.bytes.write(value);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public ValueOut writeLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Invalid length " + length);
            }
            if (length < 256L) {
                BinaryWire.this.writeCode(128);
                BinaryWire.this.bytes.writeUnsignedByte((int)length);
            } else if (length < 65536L) {
                BinaryWire.this.writeCode(129);
                BinaryWire.this.bytes.writeUnsignedShort((int)length);
            } else {
                BinaryWire.this.writeCode(130);
                BinaryWire.this.bytes.writeUnsignedInt(length);
            }
            return this;
        }

        @Override
        @NotNull
        public WireOut bytes(@NotNull byte[] fromBytes) {
            this.writeLength(Maths.toInt32((long)fromBytes.length + 1L));
            BinaryWire.this.writeCode(138);
            BinaryWire.this.bytes.write(fromBytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @Nullable BytesStore fromBytes) {
            this.typePrefix(type);
            if (fromBytes != null) {
                this.bytes0(fromBytes, fromBytes.readRemaining());
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut bytes(String type, @NotNull byte[] fromBytes) {
            this.typePrefix(type);
            return this.bytes(fromBytes);
        }

        @Override
        @NotNull
        public WireOut int8(byte i8) {
            return this.fixedInt8(i8);
        }

        @Override
        @NotNull
        public WireOut fixedInt8(byte i8) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Integer.toString(i8));
            }
            BinaryWire.this.writeCode(164).writeByte(i8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint8checked(int u8) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Integer.toString(u8));
            }
            BinaryWire.this.writeCode(161).writeUnsignedByte(u8);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int16(short i16) {
            return this.fixedInt16(i16);
        }

        @Override
        @NotNull
        public WireOut fixedInt16(short i16) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Integer.toString(i16));
            }
            BinaryWire.this.writeCode(165).writeShort(i16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint16checked(int u16) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Integer.toString(u16));
            }
            BinaryWire.this.writeCode(162).writeUnsignedShort(u16);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut utf8(int codepoint) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(new String(Character.toChars(codepoint)));
            }
            BinaryWire.this.writeCode(162);
            BinaryWire.this.bytes.appendUtf8(codepoint);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32(int i32) {
            return this.fixedInt32(i32);
        }

        @Override
        @NotNull
        public WireOut fixedInt32(int i32) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Integer.toString(i32));
            }
            BinaryWire.this.writeCode(166).writeInt(i32);
            return BinaryWire.this;
        }

        @NotNull
        public WireOut fixedOrderedInt32(int i32) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Integer.toString(i32));
            }
            BinaryWire.this.writeCode(166).writeOrderedInt(i32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uint32checked(long u32) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Long.toUnsignedString(u32));
            }
            BinaryWire.this.writeCode(163).writeUnsignedInt(u32);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64(long i64) {
            return this.fixedInt64(i64);
        }

        @Override
        @NotNull
        public WireOut fixedInt64(long i64) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Long.toString(i64));
            }
            BinaryWire.this.writeCode(167).writeLong(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64_0x(long i64) {
            BinaryWire.this.writeCode(175).writeLong(i64);
            return BinaryWire.this;
        }

        @NotNull
        private WireOut fixedOrderedInt64(long i64) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Long.toString(i64));
            }
            BinaryWire.this.writeAlignTo(8, 1);
            BinaryWire.this.writeCode(167).writeOrderedLong(i64);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Long.toString(capacity));
            }
            BinaryWire.this.writeAlignTo(8, 1);
            BinaryWire.this.writeCode(141);
            BinaryLongArrayReference.lazyWrite(BinaryWire.this.bytes, capacity);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int128forBinding(long value, long value2) {
            BinaryWire.this.writeAlignTo(16, 1);
            BinaryWire.this.writeCode(141);
            BinaryWire.this.bytes.writeLong(2L);
            BinaryWire.this.bytes.writeLong(2L);
            BinaryWire.this.bytes.writeLong(value);
            BinaryWire.this.bytes.writeLong(value2);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64array(long capacity, @NotNull LongArrayValues values) {
            BinaryWire.this.writeAlignTo(8, 1);
            BinaryWire.this.writeCode(141);
            long pos = BinaryWire.this.bytes.writePosition();
            BinaryLongArrayReference.lazyWrite(BinaryWire.this.bytes, capacity);
            ((Byteable)((Object)values)).bytesStore(BinaryWire.this.bytes, pos, BinaryWire.this.bytes.lengthWritten(pos));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float32(float f) {
            return this.fixedFloat32(f);
        }

        @Override
        @NotNull
        public WireOut fixedFloat32(float f) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Float.toString(f));
            }
            BinaryWire.this.writeCode(144).writeFloat(f);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut float64(double d) {
            return this.fixedFloat64(d);
        }

        @Override
        @NotNull
        public WireOut fixedFloat64(double d) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(Double.toString(d));
            }
            BinaryWire.this.writeCode(145).writeDouble(d);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut time(@NotNull LocalTime localTime) {
            String text = localTime.toString();
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(text);
            }
            BinaryWire.this.writeCode(178).writeUtf8(text);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut zonedDateTime(@NotNull ZonedDateTime zonedDateTime) {
            String text = zonedDateTime.toString();
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(text);
            }
            BinaryWire.this.writeCode(181).writeUtf8(text);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut date(@NotNull LocalDate localDate) {
            String text = localDate.toString();
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(text);
            }
            BinaryWire.this.writeCode(179).writeUtf8(text);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut dateTime(@NotNull LocalDateTime localDateTime) {
            String text = localDateTime.toString();
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(text);
            }
            BinaryWire.this.writeCode(180).writeUtf8(text);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public ValueOut typePrefix(CharSequence typeName) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(typeName);
            }
            if (typeName != null) {
                BinaryWire.this.writeCode(182).writeUtf8(typeName);
            }
            return this;
        }

        @Override
        public ClassLookup classLookup() {
            return BinaryWire.this.classLookup();
        }

        @Override
        @NotNull
        public WireOut typeLiteral(CharSequence typeName) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(typeName);
            }
            if (typeName == null) {
                this.nu11();
            } else {
                BinaryWire.this.writeCode(188).writeUtf8(typeName);
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@Nullable Class type) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription() && type != null) {
                BinaryWire.this.bytes.writeHexDumpDescription(type.getName());
            }
            if (type == null) {
                this.nu11();
            } else {
                BinaryWire.this.writeCode(188).writeUtf8(this.classLookup().nameFor(type));
            }
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut typeLiteral(@NotNull BiConsumer<Class, Bytes<?>> typeTranslator, @Nullable Class type) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(type == null ? null : type.getName());
            }
            BinaryWire.this.writeCode(188);
            typeTranslator.accept(type, BinaryWire.this.bytes);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut uuid(@NotNull UUID uuid) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(uuid.toString());
            }
            ((Bytes)BinaryWire.this.writeCode(160).writeLong(uuid.getMostSignificantBits())).writeLong(uuid.getLeastSignificantBits());
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("int32 for binding");
            }
            BinaryWire.this.writeAlignTo(4, 1);
            this.fixedInt32(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("int64 for binding");
            }
            BinaryWire.this.writeAlignTo(8, 1);
            this.fixedOrderedInt64(value);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int32forBinding(int value, @NotNull IntValue intValue) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("int32 for binding");
            }
            this.int32forBinding(value);
            ((BinaryIntReference)intValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 4L, 4L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int64forBinding(long value, @NotNull LongValue longValue) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("int64 for binding");
            }
            this.int64forBinding(value);
            ((BinaryLongReference)longValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 8L, 8L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut boolForBinding(boolean value, @NotNull BooleanValue booleanValue) {
            this.bool(value);
            ((BinaryBooleanReference)booleanValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 1L, 1L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut int128forBinding(long i64x0, long i64x1, TwoLongValue longValue) {
            this.int128forBinding(i64x0, i64x1);
            ((BinaryTwoLongReference)longValue).bytesStore((BytesStore)BinaryWire.this.bytes, BinaryWire.this.bytes.writePosition() - 16L, 16L);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public <T> WireOut sequence(T t, @NotNull BiConsumer<T, ValueOut> writer) {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("sequence");
            }
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            writer.accept(t, this);
            this.setSequenceLength(position);
            return BinaryWire.this;
        }

        private void setSequenceLength(long position) {
            long length0 = BinaryWire.this.bytes.lengthWritten(position) - 4L;
            int length = BinaryWire.this.bytes instanceof HexDumpBytes ? (int)length0 : Maths.toInt32(length0, "Document length %,d out of 32-bit int range.");
            BinaryWire.this.bytes.writeInt(position, length);
        }

        @Override
        @NotNull
        public <T, K> WireOut sequence(T t, K kls, @NotNull TriConsumer<T, K, ValueOut> writer) throws InvalidMarshallableException {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription("sequence");
            }
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            writer.accept(t, kls, this);
            this.setSequenceLength(position);
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull WriteMarshallable object) throws InvalidMarshallableException {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(object.getClass().getSimpleName());
            }
            BinaryLengthLength binaryLengthLength = object.binaryLengthLength();
            long pos = binaryLengthLength.initialise(BinaryWire.this.bytes);
            if (BinaryWire.this.useSelfDescribingMessage(object)) {
                object.writeMarshallable(BinaryWire.this);
            } else {
                ((WriteBytesMarshallable)((Object)object)).writeMarshallable(BinaryWire.this.bytes());
            }
            binaryLengthLength.writeLength(BinaryWire.this.bytes, pos, BinaryWire.this.bytes.writePosition());
            return BinaryWire.this;
        }

        @Override
        public WireOut bytesMarshallable(WriteBytesMarshallable object) throws InvalidMarshallableException {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(object.getClass().getSimpleName());
            }
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            object.writeMarshallable(BinaryWire.this.bytes());
            long length = BinaryWire.this.bytes.lengthWritten(position) - 4L;
            if (length > Integer.MAX_VALUE && BinaryWire.this.bytes instanceof HexDumpBytes) {
                length = (int)length;
            }
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32(length, "Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut marshallable(@NotNull Serializable object) throws InvalidMarshallableException {
            if (BinaryWire.this.bytes.retainedHexDumpDescription()) {
                BinaryWire.this.bytes.writeHexDumpDescription(object.getClass().getSimpleName());
            }
            BinaryWire.this.writeCode(130);
            long position = BinaryWire.this.bytes.writePosition();
            BinaryWire.this.bytes.writeInt(0);
            try {
                if (object instanceof Externalizable) {
                    ((Externalizable)object).writeExternal(BinaryWire.this.objectOutput());
                } else {
                    Wires.writeMarshallable(object, BinaryWire.this);
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            BinaryWire.this.bytes.writeOrderedInt(position, Maths.toInt32(BinaryWire.this.bytes.lengthWritten(position) - 4L, "Document length %,d out of 32-bit int range."));
            return BinaryWire.this;
        }

        @Override
        @NotNull
        public WireOut map(Map map) throws InvalidMarshallableException {
            return this.marshallable(map);
        }

        @Override
        @NotNull
        public WireOut wireOut() {
            return BinaryWire.this;
        }

        @Override
        public void resetState() {
        }
    }

    static enum AnyCodeMatch implements WireKey
    {
        ANY_CODE_MATCH;


        @Override
        public int code() {
            return Integer.MIN_VALUE;
        }
    }
}

