/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.AppendableUtil;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.BytesInternal;
import net.openhft.chronicle.bytes.internal.HasUncheckedRandomDataInput;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.internal.UncheckedRandomDataInput;
import net.openhft.chronicle.bytes.internal.migration.HashCodeEqualsUtil;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UncheckedNativeBytes<U>
extends AbstractReferenceCounted
implements Bytes<U>,
HasUncheckedRandomDataInput {
    protected final long capacity;
    private final UncheckedRandomDataInput uncheckedRandomDataInput = new UncheckedRandomDataInputHolder();
    @NotNull
    private final Bytes<U> underlyingBytes;
    @NotNull
    protected BytesStore<?, U> bytesStore;
    protected long readPosition;
    protected long writePosition;
    protected long writeLimit;
    private int lastDecimalPlaces = 0;
    private boolean lastNumberHadDigits = false;

    public UncheckedNativeBytes(@NotNull Bytes<U> underlyingBytes) throws IllegalStateException {
        this.underlyingBytes = underlyingBytes;
        underlyingBytes.reserve(this);
        this.bytesStore = BytesInternal.failIfBytesOnBytes(underlyingBytes.bytesStore());
        assert (this.bytesStore.start() == 0L);
        this.writePosition = underlyingBytes.writePosition();
        this.readPosition = underlyingBytes.readPosition();
        this.capacity = this.bytesStore.realCapacity();
        this.writeLimit = Math.min(this.capacity, underlyingBytes.writeLimit());
    }

    @Override
    public void ensureCapacity(@NonNegative long desiredCapacity) throws IllegalArgumentException, IllegalStateException {
        if (desiredCapacity > this.realCapacity()) {
            this.underlyingBytes.ensureCapacity(desiredCapacity);
            this.bytesStore = this.underlyingBytes.bytesStore();
        }
    }

    @Override
    public boolean unchecked() {
        return true;
    }

    @Override
    public boolean isDirectMemory() {
        return true;
    }

    @Override
    @NotNull
    public Bytes<U> unchecked(boolean unchecked) {
        this.throwExceptionIfReleased();
        return this;
    }

    @Override
    public void move(@NonNegative long from, @NonNegative long to, @NonNegative long length) throws IllegalStateException, BufferUnderflowException {
        this.bytesStore.move(from - this.start(), to - this.start(), length);
    }

    @Override
    @NotNull
    public Bytes<U> compact() {
        try {
            long start = this.start();
            long readRemaining = this.readRemaining();
            if (readRemaining > 0L && start < this.readPosition) {
                this.bytesStore.move(this.readPosition, start, readRemaining);
                this.readPosition = start;
                this.writePosition = this.readPosition + readRemaining;
            }
            return this;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
        catch (IllegalStateException ignored) {
            return this;
        }
    }

    @Override
    @NotNull
    public Bytes<U> readPosition(@NonNegative long position) {
        this.readPosition = position;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> readLimit(@NonNegative long limit) {
        this.writePosition = limit;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writePosition(@NonNegative long position) {
        this.writePosition = Longs.requireNonNegative(position);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> readSkip(long bytesToSkip) {
        this.readPosition += bytesToSkip;
        return this;
    }

    @Override
    public byte readVolatileByte(@NonNegative long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileByte(offset);
    }

    @Override
    public short readVolatileShort(@NonNegative long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileShort(offset);
    }

    @Override
    public int readVolatileInt(@NonNegative long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong(@NonNegative long offset) throws BufferUnderflowException {
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    public void uncheckedReadSkipOne() {
        ++this.readPosition;
    }

    @Override
    public void uncheckedReadSkipBackOne() {
        --this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<U> writeSkip(long bytesToSkip) {
        this.writePosition += bytesToSkip;
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLimit(@NonNegative long limit) {
        this.writeLimit = Longs.requireNonNegative(limit);
        return this;
    }

    @Override
    @NotNull
    public BytesStore<Bytes<U>, U> copy() {
        this.throwExceptionIfReleased();
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean isElastic() {
        return false;
    }

    protected long readOffsetPositionMoved(@NonNegative long adding) {
        long offset = this.readPosition;
        this.readPosition += adding;
        return offset;
    }

    protected long writeOffsetPositionMoved(@NonNegative long adding) {
        return this.writeOffsetPositionMoved(adding, adding);
    }

    protected long writeOffsetPositionMoved(@NonNegative long adding, @NonNegative long advance) {
        long oldPosition = this.writePosition;
        long writeEnd = oldPosition + adding;
        assert (writeEnd <= this.bytesStore.safeLimit());
        this.writePosition += advance;
        return oldPosition;
    }

    protected long prewriteOffsetPositionMoved(@NonNegative long substracting) {
        this.readPosition -= substracting;
        return this.readPosition;
    }

    @Override
    @NotNull
    public Bytes<U> write(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(offset);
        Longs.requireNonNegative(length);
        if (length == 8L) {
            this.writeLong(bytes.readLong(offset));
        } else if (length >= 16L && bytes.isDirectMemory()) {
            this.rawCopy(bytes, offset, length);
        } else {
            BytesInternal.writeFully(bytes, offset, length, this);
        }
        return this;
    }

    public long rawCopy(@NotNull RandomDataInput bytes, @NonNegative long offset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        long len = Math.min(this.writeRemaining(), Math.min(bytes.capacity() - offset, length));
        if (len > 0L) {
            this.writeCheckOffset(this.writePosition(), len);
            this.throwExceptionIfReleased();
            OS.memory().copyMemory(bytes.addressForRead(offset), this.addressForWritePosition(), len);
            this.writeSkip(len);
        }
        return len;
    }

    @Override
    @NotNull
    public Bytes<U> clear() {
        this.readPosition = this.writePosition = this.start();
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> clearAndPad(@NonNegative long length) throws BufferOverflowException {
        if (this.start() + length > this.capacity()) {
            throw new BufferOverflowException();
        }
        this.readPosition = this.writePosition = this.start() + length;
        this.writeLimit = this.capacity();
        return this;
    }

    @Override
    public long readLimit() {
        return this.writePosition;
    }

    @Override
    public long writeLimit() {
        return this.writeLimit;
    }

    @Override
    @NonNegative
    public long realCapacity() {
        return this.bytesStore.realCapacity();
    }

    @Override
    public long realWriteRemaining() {
        return this.writeRemaining();
    }

    @Override
    @NonNegative
    public long capacity() {
        return this.capacity;
    }

    @Override
    @Nullable
    public U underlyingObject() {
        return this.bytesStore.underlyingObject();
    }

    @Override
    @NonNegative
    public long readPosition() {
        return this.readPosition;
    }

    @Override
    @NonNegative
    public long writePosition() {
        return this.writePosition;
    }

    @Override
    public boolean compareAndSwapInt(@NonNegative long offset, int expected, int value) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        return this.bytesStore.compareAndSwapInt(offset, expected, value);
    }

    @Override
    public void testAndSetInt(@NonNegative long offset, int expected, int value) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.testAndSetInt(offset, expected, value);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    protected void performRelease() throws IllegalStateException {
        this.underlyingBytes.release(this);
        BackgroundResourceReleaser.releasePendingResources();
    }

    @Override
    public int readUnsignedByte() {
        long offset = this.readOffsetPositionMoved(1L);
        return this.bytesStore.readByte(offset) & 0xFF;
    }

    @Override
    public int uncheckedReadUnsignedByte() {
        return this.readUnsignedByte();
    }

    @Override
    public byte readByte() {
        long offset = this.readOffsetPositionMoved(1L);
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int peekUnsignedByte() {
        try {
            return this.readRemaining() > 0L ? this.bytesStore.readUnsignedByte(this.readPosition) : -1;
        }
        catch (BufferUnderflowException e) {
            return -1;
        }
    }

    @Override
    public short readShort() {
        long offset = this.readOffsetPositionMoved(2L);
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readDouble(offset);
    }

    @Override
    public int readVolatileInt() {
        long offset = this.readOffsetPositionMoved(4L);
        return this.bytesStore.readVolatileInt(offset);
    }

    @Override
    public long readVolatileLong() {
        long offset = this.readOffsetPositionMoved(8L);
        return this.bytesStore.readVolatileLong(offset);
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(@NonNegative long offset, byte i) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeByte(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeShort(@NonNegative long offset, short i) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeShort(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeInt(@NonNegative long offset, int i) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedInt(@NonNegative long offset, int i) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLong(@NonNegative long offset, long i) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedLong(@NonNegative long offset, long i) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeFloat(@NonNegative long offset, float d) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeFloat(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeDouble(@NonNegative long offset, double d) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileByte(@NonNegative long offset, byte i8) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 1L);
        this.bytesStore.writeVolatileByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileShort(@NonNegative long offset, short i16) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 2L);
        this.bytesStore.writeVolatileShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileInt(@NonNegative long offset, int i32) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 4L);
        this.bytesStore.writeVolatileInt(offset, i32);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeVolatileLong(@NonNegative long offset, long i64) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(offset, 8L);
        this.bytesStore.writeVolatileLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull(byteArray);
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, byteArray, offset, length);
        return this;
    }

    @Override
    public void write(@NonNegative long offsetInRDO, @NotNull ByteBuffer bytes, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalStateException {
        ObjectUtils.requireNonNull(bytes);
        this.writeCheckOffset(offsetInRDO, length);
        this.bytesStore.write(offsetInRDO, bytes, offset, length);
    }

    @Override
    @NotNull
    public Bytes<U> write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferUnderflowException, BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(writeOffset, length);
        this.bytesStore.write(writeOffset, bytes, readOffset, length);
        return this;
    }

    void writeCheckOffset(long offset, long adding) throws BufferOverflowException {
    }

    @Override
    public byte readByte(@NonNegative long offset) {
        return this.bytesStore.readByte(offset);
    }

    @Override
    public int readUnsignedByte(@NonNegative long offset) {
        return this.bytesStore.readByte(offset) & 0xFF;
    }

    @Override
    public int peekUnsignedByte(@NonNegative long offset) {
        return offset < this.start() || this.writePosition <= offset ? -1 : (int)this.readByte(offset);
    }

    @Override
    public short readShort(@NonNegative long offset) {
        return this.bytesStore.readShort(offset);
    }

    @Override
    public int readInt(@NonNegative long offset) {
        return this.bytesStore.readInt(offset);
    }

    @Override
    public long readLong(@NonNegative long offset) {
        return this.bytesStore.readLong(offset);
    }

    @Override
    public float readFloat(@NonNegative long offset) {
        return this.bytesStore.readFloat(offset);
    }

    @Override
    public double readDouble(@NonNegative long offset) {
        return this.bytesStore.readDouble(offset);
    }

    @Override
    @NotNull
    public Bytes<U> writeByte(byte i8) {
        long offset = this.writeOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteByte(byte i8) {
        long offset = this.prewriteOffsetPositionMoved(1L);
        this.bytesStore.writeByte(offset, i8);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeShort(short i16) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteShort(short i16) throws IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(2L);
        this.bytesStore.writeShort(offset, i16);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeInt(int i) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeIntAdv(int i, @NonNegative int advance) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L, advance);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteInt(int i) throws IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(4L);
        this.bytesStore.writeInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLong(long i64) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeLongAdv(long i64, @NonNegative int advance) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L, advance);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewriteLong(long i64) throws IllegalStateException {
        long offset = this.prewriteOffsetPositionMoved(8L);
        this.bytesStore.writeLong(offset, i64);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeFloat(float f) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeFloat(offset, f);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeDouble(double d) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeDouble(offset, d);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeDoubleAndInt(double d, int i) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(12L);
        this.bytesStore.writeDouble(offset, d);
        this.bytesStore.writeInt(offset + 8L, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> write(byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalStateException, ArrayIndexOutOfBoundsException {
        Ints.requireNonNegative(offset);
        Ints.requireNonNegative(length);
        if (length + offset > byteArray.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + byteArray.length + ", length=" + length + ", offset=" + offset);
        }
        if ((long)length > this.writeRemaining()) {
            throw new BufferOverflowException();
        }
        long offsetInRDO = this.writeOffsetPositionMoved(length);
        this.bytesStore.write(offsetInRDO, byteArray, offset, length);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewrite(@NotNull byte[] bytes) throws IllegalStateException, BufferOverflowException {
        long offsetInRDO = this.prewriteOffsetPositionMoved(bytes.length);
        this.bytesStore.write(offsetInRDO, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> prewrite(@NotNull BytesStore bytes) throws IllegalStateException, BufferOverflowException {
        long offsetInRDO = this.prewriteOffsetPositionMoved(bytes.length());
        this.bytesStore.write(offsetInRDO, bytes);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeSome(@NotNull ByteBuffer buffer) throws IllegalStateException {
        this.bytesStore.write(this.writePosition, buffer, buffer.position(), buffer.limit());
        this.writePosition += (long)buffer.remaining();
        assert (this.writePosition <= this.writeLimit());
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedInt(int i) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(4L);
        this.bytesStore.writeOrderedInt(offset, i);
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> writeOrderedLong(long i) throws IllegalStateException {
        long offset = this.writeOffsetPositionMoved(8L);
        this.bytesStore.writeOrderedLong(offset, i);
        return this;
    }

    @Override
    public long addressForRead(@NonNegative long offset) throws BufferUnderflowException {
        return this.bytesStore.addressForRead(offset);
    }

    @Override
    public long addressForWrite(@NonNegative long offset) throws BufferOverflowException {
        return this.bytesStore.addressForWrite(offset);
    }

    @Override
    public long addressForWritePosition() throws UnsupportedOperationException, BufferOverflowException {
        return this.bytesStore.addressForWrite(0L);
    }

    public int hashCode() {
        return HashCodeEqualsUtil.hashCode(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof BytesStore && BytesInternal.contentEqual(this, (BytesStore)obj);
    }

    @Override
    @NotNull
    public String toString() {
        if (this.refCount() <= 0) {
            return "(released)";
        }
        return BytesInternal.toString(this);
    }

    @Override
    public void lenient(boolean lenient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean lenient() {
        return false;
    }

    @Override
    public void nativeRead(@NonNegative long position, long address, @NonNegative long size) throws IllegalStateException, BufferUnderflowException {
        this.bytesStore.nativeRead(position, address, size);
    }

    @Override
    public void nativeWrite(long address, @NonNegative long position, @NonNegative long size) throws IllegalStateException, BufferOverflowException {
        this.bytesStore.nativeWrite(address, position, size);
    }

    @Override
    @Nullable
    public BytesStore bytesStore() {
        return this.bytesStore;
    }

    @Override
    public int byteCheckSum() throws IORuntimeException {
        @Nullable NativeBytesStore nativeBytesStore = (NativeBytesStore)this.bytesStore();
        return nativeBytesStore.byteCheckSum(this.readPosition(), this.readLimit());
    }

    @Override
    @NotNull
    public Bytes<U> append8bit(@NotNull CharSequence cs) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        char c;
        int i;
        if (cs instanceof BytesStore) {
            return (Bytes)this.write((BytesStore)cs);
        }
        int length = cs.length();
        long offset = this.writeOffsetPositionMoved(length);
        long address = this.bytesStore.addressForWrite(offset);
        @Nullable UnsafeMemory memory = UnsafeMemory.MEMORY;
        assert (memory != null);
        for (i = 0; i < length - 1; i += 2) {
            c = cs.charAt(i);
            char c2 = cs.charAt(i + 1);
            memory.writeByte(address + (long)i, (byte)c);
            memory.writeByte(address + (long)i + 1L, (byte)c2);
        }
        while (i < length) {
            c = cs.charAt(i);
            memory.writeByte(address + (long)i, (byte)c);
            ++i;
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> appendUtf8(char[] chars, @NonNegative int offset, @NonNegative int length) throws BufferOverflowException, IllegalArgumentException, IllegalStateException {
        long actualUTF8Length = AppendableUtil.findUtf8Length(chars, offset, length);
        this.ensureCapacity(this.writePosition + actualUTF8Length);
        @NotNull BytesStore<?, U> nbs = this.bytesStore;
        long position = ((NativeBytesStore)nbs).appendUtf8(this.writePosition(), chars, offset, length);
        this.writePosition(position);
        return this;
    }

    @Override
    public int lastDecimalPlaces() {
        return this.lastDecimalPlaces;
    }

    @Override
    public void lastDecimalPlaces(int lastDecimalPlaces) {
        this.lastDecimalPlaces = Math.max(0, lastDecimalPlaces);
    }

    @Override
    public boolean lastNumberHadDigits() {
        return this.lastNumberHadDigits;
    }

    @Override
    public void lastNumberHadDigits(boolean lastNumberHadDigits) {
        this.lastNumberHadDigits = lastNumberHadDigits;
    }

    @Override
    @NotNull
    public Bytes<U> write(@NotNull RandomDataInput bytes) throws IllegalStateException {
        assert (bytes != this) : "you should not write to yourself !";
        try {
            return this.write(bytes, bytes.readPosition(), Math.min(this.writeRemaining(), bytes.readRemaining()));
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull BytesStore bs) {
        return this.bytesStore.write8bit(position, bs);
    }

    @Override
    public long write8bit(@NonNegative long position, @NotNull String s, @NonNegative int start, @NonNegative int length) {
        return this.bytesStore.write8bit(position, s, start, length);
    }

    public Bytes<U> write8bit(@Nullable BytesStore bs) throws BufferOverflowException, IllegalStateException, BufferUnderflowException {
        if (bs == null) {
            BytesInternal.writeStopBitNeg1(this);
        } else {
            long offset = bs.readPosition();
            long readRemaining = Math.min(this.writeRemaining(), bs.readLimit() - offset);
            this.writeStopBit(readRemaining);
            try {
                this.write(bs, offset, readRemaining);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public Bytes<U> write8bit(@NotNull String text, @NonNegative int start, @NonNegative int length) {
        ObjectUtils.requireNonNull(text);
        long toWriteLength = (long)UnsafeMemory.INSTANCE.stopBitLength(length) + (long)length;
        long position = this.writeOffsetPositionMoved(toWriteLength, 0L);
        this.bytesStore.write8bit(position, text, start, length);
        this.writePosition += toWriteLength;
        return this;
    }

    @Override
    @NotNull
    public UncheckedRandomDataInput acquireUncheckedInput() {
        return this.uncheckedRandomDataInput;
    }

    @Override
    public byte[] internalNumberBuffer() {
        return this.bytesStore.internalNumberBuffer();
    }

    private final class UncheckedRandomDataInputHolder
    implements UncheckedRandomDataInput {
        private UncheckedRandomDataInputHolder() {
        }

        @Override
        public byte readByte(@NonNegative long offset) {
            return UncheckedNativeBytes.this.bytesStore.readByte(offset);
        }

        @Override
        public short readShort(@NonNegative long offset) {
            return UncheckedNativeBytes.this.bytesStore.readShort(offset);
        }

        @Override
        public int readInt(@NonNegative long offset) {
            return UncheckedNativeBytes.this.bytesStore.readInt(offset);
        }

        @Override
        public long readLong(@NonNegative long offset) {
            return UncheckedNativeBytes.this.bytesStore.readLong(offset);
        }
    }
}

