/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.wire.TextMethodTester;
import net.openhft.chronicle.wire.YamlMethodTester;
import net.openhft.chronicle.wire.utils.YamlAgitator;
import net.openhft.chronicle.wire.utils.YamlTester;

public class YamlTesterParametersBuilder<T> {
    private final ThrowingFunction<T, Object, Throwable> builder;
    private final Class<T> outClass;
    private final String paths;
    private YamlAgitator[] agitators = new YamlAgitator[0];
    private Function<T, ExceptionHandler> exceptionHandlerFunction;

    public YamlTesterParametersBuilder(ThrowingFunction<T, Object, Throwable> builder, Class<T> outClass, String paths) {
        this.builder = builder;
        this.outClass = outClass;
        this.paths = paths;
    }

    public YamlTesterParametersBuilder<T> agitators(YamlAgitator ... agitators) {
        this.agitators = agitators;
        return this;
    }

    public YamlTesterParametersBuilder<T> exceptionHandlerFunction(Function<T, ExceptionHandler> exceptionHandlerFunction) {
        this.exceptionHandlerFunction = exceptionHandlerFunction;
        return this;
    }

    /*
     * Could not resolve type clashes
     */
    public List<Object[]> get() {
        String[] pathArr;
        Function<T, Object> compFunction = ThrowingFunction.asFunction(this.builder);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String path : pathArr = this.paths.split(",")) {
            String in_yaml;
            if ((path = path.trim()).isEmpty()) continue;
            String setup = path + "/_setup.yaml";
            TextMethodTester yt = new YamlMethodTester<T>(path + "/in.yaml", compFunction, this.outClass, path + "/out.yaml").genericEvent("event").setup(setup).exceptionHandlerFunction(this.exceptionHandlerFunction);
            Object[] test = new Object[]{path, yt};
            params.add(test);
            if (YamlTester.BASE_TESTS) continue;
            try {
                in_yaml = new String(IOTools.readFile(this.outClass, path + "/in.yaml"), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            String _setup_yaml = "";
            try {
                _setup_yaml = new String(IOTools.readFile(this.outClass, path + "/_setup.yaml"), StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            TreeSet<String> skipping = new TreeSet<String>();
            for (String path2 : pathArr) {
                if ((path2 = path2.trim()).isEmpty()) continue;
                String name = path2.replaceAll("[:/\\\\]+", "_");
                String output = path + "/out-" + name + ".yaml";
                try {
                    String in_yaml2;
                    if (!YamlTester.REGRESS_TESTS) {
                        IOTools.urlFor(this.builder.getClass(), output);
                    }
                    try {
                        in_yaml2 = new String(IOTools.readFile(this.outClass, path2 + "/in.yaml"), StandardCharsets.UTF_8);
                    }
                    catch (IOException e) {
                        throw new IORuntimeException(e);
                    }
                    String _setup_yaml2 = "";
                    try {
                        _setup_yaml2 = new String(IOTools.readFile(this.outClass, path2 + "/_setup.yaml"), StandardCharsets.UTF_8);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    String in2 = "=\n" + in_yaml + "\n...\n" + in_yaml2;
                    String setup2 = "=\n" + _setup_yaml + "\n...\n" + _setup_yaml2;
                    TextMethodTester yt2 = new YamlMethodTester<T>(in2, compFunction, this.outClass, output).genericEvent("event").setup(setup2).exceptionHandlerFunction(this.exceptionHandlerFunction);
                    Object[] test2 = new Object[]{path + "+" + path2, yt2};
                    params.add(test2);
                }
                catch (FileNotFoundException ioe) {
                    skipping.add(path + "/" + path + "+" + path2);
                }
            }
            if (this.agitators.length > 0) {
                LinkedHashMap<String, String> inputToNameMap = new LinkedHashMap<String, String>();
                for (YamlAgitator agitator : this.agitators) {
                    Map<String, String> agitateMap = yt.agitate(agitator);
                    for (Map.Entry<String, String> entry : agitateMap.entrySet()) {
                        inputToNameMap.putIfAbsent(entry.getKey(), entry.getValue());
                    }
                }
                for (Map.Entry entry : inputToNameMap.entrySet()) {
                    String name = (String)entry.getValue();
                    String output = path + "/out-" + name + ".yaml";
                    try {
                        if (!YamlTester.REGRESS_TESTS) {
                            IOTools.urlFor(this.builder.getClass(), output);
                        }
                        TextMethodTester yta = new YamlMethodTester<T>((String)entry.getKey(), compFunction, this.outClass, output).genericEvent("event").setup(setup).exceptionHandlerFunction(this.exceptionHandlerFunction);
                        Object[] testa = new Object[]{path + "/" + name, yta};
                        params.add(testa);
                    }
                    catch (FileNotFoundException ioe) {
                        skipping.add(path + "/" + name);
                    }
                }
            }
            if (skipping.isEmpty()) continue;
            Jvm.debug().on(YamlTester.class, "Skipping " + skipping);
        }
        return params;
    }
}

