/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal.stream;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.LongConsumer;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.domestic.extractor.DocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToDoubleDocumentExtractor;
import net.openhft.chronicle.wire.domestic.extractor.ToLongDocumentExtractor;
import org.jetbrains.annotations.NotNull;

public final class StreamsUtil {
    private static final int BATCH_UNIT_INCREASE = 1024;
    private static final int MAX_BATCH_SIZE = 0x1000000;

    private StreamsUtil() {
    }

    public static final class ExcerptIteratorOfDouble
    implements PrimitiveIterator.OfDouble {
        private final MarshallableIn tailer;
        private final ToDoubleDocumentExtractor extractor;
        private double next = Double.NaN;

        public ExcerptIteratorOfDouble(@NotNull MarshallableIn tailer, @NotNull ToDoubleDocumentExtractor extractor) {
            this.tailer = tailer;
            this.extractor = extractor;
        }

        @Override
        public boolean hasNext() {
            if (Double.isNaN(this.next)) {
                return true;
            }
            long lastIndex = -1L;
            while (true) {
                DocumentContext dc = this.tailer.readingDocument();
                Throwable throwable = null;
                try {
                    Wire wire = dc.wire();
                    if (dc.isPresent() && wire != null) {
                        lastIndex = dc.index();
                        this.next = this.extractor.extractAsDouble(wire, lastIndex);
                        if (Double.isNaN(this.next)) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            return false;
        }

        @Override
        public double nextDouble() {
            if (Double.isNaN(this.next) && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            double val = this.next;
            this.next = Double.NaN;
            return val;
        }
    }

    public static final class ExcerptIteratorOfLong
    implements PrimitiveIterator.OfLong {
        private final MarshallableIn tailer;
        private final ToLongDocumentExtractor extractor;
        private long next = Long.MIN_VALUE;

        public ExcerptIteratorOfLong(@NotNull MarshallableIn tailer, @NotNull ToLongDocumentExtractor extractor) {
            this.tailer = tailer;
            this.extractor = extractor;
        }

        @Override
        public boolean hasNext() {
            if (this.next != Long.MIN_VALUE) {
                return true;
            }
            long lastIndex = -1L;
            while (true) {
                DocumentContext dc = this.tailer.readingDocument();
                Throwable throwable = null;
                try {
                    Wire wire = dc.wire();
                    if (dc.isPresent() && wire != null) {
                        lastIndex = dc.index();
                        this.next = this.extractor.extractAsLong(wire, lastIndex);
                        if (this.next == Long.MIN_VALUE) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            return false;
        }

        @Override
        public long nextLong() {
            if (this.next == Long.MIN_VALUE && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            long val = this.next;
            this.next = Long.MIN_VALUE;
            return val;
        }
    }

    public static final class ExcerptIterator<T>
    implements Iterator<T> {
        private final MarshallableIn tailer;
        private final DocumentExtractor<T> extractor;
        private T next;

        public ExcerptIterator(@NotNull MarshallableIn tailer, @NotNull DocumentExtractor<T> extractor) {
            this.tailer = tailer;
            this.extractor = extractor;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            long lastIndex = -1L;
            while (true) {
                DocumentContext dc = this.tailer.readingDocument();
                Throwable throwable = null;
                try {
                    Wire wire = dc.wire();
                    if (dc.isPresent() && wire != null) {
                        lastIndex = dc.index();
                        this.next = this.extractor.extract(wire, lastIndex);
                        if (this.next == null) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
            return false;
        }

        @Override
        public T next() {
            if (this.next == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            T val = this.next;
            this.next = null;
            return val;
        }
    }

    static abstract class AbstractPrimitiveSpliterator<T, C, S extends Spliterator.OfPrimitive<T, C, S>, I extends PrimitiveIterator<T, C>>
    implements Spliterator.OfPrimitive<T, C, S> {
        protected final I iterator;
        protected final BiConsumer<C, I> advancer;
        protected final BiConsumer<I, C> forEachRemainer;
        private int batchSize = 2048;

        protected AbstractPrimitiveSpliterator(@NotNull I iterator, @NotNull BiConsumer<C, I> advancer, BiConsumer<I, C> forEachRemainer) {
            this.iterator = (PrimitiveIterator)ObjectUtils.requireNonNull(iterator);
            this.advancer = ObjectUtils.requireNonNull(advancer);
            this.forEachRemainer = ObjectUtils.requireNonNull(forEachRemainer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public S trySplit() {
            I i = this.iterator;
            synchronized (i) {
                if (this.iterator.hasNext()) {
                    int n = Math.min(0x1000000, this.batchSize);
                    this.batchSize += 1024;
                    return this.split(n);
                }
                return null;
            }
        }

        @NotNull
        abstract S split(int var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(C action) {
            I i = this.iterator;
            synchronized (i) {
                if (this.iterator.hasNext()) {
                    this.advancer.accept(action, this.iterator);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(C action) {
            I i = this.iterator;
            synchronized (i) {
                this.forEachRemainer.accept(this.iterator, action);
            }
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 16;
        }
    }

    public static final class VanillaSpliteratorOfDouble
    extends AbstractPrimitiveSpliterator<Double, DoubleConsumer, Spliterator.OfDouble, PrimitiveIterator.OfDouble>
    implements Spliterator.OfDouble {
        public VanillaSpliteratorOfDouble(@NotNull PrimitiveIterator.OfDouble iterator) {
            super(iterator, (a, i) -> a.accept(i.nextDouble()), PrimitiveIterator.OfDouble::forEachRemaining);
        }

        @Override
        @NotNull
        protected Spliterator.OfDouble split(int n) {
            double[] a = new double[n];
            int j = 0;
            do {
                a[j] = ((PrimitiveIterator.OfDouble)this.iterator).nextDouble();
            } while (++j < n && ((PrimitiveIterator.OfDouble)this.iterator).hasNext());
            return Spliterators.spliterator(a, 0, j, this.characteristics());
        }
    }

    public static final class VanillaSpliteratorOfLong
    extends AbstractPrimitiveSpliterator<Long, LongConsumer, Spliterator.OfLong, PrimitiveIterator.OfLong>
    implements Spliterator.OfLong {
        public VanillaSpliteratorOfLong(@NotNull PrimitiveIterator.OfLong iterator) {
            super(iterator, (a, i) -> a.accept(i.nextLong()), PrimitiveIterator.OfLong::forEachRemaining);
        }

        @Override
        @NotNull
        protected Spliterator.OfLong split(int n) {
            long[] a = new long[n];
            int j = 0;
            do {
                a[j] = ((PrimitiveIterator.OfLong)this.iterator).nextLong();
            } while (++j < n && ((PrimitiveIterator.OfLong)this.iterator).hasNext());
            return Spliterators.spliterator(a, 0, j, this.characteristics());
        }
    }

    public static final class VanillaSpliterator<T>
    implements Spliterator<T> {
        private final Iterator<T> iterator;
        private int batchSize = 2048;

        public VanillaSpliterator(@NotNull Iterator<T> iterator) {
            ObjectUtils.requireNonNull(iterator);
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Iterator<T> iterator = this.iterator;
            synchronized (iterator) {
                if (this.iterator.hasNext()) {
                    action.accept(this.iterator.next());
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            Iterator<T> iterator = this.iterator;
            synchronized (iterator) {
                this.iterator.forEachRemaining(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Spliterator<T> trySplit() {
            Iterator<T> iterator = this.iterator;
            synchronized (iterator) {
                if (this.iterator.hasNext()) {
                    int n = Math.min(0x1000000, this.batchSize);
                    Object[] a = new Object[n];
                    int j = 0;
                    do {
                        a[j] = this.iterator.next();
                    } while (++j < n && this.iterator.hasNext());
                    this.batchSize += 1024;
                    return Spliterators.spliterator(a, 0, j, this.characteristics());
                }
                return null;
            }
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 272;
        }
    }
}

