/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.net.URL;
import java.util.function.BooleanSupplier;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIORuntimeException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.RedirectHeader;
import net.openhft.chronicle.wire.channel.impl.BufferedChronicleChannel;
import net.openhft.chronicle.wire.channel.impl.SocketRegistry;
import net.openhft.chronicle.wire.channel.impl.TCPChronicleChannel;
import net.openhft.chronicle.wire.converter.NanoTime;

public interface ChronicleChannel
extends Closeable,
MarshallableOut,
MarshallableIn {
    public static ChronicleChannel newChannel(SocketRegistry socketRegistry, ChronicleChannelCfg channelCfg, ChannelHeader headerOut) {
        TCPChronicleChannel simpleConnection = new TCPChronicleChannel(channelCfg, headerOut, socketRegistry);
        ChannelHeader marshallable = simpleConnection.headerIn();
        Jvm.debug().on(ChronicleChannel.class, "Client got " + marshallable);
        if (marshallable instanceof RedirectHeader) {
            Closeable.closeQuietly((Object)simpleConnection);
            RedirectHeader rh = (RedirectHeader)marshallable;
            for (String location : rh.locations()) {
                try {
                    URL url = ChronicleContext.urlFor(location);
                    channelCfg.hostname(url.getHost());
                    channelCfg.port(url.getPort());
                    return ChronicleChannel.newChannel(socketRegistry, channelCfg, headerOut);
                }
                catch (IORuntimeException e) {
                    Jvm.debug().on(ChronicleChannel.class, e);
                }
            }
            throw new IORuntimeException("No urls available " + rh);
        }
        return channelCfg.buffered() ? new BufferedChronicleChannel(simpleConnection, (Pauser)channelCfg.pauserMode().get()) : simpleConnection;
    }

    public ChronicleChannelCfg channelCfg();

    public ChannelHeader headerOut();

    public ChannelHeader headerIn();

    default public <T> T readOne(StringBuilder eventType, Class<T> expectedType) throws ClosedIORuntimeException {
        while (!this.isClosed()) {
            DocumentContext dc = this.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) continue;
                T t = dc.wire().read(eventType).object(expectedType);
                return t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
            }
        }
        throw new ClosedIORuntimeException("Closed");
    }

    default public Runnable eventHandlerAsRunnable(Object eventHandler) {
        BooleanSupplier handlerClosed;
        MethodReader reader = this.methodReader(eventHandler);
        if (eventHandler instanceof Closeable) {
            Closeable sh = (Closeable)eventHandler;
            handlerClosed = sh::isClosed;
        } else {
            handlerClosed = () -> false;
        }
        return () -> {
            try {
                PauserMode pauserMode = this.channelCfg().pauserMode();
                if (pauserMode == null) {
                    pauserMode = PauserMode.balanced;
                }
                Pauser pauser = (Pauser)pauserMode.get();
                while (true) {
                    if (this.isClosed()) {
                        Jvm.debug().on(eventHandler.getClass(), "Reader on " + this + " is closed");
                        break;
                    }
                    if (handlerClosed.getAsBoolean()) {
                        Jvm.debug().on(eventHandler.getClass(), "Handler " + eventHandler + " is closed");
                        break;
                    }
                    if (reader.readOne()) {
                        pauser.reset();
                        continue;
                    }
                    pauser.pause();
                }
            }
            catch (Throwable t) {
                if (!this.isClosed() && !handlerClosed.getAsBoolean()) {
                    Jvm.warn().on(eventHandler.getClass(), "Error stopped reading thread", t);
                }
            }
            finally {
                Closeable.closeQuietly((Object)reader);
                Closeable.closeQuietly(eventHandler);
            }
        };
    }

    public void testMessage(@NanoTime long var1);

    public long lastTestMessage();
}

