/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.util;

import java.io.InputStream;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.Jvm;
import org.jetbrains.annotations.NotNull;

public enum PropertyReplacer {

    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{\\s*+([^}\\s]*+)\\s*+}");

    public static String replaceTokensWithProperties(String expression) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder(expression.length());
        int i = 0;
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        while (matcher.find()) {
            result.append(expression, i, matcher.start());
            String property = matcher.group(1);
            String p = Jvm.getProperty(property);
            if (p == null) {
                throw new IllegalArgumentException(String.format("System property is missing: [property=%s, expression=%s]", property, expression));
            }
            result.append(p);
            i = matcher.end();
        }
        result.append(expression.substring(i));
        return result.toString();
    }

    public static String replaceTokensWithProperties(String expression, Properties properties) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder(expression.length());
        int i = 0;
        Matcher matcher = EXPRESSION_PATTERN.matcher(expression);
        while (matcher.find()) {
            result.append(expression, i, matcher.start());
            String property = matcher.group(1);
            String p = properties.getProperty(property);
            if (p == null) {
                throw new IllegalArgumentException(String.format("Property is missing: [property=%s, expression=%s, properties=%s]", property, expression, properties));
            }
            result.append(p);
            i = matcher.end();
        }
        result.append(expression.substring(i));
        return result.toString();
    }

    @NotNull
    private static String convertStreamToString(@NotNull InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

