/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.HelloWorld;
import net.openhft.chronicle.queue.impl.single.OnEvents;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class StoreTailerTest
extends ChronicleQueueTestBase {
    private final Path dataDirectory = this.getTmpDir().toPath();

    @Test
    public void testEntryCount() {
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)this.dataDirectory).build();){
            Assert.assertEquals((long)0L, (long)queue.entryCount());
            ExcerptAppender appender = queue.acquireAppender();
            try (DocumentContext dc = appender.writingDocument();){
                dc.wire().write((CharSequence)"test").text("value");
            }
            appender.sync();
            Assert.assertEquals((long)1L, (long)queue.entryCount());
        }
    }

    @Test
    public void shouldHandleCycleRollWhenInReadOnlyMode() {
        Assume.assumeFalse((String)"Read-only mode is not supported on Windows", (boolean)OS.isWindows());
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        try (ChronicleQueue queue = this.build(this.createQueue(this.dataDirectory, RollCycles.MINUTELY, 0, "cycleRoll", false).timeProvider((TimeProvider)timeProvider));){
            ExcerptAppender appender = queue.acquireAppender();
            OnEvents events = (OnEvents)appender.methodWriterBuilder(OnEvents.class).build();
            timeProvider.setTime(System.currentTimeMillis());
            events.onEvent("firstEvent");
            timeProvider.addTime(2L, TimeUnit.MINUTES);
            events.onEvent("secondEvent");
            appender.sync();
            try (ChronicleQueue readerQueue = this.build(this.createQueue(this.dataDirectory, RollCycles.MINUTELY, 0, "cycleRoll", true).timeProvider((TimeProvider)timeProvider));){
                ExcerptTailer tailer = readerQueue.createTailer();
                tailer.sync();
                tailer.toStart();
                tailer.sync();
                try (DocumentContext context = tailer.readingDocument();){
                    Assert.assertTrue((boolean)context.isPresent());
                }
                tailer.sync();
                tailer.toEnd();
                tailer.sync();
                context = tailer.readingDocument();
                var10_14 = null;
                try {
                    Assert.assertFalse((boolean)context.isPresent());
                }
                catch (Throwable throwable) {
                    var10_14 = throwable;
                    throw throwable;
                }
                finally {
                    if (context != null) {
                        if (var10_14 != null) {
                            try {
                                context.close();
                            }
                            catch (Throwable throwable) {
                                var10_14.addSuppressed(throwable);
                            }
                        } else {
                            context.close();
                        }
                    }
                }
                tailer.sync();
            }
        }
    }

    @Test
    public void shouldConsiderSourceIdWhenDeterminingLastWrittenIndex() {
        try (ChronicleQueue firstInputQueue = this.createQueue(this.dataDirectory, RollCycles.TEST_DAILY, 1, "firstInputQueue");
             ChronicleQueue secondInputQueue = this.createQueue(this.dataDirectory, RollCycles.TEST_SECONDLY, 2, "secondInputQueue");
             ChronicleQueue outputQueue = this.createQueue(this.dataDirectory, RollCycles.TEST_DAILY, 0, "outputQueue");){
            OnEvents firstWriter = (OnEvents)firstInputQueue.acquireAppender().methodWriterBuilder(OnEvents.class).get();
            HelloWorld secondWriter = (HelloWorld)secondInputQueue.acquireAppender().methodWriterBuilder(HelloWorld.class).get();
            firstWriter.onEvent("one");
            firstWriter.onEvent("two");
            secondWriter.hello("thirteen");
            secondWriter.hello("thirtyOne");
            OnEvents eventSink = (OnEvents)outputQueue.acquireAppender().methodWriterBuilder(OnEvents.class).get();
            CapturingStringEvents outputWriter = new CapturingStringEvents(eventSink);
            MethodReader firstMethodReader = firstInputQueue.createTailer().methodReader(new Object[]{outputWriter});
            MethodReader secondMethodReader = secondInputQueue.createTailer().methodReader(new Object[]{outputWriter});
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)firstMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            Assert.assertTrue((boolean)secondMethodReader.readOne());
            secondInputQueue.createTailer().afterLastWritten(outputQueue);
        }
    }

    @Test
    public void shouldHandleCycleRoll() {
        File dir = this.getTmpDir();
        MutableTimeProvider timeProvider = new MutableTimeProvider();
        timeProvider.setTime(System.currentTimeMillis());
        try (SingleChronicleQueue chronicle = this.minutely(dir, timeProvider).build();
             SingleChronicleQueue chronicle2 = this.minutely(dir, timeProvider).build();){
            ExcerptTailer tailer = chronicle.createTailer();
            timeProvider.addTime(10L, TimeUnit.MINUTES);
            ExcerptAppender append = chronicle2.acquireAppender();
            append.writeDocument(w -> w.write((CharSequence)"test").text("text"));
            if (!tailer.readDocument(w -> w.read("test").text((Object)"text", Assert::assertEquals))) {
                Assert.fail((String)"readDocument false");
            }
        }
    }

    private SingleChronicleQueueBuilder minutely(@NotNull File file, TimeProvider timeProvider) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)WireType.BINARY).rollCycle((RollCycle)RollCycles.MINUTELY).testBlockSize().timeProvider(timeProvider);
    }

    @NotNull
    private ChronicleQueue createQueue(Path dataDirectory, RollCycles rollCycle, int sourceId, String subdirectory) {
        return this.build(this.createQueue(dataDirectory, rollCycle, sourceId, subdirectory, false));
    }

    @NotNull
    private SingleChronicleQueueBuilder createQueue(Path dataDirectory, RollCycles rollCycle, int sourceId, String subdirectory, boolean readOnly) {
        return SingleChronicleQueueBuilder.binary((Path)dataDirectory.resolve(Paths.get(subdirectory, new String[0]))).sourceId(sourceId).testBlockSize().rollCycle((RollCycle)rollCycle).readOnly(readOnly);
    }

    private ChronicleQueue build(SingleChronicleQueueBuilder builder) {
        return builder.build();
    }

    @Test
    public void disableThreadSafety() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue singleChronicleQueue, ExcerptTailer tailer) {
                tailer.readText();
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    tailer.readText();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                tailer.singleThreadedCheckDisabled(true);
                tailer.readText();
            }
        }.run();
    }

    @Test
    public void disableThreadSafetyWithMethodReader() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue queue, ExcerptTailer tailer) {
                StoreTailerTest.this.writeMethodCall(queue, "Testing1");
                StoreTailerTest.this.writeMethodCall(queue, "Testing2");
                Assert.assertEquals((Object)"Testing1", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    StoreTailerTest.this.readMethodCall(tailer);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                tailer.singleThreadedCheckDisabled(true);
                Assert.assertEquals((Object)"Testing2", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }
        }.run();
    }

    @Test
    public void clearUsedByThread() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue singleChronicleQueue, ExcerptTailer tailer) {
                tailer.readText();
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    tailer.readText();
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ((AbstractCloseable)tailer).singleThreadedCheckReset();
                tailer.readText();
            }
        }.run();
    }

    @Test
    public void clearUsedByThreadWithMethodReader() throws InterruptedException {
        new ThreadSafetyTestingTemplate(){

            @Override
            void doOnFirstThread(SingleChronicleQueue queue, ExcerptTailer tailer) {
                StoreTailerTest.this.writeMethodCall(queue, "Testing1");
                StoreTailerTest.this.writeMethodCall(queue, "Testing2");
                StoreTailerTest.this.writeMethodCall(queue, "Testing3");
                Assert.assertEquals((Object)"Testing1", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }

            @Override
            void doOnSecondThread(ExcerptTailer tailer) {
                try {
                    StoreTailerTest.this.readMethodCall(tailer);
                    Assert.fail();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                ((AbstractCloseable)tailer).singleThreadedCheckReset();
                Assert.assertEquals((Object)"Testing2", (Object)StoreTailerTest.this.readMethodCall(tailer));
            }
        }.run();
    }

    private void writeMethodCall(SingleChronicleQueue queue, String message) {
        try (ExcerptAppender appender = queue.acquireAppender();){
            Foobar foobar = (Foobar)appender.methodWriter(Foobar.class, new Class[0]);
            foobar.say(message);
        }
    }

    private String readMethodCall(ExcerptTailer tailer) {
        AtomicReference messageHolder = new AtomicReference();
        Object[] objectArray = new Object[1];
        objectArray[0] = messageHolder::set;
        MethodReader methodReader = tailer.methodReader(objectArray);
        methodReader.readOne();
        return (String)messageHolder.get();
    }

    @Test
    public void readMetaData() {
        File dir = this.getTmpDir();
        try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((File)dir).build();
             ExcerptTailer tailer = queue.createTailer();
             ExcerptAppender appender = queue.acquireAppender();){
            appender.writeText((CharSequence)"Hello World");
            try (DocumentContext dc = tailer.readingDocument(true);){
                Assert.assertTrue((boolean)dc.isPresent());
                Assert.assertTrue((boolean)dc.isMetaData());
                Assert.assertEquals((Object)"header", (Object)dc.wire().readEvent(String.class));
            }
        }
    }

    abstract class ThreadSafetyTestingTemplate {
        ThreadSafetyTestingTemplate() {
        }

        abstract void doOnFirstThread(SingleChronicleQueue var1, ExcerptTailer var2);

        abstract void doOnSecondThread(ExcerptTailer var1);

        public void run() throws InterruptedException {
            try (SingleChronicleQueue queue = ChronicleQueue.singleBuilder((Path)StoreTailerTest.this.dataDirectory).build();){
                LinkedBlockingQueue tq = new LinkedBlockingQueue();
                Thread t = new Thread(() -> {
                    ExcerptTailer tailer = queue.createTailer();
                    this.doOnFirstThread(queue, tailer);
                    tq.offer(tailer);
                    Jvm.pause((long)1000L);
                });
                t.start();
                this.doOnSecondThread((ExcerptTailer)tq.take());
                t.interrupt();
                t.join(1000L);
            }
        }
    }

    private static final class MutableTimeProvider
    implements TimeProvider {
        private long currentTimeMillis;

        private MutableTimeProvider() {
        }

        public long currentTimeMillis() {
            return this.currentTimeMillis;
        }

        void setTime(long millis) {
            this.currentTimeMillis = millis;
        }

        void addTime(long duration, TimeUnit unit) {
            this.currentTimeMillis += unit.toMillis(duration);
        }
    }

    private static final class CapturingStringEvents
    implements OnEvents {
        private final OnEvents delegate;

        CapturingStringEvents(OnEvents delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEvent(String event) {
            this.delegate.onEvent(event);
        }
    }

    static interface Foobar {
        public void say(String var1);
    }
}

