/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RollingChronicleQueueTest
extends ChronicleQueueTestBase {
    @Test
    public void testCountExcerptsWhenTheCycleIsRolled() {
        AtomicLong time = new AtomicLong();
        File name = this.getTmpDir();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.binary((File)name).testBlockSize().timeProvider(time::get).rollCycle((RollCycle)RollCycles.TEST2_DAILY).build();){
            ExcerptAppender appender = q.acquireAppender();
            time.set(0L);
            appender.writeText((CharSequence)"1. some  text");
            long start = appender.lastIndexAppended();
            appender.writeText((CharSequence)"2. some more text");
            appender.writeText((CharSequence)"3. some more text");
            time.set(TimeUnit.DAYS.toMillis(1L));
            appender.writeText((CharSequence)"4. some text - first cycle");
            time.set(TimeUnit.DAYS.toMillis(2L));
            time.set(TimeUnit.DAYS.toMillis(3L));
            time.set(TimeUnit.DAYS.toMillis(4L));
            appender.writeText((CharSequence)"5. some text - second cycle");
            appender.writeText((CharSequence)"some more text");
            long end = appender.lastIndexAppended();
            String expected = "--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T2', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 180, header: 0\n--- !!data #binary\nlisting.highestCycle: 4\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 0\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 7\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 472, header: 7\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n# 130596 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    572,\n    2456721293314\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 4\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 2\n  528,\n  572,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 528, header: 0\n--- !!data #binary\n\"1. some  text\"\n# position: 548, header: 1\n--- !!data #binary\n\"2. some more text\"\n# position: 572, header: 2\n--- !!data #binary\n\"3. some more text\"\n# position: 596, header: 2 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130472 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    528,\n    2267742732288\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  528,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 528, header: 0\n--- !!data #binary\n\"4. some text - first cycle\"\n# position: 560, header: 0 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130508 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    560,\n    2405181685761\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  528,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 528, header: 0\n--- !!data #binary\n\"5. some text - second cycle\"\n# position: 560, header: 1\n--- !!data #binary\nsome more text\n...\n# 130488 bytes remaining\n";
            Assert.assertEquals((long)5L, (long)q.countExcerpts(start, end));
            Thread.yield();
            Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !STStore {\n  wireType: !WireType BINARY_LIGHT,\n  metadata: !SCQMeta {\n    roll: !SCQSRoll { length: 86400000, format: yyyyMMdd'T2', epoch: 0 },\n    deltaCheckpointInterval: 64,\n    sourceId: 0\n  }\n}\n# position: 180, header: 0\n--- !!data #binary\nlisting.highestCycle: 4\n# position: 216, header: 1\n--- !!data #binary\nlisting.lowestCycle: 0\n# position: 256, header: 2\n--- !!data #binary\nlisting.modCount: 7\n# position: 288, header: 3\n--- !!data #binary\nchronicle.write.lock: -9223372036854775808\n# position: 328, header: 4\n--- !!data #binary\nchronicle.append.lock: -9223372036854775808\n# position: 368, header: 5\n--- !!data #binary\nchronicle.lastIndexReplicated: -1\n# position: 416, header: 6\n--- !!data #binary\nchronicle.lastAcknowledgedIndexReplicated: -1\n# position: 472, header: 7\n--- !!data #binary\nchronicle.lastIndexMSynced: -1\n...\n# 130596 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    572,\n    2456721293314\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 4\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 2\n  528,\n  572,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 528, header: 0\n--- !!data #binary\n\"1. some  text\"\n# position: 548, header: 1\n--- !!data #binary\n\"2. some more text\"\n# position: 572, header: 2\n--- !!data #binary\n\"3. some more text\"\n# position: 596, header: 2 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130472 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    528,\n    2267742732288\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  528,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 528, header: 0\n--- !!data #binary\n\"4. some text - first cycle\"\n# position: 560, header: 0 EOF\n--- !!not-ready-meta-data #binary\n...\n# 130508 bytes remaining\n--- !!meta-data #binary\nheader: !SCQStore {\n  writePosition: [\n    560,\n    2405181685761\n  ],\n  indexing: !SCQSIndexing {\n    indexCount: 16,\n    indexSpacing: 2,\n    index2Index: 200,\n    lastIndex: 2\n  },\n  dataFormat: 1\n}\n# position: 200, header: -1\n--- !!meta-data #binary\nindex2index: [\n  # length: 16, used: 1\n  368,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 368, header: -1\n--- !!meta-data #binary\nindex: [\n  # length: 16, used: 1\n  528,\n  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0\n]\n# position: 528, header: 0\n--- !!data #binary\n\"5. some text - second cycle\"\n# position: 560, header: 1\n--- !!data #binary\nsome more text\n...\n# 130488 bytes remaining\n".replaceAll(" \\d+ (bytes remaining)", " X $1"), (Object)q.dump().replaceAll(" \\d+ (bytes remaining)", " X $1"));
        }
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize();
    }
}

