/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.openhft.chronicle.core.Jvm;

public enum MappedFileUtil {

    private static final Path PROC_SELF_MAPS = Paths.get("/proc/self/maps", new String[0]);
    private static final Pattern LINE_PATTERN = Pattern.compile("([\\p{XDigit}\\-]+)\\s+([rwxsp\\-]+)\\s+(\\p{XDigit}+)\\s+(\\p{XDigit}+:\\p{XDigit}+)\\s+(\\d+)\\s*(.*)?");
    private static final int ADDRESS_INDEX = 1;
    private static final int PERMS_INDEX = 2;
    private static final int OFFSET_INDEX = 3;
    private static final int DEV_INDEX = 4;
    private static final int INODE_INDEX = 5;
    private static final int PATH_INDEX = 6;

    public static Set<String> getAllMappedFiles() {
        HashSet<String> fileList = new HashSet<String>();
        if (Files.exists(PROC_SELF_MAPS, new LinkOption[0]) && Files.isReadable(PROC_SELF_MAPS)) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(PROC_SELF_MAPS, new OpenOption[0])));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = MappedFileUtil.parseMapsLine(line);
                    if (matcher.matches()) {
                        String filename = MappedFileUtil.getPath(matcher);
                        if (filename.startsWith("/")) {
                            fileList.add(filename);
                            continue;
                        }
                        if (filename.trim().isEmpty()) continue;
                        Jvm.debug().on(MappedFileUtil.class, "Ignoring non-file " + filename);
                        continue;
                    }
                    Jvm.warn().on(MappedFileUtil.class, "Found non-matching line in /proc/self/maps: " + line);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Getting mapped files failed", e);
            }
            return fileList;
        }
        throw new UnsupportedOperationException("This only works on systems that have a /proc/self/maps (exists=" + Files.exists(PROC_SELF_MAPS, new LinkOption[0]) + ", isReadable=" + Files.isReadable(PROC_SELF_MAPS) + ")");
    }

    public static Matcher parseMapsLine(String line) {
        return LINE_PATTERN.matcher(line);
    }

    public static String getPath(Matcher matcher) {
        return matcher.group(6);
    }

    public static String getAddress(Matcher matcher) {
        return matcher.group(1);
    }
}

