/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.queue.DirectoryUtils;
import net.openhft.chronicle.queue.QueueTestCommon;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.MethodFilterOnFirstArg;
import org.junit.Assert;
import org.junit.Test;

public class IgnoreMethodBasedOnFirstArgTest
extends QueueTestCommon {
    private static final String EXPECTED_ENVELOPE = "for:rob";
    private static final String MSG = "hello world";

    @Test
    public void testIgnoreMethodBasedOnFirstArg() {
        try (SingleChronicleQueue build = SingleChronicleQueueBuilder.binary((File)DirectoryUtils.tempDir("q")).build();){
            Printer printer = (Printer)build.acquireAppender().methodWriter(Printer.class, new Class[0]);
            printer.print(EXPECTED_ENVELOPE, MSG);
            MethodReader mr = build.createTailer().methodReaderBuilder().build(new Object[]{new Printer(){

                public boolean ignoreMethodBasedOnFirstArg(String methodName, Object firstArg) {
                    Assert.assertEquals((Object)IgnoreMethodBasedOnFirstArgTest.EXPECTED_ENVELOPE, (Object)firstArg);
                    return false;
                }

                @Override
                public void print(String envelope, String msg) {
                    Assert.assertEquals((Object)IgnoreMethodBasedOnFirstArgTest.EXPECTED_ENVELOPE, (Object)envelope);
                    Assert.assertEquals((Object)IgnoreMethodBasedOnFirstArgTest.MSG, (Object)msg);
                }
            }});
            mr.readOne();
        }
    }

    static interface Printer
    extends MethodFilterOnFirstArg {
        public void print(String var1, String var2);
    }
}

