/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.cleanup;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.function.Function;
import java.util.stream.Stream;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class CleanupUnusedQueueFilesTest
extends ChronicleQueueTestBase {
    @Test
    public void testTailingWithEmptyCycles() {
        this.testTailing(p -> {
            try {
                p.execute();
            }
            catch (InvalidEventHandlerException e) {
                e.printStackTrace();
            }
            return 1;
        });
    }

    @Test
    public void testTailingWithMissingCycles() {
        this.testTailing(p -> 0);
    }

    private void testTailing(Function<Pretoucher, Integer> createGap) {
        SetTimeProvider tp = new SetTimeProvider(0L);
        File tmpDir = this.getTmpDir();
        try (SingleChronicleQueue queue = this.builder(tmpDir, WireType.BINARY).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).timeProvider((TimeProvider)tp).build();
             Pretoucher pretoucher = new Pretoucher(queue, null, c -> {}, true, true);){
            String text;
            int cyclesAdded = 0;
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeText((CharSequence)"0");
            Assert.assertEquals((long)1L, (long)this.listCQ4Files(tmpDir).length);
            tp.advanceMillis(1000L);
            appender.writeText((CharSequence)"1");
            Assert.assertEquals((long)2L, (long)this.listCQ4Files(tmpDir).length);
            tp.advanceMillis(2000L);
            Assert.assertEquals((long)(2 + (cyclesAdded += createGap.apply(pretoucher).intValue())), (long)this.listCQ4Files(tmpDir).length);
            tp.advanceMillis(1000L);
            appender.writeText((CharSequence)"2");
            Assert.assertEquals((long)(3 + cyclesAdded), (long)this.listCQ4Files(tmpDir).length);
            tp.advanceMillis(2000L);
            Assert.assertEquals((long)(3 + (cyclesAdded += createGap.apply(pretoucher).intValue())), (long)this.listCQ4Files(tmpDir).length);
            int count = 0;
            ExcerptTailer tailer = queue.createTailer();
            long[] indexes = new long[3];
            while ((text = tailer.readText()) != null) {
                indexes[count] = tailer.index() - 1L;
                Assert.assertEquals((long)count++, (long)Integer.parseInt(text));
            }
            Assert.assertEquals((long)indexes.length, (long)count);
            tailer.toStart();
            for (int i = 0; i < indexes.length; ++i) {
                Assert.assertTrue((boolean)tailer.moveToIndex(indexes[i]));
                String text2 = tailer.readText();
                Assert.assertEquals((long)i, (long)Integer.parseInt(text2));
            }
        }
    }

    @Nullable
    private File[] listCQ4Files(File tmpDir) {
        return tmpDir.listFiles(file -> file.getName().endsWith("cq4"));
    }

    @NotNull
    protected SingleChronicleQueueBuilder builder(@NotNull File file, @NotNull WireType wireType) {
        return SingleChronicleQueueBuilder.builder((File)file, (WireType)wireType).rollCycle((RollCycle)RollCycles.TEST4_DAILY).testBlockSize();
    }

    @NotNull
    private Stream<File> removableFileCandidates(@NotNull File baseDir) {
        File[] files = baseDir.listFiles(this::isChronicleQueue);
        if (files == null) {
            return Stream.empty();
        }
        return Stream.of(files).filter(this::isNotOpenByAnyProcess).sorted();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isNotOpenByAnyProcess(@NotNull File file) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
             FileChannel fileChannel = randomAccessFile.getChannel();){
            FileLock fileLock = fileChannel.tryLock();
            if (fileLock == null) return false;
            fileLock.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean isChronicleQueue(@NotNull File file) {
        return file.getName().endsWith("cq4");
    }
}

