/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.function.Consumer;
import net.openhft.chronicle.queue.reader.ChronicleReader;
import net.openhft.chronicle.queue.reader.ContentBasedLimiter;
import net.openhft.chronicle.wire.WireType;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jetbrains.annotations.NotNull;

public class ChronicleReaderMain {
    public static void main(@NotNull String[] args) {
        new ChronicleReaderMain().run(args);
    }

    public static void addOption(Options options, String opt, String argName, boolean hasArg, String description, boolean isRequired) {
        Option option = new Option(opt, hasArg, description);
        option.setArgName(argName);
        option.setRequired(isRequired);
        options.addOption(option);
    }

    protected void run(@NotNull String[] args) {
        Options options = this.options();
        CommandLine commandLine = this.parseCommandLine(args, options);
        ChronicleReader chronicleReader = this.chronicleReader();
        this.configureReader(chronicleReader, commandLine);
        chronicleReader.execute();
    }

    protected ChronicleReader chronicleReader() {
        return new ChronicleReader();
    }

    protected CommandLine parseCommandLine(@NotNull String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(options, args);
            if (commandLine.hasOption('h')) {
                this.printHelpAndExit(options, 0);
            }
        }
        catch (ParseException e) {
            this.printHelpAndExit(options, 1, e.getMessage());
        }
        return commandLine;
    }

    protected void printHelpAndExit(Options options, int status) {
        this.printHelpAndExit(options, status, null);
    }

    protected void printHelpAndExit(Options options, int status, String message) {
        PrintWriter writer = new PrintWriter(System.out);
        new HelpFormatter().printHelp(writer, 180, this.getClass().getSimpleName(), message, options, 1, 3, null, true);
        writer.flush();
        System.exit(status);
    }

    protected void configureReader(ChronicleReader chronicleReader, CommandLine commandLine) {
        Consumer<String> messageSink = commandLine.hasOption('l') ? s -> System.out.println(s.replaceAll("\n", "")) : System.out::println;
        ((ChronicleReader)chronicleReader.withMessageSink((Consumer)messageSink)).withBasePath(Paths.get(commandLine.getOptionValue('d'), new String[0]));
        if (commandLine.hasOption('i')) {
            Arrays.stream(commandLine.getOptionValues('i')).forEach(chronicleReader::withInclusionRegex);
        }
        if (commandLine.hasOption('e')) {
            Arrays.stream(commandLine.getOptionValues('e')).forEach(chronicleReader::withExclusionRegex);
        }
        if (commandLine.hasOption('f')) {
            chronicleReader.tail();
        }
        if (commandLine.hasOption('m')) {
            chronicleReader.historyRecords(Long.parseLong(commandLine.getOptionValue('m')));
        }
        if (commandLine.hasOption('n')) {
            chronicleReader.withStartIndex(Long.decode(commandLine.getOptionValue('n')));
        }
        if (commandLine.hasOption('r')) {
            String r = commandLine.getOptionValue('r');
            chronicleReader.asMethodReader(r.equals("null") ? "" : r);
            chronicleReader.showMessageHistory(commandLine.hasOption('g'));
        }
        if (commandLine.hasOption('w')) {
            chronicleReader.withWireType(WireType.valueOf(commandLine.getOptionValue('w')));
        }
        if (commandLine.hasOption('s')) {
            chronicleReader.suppressDisplayIndex();
        }
        if (commandLine.hasOption('z')) {
            System.setProperty("timestampLongConverters.zoneId", ZoneId.systemDefault().toString());
        }
        if (commandLine.hasOption('a')) {
            chronicleReader.withArg(commandLine.getOptionValue('a'));
        }
        if (commandLine.hasOption('b')) {
            chronicleReader.withBinarySearch(commandLine.getOptionValue('b'));
        }
        if (commandLine.hasOption('k')) {
            chronicleReader.inReverseOrder();
        }
        if (commandLine.hasOption('x')) {
            chronicleReader.withMatchLimit(Long.parseLong(commandLine.getOptionValue('x')));
        }
        if (commandLine.hasOption("cbl")) {
            String cbl = commandLine.getOptionValue("cbl");
            try {
                chronicleReader.withContentBasedLimiter((ContentBasedLimiter)Class.forName(cbl).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Error creating content-based limiter, could not find class: " + cbl, e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Error creating content-based limiter, it must have a no-argument constructor", e);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Error creating content-based limiter, it must implement " + ContentBasedLimiter.class.getName(), e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new IllegalArgumentException("Error creating content-based-limiter class: " + cbl, e);
            }
        }
        if (commandLine.hasOption("cblArg")) {
            chronicleReader.withLimiterArg(commandLine.getOptionValue("cblArg"));
        }
    }

    @NotNull
    protected Options options() {
        Options options = new Options();
        ChronicleReaderMain.addOption(options, "d", "directory", true, "Directory containing chronicle queue files", true);
        ChronicleReaderMain.addOption(options, "i", "include-regex", true, "Display records containing this regular expression", false);
        ChronicleReaderMain.addOption(options, "e", "exclude-regex", true, "Do not display records containing this regular expression", false);
        ChronicleReaderMain.addOption(options, "f", "follow", false, "Tail behaviour - wait for new records to arrive", false);
        ChronicleReaderMain.addOption(options, "m", "max-history", true, "Show this many records from the end of the data set", false);
        ChronicleReaderMain.addOption(options, "n", "from-index", true, "Start reading from this index (e.g. 0x123ABE)", false);
        ChronicleReaderMain.addOption(options, "b", "binary-search", true, "Use this class as a comparator to binary search", false);
        ChronicleReaderMain.addOption(options, "a", "binary-arg", true, "Argument to pass to binary search class", false);
        ChronicleReaderMain.addOption(options, "r", "as-method-reader", true, "Use when reading from a queue generated using a MethodWriter", false);
        ChronicleReaderMain.addOption(options, "g", "message-history", false, "Show message history (when using method reader)", false);
        ChronicleReaderMain.addOption(options, "w", "wire-type", true, "Control output i.e. JSON", false);
        ChronicleReaderMain.addOption(options, "s", "suppress-index", false, "Display index", false);
        ChronicleReaderMain.addOption(options, "l", "single-line", false, "Squash each output message into a single line", false);
        ChronicleReaderMain.addOption(options, "z", "use-local-timezone", false, "Print timestamps using the local timezone", false);
        ChronicleReaderMain.addOption(options, "k", "reverse", false, "Read the queue in reverse", false);
        ChronicleReaderMain.addOption(options, "h", "help-message", false, "Print this help and exit", false);
        ChronicleReaderMain.addOption(options, "x", "max-results", true, "Limit the number of results to output", false);
        ChronicleReaderMain.addOption(options, "cbl", "content-based-limiter", true, "Specify a content-based limiter", false);
        ChronicleReaderMain.addOption(options, "cblArg", "content-based-limiter-argument", true, "Specify an argument for use by the content-based limiter", false);
        return options;
    }
}

