/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.internal.util.MapUtil;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.EnumCache;
import net.openhft.chronicle.core.util.ClassNotFoundRuntimeException;
import net.openhft.chronicle.core.util.CoreDynamicEnum;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.core.util.ThrowingSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectUtils {
    static final Map<Class<?>, Class<?>> PRIM_MAP = MapUtil.ofUnmodifiable(MapUtil.entry(Boolean.TYPE, Boolean.class), MapUtil.entry(Byte.TYPE, Byte.class), MapUtil.entry(Character.TYPE, Character.class), MapUtil.entry(Short.TYPE, Short.class), MapUtil.entry(Integer.TYPE, Integer.class), MapUtil.entry(Float.TYPE, Float.class), MapUtil.entry(Long.TYPE, Long.class), MapUtil.entry(Double.TYPE, Double.class), MapUtil.entry(Void.TYPE, Void.class));
    static final Map<Class<?>, Object> DEFAULT_MAP = MapUtil.ofUnmodifiable(MapUtil.entry(Boolean.TYPE, false), MapUtil.entry(Byte.TYPE, (byte)0), MapUtil.entry(Short.TYPE, (short)0), MapUtil.entry(Character.TYPE, Character.valueOf('\u0000')), MapUtil.entry(Integer.TYPE, 0), MapUtil.entry(Long.TYPE, 0L), MapUtil.entry(Float.TYPE, Float.valueOf(0.0f)), MapUtil.entry(Double.TYPE, 0.0));
    static final ClassLocal<ThrowingFunction<String, Object, Exception>> PARSER_CL = ClassLocal.withInitial(new ConversionFunction());
    static final ClassLocal<Map<String, Enum<?>>> CASE_IGNORE_LOOKUP = ClassLocal.withInitial(ObjectUtils::caseIgnoreLookup);
    static final ClassValue<Method> READ_RESOLVE = ClassLocal.withInitial(c -> {
        try {
            Method m = c.getDeclaredMethod("readResolve", new Class[0]);
            Jvm.setAccessible(m);
            return m;
        }
        catch (NoSuchMethodException expected) {
            return null;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    });
    private static final Map<Class<?>, Immutability> IMMUTABILITY_MAP = new ConcurrentHashMap();
    private static volatile ClassLocal<Class<?>> interfaceToDefaultClass = ClassLocal.withInitial(ObjectUtils::lookForImplEnum);
    private static volatile ClassLocal<Supplier<?>> supplierClassLocal = ClassLocal.withInitial(ObjectUtils::supplierForClass);

    private ObjectUtils() {
    }

    private static Supplier<?> supplierForClass(Class<?> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c.isPrimitive()) {
            Jvm.rethrow(new IllegalArgumentException("primitive: " + c.getName()));
        }
        if (c.isInterface()) {
            return () -> {
                Class aClass = (Class)interfaceToDefaultClass.get(c);
                if (aClass == null) {
                    Jvm.rethrow(new IllegalArgumentException("interface: " + c.getName()));
                }
                return ObjectUtils.supplierForClass(aClass);
            };
        }
        if (c.isEnum()) {
            return () -> {
                try {
                    return OS.memory().allocateInstance(c);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            };
        }
        if (Modifier.isAbstract(c.getModifiers())) {
            Jvm.rethrow(new IllegalArgumentException("abstract class: " + c.getName()));
        }
        try {
            Constructor<?> constructor = c.getDeclaredConstructor(new Class[0]);
            Jvm.setAccessible(constructor);
            return ThrowingSupplier.asSupplier(() -> constructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            return () -> {
                try {
                    return OS.memory().allocateInstance(c);
                }
                catch (InstantiationException e1) {
                    throw Jvm.rethrow(e1);
                }
            };
        }
    }

    public static void immutabile(Class<?> clazz, boolean isImmutable) {
        IMMUTABILITY_MAP.put(clazz, isImmutable ? Immutability.YES : Immutability.NO);
    }

    public static Immutability isImmutable(@NotNull Class<?> clazz) {
        Immutability immutability = IMMUTABILITY_MAP.get(clazz);
        if (immutability == null) {
            return Comparable.class.isAssignableFrom(clazz) ? Immutability.MAYBE : Immutability.NO;
        }
        return immutability;
    }

    public static boolean isTrue(CharSequence s) {
        if (s == null) {
            return false;
        }
        switch (s.length()) {
            case 1: {
                try {
                    char ch = Character.toLowerCase(s.charAt(0));
                    return ch == 't' || ch == 'y';
                }
                catch (IndexOutOfBoundsException e) {
                    throw new AssertionError((Object)e);
                }
            }
            case 3: {
                return ObjectUtils.equalsCaseIgnore(s, "yes");
            }
            case 4: {
                return ObjectUtils.equalsCaseIgnore(s, "true");
            }
        }
        return false;
    }

    public static boolean isFalse(CharSequence s) {
        if (s == null) {
            return false;
        }
        switch (s.length()) {
            case 1: {
                try {
                    char ch = Character.toLowerCase(s.charAt(0));
                    return ch == 'f' || ch == 'n';
                }
                catch (IndexOutOfBoundsException e) {
                    throw new AssertionError((Object)e);
                }
            }
            case 2: {
                return ObjectUtils.equalsCaseIgnore(s, "no");
            }
            case 5: {
                return ObjectUtils.equalsCaseIgnore(s, "false");
            }
        }
        return false;
    }

    private static boolean equalsCaseIgnore(CharSequence cs, String s) {
        if (cs instanceof String) {
            return ((String)cs).equalsIgnoreCase(s);
        }
        return StringUtils.equalsCaseIgnore(cs, s);
    }

    public static Class primToWrapper(Class<?> eClass) {
        Class<?> clazz0 = PRIM_MAP.get(eClass);
        if (clazz0 != null) {
            eClass = clazz0;
        }
        return eClass;
    }

    @Nullable
    public static <E> E convertTo(@Nullable Class<E> eClass, @Nullable Object o) throws ClassCastException, IllegalArgumentException {
        return (E)(eClass == null || o == null || eClass.isInstance(o) ? o : ObjectUtils.convertTo0(eClass, o));
    }

    @NotNull
    private static Map<String, Enum<?>> caseIgnoreLookup(@NotNull Class<?> c) {
        @NotNull TreeMap<String, Enum<?>> map = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        for (Object o : c.getEnumConstants()) {
            @NotNull Enum e = (Enum)o;
            map.put(e.name().toUpperCase(), e);
        }
        return map;
    }

    @NotNull
    public static <E extends Enum<E>> E valueOfIgnoreCase(@NotNull Class<E> eClass, @NotNull String name) {
        Map map = (Map)CASE_IGNORE_LOOKUP.get(eClass);
        if (name.startsWith("{") && name.endsWith("}")) {
            return ObjectUtils.getSingletonForEnum(eClass);
        }
        @NotNull Enum anEnum = (Enum)map.get(name);
        return (E)(anEnum == null ? (Enum)EnumCache.of(eClass).valueOf(name) : anEnum);
    }

    public static <E extends Enum<E>> E getSingletonForEnum(Class<E> eClass) {
        Enum[] enumConstants = (Enum[])eClass.getEnumConstants();
        if (enumConstants.length == 0) {
            throw new AssertionError((Object)("Cannot convert marshallable to " + eClass + " as it doesn't have any instances"));
        }
        if (enumConstants.length > 1) {
            Jvm.warn().on(ObjectUtils.class, eClass + " has multiple INSTANCEs, picking the first one");
        }
        return (E)enumConstants[0];
    }

    static <E> E convertTo0(Class<E> eClass, @Nullable Object o) throws NumberFormatException {
        if ((eClass = ObjectUtils.primToWrapper(eClass)).isInstance(o) || o == null) {
            return (E)o;
        }
        if (eClass == Void.class) {
            return null;
        }
        if (eClass == String.class) {
            return (E)o.toString();
        }
        if (Enum.class.isAssignableFrom(eClass)) {
            return ObjectUtils.valueOfIgnoreCase(eClass, o.toString());
        }
        if (o instanceof CharSequence) {
            @Nullable CharSequence cs = (CharSequence)o;
            if (Character.class.equals((Object)eClass)) {
                if (cs.length() > 0) {
                    try {
                        return (E)Character.valueOf(cs.charAt(0));
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                return null;
            }
            @NotNull String s = cs.toString();
            if (eClass == String.class) {
                return (E)s;
            }
            try {
                return (E)((ThrowingFunction)PARSER_CL.get(eClass)).apply(s);
            }
            catch (Exception e) {
                throw ObjectUtils.asCCE(e);
            }
        }
        if (Number.class.isAssignableFrom(eClass)) {
            return (E)ObjectUtils.convertToNumber(eClass, o);
        }
        if (ReadResolvable.class.isAssignableFrom(eClass)) {
            return (E)o;
        }
        if (Object[].class.isAssignableFrom(eClass)) {
            return ObjectUtils.convertToArray(eClass, o);
        }
        if (Set.class.isAssignableFrom(eClass)) {
            return (E)new LinkedHashSet((Collection)o);
        }
        if (Character.class == eClass) {
            String s = o.toString();
            if (s.length() == 1) {
                return (E)Character.valueOf(s.charAt(0));
            }
            if (s.isEmpty()) {
                return (E)Character.valueOf('\u0000');
            }
        }
        if (CharSequence.class.isAssignableFrom(eClass)) {
            try {
                return (E)((ThrowingFunction)PARSER_CL.get(eClass)).apply(o.toString());
            }
            catch (Exception e) {
                throw ObjectUtils.asCCE(e);
            }
        }
        throw new ClassCastException("Unable to convert " + o.getClass() + " " + o + " to " + eClass);
    }

    @NotNull
    public static ClassCastException asCCE(Exception e) {
        @NotNull ClassCastException cce = new ClassCastException();
        cce.initCause(e);
        return cce;
    }

    @NotNull
    private static <E> E convertToArray(@NotNull Class<E> eClass, Object o) {
        int len = ObjectUtils.sizeOf(o);
        Object array = Array.newInstance(eClass.getComponentType(), len);
        Iterator<?> iter = ObjectUtils.iteratorFor(o);
        Class<?> elementType = ObjectUtils.elementType(eClass);
        try {
            for (int i = 0; i < len; ++i) {
                @Nullable ? value = ObjectUtils.convertTo(elementType, iter.next());
                Array.set(array, i, value);
            }
        }
        catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        return (E)array;
    }

    private static <E> Class<?> elementType(@NotNull Class<E> eClass) {
        if (Object[].class.isAssignableFrom(eClass)) {
            return eClass.getComponentType();
        }
        return Object.class;
    }

    private static Iterator<?> iteratorFor(Object o) {
        if (o instanceof Iterable) {
            return ((Iterable)o).iterator();
        }
        if (o instanceof Object[]) {
            return Arrays.asList((Object[])o).iterator();
        }
        throw new UnsupportedOperationException();
    }

    private static int sizeOf(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        try {
            if (o.getClass().isArray()) {
                return Array.getLength(o);
            }
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        throw new UnsupportedOperationException();
    }

    private static Number convertToNumber(Class<?> eClass, Object o) throws NumberFormatException {
        if (o instanceof Number) {
            @NotNull Number n = (Number)o;
            if (eClass == Double.class) {
                return n.doubleValue();
            }
            if (eClass == Long.class) {
                return n.longValue();
            }
            if (eClass == Integer.class) {
                return n.intValue();
            }
            if (eClass == Float.class) {
                return Float.valueOf(n.floatValue());
            }
            if (eClass == Short.class) {
                return n.shortValue();
            }
            if (eClass == Byte.class) {
                return n.byteValue();
            }
            if (eClass == BigDecimal.class) {
                return n instanceof Long ? BigDecimal.valueOf(n.longValue()) : BigDecimal.valueOf(n.doubleValue());
            }
            if (eClass == BigInteger.class) {
                return new BigInteger(o.toString());
            }
        } else {
            String s = o.toString();
            if (eClass == Double.class) {
                return Double.parseDouble(s);
            }
            if (eClass == Long.class) {
                return Long.parseLong(s);
            }
            if (eClass == Integer.class) {
                return Integer.parseInt(s);
            }
            if (eClass == Float.class) {
                return Float.valueOf(Float.parseFloat(s));
            }
            if (eClass == Short.class) {
                return Short.parseShort(s);
            }
            if (eClass == Byte.class) {
                return Byte.parseByte(s);
            }
            if (eClass == BigDecimal.class) {
                return new BigDecimal(s);
            }
            if (eClass == BigInteger.class) {
                return new BigInteger(s);
            }
        }
        throw new UnsupportedOperationException("Cannot convert " + o.getClass() + " to " + eClass);
    }

    @NotNull
    public static <T> T newInstance(@NotNull String className) {
        return (T)ObjectUtils.newInstance(ClassAliasPool.CLASS_ALIASES.forName(className));
    }

    @NotNull
    public static <T> T newInstance(@NotNull Class<T> clazz) {
        Supplier cons = (Supplier)supplierClassLocal.get(clazz);
        return cons.get();
    }

    @Nullable
    public static Object newInstanceOrNull(Class<?> type) {
        try {
            return ObjectUtils.newInstance(type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T[] addAll(@NotNull T first, T ... additional) {
        Object[] interfaces;
        if (additional.length == 0) {
            interfaces = (Object[])Array.newInstance(first.getClass(), 1);
            interfaces[0] = first;
        } else {
            @NotNull ArrayList<T> objs = new ArrayList<T>();
            objs.add(first);
            Collections.addAll(objs, additional);
            interfaces = objs.toArray((Object[])Array.newInstance(first.getClass(), objs.size()));
        }
        return interfaces;
    }

    public static boolean matchingClass(@NotNull Class<?> base, @NotNull Class<?> toMatch) {
        return base == toMatch || base.isInterface() && interfaceToDefaultClass.get(base) == toMatch || Enum.class.isAssignableFrom(toMatch) && base.equals(toMatch.getEnclosingClass());
    }

    public static Object defaultValue(Class<?> type) {
        return DEFAULT_MAP.get(type);
    }

    @NotNull
    public static <T> T onMethodCall(final @NotNull BiFunction<Method, Object[], Object> biFunction, @NotNull Class<T> tClass, Class<?> ... additional) throws IllegalArgumentException {
        Class<?>[] interfaces = ObjectUtils.addAll(tClass, additional);
        return (T)Proxy.newProxyInstance(tClass.getClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                return biFunction.apply(method, args);
            }
        });
    }

    public static boolean isConcreteClass(@NotNull Class<?> tClass) {
        return (tClass.getModifiers() & 0x600) == 0;
    }

    public static Object readResolve(@NotNull Object o) {
        Method readResove = READ_RESOLVE.get(o.getClass());
        if (readResove == null) {
            return o;
        }
        try {
            return readResove.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw Jvm.rethrow(e);
        }
        catch (InvocationTargetException e) {
            throw Jvm.rethrow(e.getCause());
        }
    }

    @Nullable
    public static Boolean toBoolean(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if (ObjectUtils.isTrue(s = s.trim())) {
            return Boolean.TRUE;
        }
        if (ObjectUtils.isFalse(s)) {
            return Boolean.FALSE;
        }
        if (s.isEmpty()) {
            return null;
        }
        Jvm.debug().on(ObjectUtils.class, "Treating '" + s + "' as false");
        return Boolean.FALSE;
    }

    public static Class<?>[] getAllInterfaces(Object o) {
        try {
            HashSet results = new HashSet();
            ObjectUtils.getAllInterfaces(o, results::add);
            return results.toArray(new Class[results.size()]);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void getAllInterfaces(Object o, Function<Class<?>, Boolean> accumulator) throws IllegalArgumentException {
        if (null == o) {
            return;
        }
        if (null == accumulator) {
            throw new IllegalArgumentException("Accumulator cannot be null");
        }
        if (o instanceof Class) {
            Class clazz = (Class)o;
            if (clazz.isInterface()) {
                if (Boolean.TRUE.equals(accumulator.apply((Class)o))) {
                    for (Class<?> aClass : clazz.getInterfaces()) {
                        ObjectUtils.getAllInterfaces(aClass, accumulator);
                    }
                }
            } else {
                if (null != clazz.getSuperclass()) {
                    ObjectUtils.getAllInterfaces(clazz.getSuperclass(), accumulator);
                }
                for (Class<?> aClass : clazz.getInterfaces()) {
                    ObjectUtils.getAllInterfaces(aClass, accumulator);
                }
            }
        } else {
            ObjectUtils.getAllInterfaces(o.getClass(), accumulator);
        }
    }

    public static synchronized void defaultObjectForInterface(ThrowingFunction<Class<?>, Class<?>, ClassNotFoundException> defaultObjectForInterface) {
        interfaceToDefaultClass = ClassLocal.withInitial(c -> {
            Class c2;
            try {
                c2 = (Class)defaultObjectForInterface.apply((Class<?>)c);
            }
            catch (ClassNotFoundException cne) {
                Jvm.warn().on(ObjectUtils.class, "Unable to find alias for " + c + " " + cne);
                c2 = c;
            }
            return ObjectUtils.lookForImplEnum(c2);
        });
        supplierClassLocal = ClassLocal.withInitial(ObjectUtils::supplierForClass);
    }

    @NotNull
    static Class<?> lookForImplEnum(Class<?> c2) {
        if (c2.isInterface()) {
            try {
                Class<?> c3 = ClassAliasPool.CLASS_ALIASES.forName(c2.getName() + "s");
                if (c2.isAssignableFrom(c3)) {
                    return c3;
                }
            }
            catch (ClassNotFoundRuntimeException classNotFoundRuntimeException) {
                // empty catch block
            }
        }
        return c2;
    }

    public static <T> Class<T> implementationToUse(Class<T> tClass) {
        Class class2;
        if (tClass.isInterface() && (class2 = (Class)interfaceToDefaultClass.get(tClass)) != null) {
            return class2;
        }
        return tClass;
    }

    public static <T> T requireNonNull(@NotNull T o) {
        o.getClass();
        return o;
    }

    private static final class ConversionFunction
    implements Function<Class<?>, ThrowingFunction<String, Object, Exception>> {
        private ConversionFunction() {
        }

        @Override
        public ThrowingFunction<String, Object, Exception> apply(@NotNull Class<?> c) {
            if (c == Class.class) {
                return ClassAliasPool.CLASS_ALIASES::forName;
            }
            if (c == Boolean.class) {
                return ObjectUtils::toBoolean;
            }
            if (c == UUID.class) {
                return UUID::fromString;
            }
            if (CoreDynamicEnum.class.isAssignableFrom(c)) {
                return EnumCache.of(c)::get;
            }
            try {
                Method valueOf = c.getDeclaredMethod("valueOf", String.class);
                Jvm.setAccessible(valueOf);
                return s -> valueOf.invoke(null, s);
            }
            catch (NoSuchMethodException valueOf) {
                try {
                    Method parse = c.getDeclaredMethod("parse", CharSequence.class);
                    Jvm.setAccessible(parse);
                    return s -> parse.invoke(null, s);
                }
                catch (NoSuchMethodException parse) {
                    try {
                        Constructor<?> constructor = c.getDeclaredConstructor(String.class);
                        Jvm.setAccessible(constructor);
                        return xva$0 -> constructor.newInstance(xva$0);
                    }
                    catch (Exception e) {
                        throw ObjectUtils.asCCE(e);
                    }
                }
            }
        }
    }

    public static enum Immutability {
        YES,
        NO,
        MAYBE;

    }
}

