/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Test;

public class ToEndPaddingTest
extends ChronicleQueueTestBase {
    @Test
    public void toEndWorksWithDifferentlyPaddedMessages() {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.single((File)this.getTmpDir()).testBlockSize().rollCycle((RollCycle)RollCycles.TEST8_DAILY).build();){
            DocumentContext dc;
            Object text2;
            ExcerptAppender appender = queue.acquireAppender();
            ExcerptTailer tailer = queue.createTailer();
            try (DocumentContext documentContext = appender.acquireWritingDocument(false);){
                documentContext.wire().write((CharSequence)"start").text("start");
            }
            try (DocumentContext documentContext = tailer.readingDocument(false);){
                Assert.assertTrue((boolean)documentContext.isPresent());
                text2 = documentContext.wire().read().text();
                Assert.assertEquals((Object)"start", (Object)text2);
                dc = documentContext;
            }
            for (int i = 0; i < 2; ++i) {
                DocumentContext documentContext = appender.acquireWritingDocument(true);
                text2 = null;
                try {
                    documentContext.wire().write((CharSequence)("metakey" + i)).text((BytesStore)Bytes.wrapForRead((byte[])new byte[i + 1]));
                    continue;
                }
                catch (Throwable throwable) {
                    text2 = throwable;
                    throw throwable;
                }
                finally {
                    if (documentContext != null) {
                        if (text2 != null) {
                            try {
                                documentContext.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)text2).addSuppressed(throwable);
                            }
                        } else {
                            documentContext.close();
                        }
                    }
                }
            }
            Assert.assertEquals((long)2336L, (long)dc.wire().bytes().readPosition());
            tailer.toEnd();
            Assert.assertEquals((long)2368L, (long)dc.wire().bytes().readPosition());
            documentContext = appender.acquireWritingDocument(false);
            var7_13 = null;
            try {
                documentContext.wire().write((CharSequence)"key").text("value");
            }
            catch (Throwable text2) {
                var7_13 = text2;
                throw text2;
            }
            finally {
                if (documentContext != null) {
                    if (var7_13 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable text2) {
                            var7_13.addSuppressed(text2);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
            documentContext = tailer.readingDocument(false);
            var7_13 = null;
            try {
                Assert.assertTrue((boolean)documentContext.isPresent());
                text2 = documentContext.wire().read().text();
                Assert.assertEquals((Object)"value", (Object)text2);
            }
            catch (Throwable throwable) {
                var7_13 = throwable;
                throw throwable;
            }
            finally {
                if (documentContext != null) {
                    if (var7_13 != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable) {
                            var7_13.addSuppressed(throwable);
                        }
                    } else {
                        documentContext.close();
                    }
                }
            }
        }
    }
}

