/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Mocker;
import net.openhft.chronicle.core.util.IgnoresEverything;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.wire.AbstractMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.IntConversion;
import net.openhft.chronicle.wire.IntConverter;
import net.openhft.chronicle.wire.LongConversion;
import net.openhft.chronicle.wire.LongConverter;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.RawText;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteDocumentContext;
import org.jetbrains.annotations.NotNull;

public class TextMethodWriterInvocationHandler
extends AbstractMethodWriterInvocationHandler {
    @NotNull
    private final Supplier<MarshallableOut> marshallableOutSupplier;
    private final Map<Method, Consumer<Object[]>> visitorConverter = new LinkedHashMap<Method, Consumer<Object[]>>();
    static final Consumer<Object[]> NOOP_CONSUMER = Mocker.ignored(Consumer.class, new Class[0]);

    TextMethodWriterInvocationHandler(Class tClass, @NotNull MarshallableOut marshallableOut) {
        this(tClass, () -> marshallableOut);
    }

    public TextMethodWriterInvocationHandler(Class tClass, @NotNull Supplier<MarshallableOut> marshallableOutSupplier) {
        super(tClass);
        this.marshallableOutSupplier = marshallableOutSupplier;
    }

    @Override
    protected Object doInvoke(Object proxy, Method method, Object[] args) {
        if (method.getName().equals("writingDocument") && method.getParameterCount() == 0) {
            MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
            return marshallableOut.writingDocument();
        }
        return super.doInvoke(proxy, method, args);
    }

    @Override
    protected void handleInvoke(Method method, Object[] args) {
        this.visitorConverter.computeIfAbsent(method, this::buildConverter).accept(args);
        boolean chained = method.getReturnType().isInterface();
        MarshallableOut marshallableOut = this.marshallableOutSupplier.get();
        try (WriteDocumentContext dc = (WriteDocumentContext)marshallableOut.acquireWritingDocument(false);){
            try {
                dc.chainedElement(chained);
                Wire wire = dc.wire();
                this.handleInvoke(method, args, wire);
            }
            catch (Throwable t) {
                dc.rollbackOnClose();
                throw Jvm.rethrow(t);
            }
        }
    }

    private Consumer<Object[]> buildConverter(Method method) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        if (parameterAnnotations.length <= 0) {
            return NOOP_CONSUMER;
        }
        for (Annotation anno : parameterAnnotations[0]) {
            if (anno instanceof LongConversion) {
                LongConversion longConversion = (LongConversion)anno;
                LongConverter ic = ObjectUtils.newInstance(longConversion.value());
                return a -> {
                    if (a[0] instanceof Number) {
                        StringBuilder sb = Wires.acquireStringBuilder();
                        ic.append(sb, ((Number)a[0]).longValue());
                        a[0] = new RawText(sb);
                    }
                };
            }
            if (!(anno instanceof IntConversion)) continue;
            IntConversion intConversion = (IntConversion)anno;
            IntConverter ic = ObjectUtils.newInstance(intConversion.value());
            return a -> {
                if (a[0] instanceof Number) {
                    StringBuilder sb = Wires.acquireStringBuilder();
                    ic.append(sb, ((Number)a[0]).intValue());
                    a[0] = new RawText(sb);
                }
            };
        }
        return NOOP_CONSUMER;
    }

    @Deprecated
    static enum NoOp implements Consumer<Object[]>,
    IgnoresEverything
    {
        INSTANCE;


        @Override
        public void accept(Object[] objects) {
        }
    }
}

