/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.threads;

import java.io.File;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.core.threads.ThreadLock;
import net.openhft.chronicle.core.values.LongValue;

public class VanillaThreadLock
implements ThreadLock {
    static final Metrics METRICS = new Metrics();
    private static final long TOP_BITS = -4294967296L;
    private static final int UNLOCKED = 0;
    private final LongValue twoThreadId;
    private final long timeoutMs;
    int busyLoopCount = 20000;
    int busyLockSlowerCount = 100;
    private long oldLock;

    public VanillaThreadLock(LongValue twoThreadId, long timeoutMs) {
        this.twoThreadId = twoThreadId;
        this.timeoutMs = timeoutMs;
    }

    @Override
    public boolean tryLock(int threadId) throws IllegalStateException {
        if (threadId == 0) {
            throw new IllegalArgumentException();
        }
        long twoThreadId0 = this.twoThreadId.getVolatileValue();
        int threadId0 = (int)twoThreadId0;
        if (threadId0 != 0) {
            if (threadId0 == threadId) {
                throw new IllegalStateException("trying to lock twice");
            }
            return false;
        }
        return this.twoThreadId.compareAndSwapValue(twoThreadId0, twoThreadId0 & 0xFFFFFFFF00000000L | (long)threadId);
    }

    @Override
    public void lock(int threadId) throws InterruptedRuntimeException {
        if (this.tryLock(threadId)) {
            return;
        }
        this.busyLock(threadId);
    }

    private void busyLock(int threadId) {
        for (int i = 0; i < this.busyLoopCount; ++i) {
            if (this.tryLock(threadId)) {
                return;
            }
            Jvm.nanoPause();
        }
        if (this.busyLockSlower(threadId)) {
            return;
        }
        this.forceUnlockAndRetry(threadId);
    }

    private boolean busyLockSlower(int threadId) throws InterruptedRuntimeException {
        this.oldLock = 0L;
        long startMS = System.currentTimeMillis();
        long prevDelayMS = 0L;
        long endMS = startMS + this.timeoutMs;
        do {
            int lockedThread;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedRuntimeException();
            }
            long currLock = this.twoThreadId.getVolatileValue();
            if (this.oldLock == 0L) {
                this.oldLock = currLock;
            }
            int lastThreadId = (int)currLock;
            for (int i = 0; i < this.busyLockSlowerCount; ++i) {
                if (this.tryLock(threadId)) {
                    return true;
                }
                int currThreadId = (int)this.twoThreadId.getVolatileValue();
                if (currThreadId != lastThreadId) {
                    Jvm.perf().on(this.getClass(), "Owning thread changed from " + lastThreadId + " to " + currThreadId);
                    lastThreadId = currThreadId;
                    this.oldLock = currLock;
                    endMS = System.currentTimeMillis() + this.timeoutMs;
                }
                Thread.yield();
            }
            if (!VanillaThreadLock.METRICS.supportsProc || (lockedThread = (int)this.twoThreadId.getVolatileValue()) == 0) continue;
            if (this.isThreadRunning(lockedThread)) {
                long delayMS = System.currentTimeMillis() - startMS;
                if (delayMS <= prevDelayMS) continue;
                Jvm.warn().on(this.getClass(), "ThreadId " + lockedThread + " is running while still holding a lock after " + delayMS + " ms.");
                prevDelayMS = delayMS;
                continue;
            }
            Jvm.warn().on(this.getClass(), "ThreadId " + lockedThread + " died while holding a lock");
            return false;
        } while (System.currentTimeMillis() < endMS);
        return false;
    }

    private boolean isThreadRunning(int lockedThread) {
        return new File("/proc/" + lockedThread).exists();
    }

    private void forceUnlockAndRetry(int threadId) {
        long twoThreadId0 = this.twoThreadId.getVolatileValue();
        int threadId0 = (int)twoThreadId0;
        if (threadId0 != 0 && twoThreadId0 == this.oldLock) {
            if (this.twoThreadId.compareAndSwapValue(this.oldLock, (long)threadId0 << 32 | 0L)) {
                String status = VanillaThreadLock.METRICS.supportsProc ? (this.isThreadRunning(threadId0) ? "running" : "dead") : "unknown";
                Jvm.warn().on(this.getClass(), "Successfully forced an unlock for threadId: " + threadId + ", previous thread held by: " + threadId0 + ", status: " + status);
            } else {
                Jvm.warn().on(this.getClass(), "Failed to forced an unlock for threadId: " + threadId);
            }
        }
        this.lock(threadId);
    }

    @Override
    public void unlock(int threadId) throws IllegalStateException {
        long twoThreadId0 = this.twoThreadId.getVolatileValue();
        int threadId0 = (int)twoThreadId0;
        if (threadId0 != threadId) {
            this.unlock2(threadId, twoThreadId0, threadId0);
            return;
        }
        if (this.twoThreadId.compareAndSwapValue(twoThreadId0, (long)threadId << 32 | 0L)) {
            return;
        }
        Jvm.warn().on(this.getClass(), "Failed to unlock");
    }

    private void unlock2(int threadId, long twoThreadId0, int threadId0) throws IllegalStateException {
        if (threadId0 == 0) {
            int prevThreadId = (int)(twoThreadId0 >>> 32);
            if (prevThreadId == threadId) {
                throw new IllegalStateException("Lock already unlocked by threadId " + threadId);
            }
            Jvm.warn().on(this.getClass(), "Lock previously held by another thread " + prevThreadId + " not mine " + threadId);
        } else {
            Jvm.warn().on(this.getClass(), "Lock held by another thread " + threadId0 + " not mine " + threadId);
        }
    }

    static class Metrics {
        final boolean supportsProc = new File("/proc").isDirectory();

        Metrics() {
            if (OS.isLinux() && !this.supportsProc) {
                Jvm.warn().on(this.getClass(), "/proc not found on Linux");
            }
        }
    }
}

