/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.reader;

import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.chronicle.bytes.MethodId;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.reader.ChronicleHistoryReader;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class ChronicleHistoryReaderTest
extends ChronicleQueueTestBase {
    @Test
    public void testWithQueueHistoryRecordHistoryInitial() {
        if (OS.isWindows()) {
            this.expectException("Read-only mode is not supported on Windows");
        }
        this.checkWithQueueHistoryRecordHistoryInitial(DummyListener.class);
    }

    @Test
    public void testWithQueueHistoryRecordHistoryInitialMethodIds() {
        if (OS.isWindows()) {
            this.expectException("Read-only mode is not supported on Windows");
        }
        this.checkWithQueueHistoryRecordHistoryInitial(DummyListenerId.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkWithQueueHistoryRecordHistoryInitial(Class<? extends DummyListener> dummyClass) {
        this.expectException("Overriding sourceId from existing metadata, was 0, overriding to");
        SetTimeMessageHistory mh = new SetTimeMessageHistory();
        mh.addSourceDetails(true);
        MessageHistory.set((MessageHistory)mh);
        int extraTiming = 1;
        File queuePath1 = IOTools.createTempFile((String)(this.testName.getMethodName() + "1-"));
        File queuePath2 = IOTools.createTempFile((String)(this.testName.getMethodName() + "2-"));
        File queuePath3 = IOTools.createTempFile((String)(this.testName.getMethodName() + "3-"));
        try {
            MethodReader reader;
            DummyListenerId dummy;
            AtomicInteger numberRead;
            DummyListener writer3;
            Throwable throwable;
            SingleChronicleQueue out3;
            try (SingleChronicleQueue out2 = this.queue(queuePath1, 1);){
                DummyListener writer2 = (DummyListener)out2.acquireAppender().methodWriterBuilder(dummyClass).get();
                writer2.say("hello");
            }
            var8_8 = null;
            try (SingleChronicleQueue in = this.queue(queuePath1, 1);){
                out3 = this.queue(queuePath2, 2);
                throwable = null;
                try {
                    writer3 = (DummyListener)out3.acquireAppender().methodWriterBuilder(dummyClass).get();
                    numberRead = new AtomicInteger();
                    dummy = msg -> {
                        numberRead.incrementAndGet();
                        MessageHistory history = MessageHistory.get();
                        Assert.assertEquals((long)1L, (long)history.sources());
                        Assert.assertEquals((long)(1 + extraTiming), (long)history.timings());
                        writer3.say(msg);
                    };
                    reader = in.createTailer().methodReader(new Object[]{dummy});
                    Assert.assertTrue((boolean)reader.readOne());
                    Assert.assertEquals((String)"check routed to correct dest", (long)1L, (long)numberRead.get());
                    Assert.assertFalse((boolean)reader.readOne());
                }
                catch (Throwable writer3) {
                    throwable = writer3;
                    throw writer3;
                }
                finally {
                    if (out3 != null) {
                        if (throwable != null) {
                            try {
                                out3.close();
                            }
                            catch (Throwable writer3) {
                                throwable.addSuppressed(writer3);
                            }
                        } else {
                            out3.close();
                        }
                    }
                }
            }
            catch (Throwable out3) {
                var8_8 = out3;
                throw out3;
            }
            in = this.queue(queuePath2, 2);
            var8_8 = null;
            try {
                out3 = this.queue(queuePath3, 3);
                throwable = null;
                try {
                    writer3 = (DummyListener)out3.acquireAppender().methodWriterBuilder(dummyClass).get();
                    numberRead = new AtomicInteger();
                    dummy = msg -> {
                        numberRead.incrementAndGet();
                        MessageHistory history = MessageHistory.get();
                        Assert.assertEquals((long)2L, (long)history.sources());
                        Assert.assertEquals((long)(3 + extraTiming), (long)history.timings());
                        writer3.say(msg);
                    };
                    reader = in.createTailer().methodReader(new Object[]{dummy});
                    Assert.assertTrue((boolean)reader.readOne());
                    Assert.assertEquals((String)"check routed to correct dest", (long)1L, (long)numberRead.get());
                    Assert.assertFalse((boolean)reader.readOne());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out3 != null) {
                        if (throwable != null) {
                            try {
                                out3.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out3.close();
                        }
                    }
                }
            }
            catch (Throwable out4) {
                var8_8 = out4;
                throw out4;
            }
            finally {
                if (in != null) {
                    if (var8_8 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable out4) {
                            var8_8.addSuppressed(out4);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            var8_8 = null;
            try (ChronicleHistoryReader chronicleHistoryReader = new ChronicleHistoryReader().withBasePath(queuePath3.toPath()).withTimeUnit(TimeUnit.MICROSECONDS).withMessageSink(System.out::println);){
                Map histos = chronicleHistoryReader.readChronicle();
                chronicleHistoryReader.outputData();
                Assert.assertEquals((long)5L, (long)histos.size());
                Assert.assertEquals((Object)"[1, startTo1, 2, 1to2, endToEnd]", (Object)histos.keySet().toString());
            }
            catch (Throwable throwable4) {
                var8_8 = throwable4;
                throw throwable4;
            }
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{queuePath1.toString(), queuePath2.toString(), queuePath3.toString()});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{queuePath1.toString(), queuePath2.toString(), queuePath3.toString()});
    }

    @Test
    public void testPredictable() {
        this.runPredictable(0, null, "Timings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                   100          100          100          100          100 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \n");
    }

    @Test
    public void testPredictableStartIndex() {
        this.runPredictable(0, 33L, "Timings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                    67           67           67           67           67 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \n");
    }

    @Test
    public void testPredictableMeasurementWindow() {
        this.runPredictable(2800, null, "Timings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                     1            1            1            1            1 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \nTimings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                    40           40           40           40           40 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \nTimings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                    40           40           40           40           40 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \nTimings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                    19           19           19           19           19 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPredictable(int mwMicros, Long startIndexOffset, String output) {
        this.expectException("Overriding sourceId from existing metadata, was 0, overriding to");
        SetTimeMessageHistory mh = new SetTimeMessageHistory();
        mh.addSourceDetails(true);
        MessageHistory.set((MessageHistory)mh);
        File queuePath1 = IOTools.createTempFile((String)(this.testName.getMethodName() + "1-"));
        File queuePath2 = IOTools.createTempFile((String)(this.testName.getMethodName() + "2-"));
        File queuePath3 = IOTools.createTempFile((String)(this.testName.getMethodName() + "3-"));
        try {
            StringBuilder sb = new StringBuilder();
            try (SingleChronicleQueue q1 = this.queue(queuePath1, 1);
                 SingleChronicleQueue q2 = this.queue(queuePath2, 2);
                 SingleChronicleQueue q3 = this.queue(queuePath3, 3);
                 ChronicleHistoryReader chronicleHistoryReader = new ChronicleHistoryReader().withBasePath(queuePath3.toPath()).withTimeUnit(TimeUnit.MICROSECONDS).withMeasurementWindow((long)mwMicros).withMessageSink(str -> sb.append((String)str).append('\n'));){
                DummyListener writer1 = (DummyListener)q1.acquireAppender().methodWriterBuilder(DummyListener.class).get();
                DummyListener writer2 = (DummyListener)q2.acquireAppender().methodWriterBuilder(DummyListener.class).get();
                DummyListener writer3 = (DummyListener)q3.acquireAppender().methodWriterBuilder(DummyListener.class).get();
                MethodReader reader1 = q1.createTailer().methodReader(new Object[]{writer2});
                MethodReader reader2 = q2.createTailer().methodReader(new Object[]{writer3});
                for (int i = 0; i < 100; ++i) {
                    writer1.say("hello " + i);
                    Assert.assertTrue((boolean)reader1.readOne());
                    Assert.assertTrue((boolean)reader2.readOne());
                    Assert.assertFalse((boolean)reader1.readOne());
                    Assert.assertFalse((boolean)reader2.readOne());
                }
                if (startIndexOffset != null) {
                    chronicleHistoryReader.withStartIndex(startIndexOffset + q3.firstIndex());
                }
                chronicleHistoryReader.readChronicle();
                chronicleHistoryReader.outputData();
                Assert.assertEquals((Object)output, (Object)sb.toString());
                writer1.say("again");
                Assert.assertTrue((boolean)reader1.readOne());
                Assert.assertTrue((boolean)reader2.readOne());
                Assert.assertFalse((boolean)reader1.readOne());
                Assert.assertFalse((boolean)reader2.readOne());
                sb.setLength(0);
                chronicleHistoryReader.readChronicle();
                chronicleHistoryReader.outputData();
                Assert.assertEquals((String)"re-reading should only show new data", (Object)"Timings below in MICROSECONDS\nsourceId                   1     startTo1            2         1to2     endToEnd \ncount:                     1            1            1            1            1 \n50:                        9           19            9           19           60 \n90:                        9           19            9           19           60 \n99:                        9           19            9           19           60 \n99.9:                                                                            \n99.99:                                                                           \n99.999:                                                                          \n99.9999:                                                                         \nworst:                     9           19            9           19           60 \n", (Object)sb.toString());
            }
        }
        catch (Throwable throwable) {
            IOTools.deleteDirWithFiles((String[])new String[]{queuePath1.toString(), queuePath2.toString(), queuePath3.toString()});
            throw throwable;
        }
        IOTools.deleteDirWithFiles((String[])new String[]{queuePath1.toString(), queuePath2.toString(), queuePath3.toString()});
    }

    @NotNull
    private SingleChronicleQueue queue(File queuePath1, int sourceId) {
        return ChronicleQueue.singleBuilder((File)queuePath1).testBlockSize().sourceId(sourceId).build();
    }

    static class SetTimeMessageHistory
    extends VanillaMessageHistory {
        long nanoTime = 140000000000000L;

        SetTimeMessageHistory() {
        }

        protected long nanoTime() {
            return this.nanoTime += 10000L;
        }
    }

    @FunctionalInterface
    static interface DummyListenerId
    extends DummyListener {
        @Override
        @MethodId(value=1L)
        public void say(String var1);
    }

    @FunctionalInterface
    static interface DummyListener {
        public void say(String var1);
    }
}

