/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Test;

public class AppenderListenerTest {
    @Test
    public void appenderListenerTest() {
        String path = OS.getTarget() + "/appenderListenerTest";
        StringBuilder results = new StringBuilder();
        try (SingleChronicleQueue q = SingleChronicleQueueBuilder.single((String)path).testBlockSize().appenderListener((wire, index) -> {
            long offset = index >>> 32 << 40 | wire.bytes().readPosition();
            String event = (String)wire.readEvent(String.class);
            String text = wire.getValueIn().text();
            results.append(event).append(" ").append(text).append(", addr:").append(Long.toHexString(offset)).append(", index: ").append(Long.toHexString(index)).append("\n");
        }).timeProvider((TimeProvider)new SetTimeProvider("2021/11/29T13:53:59").advanceMillis(1000L)).build();
             ExcerptAppender appender = q.acquireAppender();){
            HelloWorld writer = (HelloWorld)appender.methodWriter(HelloWorld.class, new Class[0]);
            writer.hello("G'Day");
            writer.hello("Bye-now");
        }
        IOTools.deleteDirWithFiles((String[])new String[]{path});
        Assert.assertEquals((Object)"hello G'Day, addr:4a100000010114, index: 4a1000000000\nhello Bye-now, addr:4a100000010128, index: 4a1000000001\n", (Object)results.toString());
    }

    public static interface HelloWorld {
        public void hello(String var1);
    }
}

