/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.Externalizable;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.ClassLocal;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.pool.ClassLookup;
import net.openhft.chronicle.core.pool.EnumCache;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.core.threads.ThreadLocalHelper;
import net.openhft.chronicle.core.util.CoreDynamicEnum;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.core.util.ReadResolvable;
import net.openhft.chronicle.wire.AbstractFieldInfo;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.BitSetUtil;
import net.openhft.chronicle.wire.BracketType;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.DynamicEnum;
import net.openhft.chronicle.wire.FieldInfo;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ScalarStrategy;
import net.openhft.chronicle.wire.SerializationStrategies;
import net.openhft.chronicle.wire.SerializationStrategy;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.VanillaFieldInfo;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireDumper;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireMarshaller;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Wires
extends Enum<Wires> {
    public static final int LENGTH_MASK = 0x3FFFFFFF;
    public static final int NOT_COMPLETE = Integer.MIN_VALUE;
    public static final int META_DATA = 0x40000000;
    public static final int UNKNOWN_LENGTH = 0;
    public static final int NOT_COMPLETE_UNKNOWN_LENGTH = Integer.MIN_VALUE;
    public static final int END_OF_DATA = -1073741824;
    public static final int NOT_INITIALIZED = 0;
    public static final Bytes<?> NO_BYTES;
    public static final int SPB_HEADER_SIZE = 4;
    public static final List<Function<Class, SerializationStrategy>> CLASS_STRATEGY_FUNCTIONS;
    static final ClassLocal<SerializationStrategy> CLASS_STRATEGY;
    static final ClassLocal<FieldInfoPair> FIELD_INFOS;
    static final ClassLocal<Function<String, Marshallable>> MARSHALLABLE_FUNCTION;
    static final StringBuilderPool SBP;
    static final ThreadLocal<BinaryWire> WIRE_TL;
    private static final int TID_MASK = 0x3FFFFFFF;
    private static final int INVERSE_TID_MASK = -1073741824;
    public static boolean GENERATE_TUPLES;
    static volatile boolean warnedUntypedBytesOnce;
    static ThreadLocal<StringBuilder> sb;
    private static final /* synthetic */ Wires[] $VALUES;

    public static Wires[] values() {
        return (Wires[])$VALUES.clone();
    }

    public static Wires valueOf(String name) {
        return Enum.valueOf(Wires.class, name);
    }

    public static void init() {
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes) {
        return WireDumper.of(bytes).asString();
    }

    public static String fromAlignedSizePrefixedBlobs(@NotNull Bytes bytes) {
        return WireDumper.of(bytes, true).asString();
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, boolean abbrev) {
        return WireDumper.of(bytes).asString(abbrev);
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position) {
        return Wires.fromSizePrefixedBlobs(bytes, position, false);
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, long position, boolean padding) {
        long limit = bytes.readLimit();
        if (position > limit) {
            return "";
        }
        return WireDumper.of(bytes, padding).asString(position, limit - position);
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes bytes, boolean padding, boolean abbrev) {
        return WireDumper.of(bytes, padding).asString(abbrev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fromSizePrefixedBlobs(@NotNull DocumentContext dc) {
        long start;
        Wire wire = dc.wire();
        Bytes<?> bytes = wire.bytes();
        if (wire instanceof TextWire) {
            return bytes.toString();
        }
        if ("BufferedTailer".equals(dc.getClass().getSimpleName())) {
            long length = wire.bytes().readLimit();
            int metaDataBit = dc.isMetaData() ? 0x40000000 : 0;
            int header = metaDataBit | Wires.toIntU30(length, "Document length %,d out of 30-bit int range.");
            NativeBytes<Void> tempBytes = Bytes.allocateElasticDirect();
            try {
                tempBytes.writeOrderedInt(header);
                AbstractWire wire2 = ((BinaryReadDocumentContext)dc).wire;
                tempBytes.write(wire2.bytes, 0L, wire2.bytes.readLimit());
                WireType wireType = WireType.valueOf(wire);
                assert (wireType != null);
                Wire tempWire = (Wire)wireType.apply(tempBytes);
                String string = WireDumper.of(tempWire).asString(0L, length + 4L);
                return string;
            }
            finally {
                tempBytes.releaseLast();
            }
        }
        long headerPosition = dc instanceof BinaryReadDocumentContext ? ((start = ((BinaryReadDocumentContext)dc).lastStart) != -1L ? start : bytes.readPosition() - 4L) : bytes.readPosition() - 4L;
        long length = Wires.lengthOf(bytes.readInt(headerPosition));
        return WireDumper.of(wire).asString(headerPosition, length + 4L);
    }

    public static String fromSizePrefixedBlobs(@NotNull WireIn wireIn) {
        return Wires.fromSizePrefixedBlobs(wireIn, false);
    }

    public static String fromSizePrefixedBlobs(@NotNull WireIn wireIn, boolean abbrev) {
        return WireDumper.of(wireIn).asString(abbrev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CharSequence asText(@NotNull WireIn wireIn) {
        long pos = wireIn.bytes().readPosition();
        try {
            Bytes<?> bytes = WireInternal.acquireInternalBytes();
            wireIn.copyTo(new TextWire(bytes).addTimeStamps(true));
            Bytes<?> bytes2 = bytes;
            return bytes2;
        }
        finally {
            wireIn.bytes().readPosition(pos);
        }
    }

    public static StringBuilder acquireStringBuilder() {
        return Jvm.isDebug() ? new StringBuilder() : SBP.acquireStringBuilder();
    }

    public static int lengthOf(int len) {
        return len & 0x3FFFFFFF;
    }

    public static boolean isReady(int header) {
        return (header & Integer.MIN_VALUE) == 0 && header != 0;
    }

    public static boolean isNotComplete(int header) {
        return (header & Integer.MIN_VALUE) != 0 || header == 0;
    }

    public static boolean isReadyData(int header) {
        return (header & 0xC0000000) == 0 && header != 0;
    }

    public static boolean isData(int len) {
        return (len & 0x40000000) == 0;
    }

    public static boolean isReadyMetaData(int len) {
        return (len & 0xC0000000) == 0x40000000;
    }

    public static boolean isKnownLength(int len) {
        return (len & Integer.MAX_VALUE) != 0;
    }

    public static boolean isNotInitialized(int len) {
        return len == 0;
    }

    public static int toIntU30(long l, @NotNull String error) {
        if (l < 0L || l > 0x3FFFFFFFL) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    public static boolean acquireLock(@NotNull BytesStore store, long position) {
        return store.compareAndSwapInt(position, 0, Integer.MIN_VALUE);
    }

    public static boolean exceedsMaxLength(long length) {
        return length > 0x3FFFFFFFL;
    }

    @ForceInline
    public static <T extends WriteMarshallable> long writeData(@NotNull WireOut wireOut, @NotNull T writer) {
        return WireInternal.writeData(wireOut, false, false, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForceInline
    public static long readWire(@NotNull WireIn wireIn, long size, @NotNull ReadMarshallable readMarshallable) {
        @NotNull Bytes<?> bytes = wireIn.bytes();
        long limit0 = bytes.readLimit();
        long limit = bytes.readPosition() + size;
        try {
            bytes.readLimit(limit);
            readMarshallable.readMarshallable(wireIn);
        }
        finally {
            bytes.readLimit(limit0);
            bytes.readPosition(limit);
        }
        return bytes.readPosition();
    }

    static Bytes<?> unmonitoredDirectBytes() {
        NativeBytes<Void> bytes = Bytes.allocateElasticDirect(128L);
        IOTools.unmonitor(bytes);
        return bytes;
    }

    @NotNull
    public static Bytes<?> acquireBytes() {
        if (Jvm.isDebug()) {
            return Bytes.allocateElasticOnHeap();
        }
        Bytes bytes = ThreadLocalHelper.getTL(WireInternal.BYTES_TL, Wires::unmonitoredDirectBytes);
        bytes.clear();
        return bytes;
    }

    @NotNull
    static Bytes<?> acquireBytesForToString() {
        if (Jvm.isDebug()) {
            return Bytes.allocateElasticOnHeap();
        }
        Bytes bytes = ThreadLocalHelper.getTL(WireInternal.BYTES_F2S_TL, Wires::unmonitoredDirectBytes);
        bytes.clear();
        return bytes;
    }

    @NotNull
    public static Wire acquireBinaryWire() {
        Wire wire = ThreadLocalHelper.getTL(WireInternal.BINARY_WIRE_TL, () -> new BinaryWire(Wires.unmonitoredDirectBytes()).setOverrideSelfDescribing(true));
        wire.clear();
        return wire;
    }

    @NotNull
    public static Bytes acquireAnotherBytes() {
        if (Jvm.isDebug()) {
            return Bytes.allocateElasticOnHeap();
        }
        Bytes bytes = ThreadLocalHelper.getTL(WireInternal.BYTES_TL, Wires::unmonitoredDirectBytes);
        bytes.clear();
        return bytes;
    }

    public static String fromSizePrefixedBlobs(@NotNull Bytes<?> bytes, long position, long length) {
        return WireDumper.of(bytes).asString(position, length);
    }

    public static void readMarshallable(@NotNull Object marshallable, @NotNull WireIn wire, boolean overwrite) {
        Class<?> clazz = marshallable.getClass();
        Wires.readMarshallable(clazz, marshallable, wire, overwrite);
    }

    public static void readMarshallable(Class<?> clazz, @NotNull Object marshallable, @NotNull WireIn wire, boolean overwrite) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(clazz == null ? marshallable.getClass() : clazz);
        wm.readMarshallable(marshallable, wire, wm.defaultValue(), overwrite);
    }

    public static void writeMarshallable(@NotNull Object marshallable, @NotNull WireOut wire) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.writeMarshallable(marshallable, wire);
    }

    public static void writeMarshallable(@NotNull Object marshallable, @NotNull WireOut wire, boolean writeDefault) {
        WireMarshaller marshaller = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        if (writeDefault) {
            marshaller.writeMarshallable(marshallable, wire);
        } else {
            marshaller.writeMarshallable(marshallable, wire, marshaller.defaultValue(), false);
        }
    }

    public static void writeMarshallable(@NotNull Object marshallable, @NotNull WireOut wire, @NotNull Object previous, boolean copy) {
        assert (marshallable.getClass() == previous.getClass());
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.writeMarshallable(marshallable, wire, previous, copy);
    }

    public static void writeKey(@NotNull Object marshallable, Bytes bytes) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(marshallable.getClass());
        wm.writeKey(marshallable, bytes);
    }

    @NotNull
    public static <T extends Marshallable> T deepCopy(@NotNull T marshallable) {
        boolean useSelfDescribing;
        Wire wire = Wires.acquireBinaryWire();
        @NotNull Marshallable t = (Marshallable)ObjectUtils.newInstance(marshallable.getClass());
        boolean bl = useSelfDescribing = t.usesSelfDescribingMessage() || !(t instanceof BytesMarshallable);
        if (useSelfDescribing) {
            marshallable.writeMarshallable(wire);
            t.readMarshallable(wire);
        } else {
            ((BytesMarshallable)((Object)marshallable)).writeMarshallable(wire.bytes());
            ((BytesMarshallable)((Object)t)).readMarshallable(wire.bytes());
        }
        return (T)t;
    }

    @NotNull
    public static <T> T copyTo(Object source, @NotNull T target) {
        Wire wire = Wires.acquireBinaryWire();
        wire.getValueOut().object(source);
        wire.getValueIn().typePrefix();
        wire.getValueIn().object(target, target.getClass());
        return target;
    }

    @NotNull
    public static <T> T project(Class<T> tClass, Object source) {
        T target = ObjectUtils.newInstance(tClass);
        Wires.copyTo(source, target);
        return target;
    }

    public static boolean isEquals(@NotNull Object o1, @NotNull Object o2) {
        return o1.getClass() == o2.getClass() && ((WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o1.getClass())).isEqual(o1, o2);
    }

    @NotNull
    public static List<FieldInfo> fieldInfos(@NotNull Class aClass) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get(aClass)).list;
    }

    @NotNull
    public static Map<String, FieldInfo> fieldInfoMap(@NotNull Class aClass) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get(aClass)).map;
    }

    public static FieldInfo fieldInfo(@NotNull Class aClass, String name) {
        return ((FieldInfoPair)Wires.FIELD_INFOS.get(aClass)).map.get(name);
    }

    public static boolean isEndOfFile(int num) {
        return num == -1073741824;
    }

    @Nullable
    public static <T> T getField(@NotNull Object o, String name, Class<T> tClass) throws NoSuchFieldException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        Object value = wm.getField(o, name);
        return ObjectUtils.convertTo(tClass, value);
    }

    public static long getLongField(@NotNull Object o, String name) throws NoSuchFieldException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        return wm.getLongField(o, name);
    }

    public static void setField(@NotNull Object o, String name, Object value) throws NoSuchFieldException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        wm.setField(o, name, value);
    }

    public static void setLongField(@NotNull Object o, String name, long value) throws NoSuchFieldException {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        wm.setLongField(o, name, value);
    }

    public static void reset(@NotNull Object o) {
        WireMarshaller wm = (WireMarshaller)WireMarshaller.WIRE_MARSHALLER_CL.get(o.getClass());
        wm.reset(o);
    }

    public static int removeMaskedTidFromHeader(int header) {
        return header & 0xC0000000;
    }

    @Nullable
    public static <E> E objectSequence(ValueIn in, @Nullable E using, @Nullable Class clazz, SerializationStrategy<E> strategy) {
        SerializationStrategies finalStrategy;
        if (clazz == Object.class) {
            strategy = SerializationStrategies.LIST;
        }
        if (using == null) {
            using = strategy.newInstanceOrNull(clazz);
        }
        return in.sequence(using, (arg_0, arg_1) -> Wires.lambda$objectSequence$5(finalStrategy = strategy, clazz, arg_0, arg_1)) ? (E)ReadResolvable.readResolve(using) : null;
    }

    @Nullable
    public static <E> E objectMap(ValueIn in, @Nullable E using, @Nullable Class clazz, @NotNull SerializationStrategy<E> strategy) {
        Object e2;
        if (in.isNull()) {
            return null;
        }
        if (clazz == Object.class) {
            strategy = SerializationStrategies.MAP;
        }
        if (using == null) {
            using = strategy.newInstanceOrNull(clazz);
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return (E)WireInternal.throwable(in, false, (Throwable)using);
        }
        if (using == null) {
            throw new IllegalStateException("failed to create instance of clazz=" + clazz + " is it aliased?");
        }
        long position = in.wireIn().bytes().readPosition();
        Object marshallable = in.marshallable(using, strategy);
        Object e = ReadResolvable.readResolve(marshallable);
        String name = Wires.nameOf(e);
        if (name != null && e != (e2 = EnumCache.of(e.getClass()).valueOf(name))) {
            in.wireIn().bytes().readPosition(position);
            return (E)in.marshallable(e2, strategy);
        }
        return (E)e;
    }

    private static <E> String nameOf(E e) {
        return e instanceof CoreDynamicEnum ? ((CoreDynamicEnum)e).name() : (e instanceof Enum ? ((Enum)e).name() : null);
    }

    @NotNull
    public static <E> E objectDate(ValueIn in, @Nullable E using) {
        in.wireIn().read();
        long time = in.int64();
        if (using instanceof Date) {
            ((Date)using).setTime(time);
            return using;
        }
        return (E)new Date(time);
    }

    @Nullable
    public static <E> E object0(ValueIn in, @Nullable E using, @Nullable Class clazz) {
        Class classForStrategy;
        SerializationStrategy strategy;
        BracketType brackets;
        Object o = in.typePrefixOrObject(clazz);
        if (o != null && !(o instanceof Class)) {
            return (E)in.marshallable(o, SerializationStrategies.MARSHALLABLE);
        }
        @Nullable Class clazz2 = (Class)o;
        if (clazz2 == Void.TYPE) {
            in.text();
            return null;
        }
        if (clazz2 == BytesStore.class) {
            if (using == null) {
                using = Bytes.allocateElasticOnHeap(32);
            }
            clazz = Base64.class;
        }
        if (clazz2 == null && clazz != null) {
            clazz = ObjectUtils.implementationToUse(clazz);
        }
        if (clazz2 != null && clazz != clazz2 && (clazz == null || clazz.isAssignableFrom(clazz2) || ReadResolvable.class.isAssignableFrom(clazz2) || !ObjectUtils.isConcreteClass(clazz)) && !(clazz = clazz2).isInstance(using)) {
            using = null;
        }
        if (clazz == null) {
            clazz = Object.class;
        }
        if ((brackets = (strategy = (SerializationStrategy)CLASS_STRATEGY.get(classForStrategy = clazz.isInterface() && using != null ? using.getClass() : clazz)).bracketType()) == BracketType.UNKNOWN) {
            brackets = in.getBracketType();
        }
        if (BitSet.class.isAssignableFrom(clazz)) {
            SerializationStrategies.PrimArrayWrapper longWrapper = new SerializationStrategies.PrimArrayWrapper(long[].class);
            Wires.objectSequence(in, longWrapper, SerializationStrategies.PrimArrayWrapper.class, SerializationStrategies.PRIM_ARRAY);
            return (E)(using == null ? BitSet.valueOf((long[])longWrapper.array) : BitSetUtil.set((BitSet)using, (long[])longWrapper.array));
        }
        switch (brackets) {
            case MAP: {
                return (E)Wires.objectMap(in, using, clazz, strategy);
            }
            case SEQ: {
                return (E)Wires.objectSequence(in, using, clazz, strategy);
            }
            case NONE: {
                Object e = strategy.readUsing(clazz, using, in, BracketType.NONE);
                return (E)(clazz == Base64.class || e == null ? e : WireInternal.intern(clazz, e));
            }
        }
        throw new AssertionError();
    }

    public static boolean dtoInterface(Class clazz) {
        return clazz != null && clazz.isInterface() && clazz != Bytes.class && clazz != BytesStore.class && !clazz.getPackage().getName().startsWith("java");
    }

    public static String typeNameFor(@NotNull Object value) {
        return Wires.typeNameFor(ClassAliasPool.CLASS_ALIASES, value);
    }

    public static String typeNameFor(ClassLookup classLookup, @NotNull Object value) {
        return classLookup == ClassAliasPool.CLASS_ALIASES && value instanceof Marshallable ? ((Marshallable)value).className() : classLookup.nameFor(value.getClass());
    }

    static Marshallable newInstance(Constructor constructor, String typeName) {
        try {
            return (Marshallable)constructor.newInstance(new TupleInvocationHandler(typeName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public static <T> T tupleFor(Class<T> tClass, String typeName) {
        if (!GENERATE_TUPLES) {
            Jvm.warn().on(Wires.class, "Cannot find a class for " + typeName + " are you missing an alias?");
            return null;
        }
        if (tClass == null || tClass == Object.class) {
            tClass = Marshallable.class;
        }
        if (!tClass.isInterface()) {
            Jvm.warn().on(Wires.class, "Cannot generate a class for " + typeName + " are you missing an alias?");
            return null;
        }
        return (T)((Function)MARSHALLABLE_FUNCTION.get(tClass)).apply(typeName);
    }

    public static boolean isInternal(@NotNull Object value) {
        String name = value.getClass().getPackage().getName();
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("jdk.");
    }

    @NotNull
    public static BinaryWire binaryWireForRead(Bytes in, long position, long length) {
        BinaryWire wire = WIRE_TL.get();
        VanillaBytes bytes = (VanillaBytes)wire.bytes();
        wire.clear();
        bytes.bytesStore(in.bytesStore(), position, length);
        return wire;
    }

    @NotNull
    public static BinaryWire binaryWireForWrite(Bytes in, long position, long length) {
        BinaryWire wire = WIRE_TL.get();
        VanillaBytes bytes = (VanillaBytes)wire.bytes();
        bytes.bytesStore(in.bytesStore(), 0L, position);
        bytes.writeLimit(position + length);
        return wire;
    }

    private static /* synthetic */ void lambda$objectSequence$5(SerializationStrategy finalStrategy, Class clazz, Object using1, ValueIn in1) {
        finalStrategy.readUsing(clazz, using1, in1, BracketType.UNKNOWN);
    }

    static {
        $VALUES = new Wires[0];
        NO_BYTES = BytesStore.empty().bytesForRead();
        CLASS_STRATEGY_FUNCTIONS = new CopyOnWriteArrayList<Function<Class, SerializationStrategy>>();
        CLASS_STRATEGY = ClassLocal.withInitial(c -> {
            for (Function<Class, SerializationStrategy> func : CLASS_STRATEGY_FUNCTIONS) {
                SerializationStrategy strategy = func.apply((Class)c);
                if (strategy == null) continue;
                return strategy;
            }
            return SerializationStrategies.ANY_OBJECT;
        });
        FIELD_INFOS = ClassLocal.withInitial(VanillaFieldInfo::lookupClass);
        MARSHALLABLE_FUNCTION = ClassLocal.withInitial(tClass -> {
            Class[] interfaces = new Class[]{Marshallable.class, tClass};
            if (tClass == Marshallable.class) {
                interfaces = new Class[]{Marshallable.class};
            }
            Class<?> proxyClass = Proxy.getProxyClass(tClass.getClassLoader(), interfaces);
            try {
                Constructor<?> constructor = proxyClass.getConstructor(InvocationHandler.class);
                constructor.setAccessible(true);
                return typeName -> Wires.newInstance(constructor, typeName);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        SBP = new StringBuilderPool();
        WIRE_TL = ThreadLocal.withInitial(() -> new BinaryWire(Bytes.allocateElasticOnHeap()));
        GENERATE_TUPLES = Jvm.getBoolean("wire.generate.tuples");
        warnedUntypedBytesOnce = false;
        sb = ThreadLocal.withInitial(StringBuilder::new);
        Jvm.addToClassPath(Wires.class);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeEnum.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeJavaLang.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeBytes.INSTANCE);
        CLASS_STRATEGY_FUNCTIONS.add(SerializeMarshallables.INSTANCE);
        WireInternal.addAliases();
    }

    static class TupleFieldInfo
    extends AbstractFieldInfo {
        public TupleFieldInfo(String name, Class type) {
            super(type, SerializeMarshallables.INSTANCE.apply(type).bracketType(), name);
        }

        private Map<String, Object> getMap(Object o) {
            TupleInvocationHandler invocationHandler = (TupleInvocationHandler)Proxy.getInvocationHandler(o);
            return invocationHandler.fields;
        }

        @Override
        @Nullable
        public Object get(Object object) {
            return this.getMap(object).get(this.name);
        }

        @Override
        public long getLong(Object object) {
            return ObjectUtils.convertTo(Long.class, this.get(object));
        }

        @Override
        public int getInt(Object object) {
            return ObjectUtils.convertTo(Integer.class, this.get(object));
        }

        @Override
        public char getChar(Object object) {
            return ObjectUtils.convertTo(Character.class, this.get(object)).charValue();
        }

        @Override
        public double getDouble(Object object) {
            return ObjectUtils.convertTo(Double.class, this.get(object));
        }

        @Override
        public void set(Object object, Object value) throws IllegalArgumentException {
            this.getMap(object).put(this.name, value);
        }

        @Override
        public void set(Object object, char value) throws IllegalArgumentException {
            this.set((Object)this.name, Character.valueOf(value));
        }

        @Override
        public void set(Object object, int value) throws IllegalArgumentException {
            this.set((Object)this.name, (Object)value);
        }

        @Override
        public void set(Object object, long value) throws IllegalArgumentException {
            this.set((Object)this.name, (Object)value);
        }

        @Override
        public void set(Object object, double value) throws IllegalArgumentException {
            this.set((Object)this.name, (Object)value);
        }

        @Override
        public Class<?> genericType(int index) {
            return Object.class;
        }

        @Override
        public boolean isEqual(Object a, Object b) {
            return Objects.deepEquals(this.get(a), this.get(b));
        }
    }

    static class TupleInvocationHandler
    implements InvocationHandler {
        final String typeName;
        final Map<String, Object> fields = new LinkedHashMap<String, Object>();

        private TupleInvocationHandler(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            String name;
            switch (name = method.getName()) {
                case "hashCode": {
                    if (args != null && args.length != 0) break;
                    return (int)Maths.agitate((long)this.typeName.hashCode() * 1019L + (long)this.fields.hashCode() * 10191L);
                }
                case "equals": {
                    if (args == null || args.length != 1) break;
                    return this.equals0(proxy, args[0]);
                }
                case "deepCopy": {
                    if (args != null && args.length != 0) break;
                    TupleInvocationHandler h2 = new TupleInvocationHandler(this.typeName);
                    h2.fields.putAll(this.fields);
                    return proxy.getClass().getDeclaredConstructor(InvocationHandler.class).newInstance(h2);
                }
                case "toString": {
                    if (args != null && args.length != 0) break;
                    return WireType.TEXT.asString(proxy);
                }
                case "readMarshallable": {
                    if (args.length != 1) break;
                    WireIn in = (WireIn)args[0];
                    while (in.hasMore()) {
                        this.fields.put(in.readEvent(String.class), in.getValueIn().object());
                    }
                    return null;
                }
                case "writeMarshallable": {
                    if (args.length != 1) break;
                    WireOut out = (WireOut)args[0];
                    for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        out.write(key).object(value);
                    }
                    return null;
                }
                case "getField": {
                    if (args.length != 2) break;
                    Object value = this.fields.get(args[0]);
                    return ObjectUtils.convertTo((Class)args[1], value);
                }
                case "setField": {
                    if (args.length != 2) break;
                    this.fields.put(args[0].toString(), args[1]);
                    return null;
                }
                case "className": {
                    if (args != null && args.length != 0) break;
                    return this.typeName;
                }
                case "$fieldInfos": {
                    if (args != null && args.length != 0) break;
                    ArrayList<TupleFieldInfo> fieldInfos = new ArrayList<TupleFieldInfo>();
                    for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
                        Class<?> valueClass = entry.getValue().getClass();
                        fieldInfos.add(new TupleFieldInfo(entry.getKey(), valueClass));
                    }
                    return fieldInfos;
                }
                case "usesSelfDescribingMessage": {
                    return Boolean.TRUE;
                }
            }
            if (args == null || args.length == 0) {
                Class<?> returnType = method.getReturnType();
                if (this.fields.containsKey(name)) {
                    return ObjectUtils.convertTo(returnType, this.fields.get(name));
                }
                return ObjectUtils.defaultValue(returnType);
            }
            if (args.length == 1) {
                this.fields.put(name, args[0]);
                return proxy;
            }
            throw new UnsupportedOperationException("The class or alias " + this.typeName + " could not be found, so unable to call " + method);
        }

        @NotNull
        private Object equals0(Object proxy, Object o) {
            if (proxy == o) {
                return true;
            }
            if (!(o instanceof Marshallable)) {
                return false;
            }
            Marshallable m = (Marshallable)o;
            if (!m.className().equals(this.typeName)) {
                return false;
            }
            if (!Proxy.isProxyClass(m.getClass())) {
                return false;
            }
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(m);
            if (!(invocationHandler instanceof TupleInvocationHandler)) {
                return false;
            }
            TupleInvocationHandler tih = (TupleInvocationHandler)invocationHandler;
            return this.fields.equals(tih.fields);
        }
    }

    static class FieldInfoPair {
        static final FieldInfoPair EMPTY = new FieldInfoPair(Collections.emptyList(), Collections.emptyMap());
        @NotNull
        final List<FieldInfo> list;
        @NotNull
        final Map<String, FieldInfo> map;

        public FieldInfoPair(@NotNull List<FieldInfo> list, @NotNull Map<String, FieldInfo> map) {
            this.list = list;
            this.map = map;
        }
    }

    static enum SerializeBytes implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        static Bytes decodeBase64(Bytes o, ValueIn in) {
            @NotNull StringBuilder sb0 = Wires.acquireStringBuilder();
            in.text(sb0);
            String s = WireInternal.INTERNER.intern(sb0);
            byte[] decode = Base64.getDecoder().decode(s);
            if (o == null) {
                return Bytes.wrapForRead(decode);
            }
            o.clear();
            o.write(decode);
            return o;
        }

        @Override
        public SerializationStrategy apply(@NotNull Class aClass) {
            switch (aClass.getName()) {
                case "net.openhft.chronicle.bytes.BytesStore": {
                    return ScalarStrategy.of(BytesStore.class, (o, in) -> in.bytesStore());
                }
                case "net.openhft.chronicle.bytes.Bytes": {
                    return ScalarStrategy.of(Bytes.class, (o, in) -> in.bytesStore().bytesForRead());
                }
                case "java.util.Base64": {
                    return ScalarStrategy.of(Bytes.class, SerializeBytes::decodeBase64);
                }
            }
            return null;
        }
    }

    static enum SerializeMarshallables implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Nullable
        static SerializationStrategy getSerializationStrategy(@NotNull Class aClass) {
            if (Demarshallable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.DEMARSHALLABLE;
            }
            if (ReadMarshallable.class.isAssignableFrom(aClass) || ReadBytesMarshallable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.MARSHALLABLE;
            }
            return null;
        }

        @Override
        public SerializationStrategy apply(@NotNull Class aClass) {
            @Nullable SerializationStrategy x = SerializeMarshallables.getSerializationStrategy(aClass);
            if (x != null) {
                return x;
            }
            if (Map.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.MAP;
            }
            if (Set.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.SET;
            }
            if (List.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.LIST;
            }
            if (Externalizable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.EXTERNALIZABLE;
            }
            if (Serializable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.ANY_NESTED;
            }
            if (Comparable.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.ANY_SCALAR;
            }
            if (aClass.isInterface()) {
                return null;
            }
            return SerializationStrategies.ANY_NESTED;
        }
    }

    static enum SerializeJavaLang implements Function<Class, SerializationStrategy>
    {
        INSTANCE;

        private static final String SDF_4_STRING = "yyyy-MM-dd";
        private static final SimpleDateFormat SDF;
        private static final SimpleDateFormat SDF_2;
        private static final SimpleDateFormat SDF_3;
        private static final SimpleDateFormat SDF_4;

        public static WireOut writeDate(Date date, ValueOut out) {
            String format = SDF_2.format(date);
            return out.writeString(format);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Date parseDate(ValueIn in) {
            String text = in.text().trim();
            if (text.length() < 1) {
                throw new IORuntimeException("At least one character (e.g. '0') must be present in order to deserialize a Date object");
            }
            char firstChar = text.charAt(0);
            if (firstChar == '+' || firstChar == '-' || Character.isDigit(firstChar)) {
                boolean isAllNum = true;
                for (int i = 1; i < text.length(); ++i) {
                    if (Character.isDigit(text.charAt(i))) continue;
                    isAllNum = false;
                    break;
                }
                if (isAllNum) {
                    try {
                        return new Date(Long.parseLong(text));
                    }
                    catch (NumberFormatException nfe) {
                        throw new IORuntimeException(nfe);
                    }
                }
            }
            if (text.length() == SDF_4_STRING.length()) {
                try {
                    SimpleDateFormat isAllNum = SDF_4;
                    synchronized (isAllNum) {
                        return SDF_4.parse(text);
                    }
                }
                catch (ParseException pe2) {
                    throw new IORuntimeException(pe2);
                }
            }
            try {
                SimpleDateFormat pe2 = SDF_2;
                synchronized (pe2) {
                    return SDF_2.parse(text);
                }
            }
            catch (ParseException pe2) {
                SimpleDateFormat pe2 = SDF;
                synchronized (pe2) {
                    try {
                        return SDF.parse(text);
                    }
                    catch (ParseException parseException) {
                    }
                }
                try {
                    pe2 = SDF_3;
                    synchronized (pe2) {
                        return SDF_3.parse(text);
                    }
                }
                catch (ParseException pe3) {
                    throw new IORuntimeException("unable to parse: " + text, pe3);
                }
            }
        }

        private static Class forName(Class o, ValueIn in) {
            StringBuilder sb0 = sb.get();
            sb0.setLength(0);
            in.text(sb0);
            return in.classLookup().forName(sb0);
        }

        @Override
        public SerializationStrategy apply(@NotNull Class aClass) {
            switch (aClass.getName()) {
                case "[B": {
                    return ScalarStrategy.of(byte[].class, (o, in) -> in.bytes());
                }
                case "java.lang.StringBuilder": {
                    return ScalarStrategy.of(StringBuilder.class, (o, in) -> {
                        StringBuilder builder = o == null ? Wires.acquireStringBuilder() : o;
                        in.textTo(builder);
                        return o;
                    });
                }
                case "java.lang.String": {
                    return ScalarStrategy.of(String.class, (o, in) -> in.text());
                }
                case "java.lang.Object": {
                    return SerializationStrategies.ANY_OBJECT;
                }
                case "java.lang.Class": {
                    return ScalarStrategy.of(Class.class, SerializeJavaLang::forName);
                }
                case "java.lang.Boolean": {
                    return ScalarStrategy.of(Boolean.class, (o, in) -> in.bool());
                }
                case "java.lang.Byte": {
                    return ScalarStrategy.of(Byte.class, (o, in) -> in.int8());
                }
                case "java.lang.Short": {
                    return ScalarStrategy.of(Short.class, (o, in) -> in.int16());
                }
                case "java.lang.Character": {
                    return ScalarStrategy.of(Character.class, (o, in) -> {
                        @Nullable String text = in.text();
                        if (text == null || text.length() == 0) {
                            return null;
                        }
                        return Character.valueOf(text.charAt(0));
                    });
                }
                case "java.lang.Integer": {
                    return ScalarStrategy.of(Integer.class, (o, in) -> in.int32());
                }
                case "java.lang.Float": {
                    return ScalarStrategy.of(Float.class, (o, in) -> Float.valueOf(in.float32()));
                }
                case "java.lang.Long": {
                    return ScalarStrategy.of(Long.class, (o, in) -> in.int64());
                }
                case "java.lang.Double": {
                    return ScalarStrategy.of(Double.class, (o, in) -> in.float64());
                }
                case "java.time.LocalTime": {
                    return ScalarStrategy.of(LocalTime.class, (o, in) -> in.time());
                }
                case "java.time.LocalDate": {
                    return ScalarStrategy.of(LocalDate.class, (o, in) -> in.date());
                }
                case "java.time.LocalDateTime": {
                    return ScalarStrategy.of(LocalDateTime.class, (o, in) -> in.dateTime());
                }
                case "java.time.ZonedDateTime": {
                    return ScalarStrategy.of(ZonedDateTime.class, (o, in) -> in.zonedDateTime());
                }
                case "java.sql.Time": {
                    return ScalarStrategy.of(Time.class, (o, in) -> new Time(SerializeJavaLang.parseDate(in).getTime()));
                }
                case "java.sql.Date": {
                    return ScalarStrategy.of(java.sql.Date.class, (o, in) -> new java.sql.Date(SerializeJavaLang.parseDate(in).getTime()));
                }
                case "javax.naming.CompositeName": {
                    return ScalarStrategy.of(CompositeName.class, (o, in) -> {
                        try {
                            return new CompositeName(in.text());
                        }
                        catch (InvalidNameException e) {
                            throw Jvm.rethrow(e);
                        }
                    });
                }
                case "java.io.File": {
                    return ScalarStrategy.text(File.class, File::new);
                }
                case "java.util.UUID": {
                    return ScalarStrategy.of(UUID.class, (o, in) -> in.uuid());
                }
                case "java.math.BigInteger": {
                    return ScalarStrategy.text(BigInteger.class, BigInteger::new);
                }
                case "java.math.BigDecimal": {
                    return ScalarStrategy.text(BigDecimal.class, BigDecimal::new);
                }
                case "java.util.Date": {
                    return ScalarStrategy.of(Date.class, (o, in) -> SerializeJavaLang.parseDate(in));
                }
                case "java.time.Duration": {
                    return ScalarStrategy.of(Duration.class, (o, in) -> Duration.parse(in.text()));
                }
                case "java.time.Instant": {
                    return ScalarStrategy.of(Instant.class, (o, in) -> Instant.parse(in.text()));
                }
                case "java.sql.Timestamp": {
                    return ScalarStrategy.of(Timestamp.class, (o, in) -> new Timestamp(SerializeJavaLang.parseDate(in).getTime()));
                }
                case "java.util.GregorianCalendar": {
                    return ScalarStrategy.of(GregorianCalendar.class, (o, in) -> GregorianCalendar.from(in.zonedDateTime()));
                }
                case "java.util.Locale": {
                    return ScalarStrategy.of(Locale.class, (o, in) -> Locale.forLanguageTag(in.text()));
                }
            }
            if (aClass.isPrimitive()) {
                return SerializationStrategies.ANY_SCALAR;
            }
            if (aClass.isArray()) {
                Class<?> componentType = aClass.getComponentType();
                if (componentType.isPrimitive()) {
                    return SerializationStrategies.PRIM_ARRAY;
                }
                return SerializationStrategies.ARRAY;
            }
            if (Enum.class.isAssignableFrom(aClass)) {
                @Nullable SerializationStrategy ss = SerializeMarshallables.getSerializationStrategy(aClass);
                return ss == null ? SerializationStrategies.ENUM : ss;
            }
            return null;
        }

        static {
            SDF = new SimpleDateFormat("EEE MMM d HH:mm:ss.S zzz yyyy");
            SDF_2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            SDF_3 = new SimpleDateFormat("EEE MMM d HH:mm:ss.S zzz yyyy", Locale.US);
            SDF_4 = new SimpleDateFormat(SDF_4_STRING);
            SDF.setTimeZone(TimeZone.getTimeZone("GMT"));
            SDF_2.setTimeZone(TimeZone.getTimeZone("GMT"));
            SDF_3.setTimeZone(TimeZone.getTimeZone("GMT"));
            SDF_4.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    static enum SerializeEnum implements Function<Class, SerializationStrategy>
    {
        INSTANCE;


        @Nullable
        static SerializationStrategy getSerializationStrategy(@NotNull Class aClass) {
            if (DynamicEnum.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.DYNAMIC_ENUM;
            }
            if (Enum.class.isAssignableFrom(aClass)) {
                return SerializationStrategies.ENUM;
            }
            return null;
        }

        @Override
        @Nullable
        public SerializationStrategy apply(@NotNull Class aClass) {
            return SerializeEnum.getSerializationStrategy(aClass);
        }
    }
}

