/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.StandardCharsets;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.ByteableIntArrayValues;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.values.IntValue;
import org.jetbrains.annotations.NotNull;

public class TextIntArrayReference
extends AbstractReference
implements ByteableIntArrayValues {
    private static final byte[] SECTION1 = "{ locked: false, capacity: ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION2 = ", used: ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION3 = ", values: [ ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SECTION4 = " ] }\n".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ZERO = "0000000000".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] SEP = ", ".getBytes(StandardCharsets.ISO_8859_1);
    private static final int DIGITS = ZERO.length;
    private static final int CAPACITY = SECTION1.length;
    private static final int USED = CAPACITY + DIGITS + SECTION2.length;
    private static final int VALUES = USED + DIGITS + SECTION3.length;
    private static final int VALUE_SIZE = DIGITS + SEP.length;
    private static final int LOCK_OFFSET = 10;
    private static final int FALS = 1936482662;
    private static final int TRU = 1970435104;
    private long length = VALUES;

    public static void write(@NotNull Bytes bytes, long capacity) throws IllegalStateException, BufferOverflowException {
        long start = bytes.writePosition();
        bytes.write(SECTION1);
        bytes.append(capacity);
        while (bytes.writePosition() - start < (long)(CAPACITY + DIGITS)) {
            try {
                bytes.writeUnsignedByte(32);
            }
            catch (ArithmeticException e) {
                throw new AssertionError((Object)e);
            }
        }
        bytes.write(SECTION2);
        bytes.write(ZERO);
        bytes.write(SECTION3);
        for (long i = 0L; i < capacity; ++i) {
            if (i > 0L) {
                try {
                    bytes.appendUtf8(", ");
                }
                catch (BufferUnderflowException e) {
                    throw new AssertionError((Object)e);
                }
            }
            bytes.write(ZERO);
        }
        bytes.write(SECTION4);
    }

    public static long peakLength(@NotNull BytesStore bytes, long offset) throws IllegalStateException {
        try {
            return bytes.parseLong(offset + (long)CAPACITY) * (long)VALUE_SIZE - (long)SEP.length + (long)VALUES + (long)SECTION4.length;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long getUsed() throws IllegalStateException {
        try {
            return this.bytes.parseLong((long)USED + this.offset);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void setUsed(long used) throws IllegalStateException, IllegalArgumentException {
        try {
            this.bytes.append((long)VALUES + this.offset, used, DIGITS);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setMaxUsed(long usedAtLeast) throws IllegalStateException {
        try {
            while (!this.bytes.compareAndSwapInt(10L + this.offset, 1936482662, 1970435104)) {
            }
            try {
                if (this.getUsed() < usedAtLeast) {
                    this.setUsed(usedAtLeast);
                }
                return;
            }
            finally {
                this.bytes.writeInt(10L + this.offset, 1936482662);
            }
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long getCapacity() {
        return (this.length - (long)VALUES) / (long)VALUE_SIZE;
    }

    @Override
    public ByteableIntArrayValues capacity(long arrayLength) {
        BytesStore bytesStore = this.bytesStore();
        long len = this.sizeInBytes(arrayLength);
        if (bytesStore == null) {
            this.length = len;
        } else assert (this.length == len);
        return this;
    }

    @Override
    public int getValueAt(long index) throws IllegalStateException {
        try {
            return (int)this.bytes.parseLong((long)VALUES + this.offset + index * (long)VALUE_SIZE);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setValueAt(long index, int value) throws IllegalStateException {
        try {
            this.bytes.append((long)VALUES + this.offset + index * (long)VALUE_SIZE, value, DIGITS);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (IllegalArgumentException | BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void bindValueAt(long index, IntValue value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public int getVolatileValueAt(long index) throws IllegalStateException {
        OS.memory().loadFence();
        return this.getValueAt(index);
    }

    @Override
    public void setOrderedValueAt(long index, int value) throws IllegalStateException {
        this.setValueAt(index, value);
        OS.memory().storeFence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSet(long index, int expected, int value) throws IllegalStateException {
        boolean bl;
        if (!this.bytes.compareAndSwapInt(10L + this.offset, 1936482662, 1970435104)) {
            return false;
        }
        boolean ret = false;
        try {
            if (this.getVolatileValueAt(index) == expected) {
                this.setOrderedValueAt(index, value);
                ret = true;
            }
            bl = ret;
        }
        catch (Throwable throwable) {
            try {
                this.bytes.writeInt(10L + this.offset, 1936482662);
                throw throwable;
            }
            catch (NullPointerException e) {
                this.throwExceptionIfClosed();
                throw e;
            }
            catch (BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.bytes.writeInt(10L + this.offset, 1936482662);
        return bl;
    }

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosedInSetter();
        if (length != TextIntArrayReference.peakLength(bytes, offset)) {
            throw new IllegalArgumentException(length + " != " + TextIntArrayReference.peakLength(bytes, offset));
        }
        super.bytesStore(bytes, offset, length);
        this.length = length;
    }

    @Override
    public boolean isNull() {
        return this.bytes == null;
    }

    @Override
    public void reset() throws IllegalStateException {
        this.throwExceptionIfClosedInSetter();
        this.bytes = null;
        this.offset = 0L;
        this.length = 0L;
    }

    @Override
    public long maxSize() {
        return this.length;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "LongArrayTextReference{bytes=null, offset=" + this.offset + ", length=" + this.length + '}';
        }
        try {
            return "value: " + this.getValueAt(0L) + " ...";
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    @Override
    public long sizeInBytes(long capacity) {
        return capacity * (long)VALUE_SIZE + (long)VALUES + (long)SECTION3.length - (long)SEP.length;
    }
}

