/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.ref;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ref.AbstractReference;
import net.openhft.chronicle.bytes.ref.LongReference;
import org.jetbrains.annotations.NotNull;

public class BinaryLongReference
extends AbstractReference
implements LongReference {
    public static final long LONG_NOT_COMPLETE = -1L;

    @Override
    public void bytesStore(@NotNull BytesStore bytes, long offset, long length) throws IllegalStateException, IllegalArgumentException, BufferOverflowException {
        this.throwExceptionIfClosed();
        if (length != this.maxSize()) {
            throw new IllegalArgumentException();
        }
        if (bytes instanceof HexDumpBytes) {
            offset &= 0xFFFFFFFFL;
        }
        super.bytesStore(bytes, offset, length);
    }

    @Override
    public long maxSize() {
        return 8L;
    }

    @Override
    @NotNull
    public String toString() {
        if (this.bytes == null) {
            return "bytes is null";
        }
        try {
            return "value: " + this.getValue();
        }
        catch (Throwable e) {
            return e.toString();
        }
    }

    @Override
    public long getValue() throws IllegalStateException {
        try {
            return this.bytes == null ? 0L : this.bytes.readLong(this.offset);
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setValue(long value) throws IllegalStateException {
        try {
            this.bytes.writeLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long getVolatileValue() throws IllegalStateException {
        try {
            return this.bytes.readVolatileLong(this.offset);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setVolatileValue(long value) throws IllegalStateException {
        try {
            this.bytes.writeVolatileLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long getVolatileValue(long closedValue) {
        if (this.isClosed()) {
            return closedValue;
        }
        try {
            return this.getVolatileValue();
        }
        catch (Exception e) {
            return closedValue;
        }
    }

    @Override
    public void setOrderedValue(long value) throws IllegalStateException {
        try {
            this.bytes.writeOrderedLong(this.offset, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long addValue(long delta) throws IllegalStateException {
        try {
            return this.bytes.addAndGetLong(this.offset, delta);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferUnderflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long addAtomicValue(long delta) throws IllegalStateException {
        return this.addValue(delta);
    }

    @Override
    public boolean compareAndSwapValue(long expected, long value) throws IllegalStateException {
        try {
            return this.bytes.compareAndSwapLong(this.offset, expected, value);
        }
        catch (NullPointerException e) {
            this.throwExceptionIfClosed();
            throw e;
        }
        catch (BufferOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }
}

