/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.text.ParseException;
import java.util.NavigableSet;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireStorePool
extends SimpleCloseable {
    @NotNull
    private final WireStoreSupplier supplier;
    private final StoreFileListener storeFileListener;

    private WireStorePool(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        this.supplier = supplier;
        this.storeFileListener = storeFileListener;
    }

    @NotNull
    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        return new WireStorePool(supplier, storeFileListener);
    }

    @Deprecated
    @Nullable
    public SingleChronicleQueueStore acquire(int cycle, long epoch, boolean createIfAbsent, SingleChronicleQueueStore oldStore) {
        return this.acquire(cycle, createIfAbsent, oldStore);
    }

    @Nullable
    public SingleChronicleQueueStore acquire(int cycle, boolean createIfAbsent, SingleChronicleQueueStore oldStore) {
        this.throwExceptionIfClosed();
        if (oldStore != null && oldStore.cycle() == cycle && !oldStore.isClosed()) {
            return oldStore;
        }
        SingleChronicleQueueStore store = this.supplier.acquire(cycle, createIfAbsent);
        if (store != null) {
            store.cycle(cycle);
            if (store != oldStore && this.storeFileListener.isActive()) {
                BackgroundResourceReleaser.run(() -> this.storeFileListener.onAcquired(cycle, store.file()));
            }
        }
        return store;
    }

    public int nextCycle(int currentCycle, @NotNull TailerDirection direction) throws ParseException {
        this.throwExceptionIfClosed();
        return this.supplier.nextCycle(currentCycle, direction);
    }

    public void closeStore(@NotNull SingleChronicleQueueStore store) {
        BackgroundResourceReleaser.release(store);
        if (this.storeFileListener.isActive()) {
            BackgroundResourceReleaser.run(() -> this.storeFileListener.onReleased(store.cycle(), store.file()));
        }
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        this.throwExceptionIfClosed();
        return this.supplier.cycles(lowerCycle, upperCycle);
    }
}

