/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.junit.Assert;
import org.junit.Test;

public class ObjectUtilsTest {
    @Test
    public void testImmutable() {
        for (Class c : new Class[]{String.class, Integer.class, Date.class, BigDecimal.class, ZonedDateTime.class}) {
            Assert.assertEquals((String)c.getName(), (Object)((Object)ObjectUtils.Immutability.MAYBE), (Object)((Object)ObjectUtils.isImmutable(c)));
        }
        for (Class c : new Class[]{ArrayList.class, HashMap.class}) {
            Assert.assertEquals((String)c.getName(), (Object)((Object)ObjectUtils.Immutability.NO), (Object)((Object)ObjectUtils.isImmutable(c)));
        }
    }

    @Test
    public void testConvert() throws IllegalStateException, IllegalArgumentException {
        Assert.assertEquals((long)49L, (long)ObjectUtils.convertTo(Character.TYPE, 1).charValue());
        Assert.assertEquals((long)49L, (long)ObjectUtils.convertTo(Character.TYPE, 1L).charValue());
        Assert.assertEquals((long)1L, (long)ObjectUtils.convertTo(Integer.TYPE, Character.valueOf('1')).intValue());
        Assert.assertEquals((long)1L, (long)ObjectUtils.convertTo(Long.TYPE, Character.valueOf('1')));
        Assert.assertEquals((double)1.0, (double)ObjectUtils.convertTo(Double.TYPE, Character.valueOf('1')), (double)0.0);
    }
}

