/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.time.SetTimeProvider;
import org.junit.Assert;
import org.junit.Test;

public class SetTimeProviderTest {
    @Test
    public void testNoOpConstructor() throws IllegalArgumentException {
        SetTimeProvider tp = new SetTimeProvider();
        Assert.assertEquals((long)0L, (long)tp.currentTimeNanos());
        tp.currentTimeNanos(99123456789L);
        Assert.assertEquals((long)99123456789L, (long)tp.currentTimeNanos());
        Assert.assertEquals((long)99123456L, (long)tp.currentTimeMicros());
        Assert.assertEquals((long)99123L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)99L, (long)tp.currentTime(TimeUnit.SECONDS));
        tp.advanceMillis(7L).advanceMicros(5L).advanceNanos(3L);
        Assert.assertEquals((long)99130461792L, (long)tp.currentTimeNanos());
    }

    @Test
    public void testNanosConstructor() throws IllegalArgumentException {
        SetTimeProvider tp = new SetTimeProvider(99999999999000000L);
        Assert.assertEquals((long)99999999999000000L, (long)tp.currentTimeNanos());
        Assert.assertEquals((long)99999999999000L, (long)tp.currentTimeMicros());
        Assert.assertEquals((long)99999999999L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)99999999L, (long)tp.currentTime(TimeUnit.SECONDS));
        tp.currentTimeMicros(100000000000000L);
        Assert.assertEquals((long)100000000000000000L, (long)tp.currentTimeNanos());
        Assert.assertEquals((long)100000000000000L, (long)tp.currentTimeMicros());
        Assert.assertEquals((long)100000000000L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)100000000L, (long)tp.currentTime(TimeUnit.SECONDS));
        tp.currentTimeMillis(101987000000L);
        Assert.assertEquals((long)101987000000000000L, (long)tp.currentTimeNanos());
        Assert.assertEquals((long)101987000000000L, (long)tp.currentTimeMicros());
        Assert.assertEquals((long)101987000000L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)101987000L, (long)tp.currentTime(TimeUnit.SECONDS));
        tp.advanceMillis(1011L).advanceMicros(1211L).advanceNanos(789123L);
        Assert.assertEquals((long)101987001013000123L, (long)tp.currentTimeNanos());
    }

    @Test
    public void testNanosConstructorLowNumber() {
        SetTimeProvider tp = new SetTimeProvider(1000L);
        Assert.assertEquals((long)1000L, (long)tp.currentTimeNanos());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAttemptToGoBackwardsNanos() throws IllegalArgumentException {
        SetTimeProvider tp = new SetTimeProvider(100000000000L);
        tp.currentTimeNanos(99999999999L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAttemptToGoBackwardsMicros() throws IllegalArgumentException {
        SetTimeProvider tp = new SetTimeProvider(100000000000L);
        tp.currentTimeMicros(99999999L);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAttemptToGoBackwardsMillis() throws IllegalArgumentException {
        SetTimeProvider tp = new SetTimeProvider(100000000000L);
        tp.currentTimeMillis(99999L);
    }

    @Test
    public void withTimestamp() {
        SetTimeProvider tp = new SetTimeProvider("2018-08-20T12:53:04.075");
        Assert.assertEquals((long)1534769584075L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)1534769584075000L, (long)tp.currentTimeMicros());
        SetTimeProvider tp2 = new SetTimeProvider("2018-08-20T12:53:04.075123");
        Assert.assertEquals((long)1534769584075L, (long)tp2.currentTimeMillis());
        Assert.assertEquals((long)1534769584075123L, (long)tp2.currentTimeMicros());
    }

    @Test
    public void withInstant() {
        SetTimeProvider tp = new SetTimeProvider(Instant.parse("2018-08-20T12:53:04.075Z"));
        Assert.assertEquals((long)1534769584075L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)1534769584075000L, (long)tp.currentTimeMicros());
        SetTimeProvider tp2 = new SetTimeProvider(Instant.parse("2018-08-20T12:53:04.075123Z"));
        Assert.assertEquals((long)1534769584075L, (long)tp2.currentTimeMillis());
        Assert.assertEquals((long)1534769584075123L, (long)tp2.currentTimeMicros());
    }

    @Test
    public void autoIncrement() {
        SetTimeProvider tp = new SetTimeProvider("2018-08-20T12:53:04.075").autoIncrement(1L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1534769584075L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)1534769584076L, (long)tp.currentTimeMillis());
        Assert.assertEquals((long)1534769584077L, (long)tp.currentTimeMillis());
    }
}

