/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.openhft.chronicle.core.CoreTestCommon;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.internal.threads.VanillaThreadLock;
import net.openhft.chronicle.core.threads.InterruptedRuntimeException;
import net.openhft.chronicle.core.values.LongValue;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class VanillaThreadLockTest
extends CoreTestCommon {
    @Test
    public void gettid() {
        Assume.assumeFalse((Jvm.isArm() || OS.isMacOSX() ? 1 : 0) != 0);
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 1000L);
        Assert.assertTrue((lock.gettid() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)lock.tryLock());
        lock.unlock();
        lock.lock();
        lock.unlock();
    }

    @Test
    public void lockUnlock() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 1000L);
        lock.lock(1);
        lock.unlock(1);
        Assert.assertTrue((boolean)lock.tryLock(2));
        Assert.assertFalse((boolean)lock.tryLock(3));
        lock.unlock(2);
        Assert.assertEquals((long)0x200000000L, (long)value.getValue());
    }

    @Test
    public void duplicateLock() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 1000L);
        lock.lock(1);
        try {
            lock.lock(1);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        lock.unlock(1);
        Assert.assertEquals((long)0x100000000L, (long)value.getValue());
    }

    @Test
    public void duplicateUnlock() {
        VanillaThreadLock lock = new VanillaThreadLock(new VanillaLongValue(), 1000L);
        lock.lock(1);
        lock.unlock(1);
        try {
            lock.unlock(1);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assert.assertEquals((Object)"Lock already unlocked by threadId 1", (Object)e.getMessage());
        }
    }

    @Test
    public void wrongUnlock() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 1000L);
        lock.lock(1);
        this.expectException("Lock held by another thread 1 not mine 2");
        lock.unlock(2);
        lock.unlock(1);
        Assert.assertEquals((long)0x100000000L, (long)value.getValue());
    }

    @Test
    public void lockTimeOut() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 50L);
        lock.lock(-1);
        this.ignoreException("ThreadId -1 died while holding a lock");
        this.expectException("Successfully forced an unlock for threadId: 2, previous thread held by: -1, status: ");
        lock.lock(2);
        lock.unlock(2);
        this.expectException("Lock previously held by another thread 2 not mine -1");
        lock.unlock(-1);
        Assert.assertEquals((long)0x200000000L, (long)value.getValue());
    }

    @Test
    public void lockTimeOut1() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 50L);
        lock.lock(1);
        this.ignoreException("ThreadId 1 is running while still holding a lock after ");
        this.expectException("Successfully forced an unlock for threadId: 2, previous thread held by: 1, status: ");
        lock.lock(2);
        this.expectException("Lock held by another thread 2 not mine 1");
        lock.unlock(1);
        Assert.assertEquals((long)0x100000002L, (long)value.getValue());
    }

    @Test
    public void raceConditions() {
        CheckingLongValue value = new CheckingLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 100L);
        value.getValues.add(0L);
        value.getValues.add(2L);
        value.getValues.add(0x200000000L);
        value.getValues.add(0x200000000L);
        lock.lock(1);
        Assert.assertEquals((long)0L, (long)value.getValues.size());
        Assert.assertEquals((Object)"200000001", (Object)value.setValues.stream().map(Long::toHexString).collect(Collectors.joining(", ")));
        value.setValues.clear();
        value.getValues.add(0x200000001L);
        value.getValues.add(0x100000000L);
        this.expectException("Failed to unlock");
        lock.unlock(1);
        Assert.assertEquals((long)0L, (long)value.getValues.size());
        Assert.assertEquals((long)0L, (long)value.setValues.size());
    }

    @Test
    public void raceConditions2() {
        CheckingLongValue value = new CheckingLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 100L);
        lock.busyLockSlowerCount = 1;
        lock.busyLoopCount = 1;
        long deadThreadId = 0x80000000L;
        this.ignoreException("ThreadId -2147483648 died while holding a lock");
        value.getValues.add(0x80000000L);
        value.getValues.add(0x80000000L);
        value.getValues.add(0x80000000L);
        if (VanillaThreadLock.METRICS.supportsProc) {
            value.getValues.add(0x80000000L);
        }
        value.getValues.add(0x80000000L);
        this.ignoreException("Failed to forced an unlock for threadId: 1");
        value.getValues.add(Long.MIN_VALUE);
        value.getValues.add(Long.MIN_VALUE);
        value.getValues.add(0x80000000L);
        value.getValues.add(0x80000000L);
        value.getValues.add(0x80000000L);
        if (VanillaThreadLock.METRICS.supportsProc) {
            value.getValues.add(Long.MIN_VALUE);
        }
        value.getValues.add(Long.MIN_VALUE);
        value.getValues.add(Long.MIN_VALUE);
        lock.lock(1);
        Assert.assertEquals((long)0L, (long)value.getValues.size());
        Assert.assertEquals((Object)"8000000000000001", (Object)value.setValues.stream().map(Long::toHexString).collect(Collectors.joining(", ")));
    }

    @Test
    public void interrupted() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 100L);
        Thread thread = Thread.currentThread();
        lock.lock(2);
        thread.interrupt();
        try {
            lock.lock(1);
            Assert.fail((String)"Should have interrupted");
        }
        catch (InterruptedRuntimeException interruptedRuntimeException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)thread.isInterrupted());
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidThreadId() {
        VanillaLongValue value = new VanillaLongValue();
        VanillaThreadLock lock = new VanillaThreadLock(value, 100L);
        lock.lock(0);
    }

    static class CheckingLongValue
    extends VanillaLongValue {
        List<Long> getValues = new ArrayList<Long>();
        List<Long> setValues = new ArrayList<Long>();

        CheckingLongValue() {
        }

        @Override
        public long getValue() throws IllegalStateException {
            return this.getValues.remove(0);
        }

        @Override
        public void setValue(long value) throws IllegalStateException {
            this.setValues.add(value);
        }
    }

    static class VanillaLongValue
    implements LongValue {
        long value;

        VanillaLongValue() {
        }

        @Override
        public long getValue() throws IllegalStateException {
            return this.value;
        }

        @Override
        public void setValue(long value) throws IllegalStateException {
            this.value = value;
        }

        @Override
        public long addValue(long delta) throws IllegalStateException {
            throw new AssertionError();
        }

        @Override
        public boolean compareAndSwapValue(long expected, long value) throws IllegalStateException {
            if (this.getValue() == expected) {
                this.setValue(value);
                return true;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        }
    }
}

