/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.util.Arrays;
import java.util.List;
import java.util.function.IntPredicate;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.UnsafeMemoryTestMixin;
import net.openhft.chronicle.core.util.Ints;
import net.openhft.chronicle.testframework.Series;

final class UnsafeMemoryShortTest
implements UnsafeMemoryTestMixin<Short> {
    UnsafeMemoryShortTest() {
    }

    @Override
    public Class<Short> type() {
        return Short.class;
    }

    @Override
    public IntPredicate alignedToType() {
        return Ints.shortAligned();
    }

    @Override
    public Short zero() {
        return (short)0;
    }

    @Override
    public Short nonZero() {
        return (short)Short.MIN_VALUE;
    }

    @Override
    public Stream<Short> sequence() {
        return Series.powersOfTwo().limit(15L).flatMap(i -> LongStream.of(-i - 1L, -i, -i + 1L, i - 1L, i, i + 1L)).filter(i -> i > -32768L && i < 32767L).distinct().sorted().mapToObj(i -> (short)i);
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Short>>> addressWriteOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Short>>("UnsafeMemory::writeShort", UnsafeMemory::writeShort), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongObjConsumer<Short>>("UnsafeMemory::writeVolatileShort", UnsafeMemory::writeVolatileShort));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Short>>> addressReadOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Short>>("UnsafeMemory::readShort", UnsafeMemory::readShort), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryLongFunction<Short>>("UnsafeMemory::readVolatileShort", UnsafeMemory::readVolatileShort));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Short>>> objectWriteOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Short>>("UnsafeMemory::unsafePutShort(Object)", (m, obj, offset, v) -> UnsafeMemory.unsafePutShort(obj, offset, v)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Short>>("UnsafeMemory::writeShort", UnsafeMemory::writeShort), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Short>>("UnsafeMemory::writeVolatileShort", UnsafeMemory::writeVolatileShort));
    }

    @Override
    public List<UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Short>>> objectReadOperations() {
        return Arrays.asList(new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Short>>("UnsafeMemory::unsafeGetShort", (m, o, a) -> UnsafeMemory.unsafeGetShort(o, a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Short>>("UnsafeMemory::readShort", (m, o, a) -> UnsafeMemory.unsafeGetShort(o, a)), new UnsafeMemoryTestMixin.NamedOperation<UnsafeMemoryTestMixin.MemoryObjLongFunction<Short>>("UnsafeMemory::readVolatileShort", UnsafeMemory::readVolatileShort));
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryLongObjConsumer<Short> addressWriteVolatileOperation() {
        return UnsafeMemory::writeVolatileShort;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryLongFunction<Short> addressReadVolatileOperation() {
        return UnsafeMemory::readVolatileShort;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryObjLongObjConsumer<Short> objectWriteVolatileOperation() {
        return UnsafeMemory::writeVolatileShort;
    }

    @Override
    public UnsafeMemoryTestMixin.MemoryObjLongFunction<Short> objectReadVolatileOperation() {
        return UnsafeMemory::readVolatileShort;
    }
}

