/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.threads.ThreadDump;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.rules.TestName;

public class OSTest {
    @Rule
    public final TestName testName = new TestName();
    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void testIs64Bit() {
        boolean expected = Stream.of("com.ibm.vm.bitmode", "sun.arch.data.model").map(System::getProperty).filter(Objects::nonNull).anyMatch(p -> p.contains("64")) || Stream.of("java.vm.version").map(System::getProperty).filter(Objects::nonNull).anyMatch(p -> p.contains("_64"));
        Assert.assertEquals((Object)expected, (Object)OS.is64Bit());
    }

    @Test
    public void testGetProcessId() {
        int processId = OS.getProcessId();
        Assertions.assertTrue((processId > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMapGranularity() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File file = IOTools.createTempFile(this.getClass().getName() + "." + this.testName.getMethodName());
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            FileChannel fc = rw.getChannel();
            long length = OS.pageSize();
            MappedByteBuffer anchor = fc.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            anchor.order(ByteOrder.nativeOrder());
            long address = OS.map0(fc, OS.imodeFor(FileChannel.MapMode.READ_WRITE), 0L, length);
            OS.memory().writeLong(address, 0L);
            OS.unmap(address, length);
            Assert.assertEquals((long)length, (long)file.length());
        }
    }

    @Test
    public void testMap() throws IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File file = IOTools.createTempFile(this.getClass().getName() + "." + this.testName.getMethodName());
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            long offset;
            FileChannel fc = rw.getChannel();
            long length = 0x8000000L;
            long anchorSize = 0x40000000L;
            int anchorCount = (int)((length + anchorSize - 1L) / anchorSize);
            ArrayList<MappedByteBuffer> anchors = new ArrayList<MappedByteBuffer>();
            long anchorTotalRemain = length;
            for (int i = 0; i < anchorCount; ++i) {
                MappedByteBuffer anchor = fc.map(FileChannel.MapMode.READ_WRITE, (long)i * anchorSize, Math.min(anchorTotalRemain, anchorSize));
                anchor.order(ByteOrder.nativeOrder());
                anchors.add(anchor);
                anchorTotalRemain -= anchorSize;
            }
            long address = OS.map0(fc, OS.imodeFor(FileChannel.MapMode.READ_WRITE), 0L, length);
            for (offset = 0L; offset < length; offset += (long)OS.pageSize()) {
                OS.memory().writeLong(address + offset, offset);
            }
            for (offset = 0L; offset < length; offset += (long)OS.pageSize()) {
                Assert.assertEquals((long)offset, (long)OS.memory().readLong(address + offset));
            }
            OS.unmap(address, length);
        }
    }

    @Test
    public void testMapFast() throws Exception {
        File file = IOTools.createTempFile(this.getClass().getName() + "." + this.testName.getMethodName());
        try (RandomAccessFile rw = new RandomAccessFile(file, "rw");){
            FileChannel fc = rw.getChannel();
            long length = 8L;
            MappedByteBuffer anchor = fc.map(FileChannel.MapMode.READ_WRITE, 0L, length);
            anchor.order(ByteOrder.nativeOrder());
            long address = OS.map0(fc, OS.imodeFor(FileChannel.MapMode.READ_WRITE), 0L, length);
            long value = System.currentTimeMillis();
            value ^= value << 32;
            OS.memory().writeLong(address, value);
            Assert.assertEquals((long)value, (long)OS.memory().readLong(address));
            Assert.assertEquals((long)value, (long)anchor.getLong(0));
            OS.unmap(address, length);
        }
    }

    @Test
    public void getHostname() throws IOException {
        System.out.println("exec hostname: " + OS.HostnameHolder.execHostname());
        String hostName = OS.getHostName();
        System.out.println("hostname: " + hostName);
        Assert.assertNotNull((Object)hostName);
        Assert.assertNotEquals((Object)"", (Object)hostName);
        Assume.assumeTrue((OS.isWindows() || OS.isLinux() || OS.isMacOSX() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)"localhost", (Object)hostName);
    }

    @Test
    public void getIPAddress() {
        System.out.println("getIpAddressByLocalHost: " + OS.IPAddressHolder.getIpAddressByLocalHost());
        System.out.println("getIpAddressByDatagram " + OS.IPAddressHolder.getIpAddressByDatagram());
        System.out.println("getIpAddressBySocket: " + OS.IPAddressHolder.getIpAddressBySocket());
        String ipAddress = OS.getIPAddress();
        System.out.println("ipAddress: " + ipAddress);
        Assert.assertNotNull((Object)ipAddress);
        Assert.assertNotEquals((Object)"", (Object)ipAddress);
        Assume.assumeTrue((OS.isWindows() || OS.isLinux() || OS.isMacOSX() ? 1 : 0) != 0);
        Assert.assertNotEquals((Object)"0.0.0.0", (Object)ipAddress);
    }

    @Test
    public void getTarget() {
        String target = OS.getTarget();
        Assert.assertEquals((Object)"target", (Object)target);
    }

    @Test
    public void getTmp() {
        String tmp = OS.getTmp();
        Assert.assertNotNull((Object)tmp);
    }
}

