/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.IOException;
import java.util.Map;
import javax.naming.TimeLimitExceededException;
import junit.framework.TestCase;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.LicenceCheck;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LicenceCheckTest {
    @After
    public void tearDown() {
        System.getProperties().remove("chronicle.license");
        Jvm.resetExceptionHandlers();
    }

    @Test(expected=TimeLimitExceededException.class)
    public void checkIfNoExpiryFile() {
        Map<ExceptionKey, Integer> map = Jvm.recordExceptions();
        LicenceCheck.check("test", LicenceCheck.class);
        Assert.fail((String)"should have got an AssertionError");
    }

    @Test(expected=TimeLimitExceededException.class)
    public void checkEvalExpired() throws IOException {
        LicenceCheck.check("test", TestCase.class);
    }

    @Test
    public void checkLicense() {
        System.setProperty("chronicle.license", "product=test.,owner=Test Unit,expires=9999-01-01,code=123456789");
        Map<ExceptionKey, Integer> map = Jvm.recordExceptions();
        LicenceCheck.check("test", null);
        System.out.println(map);
        Assert.assertTrue((boolean)map.toString().contains("License for Test Unit expires in 29"));
    }

    @Test(expected=TimeLimitExceededException.class)
    public void checkLicenseExpired() {
        System.setProperty("chronicle.license", "product=test.,owner=Test Unit,expires=2019-01-01,code=123456789");
        LicenceCheck.check("test", null);
    }
}

