/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.function.Predicate;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.internal.JvmExceptionTracker;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.threads.CleaningThread;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.testframework.internal.ExceptionTracker;
import net.openhft.chronicle.wire.MessageHistory;
import org.junit.After;
import org.junit.Before;

public class QueueTestCommon {
    protected ThreadDump threadDump;
    protected boolean finishedNormally;
    private ExceptionTracker<ExceptionKey> exceptionTracker;

    @Before
    public void assumeFinishedNormally() {
        this.finishedNormally = true;
    }

    @Before
    public void clearMessageHistory() {
        MessageHistory.get().reset();
    }

    @Before
    public void enableReferenceTracing() {
        AbstractReferenceCounted.enableReferenceTracing();
    }

    public void assertReferencesReleased() {
        AbstractReferenceCounted.assertReferencesReleased();
    }

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    public void checkThreadDump() {
        this.threadDump.assertNoNewThreads();
    }

    @Before
    public void recordExceptions() {
        this.exceptionTracker = JvmExceptionTracker.create();
        if (OS.isWindows()) {
            this.ignoreException("Read-only mode is not supported on Windows\u00ae platforms, defaulting to read/write");
        }
        for (String msg : "Shrinking ,Allocation of , ms to add mapping for ,jar to the classpath, ms to pollDiskSpace for , us to linearScan by position from ,File released ,Overriding roll length from existing metadata, was 3600000, overriding to 86400000   ".split(",")) {
            this.ignoreException(msg);
        }
    }

    public void ignoreException(String message) {
        this.exceptionTracker.ignoreException(message);
    }

    public void expectException(String message) {
        this.exceptionTracker.expectException(message);
    }

    public void ignoreException(Predicate<ExceptionKey> predicate, String description) {
        this.exceptionTracker.ignoreException(predicate, description);
    }

    public void expectException(Predicate<ExceptionKey> predicate, String description) {
        this.exceptionTracker.expectException(predicate, description);
    }

    public void checkExceptions() {
        this.exceptionTracker.checkExceptions();
    }

    @After
    public void afterChecks() {
        this.preAfter();
        SystemTimeProvider.CLOCK = SystemTimeProvider.INSTANCE;
        CleaningThread.performCleanup((Thread)Thread.currentThread());
        System.gc();
        AbstractCloseable.waitForCloseablesToClose((long)1000L);
        if (this.finishedNormally) {
            this.assertReferencesReleased();
            this.checkThreadDump();
            this.checkExceptions();
        }
        this.tearDown();
    }

    protected void preAfter() {
    }

    protected void tearDown() {
    }
}

