/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.core.util.ObjectUtils;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.ExcerptListener;
import net.openhft.chronicle.wire.MarshallableIn;
import net.openhft.chronicle.wire.domestic.AutoTailers;
import net.openhft.chronicle.wire.internal.reduction.ReductionUtil;
import org.jetbrains.annotations.NotNull;

public final class InternalAutoTailers {
    private InternalAutoTailers() {
    }

    private static abstract class AbstractPoller
    implements AutoCloseable {
        private final ExcerptListener excerptListener;
        private final MarshallableIn tailer;
        private final Runnable closer;
        private volatile boolean running = true;

        protected AbstractPoller(@NotNull Supplier<? extends MarshallableIn> tailerSupplier, @NotNull ExcerptListener excerptListener) {
            ObjectUtils.requireNonNull(tailerSupplier);
            this.excerptListener = ObjectUtils.requireNonNull(excerptListener);
            this.tailer = ObjectUtils.requireNonNull(tailerSupplier.get());
            this.closer = AbstractPoller.closer(this.tailer);
        }

        protected ExcerptListener excerptListener() {
            return this.excerptListener;
        }

        protected MarshallableIn tailer() {
            return this.tailer;
        }

        protected Runnable closer() {
            return this.closer;
        }

        protected boolean running() {
            return this.running;
        }

        @Override
        public final void close() {
            this.running = false;
        }

        private static Runnable closer(MarshallableIn tailer) {
            if (tailer instanceof AutoCloseable) {
                AutoCloseable ac = (AutoCloseable)((Object)tailer);
                return () -> {
                    try {
                        ac.close();
                    }
                    catch (Exception e) {
                        throw Jvm.rethrow(e);
                    }
                };
            }
            return () -> {};
        }
    }

    public static final class EventHandlerPoller
    extends AbstractPoller
    implements AutoTailers.CloseableEventHandler {
        public EventHandlerPoller(@NotNull Supplier<? extends MarshallableIn> tailerSupplier, @NotNull ExcerptListener excerptListener) {
            super(tailerSupplier, excerptListener);
        }

        @Override
        public boolean action() throws InvalidEventHandlerException {
            if (!this.running()) {
                this.closer().run();
                throw InvalidEventHandlerException.reusable();
            }
            return ReductionUtil.accept(this.tailer(), this.excerptListener()) != -1L;
        }
    }

    public static final class RunnablePoller
    extends AbstractPoller
    implements AutoTailers.CloseableRunnable {
        private final Pauser pauser;

        public RunnablePoller(@NotNull Supplier<? extends MarshallableIn> tailerSupplier, @NotNull ExcerptListener excerptListener, @NotNull Supplier<Pauser> pauserSupplier) {
            super(tailerSupplier, excerptListener);
            ObjectUtils.requireNonNull(pauserSupplier);
            this.pauser = ObjectUtils.requireNonNull(pauserSupplier.get());
        }

        @Override
        public void run() {
            try {
                while (this.running()) {
                    if (ReductionUtil.accept(this.tailer(), this.excerptListener()) == -1L) continue;
                    this.pauser.pause();
                }
            }
            finally {
                this.closer().run();
            }
        }
    }
}

