/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire;

import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MethodWireKey;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.WireCommon;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

@DontChain
public interface WireOut
extends WireCommon,
MarshallableOut {
    @NotNull
    public ValueOut write();

    @NotNull
    default public ValueOut writeEventName(WireKey key) {
        return this.write(key);
    }

    default public ValueOut writeEventName(CharSequence key) {
        return this.write(key);
    }

    default public ValueOut writeEvent(Class expectedType, Object eventKey) {
        if (eventKey instanceof WireKey) {
            return this.writeEventName((WireKey)eventKey);
        }
        if (eventKey instanceof CharSequence) {
            return this.writeEventName((CharSequence)eventKey);
        }
        this.writeStartEvent();
        this.getValueOut().object(expectedType, eventKey);
        this.writeEndEvent();
        return this.getValueOut();
    }

    default public ValueOut writeEventId(int methodId) {
        return this.write(new MethodWireKey(null, methodId));
    }

    default public ValueOut writeEventId(String name, int methodId) {
        return this.write(new MethodWireKey(name, methodId));
    }

    @NotNull
    public ValueOut write(WireKey var1);

    public ValueOut write(CharSequence var1);

    @NotNull
    public ValueOut getValueOut();

    public ObjectOutput objectOutput();

    @NotNull
    public WireOut writeComment(CharSequence var1);

    @NotNull
    public WireOut addPadding(int var1);

    @NotNull
    default public WireOut padToCacheAlign() {
        @NotNull Bytes<?> bytes = this.bytes();
        try {
            int mod;
            long offset = bytes.writePosition();
            if (bytes.start() != 0L) {
                offset = bytes.addressForRead(offset);
            }
            if ((mod = (int)(offset & 0x3FL)) > 60) {
                this.addPadding(64 - mod);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    @NotNull
    default public WireOut writeAlignTo(int alignment, int plus) {
        if (!1.$assertionsDisabled && Integer.bitCount(alignment) != 1) {
            throw new AssertionError();
        }
        long mod = this.bytes().writePosition() + (long)plus & (long)(alignment - 1);
        if (mod != 0L) {
            this.addPadding((int)((long)alignment - mod));
        }
        return this;
    }

    @Override
    public void clear();

    default public void writeDocument(boolean metaData, @NotNull WriteMarshallable writer) {
        WireInternal.writeData(this, metaData, false, writer);
    }

    @Override
    public DocumentContext writingDocument(boolean var1);

    @Override
    @NotNull
    default public DocumentContext writingDocument() {
        return this.writingDocument(false);
    }

    @Override
    public DocumentContext acquireWritingDocument(boolean var1);

    default public void writeNotCompleteDocument(boolean metaData, @NotNull WriteMarshallable writer) {
        WireInternal.writeData(this, metaData, true, writer);
    }

    public void updateHeader(long var1, boolean var3, int var4) throws StreamCorruptedException;

    public long enterHeader(long var1);

    public boolean writeFirstHeader();

    public void updateFirstHeader();

    public boolean writeEndOfWire(long var1, TimeUnit var3, long var4);

    public void writeStartEvent();

    public void writeEndEvent();

    default public <K, V> void writeAllAsMap(Class<K> kClass, Class<V> vClass, @NotNull Map<K, V> map) {
        map.forEach((k, v) -> this.writeEvent(kClass, k).object(vClass, v));
    }

    @NotNull
    default public WireOut dropDefault(boolean dropDefault) {
        return this;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

