/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import net.openhft.chronicle.core.util.GenericReflection;
import net.openhft.chronicle.core.util.TypeOf;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericReflectionTest {
    GenericReflectionTest() {
    }

    @Test
    void getReturnType() {
        Assertions.assertEquals(String.class, (Object)GenericReflection.getReturnType(Returns.class.getMethods()[0], ReturnsString.class));
        Assertions.assertEquals(Integer.class, (Object)GenericReflection.getReturnType(Returns.class.getMethods()[0], ReturnsInteger.class));
        Assertions.assertEquals(Double.class, (Object)GenericReflection.getReturnType(Returns2.class.getMethods()[0], Returns2Double.class));
        Type t = GenericReflection.getReturnType(ReturnsReturnsAString.class.getMethods()[0], ReturnsReturnsAString.class);
        Assertions.assertEquals((Object)new TypeOf<Returns<String>>(){}.type(), (Object)t);
    }

    @Test
    public void getMethodReturnTypes() {
        Type returnString = new TypeOf<Returns<String>>(){}.type();
        Set<Type> methodReturnTypes = GenericReflection.getMethodReturnTypes(ReturnsString.class);
        Assertions.assertEquals(methodReturnTypes, GenericReflection.getMethodReturnTypes(returnString));
    }

    @Test
    public void getGenericInterfaces() {
        Type returnString = new TypeOf<Returns<String>>(){}.type();
        Object[] genericInterfaces = GenericReflection.getGenericInterfaces(ReturnsString.class);
        Assertions.assertArrayEquals((Object[])genericInterfaces, (Object[])GenericReflection.getGenericInterfaces(returnString));
    }

    @Test
    public void getGenericSuperclass() {
        Type returnString = new TypeOf<Returns<String>>(){}.type();
        Type genericSuperclass = GenericReflection.getGenericSuperclass(ReturnsString.class);
        Assertions.assertEquals((Object)genericSuperclass, (Object)GenericReflection.getGenericSuperclass(returnString));
    }

    @Test
    public void getParameterTypes() throws NoSuchMethodException {
        Method method = GenericMethod.class.getDeclaredMethod("method", Object.class, Object.class);
        String expected = "[class java.lang.Byte, class java.lang.Short]";
        Assertions.assertEquals((Object)"[class java.lang.Byte, class java.lang.Short]", (Object)Arrays.toString(GenericReflection.getParameterTypes(method, ExtendsGenericMethod.class)));
        Method omethod = OverridesGenericMethod.class.getDeclaredMethod("method", Byte.class, Short.class);
        Assertions.assertEquals((Object)"[class java.lang.Byte, class java.lang.Short]", (Object)Arrays.toString(GenericReflection.getParameterTypes(omethod, OverridesGenericMethod.class)));
        Assertions.assertEquals((Object)"[class java.lang.Byte, class java.lang.Short]", (Object)Arrays.toString(GenericReflection.getParameterTypes(method, OverridesGenericMethod.class)));
    }

    class Returns2Double
    extends Returns2<Double> {
        Returns2Double() {
        }

        @Override
        public Double ret() {
            return 1.0;
        }
    }

    class Returns2<A> {
        Returns2() {
        }

        public A ret() {
            return null;
        }
    }

    class ReturnsInteger
    implements Returns<Integer> {
        ReturnsInteger() {
        }

        @Override
        public Integer ret() {
            return null;
        }
    }

    static interface OverridesGenericMethod
    extends GenericMethod<Byte, Short> {
        @Override
        public void method(Byte var1, Short var2);
    }

    static interface ExtendsGenericMethod
    extends GenericMethod<Byte, Short> {
    }

    static interface GenericMethod<A, B> {
        public void method(A var1, B var2);
    }

    static interface ReturnsString
    extends Returns<String> {
    }

    static interface ReturnsReturnsAString {
        public Returns<String> retRS();
    }

    static interface Returns<A> {
        public A ret();
    }
}

