/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class UnsafePingPointMain
implements Runnable {
    private final Unsafe unsafe;
    private final long addrA;
    private final long addrB;

    public UnsafePingPointMain(Unsafe unsafe, long addrA, long addrB) {
        this.unsafe = unsafe;
        this.addrA = addrA;
        this.addrB = addrB;
    }

    @NotNull
    public static Unsafe getUnsafe() {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            return (Unsafe)theUnsafe.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void main(String[] args) {
        @NotNull Unsafe unsafe = UnsafePingPointMain.getUnsafe();
        long memory = unsafe.allocateMemory(262144L);
        long addr1 = memory + 63L;
        long addr2 = addr1 + 4096L;
        new Thread(new UnsafePingPointMain(unsafe, addr1, addr2)).start();
        new Thread(new UnsafePingPointMain(unsafe, addr2, addr1)).start();
    }

    @Override
    public void run() {
        for (int i = 0; i < 10000000; ++i) {
            this.toggle(0, -1);
            this.toggle(-1, 0);
        }
    }

    private void toggle(int x, int y) {
        if (!this.unsafe.compareAndSwapInt(null, this.addrA, x, y)) assert (false);
        int value = this.unsafe.getIntVolatile(null, this.addrB);
        int count = 1000;
        while (value != y && count-- > 0) {
            if (value != x) {
                System.out.println(Long.toHexString(this.addrB) + " was " + Integer.toHexString(value));
            }
            value = this.unsafe.getIntVolatile(null, this.addrB);
        }
    }
}

