/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.openhft.chronicle.core.CleaningRandomAccessFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CleaningRandomAccessFileTest {
    static int getFDs() {
        if (!OS.isLinux()) {
            return -1;
        }
        return new File("/proc/self/fd").list().length;
    }

    @Before
    public void cleanUp() {
        System.gc();
        Jvm.pause(100L);
    }

    @Test
    public void resourceLeak() throws IOException {
        File tempDir = IOTools.createTempFile("resourceLeak");
        tempDir.mkdir();
        int repeat = Jvm.isArm() ? 6 : 50;
        block0: for (int j = 0; j < repeat; ++j) {
            int files = CleaningRandomAccessFileTest.getFDs();
            if (files > 0) {
                Assert.assertEquals((String)("j: " + j), (float)200.0f, (float)files, (float)200.0f);
            }
            ByteBuffer bb = ByteBuffer.allocateDirect(64);
            for (int i = 0; i < 200; ++i) {
                CleaningRandomAccessFile file = new CleaningRandomAccessFile(tempDir + "/file" + i, "rw");
                bb.clear();
                file.getChannel().write(bb);
            }
            long start = System.currentTimeMillis();
            System.gc();
            for (int i = 0; i < 40; ++i) {
                Jvm.pause(20L);
                if (CleaningRandomAccessFileTest.getFDs() >= 200) continue;
                double time = (double)(System.currentTimeMillis() - start) / 1000.0;
                if (!(time > 0.1)) continue block0;
                System.out.println("resourceLeak() - Took " + time + " seconds.");
                continue block0;
            }
        }
        IOTools.deleteDirWithFiles(tempDir);
    }
}

