/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.testframework.process.ProcessRunner;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ChronicleInitTest {
    public static void main(String[] args) {
        Assertions.assertFalse((boolean)Jvm.isResourceTracing());
    }

    @Test
    public void testPositive() throws Exception {
        Process process = ProcessRunner.runClass(ChronicleInitTest.class, (String[])new String[]{"-Dchronicle.init.runnable=" + ResourceTracingInit.class.getName()}, (String[])new String[0]);
        try {
            Assertions.assertEquals((int)0, (int)process.waitFor());
        }
        finally {
            ProcessRunner.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testNoInit() throws Exception {
        Process process = ProcessRunner.runClass(ChronicleInitTest.class, (String[])new String[0]);
        try {
            Assertions.assertNotEquals((int)0, (int)process.waitFor());
        }
        finally {
            ProcessRunner.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    @Test
    public void testBadClass() throws Exception {
        Process process = ProcessRunner.runClass(ChronicleInitTest.class, (String[])new String[]{"-Dchronicle.init.class=" + ChronicleInitTest.class.getName()}, (String[])new String[0]);
        try {
            Assertions.assertNotEquals((int)0, (int)process.waitFor());
        }
        finally {
            ProcessRunner.printProcessOutput((String)"ChronicleInitTest", (Process)process);
        }
    }

    public static class ResourceTracingInit
    implements Runnable {
        @Override
        public void run() {
            System.err.println("disabling resource tracking");
            System.setProperty("jvm.resource.tracing", "false");
        }
    }
}

