/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.bytes.MethodReader;
import net.openhft.chronicle.core.time.SetTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueTestBase;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.LATMsg;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MessageHistory;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class LastAppendedTest
extends ChronicleQueueTestBase {
    public static final RollCycles ROLL_CYCLE = RollCycles.TEST4_SECONDLY;

    @Test
    void testLastWritten() {
        SetTimeProvider timeProvider = new SetTimeProvider(0L).advanceMillis(1000L);
        File outQueueDir = this.getTmpDir();
        File inQueueDir = this.getTmpDir();
        try (SingleChronicleQueue outQueue = SingleChronicleQueueBuilder.single((File)outQueueDir).rollCycle((RollCycle)ROLL_CYCLE).sourceId(1).timeProvider((TimeProvider)timeProvider).build();
             SingleChronicleQueue inQueue = SingleChronicleQueueBuilder.single((File)inQueueDir).rollCycle((RollCycle)ROLL_CYCLE).sourceId(2).timeProvider((TimeProvider)timeProvider).build();){
            LATMsg msg = (LATMsg)inQueue.acquireAppender().methodWriterBuilder(LATMsg.class).get();
            msg.msg("somedata-0");
            timeProvider.advanceMillis(1000L);
            msg.msg("somedata-1");
            LATMsg out = (LATMsg)outQueue.acquireAppender().methodWriterBuilder(LATMsg.class).get();
            Object[] objectArray = new Object[1];
            objectArray[0] = out::msg;
            MethodReader methodReader = inQueue.createTailer().methodReader(objectArray);
            methodReader.readOne();
            methodReader.readOne();
            msg.msg("somedata-2");
            timeProvider.advanceMillis(2000L);
            msg.msg("somedata-3");
            msg.msg("somedata-4");
            AtomicReference actualValue = new AtomicReference();
            ExcerptTailer excerptTailer = inQueue.createTailer().afterLastWritten((ChronicleQueue)outQueue);
            long index = excerptTailer.index();
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = actualValue::set;
            MethodReader methodReader2 = excerptTailer.methodReader(objectArray2);
            methodReader2.readOne();
            try {
                Assert.assertEquals((Object)"somedata-2", actualValue.get());
                methodReader2.readOne();
                Assert.assertEquals((Object)"somedata-3", actualValue.get());
                methodReader2.readOne();
                Assert.assertEquals((Object)"somedata-4", actualValue.get());
            }
            catch (AssertionError ae) {
                System.out.println("index: " + Long.toHexString(index));
                System.out.println("inQueue");
                System.out.println(inQueue.dump());
                System.out.println("outQueue");
                System.out.println(outQueue.dump());
                throw ae;
            }
        }
    }

    @Test
    void testLastWrittenMetadata0() {
        SetTimeProvider timeProvider = new SetTimeProvider(0L).advanceMillis(1000L);
        File outQueueDir = this.getTmpDir();
        File inQueueDir = this.getTmpDir();
        try (SingleChronicleQueue outQueue = SingleChronicleQueueBuilder.single((File)outQueueDir).rollCycle((RollCycle)ROLL_CYCLE).sourceId(1).timeProvider((TimeProvider)timeProvider).build();
             SingleChronicleQueue inQueue = SingleChronicleQueueBuilder.single((File)inQueueDir).rollCycle((RollCycle)ROLL_CYCLE).sourceId(2).timeProvider((TimeProvider)timeProvider).build();){
            LATMsg msg = (LATMsg)inQueue.acquireAppender().methodWriterBuilder(LATMsg.class).get();
            msg.msg("somedata-0");
            msg.msg("somedata-1");
            LATMsg out = (LATMsg)outQueue.acquireAppender().methodWriterBuilder(LATMsg.class).get();
            Object[] objectArray = new Object[1];
            objectArray[0] = out::msg;
            Object methodReader = inQueue.createTailer().methodReader(objectArray);
            methodReader.readOne();
            methodReader.readOne();
            msg.msg("somedata-2");
            msg.msg("somedata-3");
            msg.msg("somedata-4");
            DocumentContext dc = outQueue.acquireAppender().writingDocument(true);
            methodReader = null;
            try {
                dc.wire().write((CharSequence)"some metadata");
            }
            catch (Throwable throwable) {
                methodReader = throwable;
                throw throwable;
            }
            finally {
                if (dc != null) {
                    if (methodReader != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)methodReader).addSuppressed(throwable);
                        }
                    } else {
                        dc.close();
                    }
                }
            }
            AtomicReference actualValue = new AtomicReference();
            ExcerptTailer excerptTailer = inQueue.createTailer().afterLastWritten((ChronicleQueue)outQueue);
            long index = excerptTailer.index();
            try (DocumentContext dc2 = excerptTailer.readingDocument();){
                Assert.assertTrue((boolean)dc2.isPresent());
                MessageHistory mh = (MessageHistory)dc2.wire().read("history").object((Object)MessageHistory.get(), MessageHistory.class);
                Assert.assertTrue((String)mh.toString(), (boolean)mh.toString().startsWith("VanillaMessageHistory{sources: [2=0x100000002] timings: "));
                String msg0 = (String)dc2.wire().readEvent(String.class);
                Assert.assertEquals((Object)"msg", (Object)msg0);
                Object o = dc2.wire().getValueIn().object();
                Assert.assertEquals((Object)"somedata-2", (Object)o);
            }
            Assert.assertTrue((boolean)excerptTailer.moveToIndex(index));
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = actualValue::set;
            MethodReader methodReader2 = excerptTailer.methodReader(objectArray2);
            try {
                methodReader2.readOne();
                Assert.assertEquals((Object)"somedata-2", actualValue.get());
                methodReader2.readOne();
                Assert.assertEquals((Object)"somedata-3", actualValue.get());
                methodReader2.readOne();
                Assert.assertEquals((Object)"somedata-4", actualValue.get());
            }
            catch (AssertionError ae) {
                System.out.println("index: " + Long.toHexString(index));
                System.out.println("inQueue");
                System.out.println(inQueue.dump());
                System.out.println("outQueue");
                System.out.println(outQueue.dump());
                throw ae;
            }
        }
    }
}

