/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import java.util.Arrays;
import net.openhft.chronicle.core.util.Histogram;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class HistogramTest {
    @Test
    public void percentilesFor() {
        Assert.assertEquals((Object)"[0.5, 0.9, 0.99, 0.997, 0.999, 0.9997, 0.9999, 0.99997, 0.99999, 0.999997, 1.0]", (Object)Arrays.toString(Histogram.percentilesFor(50000000L)));
    }

    @Test
    public void singleSample() {
        Histogram h = new Histogram();
        h.sampleNanos(100000L);
        Assert.assertEquals((Object)"50/90 97/99 99.7/99.9 99.97/99.99 - worst was 100.0 / 100.0  100.0 / 100.0  100.0 / 100.0  100.0 / 100.0 - 100.0", (Object)h.toLongMicrosFormat());
    }

    @Test
    public void testSampleRange() {
        @NotNull Histogram h = new Histogram(40, 2);
        double base = 1.0;
        for (int i = 0; i < 40; ++i) {
            Assert.assertEquals((long)(i * 4 + 0), (long)h.sample(base));
            Assert.assertEquals((long)(i * 4 + 1), (long)h.sample(base * 1.25));
            Assert.assertEquals((long)(i * 4 + 2), (long)h.sample(base * 1.5));
            Assert.assertEquals((long)(i * 4 + 3), (long)h.sample(base * 1.75));
            base *= 2.0;
        }
        Assert.assertEquals((Object)"50/90 99/99.9 99.99 - worst was 980 / 77,309,410  893,353,200 / 1,030,792,150  1,030,792,150 - 1,030,792,150", (Object)h.toMicrosFormat());
    }

    @Test
    public void testSamples() {
        int i;
        @NotNull Histogram h = new Histogram(10, 5, 1000.0);
        long seed = 2141L;
        for (i = 0; i <= 500; ++i) {
            h.sampleNanos(seed);
            if ((seed += 128981L) <= 1000000L) continue;
            seed -= 1000000L;
        }
        Assert.assertEquals((Object)"50/90 99/99.9 99.99 - worst was 500 / 890  990 / 990  990 - 990", (Object)h.toMicrosFormat());
        Assert.assertEquals((Object)"50/90 97/99 99.7/99.9 99.97/99.99 - worst was 500 / 890  970 / 990  990 / 990  990 / 990 - 990", (Object)h.toLongMicrosFormat());
        for (i = 1; i <= 100; ++i) {
            Assert.assertEquals((String)("i: " + i), (float)i, (float)this.percentile(h, (double)i / 100.0), (float)1.0f);
        }
        for (i = 1; i <= 100; ++i) {
            Assert.assertEquals((double)i, (double)h.percentageLessThan(i * 10000), (double)2.0);
        }
    }

    private int percentile(@NotNull Histogram h, double fraction) {
        return (int)h.percentile(fraction) / 10000;
    }
}

