/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.ConfigurationException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.onoes.ExceptionHandler;
import net.openhft.chronicle.core.onoes.ExceptionKey;
import net.openhft.chronicle.core.onoes.ThreadLocalisedExceptionHandler;
import net.openhft.chronicle.core.threads.ThreadDump;
import net.openhft.chronicle.core.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import sun.nio.ch.DirectBuffer;

public class JvmTest {
    private ThreadDump threadDump;

    @Before
    public void threadDump() {
        this.threadDump = new ThreadDump();
    }

    @After
    public void checkThreadDump() {
        Jvm.resetExceptionHandlers();
        this.threadDump.assertNoNewThreads();
    }

    @Test
    public void addToClassPath() {
        String propertyBefore = System.getProperty("java.class.path");
        Jvm.addToClassPath(JvmTest.class);
        String propertyAfter = System.getProperty("java.class.path");
        if (JvmTest.class.getClassLoader() instanceof URLClassLoader) {
            Assert.assertNotSame((Object)propertyBefore, (Object)propertyAfter);
        } else {
            Assert.assertSame((Object)propertyBefore, (Object)propertyAfter);
        }
    }

    @Test(expected=ConfigurationException.class)
    public void testRethrow() {
        throw Jvm.rethrow(new ConfigurationException());
    }

    @Test
    public void shouldGetMajorVersion() {
        Assert.assertTrue((Jvm.majorVersion() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void resetExceptionHandlersSetHandlersBackToTheirDefaults() throws IllegalAccessException {
        Jvm.setExceptionHandlers(null, null, null, null);
        Jvm.resetExceptionHandlers();
        Assert.assertSame((Object)Jvm.getField(Jvm.class, "DEFAULT_PERF_EXCEPTION_HANDLER").get(null), (Object)((ThreadLocalisedExceptionHandler)Jvm.perf()).defaultHandler());
        Assert.assertSame((Object)Jvm.getField(Jvm.class, "DEFAULT_WARN_EXCEPTION_HANDLER").get(null), (Object)((ThreadLocalisedExceptionHandler)Jvm.warn()).defaultHandler());
        Assert.assertSame((Object)Jvm.getField(Jvm.class, "DEFAULT_ERROR_EXCEPTION_HANDLER").get(null), (Object)((ThreadLocalisedExceptionHandler)Jvm.error()).defaultHandler());
        Assert.assertSame((Object)Jvm.getField(Jvm.class, "DEFAULT_DEBUG_EXCEPTION_HANDLER").get(null), (Object)((ThreadLocalisedExceptionHandler)Jvm.debug()).defaultHandler());
    }

    @Test
    public void reportThis() {
        Map<ExceptionKey, Integer> map = Jvm.recordExceptions();
        ReportUnoptimised.reportOnce();
        String actual = map.keySet().toString();
        Assert.assertTrue((String)actual, (boolean)actual.contains("JvmTest.reportThis(JvmTest.java"));
    }

    @Test
    public void testIsInternal() {
        Assert.assertTrue((boolean)Jvm.isInternal(String.class.getName()));
        Assert.assertFalse((boolean)Jvm.isInternal(this.getClass().getName()));
    }

    @Test
    public void testGetValue() {
        ByteBuffer bb = ByteBuffer.allocateDirect(128);
        long address = (Long)Jvm.getValue(bb, "address");
        Assert.assertEquals((long)((DirectBuffer)((Object)bb)).address(), (long)address);
    }

    @Test
    public void testUsedDirectMemory() {
        long used = Jvm.usedDirectMemory();
        ByteBuffer.allocateDirect(4096);
        Assert.assertEquals((long)(used + 4096L), (long)Jvm.usedDirectMemory());
    }

    @Test
    public void testMaxDirectMemory() {
        long maxDirectMemory = Jvm.maxDirectMemory();
        Assert.assertTrue((maxDirectMemory > 0L ? 1 : 0) != 0);
    }

    @Test
    public void enableSignals() {
        AtomicBoolean failed = new AtomicBoolean();
        ExceptionHandler handler = (c, m, t) -> failed.set(true);
        Jvm.setWarnExceptionHandler(handler);
        Jvm.setErrorExceptionHandler(handler);
        Jvm.addSignalHandler(signal -> System.out.println(signal + " occurred"));
        Assert.assertFalse((boolean)failed.get());
    }

    @Test
    public void classMetrics() throws IllegalArgumentException {
        Assume.assumeFalse((boolean)Jvm.isArm());
        String expect = "ClassMetrics{offset=" + Jvm.objectHeaderSize() + ", length=16}";
        Assert.assertEquals((Object)expect, (Object)Jvm.classMetrics(ClassA.class).toString());
        Assert.assertEquals((Object)expect, (Object)Jvm.classMetrics(ClassB.class).toString());
        Assert.assertEquals((Object)expect, (Object)Jvm.classMetrics(ClassC.class).toString());
        try {
            Jvm.classMetrics(ClassD.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void microPause() {
        for (int t = 0; t < 4; ++t) {
            long start = System.nanoTime();
            int count = 1000000;
            for (int i = 0; i < count; ++i) {
                Jvm.nanoPause();
            }
            long time = System.nanoTime() - start;
            long avg = time / (long)count;
            if (t <= 0) continue;
            System.out.println("Took " + avg + " ns to nanoPause()");
        }
    }

    @Test
    public void address() {
        ByteBuffer bb = ByteBuffer.allocateDirect(64);
        Assert.assertNotEquals((long)0L, (long)Jvm.address(bb));
        try {
            Jvm.address(ByteBuffer.allocate(64));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void arrayByteBaseOffset() {
        byte[] bytes = new byte[]{0};
        UnsafeMemory.MEMORY.writeByte(bytes, Jvm.arrayByteBaseOffset(), (byte)1);
        Assert.assertEquals((long)1L, (long)bytes[0]);
    }

    @Test
    public void doNotCloseOnInterrupt() throws IOException {
        AtomicBoolean failed = new AtomicBoolean();
        ExceptionHandler handler = (c, m, t) -> failed.set(true);
        Jvm.setWarnExceptionHandler(handler);
        Jvm.setErrorExceptionHandler(handler);
        try (FileChannel fc = FileChannel.open(Paths.get(OS.getTarget(), "doNotCloseOnInterrupt-" + Time.uniqueId() + ".tmp"), StandardOpenOption.APPEND, StandardOpenOption.CREATE_NEW, StandardOpenOption.DELETE_ON_CLOSE);){
            Jvm.doNotCloseOnInterrupt(this.getClass(), fc);
        }
        Assert.assertFalse((boolean)failed.get());
    }

    @Test
    public void isProcessAliveTest() {
        long pid = Jvm.getProcessId();
        Assert.assertTrue((boolean)Jvm.isProcessAlive(pid));
        if (OS.isLinux()) {
            Assert.assertTrue((boolean)Jvm.isProcessAlive(1L));
        }
        Assert.assertFalse((boolean)Jvm.isProcessAlive(-1L));
    }

    @Test
    public void testGetMethod() {
        Assert.assertNotNull((Object)Jvm.getMethod(ClassIWDM.class, "hello", CharSequence.class));
        boolean fail = false;
        try {
            Jvm.getMethod(ClassIWDM.class, "helloDefault", CharSequence.class);
            fail = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Assert.assertFalse((boolean)fail);
    }

    @Test
    public void getCpuClass() {
        String cpuClass = Jvm.getCpuClass();
        System.out.println("cpuClass: " + cpuClass);
        if (Jvm.isMacArm()) {
            Assert.assertEquals((String)cpuClass, (Object)"Apple M1", (Object)cpuClass);
        } else if (Jvm.isArm()) {
            Assert.assertTrue((String)cpuClass, (boolean)cpuClass.startsWith("ARMv"));
        } else {
            Assert.assertTrue((String)cpuClass, (cpuClass.startsWith("Intel") && cpuClass.contains(" CPU ") && cpuClass.contains(" @ ") || cpuClass.startsWith("AMD ") ? 1 : 0) != 0);
        }
        Assert.assertNotNull((Object)cpuClass);
    }

    @Test
    public void removingTag() {
        String actual = Jvm.CpuClass.removingTag().apply("tag: value");
        Assert.assertEquals((Object)"value", (Object)actual);
    }

    @Test
    public void findAnnotationOnClass() {
        RealAnno ra = Jvm.findAnnotation(Foo.class, RealAnno.class);
        Assert.assertEquals((Object)"Hello", (Object)ra.value());
    }

    @AnnoAlias
    class Foo {
        Foo() {
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @RealAnno(value="Hello")
    public static @interface AnnoAlias {
    }

    @Target(value={ElementType.ANNOTATION_TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RealAnno {
        public String value();
    }

    static class ClassIWDM
    implements InterfaceWithDefaultMethod {
        ClassIWDM() {
        }

        @Override
        public void hello(CharSequence ignored) {
        }
    }

    static interface InterfaceWithDefaultMethod {
        public void hello(CharSequence var1);

        default public void helloDefault(CharSequence cs) {
            this.hello(cs);
        }
    }

    static class ClassD
    extends ClassC {
        byte x;

        ClassD() {
        }
    }

    static class ClassC
    extends ClassB {
        String hi;

        ClassC() {
        }
    }

    static class ClassB
    extends ClassA {
        String text;

        ClassB() {
        }
    }

    static class ClassA {
        long l;
        int i;
        short s;
        byte b;
        boolean flag;

        ClassA() {
        }
    }

    static final class ReportUnoptimised {
        private ReportUnoptimised() {
        }

        static void reportOnce() {
        }

        static {
            Jvm.reportUnoptimised();
        }
    }
}

