/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.bench;

import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.openhft.affinity.AffinityLock;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.NanoSampler;
import net.openhft.chronicle.jlbh.JLBH;
import net.openhft.chronicle.jlbh.JLBHOptions;
import net.openhft.chronicle.jlbh.JLBHTask;
import net.openhft.chronicle.jlbh.TeamCityHelper;
import net.openhft.chronicle.queue.BufferMode;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.bench.BenchmarkUtils;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.wire.DocumentContext;
import org.jetbrains.annotations.Nullable;

public class QueueMultiThreadedJLBHBenchmark
implements JLBHTask {
    private final int iterations;
    private final String path;
    private final int messageSize;
    private final Long blockSize;
    private final String tailerAffinity;
    private final RollCycle rollCycle;
    private final boolean usePretoucher;
    private final boolean useSingleQueueInstance;
    private final BufferMode readBufferMode;
    private final BufferMode writeBufferMode;
    private final Class<?> testClass;
    private final Datum datum;
    private SingleChronicleQueue sourceQueue;
    private SingleChronicleQueue sinkQueue;
    private ExcerptTailer tailer;
    private ExcerptAppender appender;
    private boolean stopped = false;
    private Thread tailerThread;
    private JLBH jlbh;
    private NanoSampler writeProbe;
    private ScheduledExecutorService pretoucherExecutorService;

    public QueueMultiThreadedJLBHBenchmark(int iterations, String path, String tailerAffinity, @Nullable RollCycle rollCycle, int messageSize, @Nullable Long blockSize, boolean usePretoucher, boolean useSingleQueueInstance, @Nullable BufferMode readBufferMode, @Nullable BufferMode writeBufferMode, @Nullable Class<?> testClass) {
        this.iterations = iterations;
        this.path = path;
        this.tailerAffinity = tailerAffinity;
        this.rollCycle = rollCycle;
        this.messageSize = messageSize;
        this.blockSize = blockSize;
        this.usePretoucher = usePretoucher;
        this.useSingleQueueInstance = useSingleQueueInstance;
        this.readBufferMode = readBufferMode;
        this.writeBufferMode = writeBufferMode;
        this.testClass = testClass == null ? this.getClass() : testClass;
        this.datum = new Datum(messageSize);
    }

    public static void main(String[] args) {
        new Builder().run();
    }

    public void init(JLBH jlbh) {
        this.jlbh = jlbh;
        IOTools.deleteDirWithFiles((String)this.path, (int)10);
        this.sourceQueue = this.createQueueInstance();
        this.sinkQueue = this.useSingleQueueInstance ? this.sourceQueue : this.createQueueInstance();
        this.appender = this.sourceQueue.acquireAppender();
        this.appender.singleThreadedCheckDisabled(true);
        this.tailer = this.sinkQueue.createTailer();
        this.tailer.singleThreadedCheckDisabled(true);
        NanoSampler readProbe = jlbh.addProbe("read");
        this.writeProbe = jlbh.addProbe("write");
        if (this.usePretoucher) {
            this.pretoucherExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("pretoucher", Boolean.valueOf(true)));
            this.pretoucherExecutorService.scheduleAtFixedRate(() -> this.sourceQueue.acquireAppender().pretouch(), 1L, 200L, TimeUnit.MILLISECONDS);
        }
        this.tailerThread = new Thread(() -> {
            try (AffinityLock affinityLock = AffinityLock.acquireLock((String)this.tailerAffinity);){
                Datum datum2 = new Datum(this.messageSize);
                while (!this.stopped) {
                    long beforeReadNs = System.nanoTime();
                    DocumentContext dc = this.tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!dc.isPresent()) continue;
                        datum2.readMarshallable((BytesIn<?>)dc.wire().bytes());
                        long now = System.nanoTime();
                        jlbh.sample(now - datum2.ts);
                        readProbe.sampleNanos(now - beforeReadNs);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                    }
                }
            }
        });
        this.tailerThread.start();
    }

    private SingleChronicleQueue createQueueInstance() {
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.single((String)this.path);
        if (this.blockSize != null) {
            builder.blockSize(this.blockSize.longValue());
        }
        if (this.rollCycle != null) {
            builder.rollCycle(this.rollCycle);
        }
        if (this.readBufferMode != null) {
            builder.readBufferMode(this.readBufferMode);
        }
        if (this.writeBufferMode != null) {
            builder.writeBufferMode(this.writeBufferMode);
        }
        return builder.build();
    }

    public void run(long startTimeNS) {
        this.datum.ts = startTimeNS;
        try (DocumentContext dc = this.appender.writingDocument();){
            this.datum.writeMarshallable((BytesOut<?>)dc.wire().bytes());
        }
        this.writeProbe.sampleNanos(System.nanoTime() - startTimeNS);
    }

    public void complete() {
        if (this.pretoucherExecutorService != null) {
            this.pretoucherExecutorService.shutdownNow();
        }
        this.stopped = true;
        BenchmarkUtils.join(this.tailerThread);
        this.sinkQueue.close();
        this.sourceQueue.close();
        TeamCityHelper.teamCityStatsLastRun((String)this.testClass.getSimpleName(), (JLBH)this.jlbh, (long)this.iterations, (PrintStream)System.out);
    }

    public static class Builder {
        private int runs = Integer.getInteger("runs", 5);
        private String path = Paths.get(System.getProperty("path", "."), new String[0]).resolve("replica").normalize().toString();
        private Integer messageSize = Integer.getInteger("messageSize", 256);
        private Long blockSize = Long.getLong("blockSize");
        private String producerAffinity = System.getProperty("producerAffinity", "last-1");
        private String consumerAffinity = System.getProperty("consumerAffinity", "last-2");
        private int warmupIterations = Integer.getInteger("warmupIterations", 50000);
        private int iterations = Integer.getInteger("iterations", 1000000);
        private int throughput = Integer.getInteger("throughput", 100000);
        private boolean usePretoucher = Boolean.getBoolean("usePretoucher");
        private boolean useSingleQueueInstance = Boolean.getBoolean("useSingleQueue");
        @Nullable
        private BufferMode readBufferMode;
        @Nullable
        private BufferMode writeBufferMode;
        @Nullable
        private Class<?> testClass;
        @Nullable
        private RollCycle rollCycle = this.getRollCycle();

        public void run() {
            System.out.println("-Dpath=" + this.path);
            QueueMultiThreadedJLBHBenchmark jlbhTask = new QueueMultiThreadedJLBHBenchmark(this.iterations, this.path, this.consumerAffinity, this.rollCycle, this.messageSize, this.blockSize, this.usePretoucher, this.useSingleQueueInstance, this.readBufferMode, this.writeBufferMode, this.testClass);
            JLBHOptions lth = new JLBHOptions().warmUpIterations(this.warmupIterations).iterations(this.iterations).throughput(this.throughput).recordOSJitter(false).accountForCoordinatedOmission(false).skipFirstRun(true).acquireLock(() -> AffinityLock.acquireLock((String)this.producerAffinity)).runs(this.runs).jlbhTask((JLBHTask)jlbhTask);
            new JLBH(lth).start();
        }

        private RollCycle getRollCycle() {
            String rollCycle = System.getProperty("rollCycle");
            if (rollCycle != null) {
                return RollCycles.valueOf((String)rollCycle);
            }
            return null;
        }

        public Builder runs(int runs) {
            this.runs = runs;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder messageSize(Integer messageSize) {
            this.messageSize = messageSize;
            return this;
        }

        public Builder blockSize(Long blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder producerAffinity(String producerAffinity) {
            this.producerAffinity = producerAffinity;
            return this;
        }

        public Builder consumerAffinity(String consumerAffinity) {
            this.consumerAffinity = consumerAffinity;
            return this;
        }

        public Builder warmupIterations(int warmupIterations) {
            this.warmupIterations = warmupIterations;
            return this;
        }

        public Builder iterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder throughput(int throughput) {
            this.throughput = throughput;
            return this;
        }

        public Builder usePretoucher(boolean usePretoucher) {
            this.usePretoucher = usePretoucher;
            return this;
        }

        public Builder useSingleQueueInstance(boolean useSingleQueueInstance) {
            this.useSingleQueueInstance = useSingleQueueInstance;
            return this;
        }

        public Builder rollCycle(RollCycle rollCycle) {
            this.rollCycle = rollCycle;
            return this;
        }

        public Builder readBufferMode(BufferMode readBufferMode) {
            this.readBufferMode = readBufferMode;
            return this;
        }

        public Builder writeBufferMode(BufferMode writeBufferMode) {
            this.writeBufferMode = writeBufferMode;
            return this;
        }

        public Builder testClass(Class<?> testClass) {
            this.testClass = testClass;
            return this;
        }
    }

    private static class Datum
    implements BytesMarshallable {
        public final byte[] filler;
        public long ts = 0L;

        public Datum(int messageSize) {
            this.filler = new byte[messageSize - 8];
        }

        public void readMarshallable(BytesIn<?> bytes) throws IORuntimeException {
            this.ts = bytes.readLong();
            bytes.read(this.filler);
        }

        public void writeMarshallable(BytesOut<?> bytes) {
            bytes.writeLong(this.ts);
            bytes.writeSkip((long)this.filler.length);
        }
    }
}

