/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.util;

import net.openhft.chronicle.core.util.Longs;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class LongsTest {
    @Test
    public void require1Arg() {
        this.test(1, 0, v -> Longs.require(Longs.positive(), v));
        this.test(1, -1, v -> Longs.require(Longs.positive(), v));
    }

    @Test
    public void require2Arg() {
        this.test(1, 0, v -> Longs.require(Longs.equalTo(), (long)v, 1L));
    }

    @Test
    public void require3Ard() {
        this.test(0, 16, v -> Longs.require(Longs.between(), (long)v, 0L, 16L));
        this.test(15, -1, v -> Longs.require(Longs.between(), (long)v, 0L, 16L));
    }

    @Test
    public void shortAligned() {
        this.test(0, 1, v -> Longs.require(Longs.shortAligned(), v));
        this.test(2, 3, v -> Longs.require(Longs.shortAligned(), v));
        this.test(4, 5, v -> Longs.require(Longs.shortAligned(), v));
        this.test(6, 7, v -> Longs.require(Longs.shortAligned(), v));
        this.test(8, 9, v -> Longs.require(Longs.shortAligned(), v));
    }

    @Test
    public void intAligned() {
        this.test(0, 1, v -> Longs.require(Longs.intAligned(), v));
        this.test(0, 2, v -> Longs.require(Longs.intAligned(), v));
        this.test(0, 3, v -> Longs.require(Longs.intAligned(), v));
        this.test(4, 5, v -> Longs.require(Longs.intAligned(), v));
        this.test(4, 6, v -> Longs.require(Longs.intAligned(), v));
    }

    @Test
    public void longAligned() {
        this.test(0, 1, v -> Longs.require(Longs.longAligned(), v));
        this.test(0, 2, v -> Longs.require(Longs.longAligned(), v));
        this.test(0, 3, v -> Longs.require(Longs.longAligned(), v));
        this.test(0, 4, v -> Longs.require(Longs.longAligned(), v));
        this.test(0, 5, v -> Longs.require(Longs.longAligned(), v));
        this.test(0, 6, v -> Longs.require(Longs.longAligned(), v));
        this.test(0, 7, v -> Longs.require(Longs.longAligned(), v));
        this.test(8, 9, v -> Longs.require(Longs.longAligned(), v));
    }

    private void test(int happy, int sad, @NotNull LongUnaryOperator mapper) {
        try {
            long result = mapper.applyAsLong(happy);
            Assert.assertEquals((long)happy, (long)result);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        try {
            long result2 = mapper.applyAsLong(sad);
            Assert.fail((String)(result2 + " is not valid!"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static interface LongUnaryOperator {
        public long applyAsLong(int var1) throws IllegalArgumentException;
    }
}

