/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.time;

import net.openhft.chronicle.core.time.RunningMinimum;
import net.openhft.chronicle.core.time.VanillaDifferencer;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Test;

public class RunningMinimumTest {
    @Test
    public void testSample() {
        for (int k = 0; k < 1000; ++k) {
            for (long delta : new long[]{0L, Integer.MIN_VALUE, Integer.MAX_VALUE}) {
                @NotNull RunningMinimum rm = new RunningMinimum(50000L);
                for (int j = 0; j < 50000000; j += 1000000) {
                    long startTime = System.nanoTime() + (long)j;
                    long endTime = System.nanoTime() + (long)j + delta + (long)(Math.pow(10000.0, Math.random()) * 1000.0);
                    rm.sample(startTime, endTime);
                }
                Assert.assertEquals((String)("delta=" + delta), (float)delta, (float)rm.minimum(), (float)40000.0f);
            }
        }
    }

    @Test
    public void testVanillaDiff() {
        @NotNull VanillaDifferencer vd = new VanillaDifferencer();
        Assert.assertEquals((long)100L, (long)vd.sample(123400L, 123500L));
    }
}

