/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.threads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.stream.Stream;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvalidEventHandlerExceptionTest {
    InvalidEventHandlerException e;

    @Before
    public void setup() {
        this.e = InvalidEventHandlerException.reusable();
    }

    @Test
    public void stacktrace() {
        Assert.assertEquals((long)0L, (long)this.e.getStackTrace().length);
        StackTraceElement[] newStackTrace = (StackTraceElement[])Stream.of(new StackTraceElement("A", "foo", "A.java", 42)).toArray(StackTraceElement[]::new);
        this.e.setStackTrace(newStackTrace);
        Assert.assertEquals((long)0L, (long)this.e.getStackTrace().length);
    }

    @Test
    public void printStackTrace() throws IOException {
        final StringBuilder sb = new StringBuilder();
        try (OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                sb.append((char)b);
            }
        };
             PrintStream ps = new PrintStream(os);){
            this.e.printStackTrace(ps);
        }
        String stackTrace = sb.toString();
        Assert.assertTrue((boolean)stackTrace.contains("Reusable"));
        Assert.assertTrue((boolean)stackTrace.contains("no stack trace"));
    }

    @Test
    public void toStringTest() {
        Assert.assertTrue((boolean)this.e.toString().contains("Reusable"));
        Assert.assertTrue((boolean)this.e.toString().contains("no stack trace"));
    }
}

