/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.io;

import java.util.Set;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.io.ReferenceOwner;

public abstract class AbstractCloseableReferenceCounted
extends AbstractReferenceCounted
implements ManagedCloseable {
    private volatile transient boolean closing;
    private volatile transient boolean closed;
    private volatile transient StackTrace closedHere;
    private boolean initReleased;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractCloseableReferenceCounted() {
        Set<Closeable> set = AbstractCloseable.closeableSet;
        if (set != null) {
            Set<Closeable> set2 = set;
            synchronized (set2) {
                set.add(this);
            }
        }
    }

    @Override
    public void reserve(ReferenceOwner id) throws IllegalStateException {
        this.throwExceptionIfClosed();
        super.reserve(id);
    }

    @Override
    public void reserveTransfer(ReferenceOwner from, ReferenceOwner to) throws IllegalStateException {
        this.throwExceptionIfClosed();
        super.reserveTransfer(from, to);
        if (from == INIT) {
            this.initReleased = true;
        }
        if (to == INIT) {
            this.initReleased = false;
        }
    }

    @Override
    public void release(ReferenceOwner id) throws IllegalStateException {
        super.release(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public void releaseLast(ReferenceOwner id) throws IllegalStateException {
        super.releaseLast(id);
        if (id == INIT) {
            this.initReleased = true;
        }
    }

    @Override
    public boolean tryReserve(ReferenceOwner id) throws IllegalStateException, IllegalArgumentException {
        return !this.closed && super.tryReserve(id);
    }

    @Override
    public void close() {
        if (!this.initReleased) {
            try {
                this.release(INIT);
            }
            catch (IllegalStateException e) {
                Jvm.warn().on(this.getClass(), "Failed to release LAST, closing anyway", e);
            }
        }
        this.setClosed();
    }

    @Override
    protected void backgroundPerformRelease() {
        this.setClosing();
        super.backgroundPerformRelease();
    }

    protected void setClosing() {
        this.closing = true;
        this.setClosedHere(" closing here");
    }

    private void setClosedHere(String s) {
        this.closedHere = Jvm.isResourceTracing() ? new StackTrace(this.getClass().getName() + s) : null;
    }

    protected void setClosed() {
        this.closed = true;
        this.closing = true;
        this.setClosedHere(" closed here");
    }

    @Override
    public void throwExceptionIfClosed() throws IllegalStateException {
        this.throwExceptionIfClosed0();
        this.throwExceptionIfReleased();
        assert (AbstractCloseable.DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(true));
    }

    private void throwExceptionIfClosed0() {
        if (this.closing) {
            throw new ClosedIllegalStateException(this.getClass().getName() + (this.closed ? " closed" : " closing"), this.closedHere);
        }
    }

    protected void throwExceptionIfClosedInSetter() throws IllegalStateException {
        this.throwExceptionIfClosed0();
        this.throwExceptionIfReleased();
        assert (AbstractCloseable.DISABLE_SINGLE_THREADED_CHECK || this.threadSafetyCheck(false));
    }

    @Override
    public boolean isClosed() {
        return this.refCount() <= 0 || this.closed;
    }
}

