/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.PerformanceTuning;
import net.openhft.chronicle.core.io.IOTools;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class PerformanceTuningTest {
    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)OS.isLinux());
    }

    public static void main(String[] args) {
        Assume.assumeTrue((boolean)OS.isLinux());
        File cpu0ScalingGovernor = new File("/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor");
        Assert.assertTrue((boolean)cpu0ScalingGovernor.exists());
        String scalingGovernorsCheck = PerformanceTuning.checkScalingGovernors();
        System.out.println("Result of checking CPU scaling governors: " + scalingGovernorsCheck);
        Assert.assertNull((Object)scalingGovernorsCheck);
        Assert.assertTrue((boolean)PerformanceTuning.issues().isEmpty());
        PerformanceTuning.reportIssues();
    }

    @Test
    public void scalingGovernorsSetToPerformance() throws FileNotFoundException {
        Assert.assertNull((Object)PerformanceTuning.checkScalingGovernors(PerformanceTuningTest.pathTo("/cpu-performance")));
    }

    @Test
    public void scalingGovernorsForCpu2and3SetToPowersave() throws FileNotFoundException {
        Assert.assertEquals((Object)"Following CPUs have non-performant scaling governor setting: cpu2, cpu3.", (Object)PerformanceTuning.checkScalingGovernors(PerformanceTuningTest.pathTo("/cpu-2-and-3-powersave")));
    }

    @Test
    public void readKernelCommandLineParameters() throws FileNotFoundException {
        Set<String> kernelCmdLineParams = PerformanceTuning.kernelCommandLineParameters(PerformanceTuningTest.pathTo("proc/cmdline"));
        Assert.assertEquals(PerformanceTuningTest.set("BOOT_IMAGE=/vmlinuz-3.10.0-1160.25.1.el7.x86_64", "root=/dev/mapper/centos-root", "ro", "LANG=en_GB.UTF-8", "nohz_full=2-11", "spectre_v2=off", "processor.max_cstate=1", "intel_idle.max_cstate=0", "idle=poll", "mce=ignore_ce", "nosoftlockup", "audit=0", "nopti", "crashkernel=auto", "rd.lvm.lv=centos/root", "rd.lvm.lv=centos/swap", "rhgb", "quiet"), kernelCmdLineParams);
    }

    @Test
    public void checkSpectreMitigation() {
        Assert.assertNull((Object)PerformanceTuning.checkSpectreMitigation(PerformanceTuningTest.set("spectre_v2=off")));
        Assert.assertNull((Object)PerformanceTuning.checkSpectreMitigation(PerformanceTuningTest.set("nospectre_v2")));
        Assert.assertNull((Object)PerformanceTuning.checkSpectreMitigation(PerformanceTuningTest.set("mitigations=off")));
        Assert.assertNotNull((Object)PerformanceTuning.checkSpectreMitigation(PerformanceTuningTest.set("nosoftlockup")));
    }

    @Test
    public void checkCStates() {
        Assert.assertNull((Object)PerformanceTuning.checkCStates(PerformanceTuningTest.set("processor.max_cstate=1", "intel_idle.max_cstate=0", "idle=poll")));
        Assert.assertNotNull((Object)PerformanceTuning.checkCStates(PerformanceTuningTest.set("intel_idle.max_cstate=0", "idle=poll")));
        Assert.assertNotNull((Object)PerformanceTuning.checkCStates(PerformanceTuningTest.set("processor.max_cstate=1", "idle=poll")));
    }

    @Test
    public void checkMCE() {
        Assert.assertNull((Object)PerformanceTuning.checkMCE(PerformanceTuningTest.set("mce=ignore_ce")));
        Assert.assertNotNull((Object)PerformanceTuning.checkMCE(PerformanceTuningTest.set("intel_idle.max_cstate=0")));
        Assert.assertNotNull((Object)PerformanceTuning.checkMCE(PerformanceTuningTest.set("mce=off")));
    }

    @Test
    public void checkAudit() {
        Assert.assertNull((Object)PerformanceTuning.checkAudit(PerformanceTuningTest.set("audit=0")));
        Assert.assertNull((Object)PerformanceTuning.checkAudit(PerformanceTuningTest.set("audit=off")));
        Assert.assertNotNull((Object)PerformanceTuning.checkAudit(PerformanceTuningTest.set("audit=1")));
        Assert.assertNotNull((Object)PerformanceTuning.checkAudit(PerformanceTuningTest.set("audit=on")));
    }

    @Test
    public void checkPageTableIsolation() {
        Assert.assertNull((Object)PerformanceTuning.checkPageTableIsolation(PerformanceTuningTest.set("nopti")));
        Assert.assertNull((Object)PerformanceTuning.checkPageTableIsolation(PerformanceTuningTest.set("pti=off")));
        Assert.assertNotNull((Object)PerformanceTuning.checkPageTableIsolation(PerformanceTuningTest.set("pti=on")));
    }

    @SafeVarargs
    private static <T> Set<T> set(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    private static Path pathTo(String path) throws FileNotFoundException {
        return Paths.get(IOTools.urlFor(PerformanceTuningTest.class, path).getFile(), new String[0]);
    }
}

